//------ 1928 Mercedes-Benz SS 38/250 tourer         Miller 8/22/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}
    
#version 3.1;    
    
#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "glass.inc"
#include "CarColour.INC"
#include "Hood.INC"
#include "Cab.INC"
#include "Cover.INC"
#include "Top.INC"
#include "Tire.INC"
#include "Trunk.INC"
#include "Grill.INC"
#include "Logo.INC"
#include "Lights.INC"
#include "Mess.INC"
#include "WindSh.INC"
#include "Pipe.INC"
#include "Fender.INC"
#include "BFrame.INC"
#include "Skirt.INC"
#include "Seat.INC"
//#include "Box.INC"
//#include "Bottle.INC"
//#include "Floor.INC"

camera {
   location <5, 260, -690>
   direction z*4
   up y
   right x*image_width/image_height
   look_at <5, 40, 0>
}

light_source { <  500, 1000, -3660> color White }
light_source { < 1100,  370, -1000> color White }
light_source { <-4000, 7770,   -30> color White }

//------ Car
#declare Car =
union {
  object { HoodJoints }
  object { Cab }
  object { Cover }
  object { Hood }
  object { Nose }
  object { Grill }
  object { Mess translate x*0.1 }
  object { Logo translate <77, 65.7, 0> } 
  object { Trunk }
  object { GasCap }
  object { Tire rotate x*90 rotate z*19.5 translate <-94, 57, 0> }
  object { Tire translate < 82, 23, -42> }
  object { Tire translate < 82, 23,  42> }
  object { Tire translate <-80, 23, -42> }
  object { Tire translate <-80, 23,  42> }
  object { HeadLights rotate y*-90 translate <88, 36.5, 0>}
  object { Pipe translate <19.5, 48, -17.5> }
  object { Pipe translate <33.5, 48, -17.5> }
  object { Pipe translate <47.5, 48, -17.5> }
  object { WindShield }
  object { Fender rotate y*-90 translate <110, 25.5, 0> }
  object { Fender rotate y*90 translate <-120, 25.5, 0> }
  object { BodyFrame }
  object { Skirt }
  object { Seat rotate y*90 translate <-62.5, 41.5, 0> }  
  bounded_by { box { -1, 1 scale <130, 60, 60> translate <-5, 55, 0> } }
}

object { Car rotate y*45 }

//------ World
sphere { 0, 200000
  inverse
  hollow on
  texture {
    pigment { color Black }
    finish { ambient 1 diffuse 0.1 }
  }
}

//------ Ground
plane { y, 0
  texture {
    pigment { color DimGray }
    finish { ambient 0.1 diffuse 0.4 reflection { 0.28 } }
  }
}

//------ Sky
plane { y, 10000
  texture {
    pigment { color Blue }
    finish { ambient 0.1 }
  }
}

fog { distance 10000 color Black }