//------ Testers Bottle         Miller 8/22/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare ThinLip =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -164, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,    160, 0, 0, 0, 0, 1, 0, -164, 0, 6400> }

#declare ThickLip =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -166.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 157.5, 0, 0, 0, 0, 1, 0, -166.5, 0, 6201.5625> }

#declare GoldLip =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -221, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 220, 0, 0, 0, 0, 1, 0, -221, 0, 12100> }

#declare C1b =
texture {
  pigment { color LightWood }
  finish { ambient 0.5 diffuse 0.6 phong 1 }
}

// An excellent lead crystal glass!
// Need to change to v3.x Glass!
#declare Mike_Miller_Glass3 =
texture {
  pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
  finish {
    ambient 0.1
	diffuse 0.1
	specular 0.8
	reflection { 0.1 } 
	//refraction 0.9 
	//ior 1.45
	roughness 0.001
	phong 1
	phong_size 400
  }
}

//--- Glass Bottle
#declare Bottle1 =
object {
  union{   
    difference {
      box { -1, 1 scale <12, 15, 12> translate y*15 }

      plane { x, 0 rotate z*-45 translate x*-39 }
      plane { x, 0 rotate z*45 translate <-39, 30, 0> }
      plane { y, 0 rotate z*45 translate <39, 30, 0> }
      plane { y, 0 rotate z*135 translate x*39 }
      union {
        plane { x, 0 rotate z*-45 translate x*-39 }
        plane { x, 0 rotate z*45 translate <-39, 30, 0> }
        plane { y, 0 rotate z*45 translate <39, 30, 0> }
        plane { y, 0 rotate z*135 translate x*39 }
        rotate y*90
      }
      object { Cylinder_Y scale <15, 1, 15> inverse  }
      cylinder { y, -y, 1 scale <8.5, 22, 8.5> translate y*27 }
    }
    difference {
      cylinder { y, -y, 1 scale <9, 6.75, 9> translate y*36.7 }
      cylinder { y, -y, 1 scale <7.5, 22, 7.5> translate y*27 }    
    }
    object { ThinLip rotate y*15 translate y*39.5 }
    object { ThickLip translate y*33 }
  }
  material { texture { Mike_Miller_Glass3 } interior { ior 1.45 } }
//  texture { 
//    pigment { color Green }
//    finish { phong 1} 
//    Mike_Miller_Glass3
//  }
}

//--- Lable on Bottle
#declare Label = 
box { -1, 1
  scale <10.25, 11.25, 0.05> 
  texture {
    pigment {
      image_map { /* <1, -1, 0> */ gif "label.gif" interpolate 4 }
      scale <20.6, 22.5, 1>
      translate <-10.28, -11.28, 0>
    }
    finish { ambient 0.5 diffuse 0.5 }
  }
}

//--- Paint in Bottle
#declare Paint =
box { -1, 1
  scale <7, 9, 7>
  translate y*14
  texture { C1b }
}

//--- Nub grip on cap
#declare Nub = 
sphere { 
  0, 1
  scale <0.5, 1.25, 0.5> 
  translate <-10.5, 2.2, 0> 
}

//--- Bottle Lid
#declare Lid1 =
object {
  union {
    difference {
      cylinder { y, -y, 1 scale <10.5, 4.25, 10.5> translate y*4.75 }
      cylinder { y, -y, 1 scale <10, 5, 10> translate y*5.5 }
    }
    sphere { 0, 1 scale <10.5, 0.5, 10.5> translate y*0.5 }
    object { Nub }
    object { Nub rotate y*10 }
    object { Nub rotate y*20 }
    object { Nub rotate y*30 }
    object { Nub rotate y*40 }
    object { Nub rotate y*50 }
    object { Nub rotate y*60 }
    object { Nub rotate y*70 }
    object { Nub rotate y*80 }
    object { Nub rotate y*90 }
    object { Nub rotate y*100 }
    object { Nub rotate y*110 }
    object { Nub rotate y*120 }
    object { Nub rotate y*130 }
    object { Nub rotate y*140 }
    object { Nub rotate y*150 }
    object { Nub rotate y*160 }
    object { Nub rotate y*170 }
    object { Nub rotate y*180 }
    object { Nub rotate y*190 }
    object { Nub rotate y*200 }
    object { Nub rotate y*210 }
    object { Nub rotate y*220 }
    object { Nub rotate y*230 }
    object { Nub rotate y*240 }
    object { Nub rotate y*250 }
    object { Nub rotate y*260 }
    object { Nub rotate y*270 }
    object { Nub rotate y*280 }
    object { Nub rotate y*290 }
    object { Nub rotate y*300 }
    object { Nub rotate y*310 }
    object { Nub rotate y*320 }
    object { Nub rotate y*330 }
    object { Nub rotate y*340 }
    object { Nub rotate y*350 }
  }
  texture { 
    pigment { color White }
    finish { ambient 0.1 diffuse 0.6 phong 1 phong_size 100 reflection { 0.1 } }
  }
  bounded_by { box { -1, 1 scale <12, 6, 12> translate y*4.5 } }
}

#declare GL =
object {
  GoldLip
  texture {
    pigment { color Gold }
    finish { ambient 0.2 diffuse 0.6 crand 0.05 brilliance 10 reflection { 0.5 } phong 1 phong_size 30 }
  }
}

//-- Lid with gold ring
#declare Lid =
union {
  object { Lid1 }
  object { GL translate y*9 }
  bounded_by { box { -1, 1 scale <12, 6, 12> translate y*4.5 } }
}

//--- Bottle with Label    
#declare Bottle =
union {
  object { Bottle1 }
  object { Label scale <0.90, 0.95, 0.95> translate <0, 15, -12> }
  object { Paint }
  bounded_by { box { -1, 1 scale <14.5, 23.5, 14.5> translate y*21.3 } }
}

//--- Brush Tip
#declare BTip =
object { 
  union {
    sphere { 0, 1 scale <6, 2.2, 2.2> translate x*14 }
    difference {
      object { QCone_X scale <14, 2.2, 2.2> }
      plane { x, 14 inverse }
      plane { x, 0 }
    }
  }
  texture {
    pigment { color BakersChoc }
    finish { ambient 0.1 diffuse 0.4 phong 1 }
    normal { waves 1 rotate x*90 scale <100, 0.01, 1> }
  }
}

//--- Brush Handle Neck
#declare Neck =
object { 
  difference {
    object { QCone_X scale <51, 2, 2> translate x*-8 }
    plane { x, 19.5 }
    plane { x, 43 inverse }
  }
  texture { CromeTexture }
}

//--- Brush Handle
#declare Handle =
object { 
  union {
    difference {
      object { QCone_X scale <63.8, 2.5, 2.5> translate x*-8 }
      plane { x, 43 }
      plane { x, 55.5 inverse }
    }
    difference {
      object { QCone_X scale <124.5, 2.5, 2.5> translate x*180 }
      plane { x, 55.5 }
      plane { x, 180 inverse }
    }
  }
  texture {
    pigment { color Scarlet }
    finish { ambient 0.1 diffuse 0.4 phong 1 }
  }
}

//-- Complete Brush 
#declare Brush =
union {
  object { BTip }
  object { Neck }
  object { Handle }
  bounded_by { box { -1, 1 scale <95, 5, 5> translate x*88.5 } }
}

//--- Lean Brush on Lid
#declare BrushLid =
union {
   object { Brush rotate z*-4 translate <-24, 13, 0> }
   object { Lid }
}