//------ Testers Bottle         Miller 8/22/92



#declare ThinLip =
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -164.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        160.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -164.000000 0.000000 6400.000000 >
    }

#declare ThickLip =
  quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -166.500000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        157.500000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -166.500000 0.000000 6201.562500 >
}

#declare GoldLip =
quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -221.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        220.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -221.000000 0.000000 12100.000000 >
}

#declare C1b =
texture {
	color LightWood
	ambient .5
	diffuse .6
	phong 1
}




// An excellent lead crystal glass!
#declare Glass3 = texture {
   color red 0.98 green 0.98 blue 0.98 alpha 0.9
   ambient 0.1
   diffuse 0.1
   specular 0.8
   reflection 0.1
   refraction 0.9
   ior 1.45
   roughness 0.001
   phong 1 phong_size 400
}






//--- Glass Bottle
#declare Bottle1 =
object {
   union{   
      difference {
         box { UnitBox scale <12 15 12> translate <0 15 0> }

         plane { <1 0 0> 0 rotate <0 0 -45> translate <-39 0 0> }
         plane { <1 0 0> 0 rotate <0 0 45> translate <-39 30 0> }
         plane { <0 1 0> 0 rotate <0 0 45> translate <39 30 0> }
         plane { <0 1 0> 0 rotate <0 0 135> translate <39 0 0> }
         union {
         plane { <1 0 0> 0 rotate <0 0 -45> translate <-39 0 0> }
         plane { <1 0 0> 0 rotate <0 0 45> translate <-39 30 0> }
         plane { <0 1 0> 0 rotate <0 0 45> translate <39 30 0> }
         plane { <0 1 0> 0 rotate <0 0 135> translate <39 0 0> }
         rotate <0 90 0> 
         }
         quadric { Cylinder_Y scale <15 1 15> inverse  }
         intersection { Disk_Y scale <8.5 22 8.5> translate <0 27 0> }
     }
         difference {
         intersection { Disk_Y scale <9 6.75 9> translate <0 36.7 0> }
         intersection { Disk_Y scale <7.5 22 7.5> translate <0 27 0> }    
         }
         quartic { ThinLip rotate <0 15 0> translate <0 39.5 0> }
         quartic { ThickLip  translate <0 33 0> }

 }
           texture { 
//           color Green
//	   phong 1


	   Glass3
           }
}

//--- Lable on Bottle
#declare Label = 
object {
    box { UnitBox scale <10.25 11.25 .05> }
     texture {
	image_map { <1 -1 0> gif "label.gif" interpolate 4 }
	scale <20.6 22.5 1>
	translate <-10.28 -11.28 0>
	ambient .5
	diffuse .5
	}
}

//--- Paint in Bottle
#declare Paint =
object {
  box { UnitBox scale <7 9 7> translate <0 14 0> }
   texture { C1b }
}

//--- Nub grip on cap
#declare Nub = 
quadric { 
    Sphere 
    scale <.5 1.25 .5> 
    translate <-10.5 2.2 0> 
}

//--- Bottle Lid
#declare Lid1 =
object {
  union {
    difference {
      intersection { Disk_Y scale <10.5 4.25 10.5> translate <0 4.75 0> }
      intersection { Disk_Y scale <10 5 10> translate <0 5.5 0> }
    }
   quadric { Sphere scale <10.5 .5 10.5> translate <0 .5 0> }
   quadric { Nub rotate <0 0 0> }
   quadric { Nub rotate <0 10 0> }  
   quadric { Nub rotate <0 20 0> }
   quadric { Nub rotate <0 30 0> }
   quadric { Nub rotate <0 40 0> }
   quadric { Nub rotate <0 50 0> }
   quadric { Nub rotate <0 60 0> }
   quadric { Nub rotate <0 70 0> }
   quadric { Nub rotate <0 80 0> }
   quadric { Nub rotate <0 90 0> }
   quadric { Nub rotate <0 100 0> }
   quadric { Nub rotate <0 110 0> }
   quadric { Nub rotate <0 120 0> }
   quadric { Nub rotate <0 130 0> }
   quadric { Nub rotate <0 140 0> }
   quadric { Nub rotate <0 150 0> }
   quadric { Nub rotate <0 160 0> }
   quadric { Nub rotate <0 170 0> }
   quadric { Nub rotate <0 180 0> }
   quadric { Nub rotate <0 190 0> }
   quadric { Nub rotate <0 200 0> }
   quadric { Nub rotate <0 210 0> }
   quadric { Nub rotate <0 220 0> }
   quadric { Nub rotate <0 230 0> }
   quadric { Nub rotate <0 240 0> }
   quadric { Nub rotate <0 250 0> }
   quadric { Nub rotate <0 260 0> }
   quadric { Nub rotate <0 270 0> }
   quadric { Nub rotate <0 280 0> }
   quadric { Nub rotate <0 290 0> }
   quadric { Nub rotate <0 300 0> }
   quadric { Nub rotate <0 310 0> }
   quadric { Nub rotate <0 320 0> }
   quadric { Nub rotate <0 330 0> }
   quadric { Nub rotate <0 340 0> }
   quadric { Nub rotate <0 350 0> }
   }
     texture { 
     color White
     ambient .1
     diffuse .6
     phong 1
     phong_size 100
     reflection .1
     }
	bounded_by {
	box { UnitBox scale <12 6 12> translate <0 4.5 0> }
	}
}

#declare GL =
object {
   quartic { GoldLip }
     texture {
	color Gold
	ambient .2
	diffuse .6
	.05
	brilliance 10
	reflection .5
	phong 1
	phong_size 30
	}
}


//-- Lid with gold ring
#declare Lid =
composite {
object { Lid1 }
object { GL translate <0 9 0> }
	bounded_by {
	box { UnitBox scale <12 6 12> translate <0 4.5 0> }
	}
}




//--- Bottle with Label    
#declare Bottle =
composite {
object { Bottle1 }
object { Label scale <.90 .95 .95> translate <0 15 -12> }
object { Paint }
    bounded_by {
    box { UnitBox scale <14.5 23.5 14.5> translate <0 21.3 0> }
    }
}


//--- Brush Tip
#declare BTip =
object { 
  union {
   quadric { Sphere scale <6 2.2 2.2> translate <14 0 0> }
     difference {
        quadric { QCone_X scale <14 2.2 2.2> }
	plane { <1 0 0> 14 inverse }
	plane { <1 0 0> 0 }
     }
  }
	texture {
	color BakersChoc
	ambient .1
	diffuse .4
	phong 1
 	waves 1
	rotate <90 0 0>
	scale <100 .01 1>
	}
}



//--- Brush Handle Neck
#declare Neck =
object { 
     difference {
        quadric { QCone_X scale <51 2 2> translate <-8 0 0> }
	plane { <1 0 0> 19.5 }
	plane { <1 0 0> 43 inverse }
     }
  	texture {
	CromeTexture
	}
}


//--- Brush Handle
#declare Handle =
object { 
   union {
     difference {
        quadric { QCone_X scale <63.8 2.5 2.5> translate <-8 0 0> }
	plane { <1 0 0> 43 }
	plane { <1 0 0> 55.5 inverse }
     }
     difference {
        quadric { QCone_X scale <124.5 2.5 2.5> translate <180 0 0> }
	plane { <1 0 0> 55.5 }
	plane { <1 0 0> 180 inverse }
     }
   }
  	texture {
	color Scarlet
	ambient .1
	diffuse .4
	phong 1
	}
}


//-- Complete Brush 
#declare Brush =
composite {
object { BTip }
object { Neck }
object { Handle }
   bounded_by {
   box { UnitBox scale <95 5 5> translate <88.5 0 0> }
   }
}


//--- Lean Brush on Lid
#declare BrushLid =
composite {
   composite { Brush rotate <0 0 -4> translate <-24 13 0> }
   composite { Lid }
}






