//---- Plant stalk
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare T_Texture = 
texture {
  //pigment { colour DarkGreen } finish { phong 1 }
  pigment {
    gradient x
    turbulence 0.1
    colour_map {
      [0 0.6 colour DarkGreen colour DarkGreen]
      [0.6 0.8 colour DarkGreen colour MediumForestGreen]
      [0.8 1 colour Khaki colour Tan]
    }
  }
  finish { crand 0.07 ambient 0.2 diffuse 0.5 }
}
texture {
  pigment { colour Clear }
  normal { waves 0.5 scale <20, 2, 20> }
  finish { phong 0.6 phong_size 20 }
}

#declare Dot = sphere { 0, 1 }
//quadric { 1, 0, 0, -1.0 }

#declare Connector_1 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane { x, 0 inverse }
  plane { x, 1}
}

#declare Connector_2 = 
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

/*----------------------------------------------------------------------------*/

#declare Stalk =
  union {
    sphere { 0, 9.33333 texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 9.312603 }
        plane { x, 8.647423 inverse }
      }
      texture { T_Texture }
      translate x*-9.312603
      scale <14.979824, 1, 1>
      translate x*-0.621676
      rotate y*180
      rotate z*87.614085
      rotate y*60.000128
      }
    sphere { 0, 8.666670 translate <0.20833, 10, -0.360840 >texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 8.647489 }
        plane { x, 7.982295 inverse }
      }
      texture { T_Texture }     
      translate x*-8.647489
      scale <15.005653, 1, 1>
      translate x*-0.576282
      rotate y*180
      rotate z*85.872172
      rotate y*149.999582
      translate <0.208330, 10, -0.360840>
    }
    sphere { 0, 8 translate <-0.41667, 20, -0.721690> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 7.982416 }
        plane { x, 7.317212 inverse }
      }
      texture { T_Texture }
      translate x*-7.982416
      scale <15.057626, 1, 1>
      translate x*-0.530124
      rotate y*180
      rotate z*83.709142
      rotate y*-139.106407
      translate <-0.416670, 20, -0.721690>
    }
    sphere { 0, 7.33333 translate <-1.25, 30, 0> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 7.317376 }
        plane { x, 6.652167 inverse }
      }
      texture { T_Texture }
      translate x*-7.317376
      scale <15.135480, 1, 1>
      translate x*-0.483458
      rotate y*180
      rotate z*81.456245
      rotate y*-73.897810
      translate <-1.250000, 30, 0>
    }
    sphere { 0, 6.66667 translate <-0.83333, 40, 1.44338> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 6.652361 }
        plane { x, 5.987122 inverse }
      }
      texture { T_Texture }
      translate x*-6.652361
      scale <15.238136, 1, 1>
      translate x*-0.436560
      rotate y*180
      rotate z*79.190028
      rotate y*-10.893279
      translate <-0.833330, 40, 1.443380>
    }
    sphere { 0, 6 translate <1.04167, 50, 1.80422> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 5.987334 }
        plane { x, 5.322071 inverse }
      }
      texture { T_Texture }
      translate x*-5.987334
      scale <15.365773, 1, 1>
      translate x*-0.389654
      rotate y*180
      rotate z*76.938992
      rotate y*51.051795
      translate <1.041670, 50, 1.804220>
    }
    sphere { 0, 5.33333 translate <2.5, 60, -0> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 5.322290 }
        plane { x, 4.657010 inverse }
      }
      texture { T_Texture }
      translate x*-5.32229
      scale <15.517788, 1, 1>
      translate x*-0.34298
      rotate y*180
      rotate z*74.718236
      rotate y*112.410955
      translate <2.5, 60, -0>
    }
    sphere { 0, 4.66667 translate <1.45833, 70, -2.52591> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 4.657224 }
        plane { x, 3.991903 inverse }
      }
      texture { T_Texture }
      translate x*-4.657224
      scale <15.692774, 1, 1>
      translate x*-0.296775
      rotate y*180
      rotate z*72.537656
      rotate y*173.413295
      translate <1.45833, 70, -2.525910>
    }
    sphere { 0, 4 translate <-1.66667, 80, -2.88675> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 3.992103 }
        plane { x, 3.326749 inverse }
      }
      texture { T_Texture }
      translate x*-3.992103
      scale <15.890659, 1, 1>
      translate x*-0.251223
      rotate y*180
      rotate z*70.404278
      rotate y*-125.817495
      translate <-1.666670, 80, -2.886750>
    }
    sphere { 0, 3.33333 translate <-3.75, 90, 0> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 3.326927 }
        plane { x, 2.661548 inverse }
      }
      texture { T_Texture }
      translate x*-3.326927
      scale <16.110621, 1, 1>
      translate x*-0.206505
      rotate y*180
      rotate z*68.323422
      rotate y*-65.208680
      translate <-3.75, 90, 0>
    }
    sphere { 0, 2.66667 translate <-2.08333, 100, 3.60844> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 2.661697 }
        plane { x, 1.996270 inverse }
      }
      texture { T_Texture }
      translate x*-2.661697
      scale <16.351045, 1, 1>
      translate x*-0.162785
      rotate y*180
      rotate z*66.299220
      rotate y*-4.714953
      translate <-2.08333, 100, 3.60844>
    }
    sphere { 0, 2 translate <2.29167, 110, 3.96928> texture { T_Texture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.996386 }
        plane { x, 1.330921 inverse }
      }
      texture { T_Texture }
      translate x*-1.996386
      scale <16.611751, 1, 1>
      translate x*-0.120179
      rotate y*180
      rotate z*64.334645
      rotate y*55.693393
      translate <2.29167, 110, 3.969280>
    }
    sphere { 0, 1.33333 translate <5, 120, -0> texture { T_Texture } }
    bounded_by { sphere { 0, 73.318661 translate y*56 } }
  }