//---- Potted House Plant.................... M.Miller 7/27/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "stalk.inc"
#include "leaf1.inc"

//--- A 17 Leaf Plant
#declare Plant17 =
union {
  object { Stalk }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*30   translate < 5,    119,  0> }
  object { Leaf1 scale 0.4  rotate x*-20 rotate y*-30  translate < 5,    119,  0> }
  object { Leaf1 scale 0.7  rotate x*-20 rotate y*20   translate <-2,    100,  3.6> }
  object { Leaf1 scale 0.7  rotate x*-20 rotate y*120  translate <-2,    100,  3.6> }
  object { Leaf1 scale 0.65 rotate x*-20 rotate y*240  translate <-2,    100,  3.6> }
  object { Leaf1 scale 0.4  rotate x*-20 rotate y*-40  translate <-2,    100,  3.6> }
  object { Leaf1 scale 0.5  rotate x*-20 rotate y*-20  translate <-3.75,  90, -2> }
  object { Leaf1 scale 0.5  rotate x*-20 rotate y*140  translate <-3.75,  90, -2> }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*180  translate <-1.66,  80, -2> }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*50   translate <-1.66,  80, -2> }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*-50  translate <-1.66,  80, -2> }
  object { Leaf1 scale 0.5  rotate x*-20 rotate y*-110 translate <-1.66,  80, -2> }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*110  translate <-1.66,  80, -2> }
  object { Leaf1 scale 0.5  rotate x*-20 rotate y*10   translate <-1.66,  80, -2> }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*30   translate <  2.5,  60, -2> }
  object { Leaf1 scale 0.5  rotate x*-20 rotate y*-40  translate <  4.5,  60, -2> }
  object { Leaf1 scale 0.5  rotate x*-20 rotate y*100  translate <  5.5,  60,  0> }
}

//--- A 6 Leaf Plant
#declare Plant6 =
union {
  object { Stalk }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*30   translate < 5, 119, 0> }
  object { Leaf1 scale 0.4  rotate x*-20 rotate y*-30  translate < 5, 119, 0> }
  object { Leaf1 scale 0.7  rotate x*-20 rotate y*-20  translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.7  rotate x*-20 rotate y*-70  translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.65 rotate x*-20 rotate y*-180 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.4  rotate x*-20 rotate y*-40  translate <-2, 100, 3.6> }
}

//--- A 3 Leaf Plant
#declare Plant3 =
union {
  object { Stalk }
  object { Leaf1 scale 0.6  rotate x*-20 rotate y*30  translate < 5, 119, 0> }
  object { Leaf1 scale 0.4  rotate x*-20 rotate y*-30 translate < 5, 119, 0> }
  object { Leaf1 scale 0.07 rotate x*-20 rotate y*-20 translate <-2, 100, 3.6> }
}

//--- Complete House Plant
#declare Plant1 =
union {
  object { Plant17 }
  object { Plant6 scale 0.7  rotate 0 translate <20, 0, -10> }
  object { Plant6 scale 0.7  rotate y*200 translate <-15, 0, 15> }
  object { Plant3 scale 0.55 translate <-2, 0, -11> }
  object { Plant3 scale 0.6  translate <3, 0, 9> }
}