//--- House Plant     .........M.Miller 7/30/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "plant1.inc"
#include "dirt.inc"
#include "crock.inc"
#include "light.inc"

camera {
  location <10, 220, -260> 
  direction z*1.9
  up y
  right x*image_width/image_height
  look_at <10, 80, 0>
 }

object { Plant1 translate y*10  }
object { Dirt2 }
object { Crock  }
//object { Floor scale 0.2 }

plane { y, 0
  texture {
    pigment { colour DimGray }
    finish { crand 0.02 ambient 0.1 diffuse 0.4 }
  }
}

#declare Bla = colour rgb <0.05, 0, 0>;

object {
  Square_Z
  pigment {
    wood
    colour_map {
      [0 0.15 colour Clear colour Clear]
      [0.15 1 colour Clear colour Bla]
    }
  }
  scale <1300, 1300, 1>
  rotate x*90
  translate y*5
}

