//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
/*
Leaf1
This leaf & stem has a base point at <0 0 0> & arches towards
the negative z with the tip of the leaf at -50 z & the arch 
apexes at 57 y.
*/

//---- Texture for the right side of leaf
#declare Leaf_Texture_R = 
texture {
  pigment { color DarkGreen }
  finish { crand 0.02 ambient 0.25 diffuse 0.5 phong 0.75 phong_size 40 }
  normal { waves 0.8 frequency 0.05 }
  scale <10, 0.01, 10>
  rotate z*45
}
texture {
  pigment {
    wood
    color_map {
      [0 0.5 color Black filter 0.8 color DarkGreen filter 0.7]
      [0.5 1 color DarkGreen filter 0.7 color Yellow filter 0.7]
    }
  }
  finish { diffuse 0.4 }
  scale <30, 40, 20>
} 

//---- Texture for left side of leaf
#declare Leaf_Texture_L = 
texture {
  pigment { color DarkGreen }
  finish { crand 0.02 ambient 0.25 diffuse 0.5 phong 0.75 phong_size 40 }
  normal { waves 0.8 frequency 0.05 }
  scale <10, 0.01, 10>
  rotate z*45
}
texture {
  pigment {
    wood
    color_map {
      [0 0.5 color Black filter 0.8 color DarkGreen filter 0.7]
      [0.5 1 color DarkGreen filter 0.7 color Yellow filter 0.7]
    }
  }
  finish { diffuse 0.4 }
  scale <30, 40, 20>
} 

//--- Texture for leaf stem
#declare Stem_Texture = 
texture {
  pigment { color DarkGreen }
  finish { crand 0.02 ambient 0.25 diffuse 0.5 phong 0.75 phong_size 40 }
  normal { waves 0.8 frequency 0.05 }
  scale <10, 0.1, 10>
  rotate z*45
}

//----- Right 1/2 of leaf
#declare Leaf_R = 
object {
  sphere { 0, 1 scale <10, 20, 8> translate x*5 }
  clipped_by {
    sphere { 0, 1 scale <12.5, 30, 12.5> translate y*15 }
    object { Cylinder_X scale <1, 22, 8> translate z*1.7 inverse }
    plane { z, 0 inverse }
  }
  texture { Leaf_Texture_R }
}

//--- Left 1/2 of leaf
#declare Leaf_L = 
object {
  sphere { 0, 1 scale <10, 20, 8> translate x*-5 }
  clipped_by {
    sphere { 0, 1 scale <12.5, 30, 12.5> translate y*15 }
    object { Cylinder_X scale <1, 22, 8> translate z*1.7 inverse }
    plane { z, 0 }
  }
  texture { Leaf_Texture_L }
}

//--- Texture for Stem
#declare YourTexture = texture { Stem_Texture }

#declare Dot = sphere { 0, 1 }
//quadric { 1, 0, 0, -1.0 }

#declare Connector_1 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane { x, 0 inverse }
  plane { x, 1}
}

#declare Connector_2 = 
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

/*----------------------------------------------------------------------------*/

//--- Arched Stem
#declare Stem =
  union {
    sphere { 0, 1.88462 texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.884409 }
        plane { x, 1.769032 inverse }
      }
      translate x*-1.884409
      scale <66.871071, 1, 1>
      translate x*-0.02818
      rotate y*180
      rotate z*66.321546
      rotate y*-90
      texture { YourTexture }
    }
    sphere { 0, 1.76923 translate <0, 7.06744, 3.099220> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.769032 }
        plane { x, 1.653665 inverse }
      }
      translate x*-1.769032
      scale <66.876887, 1, 1>
      translate x*-0.026452
      rotate y*180
      rotate z*77.073854
      rotate y*-90
      translate <0, 7.067440, 3.099220>
      texture { YourTexture }
    }
    sphere { 0, 1.65385 translate <0, 14.589, 4.8255> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.653665 }
        plane { x, 1.538288 inverse }
      }
      translate x*-1.653665
      scale <66.871050, 1, 1>
      translate x*-0.024729
      rotate y*180
      rotate z*87.826250
      rotate y*-90
      translate <0, 14.589000, 4.825500>
      texture { YourTexture }
    }
    sphere { 0, 1.53846 translate <0, 22.30056, 5.118210> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.538288 }
        plane { x, 1.422921 inverse }
      }
      translate x*-1.538288
      scale <66.876872, 1, 1>
      translate x*-0.023002
      rotate y*180
      rotate z*81.421487
      rotate y*90
      translate <0, 22.300560, 5.118210>
      texture { YourTexture }
    }
    sphere { 0, 1.42308 translate <0, 29.93134, 3.96709> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.422921 }
        plane { x, 1.307544 inverse }
      }
      translate x*-1.422921
      scale <66.871072, 1, 1>
      translate x*-0.021279
      rotate y*180
      rotate z*70.669222
      rotate y*90
      translate <0, 29.931340, 3.967090>
      texture { YourTexture }
    }
    sphere { 0, 1.30769 translate <0, 37.21339, 1.41256> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.307544 }
        plane { x, 1.192177 inverse }
      }
      translate x*-1.307544
      scale <66.876889, 1, 1>
      translate x*-0.019552
      rotate y*180
      rotate z*59.916798
      rotate y*90
      translate <0, 37.213390, 1.412560>
      texture { YourTexture }
    }
    sphere { 0, 1.19231 translate <0, 43.891, -2.4557> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.192177 }
        plane { x, 1.076800 inverse }
      }
      translate x*-1.192177
      scale <66.870990, 1, 1>
      translate x*-0.017828
      rotate y*180
      rotate z*49.164547
      rotate y*90
      translate <0, 43.891000, -2.455700>
      texture { YourTexture }
    }
    sphere { 0, 1.07692 translate <0, 49.72969, -7.50183> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 1.076800 }
        plane { x, 0.961433 inverse }
      }
      translate x*-1.0768
      scale <66.876938, 1, 1>
      translate x*-0.016101
      rotate y*180
      rotate z*38.412182
      rotate y*90
      translate <0, 49.729690, -7.501830>
      texture { YourTexture }
    }
    sphere { 0, 0.96154 translate <0, 54.52445, -13.54867> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 0.961433 }
        plane { x, 0.846055 inverse }
      }
      translate x*-0.961433
      scale <66.871053, 1, 1>
      translate x*-0.014377
      rotate y*180
      rotate z*27.659934
      rotate y*90
      translate <0, 54.524450, -13.548670>
      texture { YourTexture }
    }
    sphere { 0, 0.84615 translate <0, 58.10691, -20.38386> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 0.846055 }
        plane { x, 0.730688 inverse }
      }
      translate x*-0.846055
      scale <66.876810, 1, 1>
      translate x*-0.012651
      rotate y*180
      rotate z*16.907523
      rotate y*90
      translate <0, 58.106910, -20.383860>
      texture { YourTexture }
    }
    sphere { 0, 0.73077 translate <0, 60.35126, -27.7674> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 0.730688 }
        plane { x, 0.615311 inverse }
      }
      translate x*-0.730688
      scale <66.871100, 1, 1>
      translate x*-0.010927
      rotate y*180
      rotate z*6.155239
      rotate y*90
      translate <0, 60.351260, -27.767400>
      texture { YourTexture }
    }
    sphere { 0, 0.61538 translate <0, 61.17871, -35.44003> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 0.615311 }
        plane { x, 0.499944 inverse }
      }
      translate x*-0.615311
      scale <66.876872, 1, 1>
      translate x*-0.009201
      rotate y*180
      rotate z*-4.597062
      rotate y*90
      translate <0, 61.17871, -35.440030>
      texture { YourTexture }
    }
    sphere { 0, 0.5 translate <0, 60.5602, -43.13232> texture { YourTexture } }
    object {
      Connector_2
      clipped_by {
        plane { x, 0.499944 }
        plane { x, 0.384577 inverse }
      }
      translate x*-0.499944
      scale <66.876832, 1, 1>
      translate x*-0.007476
      rotate y*180
      rotate z*-15.349363
      rotate y*90
      translate <0, 60.560200, -43.132320>
      texture { YourTexture }
    }
    sphere { 0, 0.38462 translate <0, 58.51745, -50.57416> texture { YourTexture } }
    bounded_by { sphere { 0, 47.276732 translate <0, 29.954735, -22.151055> } }
  }

//--- Complete Leaf & Stem
#declare Leaf1 =
union {
  object { Leaf_L rotate x*90 translate <0, 54, -38> }
  object { Leaf_R rotate x*90 translate <0, 54, -38> }
  object { Stem }
}