//---  Plant Crock
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Torus1 = 
  quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -2896, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2880, 0, 0, 0, 0, 1, 0, -2896 0, 2073600> }

#declare Torus2 = 
  quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -2468, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2432, 0, 0, 0, 0, 1, 0, -2468, 0, 1478656> }

#declare Grnt7 =
texture {
  pigment {
    granite
    turbulence 0.5
    colour_map {
      [0.000 0.153 colour rgbf <0.439, 0.310, 0.282, 0> colour rgbf <0.463, 0.369, 0.259, 0>]
      [0.153 0.398 colour rgbf <0.463, 0.369, 0.259, 0> colour rgbf <0.541, 0.369, 0.298, 0>]
      [0.398 0.559 colour rgbf <0.541, 0.369, 0.298, 0> colour rgbf <0.573, 0.424, 0.286, 0>]
      [0.559 0.729 colour rgbf <0.573, 0.424, 0.286, 0> colour rgbf <0.494, 0.396, 0.306, 0>]
      [0.729 1.001 colour rgbf <0.494, 0.396, 0.306, 0> colour rgbf <0.439, 0.310, 0.282, 0>]
    }
  }
}
#declare Grnt0a =
texture {
  pigment {
    granite
    turbulence 0.6
    colour_map {
      [0.000 0.153 colour rgbf <0.729, 0.502, 0.451, 0.306> colour rgbf <0.769, 0.686, 0.592, 0.792>]
      [0.153 0.398 colour rgbf <0.769, 0.686, 0.592, 0.792> colour rgbf <0.843, 0.753, 0.718, 0.396>]
      [0.398 0.559 colour rgbf <0.843, 0.753, 0.718, 0.396> colour rgbf <0.780, 0.667, 0.561, 0.976>]
      [0.559 0.729 colour rgbf <0.780, 0.667, 0.561, 0.976> colour rgbf <0.741, 0.659, 0.576, 0.820>]
      [0.729 1.001 colour rgbf <0.741, 0.659, 0.576, 0.820> colour rgbf <0.729, 0.502, 0.451, 0.306>]
    }
  }
}

#declare Stone1 =
texture { Grnt7 scale <2, 3, 2> rotate z*40 finish { ambient 0.1 diffuse 0.4 } }
texture { Grnt0a scale <2, 3, 2> rotate z*-30 finish { ambient 0.1 diffuse 0.4 phong 1.0 phong_size 80 } }

#declare Crock_Texture =
texture { Stone1 scale <20, 35, 10> finish { ambient 0.1 diffuse 0.5 phong 1 phong_size 80 } }

#declare Rib = sphere { 0, 1 scale <20, 41, 41> }

#declare Crock =
union {
  intersection {
    union {
      object { Rib }
      object { Rib rotate y*15 }		
      object { Rib rotate y*30 }
      object { Rib rotate y*45 }
      object { Rib rotate y*60 }
      object { Rib rotate y*75 }
      object { Rib rotate y*90 }
      object { Rib rotate y*105 }
      object { Rib rotate y*120 }
      object { Rib rotate y*135 }
      object { Rib rotate y*150 }
      object { Rib rotate y*165 }
    }
    object { Cylinder_Y scale <33, 1, 33> inverse }
  }	
  object { Torus1 translate y*26 }
  object { Torus2 translate y*26 }
  texture { Crock_Texture }
  bounded_by { sphere { 0, 50 } }
  translate y*30
}