//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//--- Wall
#include "Socket.inc"

#declare MoldingTexture =
texture {
  pigment { color DustyRose }
  finish { ambient 0.05 diffuse 0.7 phong 1 }
}

#declare WallTexture =
texture {
  pigment { image_map { /* <1, -1, 0> */ gif "pp7.gif" interpolate 4 } }
  finish { ambient 0.1 diffuse 0.4 phong 0.1 crand 0.03 }
  scale <225, 300, 1>
}

#declare Wall =
union {
  //--- Baseboard
  object {
    union {
      difference {
        object { Cylinder_X scale <1, 14, 14> translate z*-74 }
        plane { x, 0 rotate y*45 }
        plane { x, 0 rotate y*-45 translate x*1112 inverse }
      }
      difference {
        object { Cylinder_X scale <1, 14, 14> translate z*74 }
        plane { x, 0 rotate y*-45 }
        plane { x, 0 rotate y*45 translate x*1112 inverse }
      }
      difference {
        object { Cylinder_Z scale <14, 14, 1> translate x*-74 }
        plane { x, 0 rotate y*-45 inverse }
        plane { x, 0 rotate y*45 inverse }
      }
      difference {
	object { Cylinder_Z scale <14, 14, 1> translate x*1186 }
	plane { x, 0 rotate y*45 translate x*1112 }
	plane { x, 0 rotate y*-45 translate x*1112 }
      }
      box { -1, 1 scale <630, 45, 74> translate <556, 45, 0> }
      difference {
        box { -1, 1 scale <630, 9, 74> translate <556, 101, 0> }
        object { Cylinder_X scale < 1, 14, 14> translate <   0, 110, -74> }
        object { Cylinder_X scale < 1, 14, 14> translate <   0, 110,  74> }
        object { Cylinder_Z scale <14, 14,  1> translate < -74, 110,   0> }
        object { Cylinder_Z scale <14, 14,  1> translate <1186, 110,   0> }
      }
    }
    texture { MoldingTexture }
    bounded_by { box { -1, 1 scale <650, 70, 95> translate <556, 65, 0> } }
  }
  box { -1, 1
    scale <612, 420, 56>
    texture {
      WallTexture
      translate <-612, -420, 0>
    }
    translate <556, 530, 0>
  } 
  object {
    Square_Z
    scale <56, 420, 1>
    texture {
      WallTexture
      finish { diffuse 0.6 ambient 0.2 }
      translate <56, -420, 0>
    }
    rotate y*90
    translate <-56.1, 530, 0>
  } 
  object {
    Receptical //Plugin
    translate <100, 250, -56>
  }
}