//--- Tonka Toy Truck..............11/08/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Dumby Truck
#declare Dumb1 =
object {
  union {
    box { -1, 1 scale <180, 64,  50> translate <-44, 106, 0> }
    box { -1, 1 scale < 42, 35,  45> translate < 10, 199, 0> }
    box { -1, 1 scale < 44, 41, 100> translate <260,  41, 0> }
    cylinder { z, -z, 1 scale <62, 62, 22> translate <-100, 62, -80> }
    cylinder { z, -z, 1 scale <62, 62, 22> translate <-100, 62,  80> }
    cylinder { z, -z, 1 scale <62, 62, 22> translate < 126, 62, -80> }
    cylinder { z, -z, 1 scale <62, 62, 22> translate < 126, 62,  80> }
  }
  texture {
    pigment { color Gold }
    finish { ambient 0.1 phong 1 }
  }
  bounded_by { box { -1, 1 scale <300, 128, 151> translate <64, 122, 0> } }
}

//----------------------------------- Truck Textures
#declare Truck_Yellow =
texture {
  pigment { color rgb <0.9, 0.56, 0.1> }
  finish { ambient 0.15 phong 1 phong_size 70 reflection { 0.1 } }
}

#declare Gloss_Black =
texture {
  pigment { color Black }
  finish { ambient 0.1 diffuse 0.6 reflection { 0.25 } phong 1 phong_size 70 }
}

#declare Tire_Texture =
texture {
  pigment { image_map { /* <1, -1, 0> */ gif "tire.gif" interpolate 4 } }
  finish { ambient 0.2 diffuse 0.4 phong 0.5 phong_size 10 crand 0.06 }
  scale <130, 130, 1>
  translate <-65, -65, 1>
}

#declare Truck_Glass =
texture {
  //pigment { color Gray95 filter 0.95 }
  pigment { color rgbf <0.90, 0.94, 1.0, 0.8> }
  finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } /* refraction 0.9 */ crand 0.001 }
}

#declare B_Silver =
texture {
  pigment { color Gray70 }
  finish { ambient 0.1 diffuse 0.5 phong 1 phong_size 60 reflection { 0.5 } crand 0.05 }
}

#declare Bumble =
texture {
  pigment {
    gradient x
    color_map {
      [0 .5 color Black color Black]
      [.5 1 color rgb <0.9, 0.56, 0.1> color rgb <0.9, 0.56, 0.1>]
    }
  }
  finish { ambient 0.1 phong 1 phong_size 70 reflection { 0.1 } }
  scale <300, 1, 1>
  translate <-310, 140, 0>
  rotate z*10
}

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane { x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

// #include "P20_CJF.inc"
#declare P20 =
union {
  sphere { 0, 4 translate <-18, 230, -10> texture { Truck_Yellow } }
  object { Connector_1 scale <64, 4, 4> translate <-18, 230, -10> texture { Truck_Yellow } }
  sphere { 0, 4 translate <46, 230, -10> texture { Truck_Yellow } }
  object { Connector_1 scale <2, 4, 4> rotate z*-90 translate <46, 230, -10> texture { Truck_Yellow } }
  sphere { 0, 4 translate <46, 228, -10> texture { Truck_Yellow } }
  object { Connector_1 scale <10, 4, 4> rotate y*-180 translate <46, 228, -10> texture { Truck_Yellow } }
  sphere { 0, 4 translate <36, 228, -10> texture { Truck_Yellow } }
  object { Connector_1 scale <62, 4, 4> rotate z*-75.407449 rotate y*-39.805571 translate <36, 228, -10> texture { Truck_Yellow } }
  sphere { 0, 4 translate <48, 168, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <76, 4, 4> rotate <0, -180, 0> translate <48, 168, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-28, 168, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <61.644140  4, 4> rotate z*76.737324 rotate y*45 translate <-28, 168, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-18, 228, -10> texture { Truck_Yellow } }
  object { Connector_1 scale <2, 4, 4> rotate z*90 translate <-18, 228, -10> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-18, 230, -10> texture { Truck_Yellow } }
  bounded_by { sphere { 0, 60.948339 translate <10, 199, -5> } }
}

//---- Round Pipe for back bed
#declare Pipe1 =
union {
  sphere { 0, 4 translate y*98 texture { Truck_Yellow } }
  object { Connector_1 scale <212, 4, 4> rotate y*-180 translate y* 98 texture { Truck_Yellow } }
  sphere { 0, 4 translate <-212, 98, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <36.878178, 4, 4> rotate z*-77.471192 rotate y*-180 translate <-212, 98, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-220, 62, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <220, 4, 4> translate <-220, 62, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate y*62 texture { Truck_Yellow } }
  bounded_by { sphere { 0, 127.789514 translate <-110, 80, 0> } }
}

#declare P1 = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -3514.25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 3458, 0, 0, 0, 0, 1, 0, -3514.25, 0, 2989441> }

//--- Skirt Around Back Bed
#declare Pipe2 =
union {
  sphere { 0, 4 translate <-22, 52, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <14, 4, 4> rotate z*90 translate <-22  52  0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-22, 66, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <8.485281, 4, 4> rotate z*45 rotate y*-180 translate <-22, 66, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-28, 72, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <192, 4, 4> rotate y*-180 translate <-28, 72, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-220, 72, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <6, 4, 4> rotate z*-90 translate <-220, 72, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-220, 66, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <198.494332 ,4, 4> rotate z*-4.044486 translate <-220, 66, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-22, 52, 0> texture { Truck_Yellow } }
  bounded_by { sphere { 0, 114.426439 translate <-121, 62, 0> } }
}

//--- Stack exhalst
#declare Stack_Pipe =
object {
  union {
    sphere { 0, 6 translate <-120, 170, 18> }
    intersection { 
      object { Connector_2 }
      plane { x, 5.997685 }
      plane { x, 4.998071 inverse }
      translate x*-5.997685
      scale <35.986108, 1, 1>
      translate x*-0.166667
      rotate y*180
      rotate z*90
      translate <-120, 170, 18>
    }
    sphere { 0, 5 translate <-120, 206, 18> }
    intersection {
      object { Connector_2 }
      plane { x, 4.994997 }
      plane { x, 3.995998 inverse }
      translate x*-4.994997
      scale <22.338308, 1, 1>
      translate x*-0.223607
      rotate y*180
      rotate z*26.565051
      rotate y*-180
      translate <-120, 206, 18>
    }
    sphere { 0, 4 translate <-140, 216, 18> }
  }
  texture { Gloss_Black finish { reflection { 0.05 } } }
  bounded_by { sphere { 0, 35.559106 translate <-129, 192, 18> } }
}

#declare Pipe3 =
union {
  sphere { 0, 4 translate <-74, 100, 0> texture { Bumble } }
  object { Connector_1 scale <66, 4, 4> rotate z*90 translate <-74, 100, 0> texture { Bumble } }
  sphere { 0, 4 translate <-74, 166, 0> texture { Bumble } }
  object { Connector_1 scale <22, 4, 4> rotate y*-180 translate <-74, 166, 0> texture { Bumble } }
  sphere { 0, 4 translate <-96, 166, 0> texture { Bumble } }
  object { Connector_1 scale <66, 4, 4> rotate z*-90 translate <-96, 166, 0> texture { Bumble } }
  sphere { 0, 4 translate <-96, 100, 0> texture { Bumble } }
  object { Connector_1 scale <8, 4, 4> rotate y*-180 translate <-96, 100, 0> texture { Bumble } }
  sphere { 0, 4 translate <-104, 100, 0> texture { Bumble } }
  object { Connector_1 scale <66, 4, 4> rotate z*90 translate <-104, 100, 0> texture { Bumble } }
  sphere { 0, 4 translate <-104, 166, 0> texture { Bumble } }
  object { Connector_1 scale <110, 4, 4> rotate y*-180 translate <-104, 166, 0> texture { Bumble } }
  sphere { 0, 4 translate <-214, 166, 0> texture { Bumble } }
  object { Connector_1 scale <57.271284, 4, 4> rotate z*-77.905243 translate <-214, 166, 0> texture { Bumble } }
  sphere { 0, 4 translate <-202, 110, 0> texture { Bumble } }
  object { Connector_1 scale <11.661904, 4, 4> rotate z*-59.036243 rotate y*-180 translate <-202, 110, 0> texture { Bumble } }
  sphere { 0, 4 translate <-208, 100, 0> texture { Bumble } }
  bounded_by { sphere { 0, 91.114269 translate <-144, 133, 0> } }
}

//--- Vent on Engine Hood
#declare Pipe4 =
union {
  sphere { 0, 4 translate <-190, 154, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <78, 4, 4> translate <-190, 154, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-112, 154, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <38, 4, 4> rotate z*-90 translate <-112, 154, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-112, 116, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <70, 4, 4> rotate y*-180 translate <-112, 116, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-182  116  0> texture { Truck_Yellow } }
  object { Connector_1 scale <38.832976, 4, 4> rotate z*78.111342 rotate y*-180 translate <-182, 116, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-190  154  0> texture { Truck_Yellow } }
  bounded_by { sphere { 0, 53.821371 translate <-151, 135, 0> } }
}

//-- Rib for Vent on Engine Hood
#declare Pipe5 =
union {
  sphere { 0, 2.5 translate <-183, 152, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <34.928498, 2.5, 2.5> rotate z*-76.759480 translate <-183, 152, 0> texture { Truck_Yellow } }
  sphere { 0, 2.5 translate <-175, 118, 0> texture { Truck_Yellow } }
  bounded_by { sphere { 0, 22.776907 translate <-179, 135, 0> } }
}

//-- Rib for Vent on Engine Hood
#declare Pipe5 =
union {
  sphere { 0, 2.5 translate <-183, 152, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <34.928498, 2.5, 2.5> rotate z*-76.759480 translate <-183, 152, 0> texture { Truck_Yellow } }
  sphere { 0, 2.5 translate <-175, 118, 0> texture { Truck_Yellow } }
  bounded_by { sphere { 0, 22.776907 translate <-179, 135, 0> } }
}

//--- Cab Base
#declare Pipe7 =
union {
  sphere { 0, 4 translate <-32, 164, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <92, 4, 4> translate <-32, 164, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate < 60, 164, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <133.775932, 4, 4> rotate z*-58.448615 translate <60, 164, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate < 130, 50, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <6, 4, 4> rotate z*-90 translate <130, 50, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate < 130, 44, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <96, 4, 4> rotate y*-180 translate <130, 44, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate < 34, 44, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <6, 4, 4> rotate z*90 translate <34, 44, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate < 34, 50, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <26, 4, 4> translate <34, 50, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate < 60, 50, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <58, 4, 4> rotate z*90 translate <60, 50, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate < 60, 108, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <92, 4, 4> rotate y*-180 translate <60, 108, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-32, 108, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <56, 4, 4> rotate z*90 translate <-32, 108, 0> texture { Truck_Yellow } }
  sphere { 0, 4 translate <-32, 164, 0> texture { Truck_Yellow } }
  bounded_by { box { -1, 1 scale <95, 70, 5> translate <47, 104, 0> } }
}

//--- Cab
#declare Pipe8 =
object {
  union {
    sphere { 0, 4 translate <-18, 230, 10> texture { Truck_Yellow } }
    object { Connector_1 scale <64, 4, 4> translate <-18, 230, 10> texture { Truck_Yellow } }
    sphere { 0, 4 translate <46, 230, 10> texture { Truck_Yellow } }
    object { Connector_1 scale <2, 4, 4> rotate z*-90 translate <46, 230, 10> texture { Truck_Yellow } }
    sphere { 0, 4 translate <46, 228, 10> texture { Truck_Yellow } }
    object { Connector_1 scale <10, 4, 4> rotate y*-180 translate <46, 228, 10> texture { Truck_Yellow } }
    sphere { 0, 4 translate <36, 228, 10> texture { Truck_Yellow } }
    object { Connector_1 scale <62, 4, 4> rotate z*-75.407449 rotate y*39.805571 translate <36, 228, 10> texture { Truck_Yellow } }
    sphere { 0, 4 translate <48, 168, 0> texture { Truck_Yellow } }
    object { Connector_1 scale <76, 4, 4> rotate <0, -180, 0> translate <48, 168, 0> texture { Truck_Yellow } }
    sphere { 0, 4 translate <-28, 168, 0> texture { Truck_Yellow } }
    object { Connector_1 scale <61.644140  4, 4> rotate z*76.737324 rotate y*-45 translate <-28, 168, 0> texture { Truck_Yellow } }
    sphere { 0, 4 translate <-18, 228, 10> texture { Truck_Yellow } }
    object { Connector_1 scale <2, 4, 4> rotate z*90 translate <-18, 228, 10> texture { Truck_Yellow } }
    sphere { 0, 4 translate <-18, 230, 10> texture { Truck_Yellow } }
    bounded_by { box { -1, 1 scale <50, 38, 12> translate <10, 200, 0> } }
    translate <0, 0, -44>
  }
  bounded_by { box { -1, 1 scale <50, 38, 50> translate <10, 200, 0> } }
}

//--- Cab Window
#declare Pipe9 =
union {
  sphere { 0, 3 translate <-49, 47, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <36, 3, 3> translate <-49, 47, 0> texture { Truck_Yellow } }
  sphere { 0, 3 translate <-13, 47, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <45.122057, 3, 3> rotate z*-77.195734 translate <-13, 47, 0> texture { Truck_Yellow } }
  sphere { 0, 3 translate <-3, 3, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <54, 3, 3> rotate y*-180 translate <-3, 3, 0> texture { Truck_Yellow } }
  sphere { 0, 3 translate <-57, 3, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <44.721360, 3, 3> rotate z*79.695154 translate <-57, 3, 0> texture { Truck_Yellow } }
  sphere { 0, 3 translate <-49, 47, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <10, 3, 3> translate <-49, 47, 0> texture { Truck_Yellow } }
  sphere { 0, 3 translate <-39, 47, 0> texture { Truck_Yellow } }
  object { Connector_1 scale <45.122057, 3, 3> rotate z*-77.195734 translate <-39, 47, 0> texture { Truck_Yellow } }
  sphere { 0, 3 translate <-29, 3, 0> texture { Truck_Yellow } }
  bounded_by { sphere { 0, 43.082943 translate <-30, 25, 0> } }
  scale <1, 1, 0.6>
}

//-- Shovel Head & a few toruss
#declare S1 =
union {
  sphere { 0, 2 translate <20, -22, 0> texture { Gloss_Black } }
  object { Connector_1 scale <14.142136, 2, 2> rotate z*-45 translate <20, -22, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <30, -32, 0> texture { Gloss_Black } }
  object { Connector_1 scale <62, 2, 2> translate <30, -32, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <92, -32, 0> texture { Gloss_Black } }
  object { Connector_1 scale <10, 2, 2> rotate z*36.869898 rotate y*-180 translate <92, -32, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <84, -26, 0> texture { Gloss_Black } }
  object { Connector_1 scale <58.855756, 2, 2> rotate z*80.217593 rotate y*-180 translate <84, -26, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <74, 32, 0> texture { Gloss_Black } }
  object { Connector_1 scale <7.211103, 2, 2> rotate z*33.690068 translate <74, 32, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <80, 36, 0> texture { Gloss_Black } }
  object { Connector_1 scale <8.246211, 2, 2> rotate z*75.963757 rotate y*-180 translate <80, 36, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <78, 44, 0> texture { Gloss_Black } }
  object { Connector_1 scale <61.351447, 2, 2> rotate z*-19.025606 rotate y*-180 translate <78, 44, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <20, 24, 0> texture { Gloss_Black } }
  object { Connector_1 scale <46, 2, 2> rotate z*-90 translate <20, 24, 0> texture { Gloss_Black } }
  sphere { 0, 2 translate <20, -22, 0> texture { Gloss_Black } }
  bounded_by { box { -1, 1 scale <58, 46, 5> translate <40, 6, 0> } }
}

//--- Torus for Tire
#declare TR2 = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -3764, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2320, 0, 0, 0, 0, 1, 0, -3764, 0, 1345600> rotate x*90 }
#declare TR3 = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -259.25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 247, 0, 0, 0, 0, 1, 0, -259.25, 0, 15252.25> }

#declare Spoke = object { Cylinder_Y scale <5, 1, 16> translate z*-22 inverse }
#declare Spoke1 = object { Cylinder_Y scale <5, 1, 16> rotate z*10 translate z*22 inverse }

//-- Cut-out for cab window
#declare Window =
intersection {
  plane { x,    0 rotate  z*12.7 translate < 37, 177, 0> }
  plane { x,    0 rotate z*-10.8 translate <-17, 177, 0> inverse }
  plane { y,  177 inverse }
  plane { y,  221 }
  plane { z, -100 inverse }
  plane { z,  100 }
}

#declare Axle = cylinder { z, -z, 1 scale <3, 3, 85> texture { B_Silver } } 

//--------------------------- Truck Tires
#declare Tire =
union {
  object {
    union {
      object { TR2 scale <1, 1, 1.15> }
      intersection {
        sphere { 0, 1 scale <62, 61, 62> }
        plane { z, 22 }
        plane { z, -22 inverse }
        object { Cylinder_Z scale <39, 39, 1> inverse }
        object { Spoke }
        object { Spoke rotate z*20 }
        object { Spoke rotate z*40 }
        object { Spoke rotate z*60 }
        object { Spoke rotate z*80 }
        object { Spoke rotate z*100 }
        object { Spoke rotate z*120 }
        object { Spoke rotate z*140 }
        object { Spoke rotate z*160 }
        object { Spoke1 }
        object { Spoke1 rotate z*20 }
        object { Spoke1 rotate z*40 }
        object { Spoke1 rotate z*60 }
        object { Spoke1 rotate z*80 }
        object { Spoke1 rotate z*100 }
        object { Spoke1 rotate z*120 }
        object { Spoke1 rotate z*140 }
        object { Spoke1 rotate z*160 }
      }
    }
    texture { Tire_Texture }
    bounded_by { box { -1, 1 scale <65, 65, 30> } }
  }
  object {
    union {
      difference {
        cylinder { z, -z, 1 scale <24, 24, 15> }
        cylinder { z, -z, 1 scale <20, 20, 15> translate z*-2 }
      }
      cylinder { z, -z, 1 scale <9, 7, 5> translate <18, 0, -5> }
      cylinder { z, -z, 1 scale <9, 7, 5> translate <18, 0, -5> rotate z*72 }
      cylinder { z, -z, 1 scale <9, 7, 5> translate <18, 0, -5> rotate z*144 }
      cylinder { z, -z, 1 scale <9, 7, 5> translate <18, 0, -5> rotate z*215 }
      cylinder { z, -z, 1 scale <9, 7, 5> translate <18, 0, -5> rotate z*288 }
    }
    texture { Truck_Yellow }
    bounded_by { box { -1, 1 scale <25, 25, 18> } }
  }
}

//-------------------------- One Complete Truck
#declare Truck =
union {
  union {
    union {
      object { Pipe1 translate z*-42 }
      object { Pipe1 translate z*42 }
      object {
        union {
          object { P1 translate y*98 }
          cylinder { y, -y, 1 scale <42,  4, 42> translate y*98 }
          cylinder { y, -y, 1 scale <46, 18, 46> translate y*80 }
        }
        texture { Truck_Yellow }
        bounded_by { box { -1, 1 scale <50, 30, 50> translate y*75 } }
      }   
      object {
        union {
          triangle { <   0  98,  -46>, <-212,  98, -46>, <-220,  62, -46> }
          triangle { <   0, 98,  -46>, <   0,  62, -46>, <-220,  62, -46> }
          triangle { <   0, 98,   46>, <-212,  98,  46>, <-220,  62,  46> }
          triangle { <   0, 98,   46>, <   0,  62,  46>, <-220,  62,  46> }
          triangle { <   0, 102, -42>, <-212, 102, -42>, <-212, 102,  42> }
          triangle { <   0, 102, -42>, <   0, 102,  42>, <-212, 102,  42> }
          triangle { <-224, 62,  -42>, <-216,  98, -42>, <-224,  62,  42> }
          triangle { <-216, 98,   42>, <-216,  98, -42>, <-224,  62,  42> }
          cylinder { z, -z, 1 scale <4, 4, 42> translate <-212,  98,   0> }
        }
        texture { Truck_Yellow }
      }   
      //--- Side Skirt around back bed
      union {
        object { Pipe2 translate z*-50 }
        object { Pipe2 translate z*50 }
        object {
          union {
            triangle { <-22, 52, -54>, < -28, 72, -54>, < -22, 62, -54> }
            triangle { <-22, 52, -54>, <-220, 66, -54>, < -28, 72, -54> }
            triangle { <-28, 72, -54>, <-220, 72, -54>, <-220, 66, -54> }
            triangle { <-22, 52,  54>, < -28, 72,  54>, < -22, 62,  54> }
            triangle { <-22, 52,  54>, <-220, 66,  54>, < -28, 72,  54> }
            triangle { <-28, 72,  54>, <-220, 72,  54>, <-220, 66,  54> }
          }
          texture { Truck_Yellow }
          bounded_by { box { -1, 1 scale <108, 21, 55> translate <-120, 63, 0> } }
        } 
      }
      //--- Back Engine Hood
      union {
        object { Pipe3 translate z*-40 }
        object { Pipe3 translate z*40 }
        object {
          union {
            cylinder { z, -z, 1 scale <4, 4, 40> translate < -74, 166, 0> }
            cylinder { z, -z, 1 scale <4, 4, 40> translate < -96, 166, 0> }
            cylinder { z, -z, 1 scale <4, 4, 40> translate <-104, 166, 0> }
            cylinder { z, -z, 1 scale <4, 4, 40> translate <-214, 166, 0> }
            triangle { < -74, 100, -44>, < -96, 100, -44>, < -74, 166, -44> }
            triangle { < -96, 100, -44>, < -74, 166, -44>, < -96, 166, -44> }
            triangle { <-104, 100, -44>, <-208, 100, -44>, <-104, 166, -44> }
            triangle { <-208, 100, -44>, <-104, 166, -44>, <-202, 110, -44> }
            triangle { <-202, 110, -44>, <-104, 166, -44>, <-214, 166, -44> }
            triangle { < -74, 100,  44>, < -96, 100,  44>, < -74, 166,  44> }
            triangle { < -96, 100,  44>, < -74, 166,  44>, < -96, 166,  44> }
            triangle { <-104, 100,  44>, <-208, 100,  44>, <-104, 166,  44> }
            triangle { <-208, 100,  44>, <-104, 166,  44>, <-202, 110,  44> }
            triangle { <-202, 110,  44>, <-104, 166,  44>, <-214, 166,  44> }
            triangle { < -70, 100, -40>, < -70, 100,  40>, < -70, 166,  40> }
            triangle { < -70, 100, -40>, < -70, 166, -40>, < -70, 166,  40> }
            triangle { < -74, 170, -40>, < -96, 170, -40>, < -96, 170,  40> }
            triangle { < -74, 170, -40>, < -74, 170,  40>, < -96, 170,  40> }
            triangle { <-104, 170, -40>, <-214, 170, -40>, <-214, 170,  40> }
            triangle { <-214, 170,  40>, <-104, 170,  40>, <-104, 170, -40> }
          }
          texture { Bumble }
          bounded_by { box { -1, 1 scale <80, 42, 55> translate <-144, 134, 0> } }
        } 
      }
      //--- Vent Panel & Vents on Engine Cover
      union {
        object { Pipe4 translate z*-44 }
        object { Pipe5 translate z*-48 }
        object { Pipe5 translate <10, 0, -48> }
        object { Pipe5 translate <20, 0, -48> }
        object { Pipe5 translate <30, 0, -48> }
        object { Pipe5 translate <40, 0, -48> }
        object { Pipe5 translate <50, 0, -48> }
        object { Pipe5 translate <60, 0, -48> }
        union {
          triangle { <-112, 154, -48>, <-190, 154, -48>, <-182, 116, -48> }
          triangle { <-112, 154, -48>, <-112, 116, -48>, <-182, 116, -48> }
          texture { Truck_Yellow }
        }
        bounded_by { box { -1, 1 scale <45, 27, 8> translate <-151, 135, -48> } }  
      }
      //--- Vent Panel & Vents on Engine Cover "Back"
      union {
        object { Pipe4 translate z*44 }
        object { Pipe5 translate z*48 }
        object { Pipe5 translate <10, 0, 48> }
        object { Pipe5 translate <20, 0, 48> }
        object { Pipe5 translate <30, 0, 48> }
        object { Pipe5 translate <40, 0, 48> }
        object { Pipe5 translate <50, 0, 48> }
        object { Pipe5 translate <60, 0, 48> }
        union {
          triangle { <-112, 154, 48>, <-190, 154, 48>, <-182, 116, 48> }
          triangle { <-112, 154, 48>, <-112, 116, 48>, <-182, 116, 48> }
          texture { Truck_Yellow }
        }
        bounded_by { box { -1, 1 scale <45, 27, 8> translate <-151, 135, 48> } }
      }
      bounded_by { box { -1, 1 scale <145, 75, 55> translate <-87, 106, 0> } }
    }
    object { Stack_Pipe }
    object { Tire translate <-100, 60.5, -78> }
    object { Tire rotate y*180 translate <-100, 60.5, 78> }
    object { Axle translate <-100, 60.5, 0> }
    rotate y*20 //-----Use to rotate back bed
  }

  //--- Cab Base
  union {
    union {
      union {
        union {
          object { Pipe7 translate z*47 }
          object { Pipe7 translate z*-47 }
          bounded_by {  box { -1, 1 scale <95, 70, 53> translate <47, 104, 0> } }
        }
        union {
          cylinder { z, -z, 1 scale <4, 4, 47> translate < 34,  44, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate < 34,  50, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate < 60,  50, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate < 60, 108, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate <-32, 108, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate <-32, 164, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate < 60, 164, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate <130,  50, 0> }
          cylinder { z, -z, 1 scale <4, 4, 47> translate <130,  44, 0> }
          texture { Truck_Yellow }
          bounded_by { box { -1, 1 scale <95, 70, 53> translate <47, 104, 0> } }
        } 
        union {
          triangle { <-36,   164, -47>, <-36,  108, -47>, <-36,   164,  47> }
          triangle { <-36,   108, -47>, <-36,  164,  47>, <-36,   108,  47> }
          triangle { <-32,   108,  51>, <-32,  164,  51>, < 60,   164,  51> }
          triangle { <-32,   108,  51>, < 60,  108,  51>, < 60,   164,  51> }      
          triangle { <-32,   108, -51>, <-32,  164, -51>, < 60,   164, -51> }
          triangle { <-32,   108, -51>, < 60,  108, -51>, < 60,   164, -51> }      
          triangle { < 34,    54, -47>, < 60,   54, -47>, < 34,    54,  47> }
          triangle { < 60,    54, -47>, < 34,   54,  47>, < 60,    54,  47> }
          triangle { < 34,    50, -51>, < 34,   44, -51>, <130,    50, -51> }
          triangle { < 34,    44, -51>, <130,   44, -51>, <130,    50, -51> }
          triangle { < 60,   164, -51>, < 60,   50, -51>, <130,    50, -51> }
          triangle { < 34,    50,  51>, < 34,   44,  51>, <130,    50,  51> }
          triangle { < 34,    44,  51>, <130,   44,  51>, <130,    50,  51> }
          triangle { < 60,   164,  51>, < 60,   50,  51>, <130,    50,  51> }
          triangle { < 64.5, 164, -47>, <134.5, 50, -47>, < 64.5, 164,  47> }
          triangle { < 64.5, 164,  47>, <134.5, 50, -47>, <134.5, 50, 47> }
          cylinder { y, -y, 1 scale <40, 7, 40> translate <30, 47, 0> }
          triangle { <60, 168, -47>, <26, 168, -47>, <26, 168, 47> }
          triangle { <60, 168, -47>, <60, 168,  47>, <26, 168, 47> }
          texture { Truck_Yellow }
          bounded_by { box { -1, 1 scale <95, 70, 53> translate <47, 104, 0> } }
        }
      }
      //--- Cab & Windsheld
      union {
        object { Pipe8 }
        object { P20 translate z*44 }
        object { Pipe9 rotate x* 9.3 translate <40, 174, -47> }
        object { Pipe9 rotate x*-9.3 translate <40, 174,  47> }
        //--- Steering Wheel
        object {
          TR3
          texture { Gloss_Black }
          bounded_by { box { -1, 1 scale <14, 5, 14> } }
          rotate z*10
          translate <29, 178, 0> 
        }
      union {
        cylinder { z, -z, 1 scale <4, 4, 34> translate <-18, 230, 0> }
        cylinder { z, -z, 1 scale <4, 4, 34> translate <-18, 228, 0> }
        cylinder { z, -z, 1 scale <4, 4, 34> translate < 46, 230, 0> }
        cylinder { z, -z, 1 scale <4, 4, 34> translate < 46, 228, 0> }
        cylinder { z, -z, 1 scale <4, 4, 34> translate < 36, 228, 0> }
        cylinder { z, -z, 1 scale <4, 4, 40> translate <-28, 168, 0> }
        cylinder { z, -z, 1 scale <4, 4, 40> translate < 48, 168, 0> }
        texture { Truck_Yellow }
        bounded_by { box { -1, 1 scale <50, 38, 50> translate <10, 200, 0> } }
      }
      union {
        triangle { <-28, 168, -48.4>, <-18, 228, -38.4>, < 36, 228, -38.4> }
        triangle { <-28, 168, -48.4>, < 48, 168, -48.4>, < 36, 228, -38.4> }
        triangle { <-18, 228, -38>,   < 46, 228, -38>,   <-18, 230, -38> }
        triangle { <-18, 230, -38>,   < 46, 228, -38>,   < 46, 230, -38> }
        triangle { <-28, 168,  48.4>, <-18, 228,  38.4>, < 36, 228,  38.4> }
        triangle { <-28, 168,  48.4>, < 48, 168,  48.4>, < 36, 228,  38.4> }
        triangle { <-18, 228,  38>,   < 46, 228,  38>,   <-18, 230,  38> }
        triangle { <-18, 230,  38>,   < 46, 228,  38>,   < 46, 230,  38> }
        triangle { <-18, 234, -34>,   < 46, 234, -34>,   <-18, 234,  34> }    
        triangle { <-18, 234,  34>,   < 46, 234,  34>,   < 46, 234, -34> }
        texture { Truck_Yellow }
        bounded_by { box { -1, 1 scale <50, 38, 50> translate <10, 200, 0> }  }
        clipped_by { object { Window inverse }  }
      }  
      //--- Glass
      object {
        intersection {
          plane { x, 0 rotate z*-9.6 translate <-28, 168, 0> inverse }
          plane { x, 0 rotate  z*9.6 translate < 48, 168, 0> }
          plane { y, 168 inverse }
          plane { y, 228 }
          plane { z, 0 rotate  x*9.7 translate <0, 168, -47> inverse }
          plane { z, 0 rotate x*-9.7 translate <0, 168,  47> }
        }
        texture { Truck_Glass }
        interior { ior 1.5 }
        bounded_by { box { -1, 1 scale <50, 38, 50> translate <10, 200, 0> }  }
      }
      object { Tire translate <123, 60.5, -78> }
      object { Tire rotate y*180 translate <123, 60.5, 78> }
      object { Axle translate <123, 60.5, 0> } 
    }
    bounded_by { box { -1, 1 scale <135, 125, 111> translate <88, 119, 0> } }
    //rotate 0 //---- rotates whole cab & cab base
  }
  union {
    union {
      union {
      //--- Front Arm
        union {
          cylinder { z, -z, 1 scale <14, 14, 0.1> translate <0, -2, -53> }
          cylinder { z, -z, 1 scale <14, 14, 0.1> translate <160, -120, -53> }
          triangle { <  0,  -16, -53>, <  0,   12, -53>, < 80,   12, -53> }
          triangle { <  0,  -16, -53>, < 80,   12, -53>, < 80,  -32, -53> }
          triangle { < 80,   12, -53>, < 80,  -56, -53>, <138,  -46, -53> }
          triangle { < 80,  -56, -53>, <138,  -46, -53>, <116,  -96, -53> }
          triangle { <116,  -96, -53>, <154,  -96, -53>, <138,  -46, -53> }
          triangle { <116,  -96, -53>, <174,  -96, -53>, <116, -104, -53> }
          triangle { <116, -104, -53>, <174,  -96, -53>, <150, -132, -53> }
          triangle { <150, -132, -53>, <174, -122, -53>, <174,  -96, -53> }
          triangle { < 22,   12, -53>, < 80,   12, -53>, < 22,   12, -48> }
          triangle { < 80,   12, -53>, < 22,   12, -48>, < 80,   12, -48> }
          texture { Truck_Yellow }
          bounded_by { box { -1, 1 scale <100, 80, 6> translate <81, -61, -53> } }
        }
        //--- Back Arm
        union {
          cylinder { z, -z, 1 scale <14, 14, 0.1> translate <0, -2, 53> }
          cylinder { z, -z, 1 scale <14, 14, 0.1> translate <160, -120, 53> }
          triangle { <  0,  -16, 53>, <  0,   12, 53>, < 80,   12, 53> }
          triangle { <  0,  -16, 53>, < 80,   12, 53>, < 80,  -32, 53> }
          triangle { < 80,   12, 53>, < 80,  -56, 53>, <138,  -46, 53> }
          triangle { < 80,  -56, 53>, <138,  -46, 53>, <116,  -96, 53> }
          triangle { <116,  -96, 53>, <154,  -96, 53>, <138,  -46, 53> }
          triangle { <116,  -96, 53>, <174,  -96, 53>, <116, -104, 53> }
          triangle { <116, -104, 53>, <174,  -96, 53>, <150, -132, 53> }
          triangle { <150, -132, 53>, <174, -122, 53>, <174,  -96, 53> }
          triangle { < 22,   12, 53>, < 80,   12, 53>, < 22,   12, 48> }
          triangle { < 80,   12, 53>, < 22,   12, 48>, < 80,   12, 48> }
          texture { Truck_Yellow }
          bounded_by { box { -1, 1 scale <100, 80, 6> translate <81, -61, 53> } }
        }
        //--- Middle Plate on Shovel Arm
        union {
          triangle { < 80,  12, -53>, <138, -46, -53>, <80, 12, 53> }
          triangle { <138, -46, -53>, <138, -46,  53>, <80, 12, 53> }
          texture { Truck_Yellow }
          clipped_by {
            box { -1, 1 scale <18, 26, 2.5> translate <108, -16, -45> inverse }
            box { -1, 1 scale <18, 26, 2.5> translate <108, -16,  45> inverse }
          }
        }
        //--- Pivot Pins on Arm
        union {
          sphere { 0, 1 scale <5, 5, 2> translate z*-53 }
          sphere { 0, 1 scale <5, 5, 2> translate <118,  -38, -53> }
          sphere { 0, 1 scale <5, 5, 2> translate <160, -120, -53> }
          sphere { 0, 1 scale <5, 5, 2> translate z*53 }
          sphere { 0, 1 scale <5, 5, 2> translate <118,  -38, 53> }
          sphere { 0, 1 scale <5, 5, 2> translate <160, -120, 53> }
          sphere { 0, 1 scale <5, 5, 2> translate <160, -120, 51> }
          sphere { 0, 1 scale <5, 5, 2> translate <160, -120, 51> }
          texture { B_Silver }
          bounded_by { box { -1, 1 scale <100, 80, 60> translate <81, -61, 0> } }
        }
        bounded_by { box { -1, 1 scale <100, 80, 60> translate <81, -61, 0> } }
      }    
      //-- Shovle Mouth Handle     
      union {
        triangle { <111,  -6, -45>, <108, -18, -45>, <174, -22, -45> }
        triangle { <108, -18, -45>, <174, -22, -45>, <172, -32, -45> }
        cylinder { z, -z, 1 scale <15, 15, 0.1> translate <107, -21, -45> }
        triangle { <111,  -6, 45>, <108, -18, 45>, <174, -22, 45> }
        triangle { <108, -18, 45>, <174, -22, 45>, <172, -32, 45> }
        cylinder { z, -z, 1 scale <15, 15, 0.1> translate <107, -21, 45> }
        triangle { <174, -22, -45>, <172, -32, -45>, <174, -22, 45> }
        triangle { <172, -32, -45>, <174, -22,  45>, <172, -32, 45> }
        triangle { <174, -22, -45>, <172, -18, -45>, <172, -18, 45> }
        triangle { <174, -22, -45>, <172, -18,  45>, <174, -22, 45> }
        texture { Gloss_Black }
        bounded_by { box { -1, 1 scale <45, 19, 50> translate <132, -21, 0> } }
        translate <-107, 21, 0>
        //rotate 0 //--- rotate handle +z to pull back as the shovel drops
        translate <107, -21, 0>
      }
    }
    //--- Shovel Mouth
    union {
      object { S1 translate z*102 }
      object { S1 translate z*-102 }
      union {
        cylinder { z, -z, 1 scale <2, 2, 102> translate <20, -22, 0> }
        cylinder { z, -z, 1 scale <2, 2, 102> translate <30, -32, 0> }
        cylinder { z, -z, 1 scale <2, 2, 102> translate <92, -32, 0> }
        cylinder { z, -z, 1 scale <2, 2, 102> translate <84, -30, 0> }
        cylinder { z, -z, 1 scale <2, 2, 102> translate <80,  36, 0> }
        cylinder { z, -z, 1 scale <2, 2, 102> translate <78,  44, 0> }
        cylinder { z, -z, 1 scale <2, 2, 102> translate <20,  24, 0> }
        texture { Gloss_Black }
        bounded_by { box { -1, 1 scale <58, 46, 110> translate <40, 6, 0> } }
      } 
      union {
        triangle { <20,  24, -104>, <78,  44, -104>, <80,  36, -104> }
        triangle { <20,  24, -104>, <80,  36, -104>, <74,  32, -104> }
        triangle { <20,  24, -104>, <20, -22, -104>, <74,  32, -104> }
        triangle { <20, -22, -104>, <74,  32, -104>, <84, -26, -104> }
        triangle { <20, -22, -104>, <84, -26, -104>, <30, -32, -104> }
        triangle { <30, -32, -104>, <84, -26, -104>, <92, -32, -104> }
        texture { Gloss_Black }
        bounded_by { box { -1, 1 scale <58, 46, 2> translate <40, 6, -104> } }
      }
      union {
        triangle { <20,  24, 104>, <78,  44, 104>, <80,  36, 104> }
        triangle { <20,  24, 104>, <80,  36, 104>, <74,  32, 104> }
        triangle { <20,  24, 104>, <20, -22, 104>, <74,  32, 104> }
        triangle { <20, -22, 104>, <74,  32, 104>, <84, -26, 104> }
        triangle { <20, -22, 104>, <84, -26, 104>, <30, -32, 104> }
        triangle { <30, -32, 104>, <84, -26, 104>, <92, -32, 104> }
        texture { Gloss_Black }
        bounded_by { box { -1, 1 scale <58, 46, 2> translate <40, 6, 104> } }
      }
      union {
        triangle { <80,  44, -102>, <82,  36, -102>, <80,  44, 102> }
        triangle { <82,  36, -102>, <80,  44,  102>, <82,  36, 102> }
        triangle { <18,  24, -102>, <18, -22, -102>, <18,  24, 102> }
        triangle { <18, -22, -102>, <18,  24,  102>, <18, -22, 102> }
        triangle { <20,  26, -102>, <78,  46, -102>, <20,  26, 102> }
        triangle { <78,  46, -102>, <78,  46,  102>, <20,  26, 102> }
        triangle { <30, -34, -102>, <92, -34, -102>, <30, -34, 102> }
        triangle { <92, -34, -102>, <30, -34,  102>, <92, -34, 102> }
        triangle { <20, -22, -102>, <30, -32, -102>, <20, -22, 102> }
        triangle { <30, -32, -102>, <20, -22,  102>, <30, -32, 102> }
        cylinder { z, -z, 1 scale <16, 16, 1> translate z*-52 }
        box { -1, 1 scale <9, 16, 1> translate <9, 0, -52> } 
        cylinder { z, -z, 1 scale <16, 16, 1> translate z*52 }
        box { -1, 1 scale <9, 16, 1> translate <9, 0, 52> } 
        texture { Gloss_Black }
        bounded_by { box { -1, 1 scale <58, 46, 110> translate <40, 6, 0> } }
      }
      bounded_by { box { -1, 1 scale <58, 46, 110> translate <40, 6, 0> } }
      rotate z*-30 //--- rotate shovel head -z to dump load
      translate <160, -120, 0>
    }
    rotate z*30 //--- rotate shovel arm & shovel +z for up direction
    translate <46, 154, 0>
   }
   rotate y*-25 //--- rotate cab & shovel +y to turn in -y to turn out
  }
  bounded_by { box { -1, 1 scale <300, 128, 151> translate <64, 122, 0> } }
}