//--- The Little People................ 11/8/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare Head_Texture =
texture {
  pigment { image_map { /* <1, -1, 0> */ gif "faceskin.gif" interpolate 4 } }
  finish { ambient 0.35 diffuse 0.4 phong 1 phong_size 80 reflection { 0.1 } }
  scale <26, 26, 1>
  translate <-13, -13, 1>
}

#declare Skin_Texture =
texture {
  pigment { image_map { /* <1, -1, 0> */ gif "skin.gif" } }
  finish { ambient 0.35 diffuse 0.4 phong 1 phong_size 80 reflection { 0.1 } }
}

#declare Chest_Texture =
texture {
  pigment { color SteelBlue }
  finish { ambient 0.2 diffuse 0.6 reflection { 0.1 } phong 1 phong_size 90 }
}

#declare Legs_Texture =
texture {
  pigment { color Navy }
  finish { ambient 0.2 diffuse 0.6  reflection { 0.1 }  phong 1 phong_size 90 }
}

#declare Head = 
union {
   //---- Face
   union {
     sphere { 0, 10.6 translate y*12.4 }
     cylinder { y, -y, 1 scale <2.5, 2, 2.5> translate y*1.6 }
     texture { Head_Texture translate y*9 }
   }
   //---- Back of Head
   sphere { 0, 10.6 translate <0, 12.4, 0.2> texture { Skin_Texture } }
   //--- Yellow Hat
   object {
     union {
       difference {
         union {
	       sphere { 0, 12 translate y*12.4 }
	       cylinder { y, -y, 1 scale <13, 0.7, 13> translate y*14.9 }
	       box { -1, 1 scale <13, 1.8, 2> translate y*16.1 }
	       cylinder { x, -x, 1 scale <0.5, 15, 15> translate y*12.4 }
	       cylinder { x, -x, 1 scale <0.5, 15, 15> translate <3, 12.4, 0> }
	       cylinder { x, -x, 1 scale <0.5, 15, 15> translate <-3, 12.4, 0> }
	     }
         sphere { 0, 13 translate y*12.4 inverse }
	     plane { y, 14.2 }
       }
       difference {
         sphere { 0, 1 scale <12, 8, 16> translate y*11 }
	     plane { y, 14.2 }
	     plane { z, 0 inverse }
       }
     }
     texture { Truck_Yellow }
     bounded_by { box { -1, 1 scale <16, 10, 18> translate y*15 } }
   }
   bounded_by { box { -1, 1 scale <16, 18, 18> translate y*14 } }
}

#declare Chest =
object {
  difference {
    union {
      sphere { 0, 1 scale <10, 4.5, 9> translate y*26.6 }
      cylinder { y, -y, 1 scale <10, 5.53, 9> translate y*20.8 }
    }
    plane { x, 0 rotate z*-7 translate <-10, 20, 0> }
    plane { x, 0 rotate z*-7 translate <10, 20, 0> inverse }
  }
  texture { Chest_Texture }
  bounded_by { box { -1, 1 scale <15, 10, 15> translate y*22.6 } }
} 

#declare Legs =
object {
  difference {
    union {
      sphere { 0, 1 scale <10.7, 15, 10.5> translate y*10 }
      sphere { 0, 9.2 translate x*-3.7 }
      sphere { 0, 9.2 translate x*3.7 }
    }
    plane { y, 0 }
    plane { y, 14.6 inverse }
  }
  texture { Legs_Texture }
  bounded_by { box { -1, 1 scale <15, 10, 15> translate y*7 } }
} 

#declare Arm =
object {
  union {
    intersection {
      quadric { <0.390625, -0.028950391245243, 0.390625>, 0, 0, -1 }
      plane { y, 6.570944330792904 }
      plane { y, -3.029055669207092 inverse }
      translate y*3.029055669207092
    }
    sphere { 0, 1 scale <2.6, 3.6, 2.6> translate y*11 }
    difference {
      union {
        sphere { 0, 1 scale <1.8, 3.7, 1.8> translate y*-0.9 }
        sphere { 0, 2.7 translate <-0.9, -2.9, 0> }	
      }
      object { Cylinder_Z scale <1.1, 1.1, 1> translate <-1.1, -2.9, 0> }
      box { -1, 1 scale <1.3, 0.9, 3> translate <-2.3, -3.1, 0> }
    }
  }
  texture { Skin_Texture }
  bounded_by { box { -1, 1 scale <5, 11, 5> translate y*4.5 } }
  scale <1, 1, 1.6>
  translate y*-10.9
}

//--- Man with right arm up 
#declare Man1 =
union {
  object { Head translate y*30 rotate y*-10 }
  object { Chest }
  object { Legs }
  object { Arm rotate z*18 rotate x*40 translate <10.5, 26.1, 0> }
  object { Arm rotate y*180 rotate z*-18 translate <-10.5, 26.1, 0> }
  bounded_by { box { -1, 1 scale <28, 31, 32> translate y*27 } }
}

//--- Man with both arms up 
#declare Man2 =
union {
  object { Head translate y*30 rotate y*10 }
  object { Chest }
  object { Legs }
  object { Arm rotate z*18 rotate x*40 translate <10.5, 26.1, 0> }
  object { Arm rotate y*180 rotate x*130 rotate z*-18 translate <-10.5, 26.1, 0> }
  bounded_by { box { -1, 1 scale <28, 31, 32> translate y*27 } }
}