//Light tan to d.brown
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare br01 = colour rgb <1.00, 0.94, 0.71>;
#declare br02 = colour rgb <1.00, 0.88, 0.65>;
#declare br03 = colour rgb <0.94, 0.80, 0.59>;
#declare br03 = colour rgb <0.94, 0.80, 0.59>;
#declare br04 = colour rgb <0.80, 0.69, 0.52>;
#declare br05 = colour rgb <0.72, 0.63, 0.46>;
#declare br06 = colour rgb <0.78, 0.63, 0.46>;
#declare br07 = colour rgb <0.74, 0.59, 0.49>;
#declare br08 = colour rgb <0.66, 0.51, 0.41>;
#declare br09 = colour rgb <0.61, 0.50, 0.42>;
#declare br10 = colour rgb <0.58, 0.45, 0.32>;
#declare br11 = colour rgb <0.65, 0.45, 0.32>;
#declare br12 = colour rgb <0.65, 0.41, 0.28>;
#declare br13 = colour rgb <0.58, 0.41, 0.28>;
#declare br14 = colour rgb <0.57, 0.37, 0.24>;
#declare br15 = colour rgb <0.60, 0.37, 0.24>;
#declare br16 = colour rgb <0.54, 0.35, 0.25>;
#declare br17 = colour rgb <0.56, 0.31, 0.21>;
#declare br18 = colour rgb <0.45, 0.31, 0.16>;
#declare br19 = colour rgb <0.45, 0.31, 0.21>;
#declare br20 = colour rgb <0.41, 0.27, 0.17>;
#declare br21 = colour rgb <0.40, 0.24, 0.14>;
#declare br22 = colour rgb <0.37, 0.24, 0.11>;
#declare br23 = colour rgb <0.37, 0.24, 0.18>;
#declare br24 = colour rgb <0.34, 0.21, 0.15>;
#declare br25 = colour rgb <0.40, 0.21, 0.15>;
#declare br26 = colour rgb <0.32, 0.19, 0.07>;
#declare br27 = colour rgb <0.30, 0.14, 0.02>;
#declare br28 = colour rgb <0.30, 0.14, 0.10>;
#declare br29 = colour rgb <0.24, 0.16, 0.12>;
#declare br30 = colour rgb <0.25, 0.13, 0.09>;
#declare br31 = colour rgb <0.21, 0.09, 0.05>;

#declare pop_wood =
texture { 
  pigment {
    marble
    color_map {
      [0   0.2  color br16 color br16]	
      [0.2 0.4  color br16 color br14]
      [0.4 0.6  color br14 color br17]
      [0.6 0.8  color br17 color br17]
      [0.8 0.9  color br17 color br14]
      [0.9 1.01 color br14 color br16]
    }
    turbulence 0.4
    scale <13, 13, 1>
  }
  finish { ambient 0.8 phong 0.5 }
}
texture {
  pigment {
    wood
    color_map {
      [0   0.05 color br25            color br25 filter 0.5]
      [0.05 0.2 color br25 filter 0.5 color br21 filter 1.0]
      [0.2 0.7  color br21 filter 1.0 color br21 filter 0.8]
      [0.7 0.8  color br27 filter 0.7 color br27 filter 1.0]
      [0.8 0.9  color br27 filter 1.0 color br27 filter 0.7]
      [0.9 1.01 color br27 filter 1.0 color br30 filter 0.5]
    }
    turbulence 0.5
    scale <5, 15, 1>
  }
  finish { ambient 0.9 phong 1 }
}

#declare zeb_wood =
texture {
  pigment {
    marble
    color_map {
      [0   0.2  color br16 color br16]	
      [0.2 0.4  color br16 color br14]
      [0.4 0.6  color br14 color br17]
      [0.6 0.8  color br17 color br17]
      [0.8 0.9  color br17 color br14]
      [0.9 1.01 color br14 color br16]
    }
    turbulence 0.25
    scale <13, 13, 1>
  }
  finish { ambient 0.3 diffuse 1.2 }
}
texture {
  pigment {
    wood
    color_map {
      [0   0.05 color br25            color br25 filter 0.7]
      [0.05 0.2 color br25 filter 0.7 color br21 filter 1.0]
      [0.2 0.7  color br21 filter 1.0 color br21 filter 0.8]
      [0.7 0.8  color br27 filter 0.7 color br27 filter 1.0]
      [0.8 0.9  color br27 filter 1.0 color br27 filter 0.7]
      [0.9 1.01 color br27 filter 1.0 color br30 filter 0.7]
    }
    turbulence 0.3
  }
  finish { ambient 0.6 diffuse 0.9 }
}
texture {
  pigment {
    wood
    color_map {
      [0    0.05 color br25            color br25 filter 0.4]
      [0.05 0.2  color br25 filter 0.4 color br21 filter 0.8]
      [0.2  0.7  color br21 filter 0.8 color br21 filter 0.9]
      [0.7  0.8  color br27 filter 0.8 color br27 filter 0.6]
      [0.8  0.9  color br27 filter 0.6 color br27 filter 0.4]
      [0.9  1.01 color br27 filter 0.5 color br30 filter 0.8]
    }
    turbulence 0.2
    scale <4, 20, 4>
  }
  finish { ambient 0.3 diffuse 0.9 }
}

/*------------------ MAKE HARDWOOD FLOOR ----------------------------------*/

#declare WT = 
texture {
  zeb_wood
  scale <15, 35, 20>
  finish { phong 0.25 phong_size 50 reflection { 0.3 } crand 0.01 }
}

#declare XX = 
texture {
  pigment { color Salmon }
  finish { phong 0.5  phong_size 20 }
}

//--Dumby Plank
#declare plank =  box { -1, 1 scale <30, 450, 10> texture { WT } }
#declare Plank1 = box { -1, 1 scale <30, 450, 10> texture { WT } }
#declare Plank2 = box { -1, 1 scale <30, 450, 10> texture { WT rotate z*10 translate <20, 100, 10> } }
#declare Plank3=  box { -1, 1 scale <30, 450, 10> texture { WT rotate z*-5 translate <10, -30,  5> } }

#declare Plank_A =
union {
  object { Plank1 }
  object { Plank2 translate y*902 }
  object { Plank3 translate y*-902 }   
  bounded_by { box { -1, 1 scale <33, 1400, 11> } }
}

#declare Plank_B =
union {
  object { Plank3 }
  object { Plank1 translate y*902 }
  object { Plank2 translate y*-902 }   
  bounded_by { box { -1, 1 scale <33, 1400, 11> } }
}

#declare Plank_C =
union {
  object { Plank2 }
  object { Plank3 translate y*902 }
  object { Plank1 translate y*-902 }   
  bounded_by { box { -1, 1 scale <33, 1400, 11> } }
}

#declare Floor =
union {
  object { Plank_A rotate x*90 rotate y*90 translate <-629, -10, 44> }
  union {
    object { Plank_A rotate x*90 translate <-74, -10, -538> }
    object { Plank_B rotate x*90 translate <-136, -10, -438> }
    object { Plank_C rotate x*90 translate <-198, -10, -338> }
    object { Plank_B rotate x*90 translate <-260, -10, -38> }
    bounded_by { box { -1, 1 scale <140, 20, 1000> translate <-167, 0, -988> } }
  }
  union {
    object { Plank_A rotate x*90 translate <-322, -10, -108> }
    object { Plank_B rotate x*90 translate <-384, -10, 378> }
    object { Plank_C rotate x*90 translate <-446, -10, 88> }
    object { Plank_A rotate x*90 translate <-508, -10, 88> }
    bounded_by { box { -1, 1 scale <140, 20, 1000> translate <-415, 0, -988> } }
  }
  union {
    object { Plank_C rotate x*90 translate <-570, -10, -88> }
    object { Plank_A rotate x*90 translate <-632, -10, 108> }
    object { Plank_B rotate x*90 translate <-694, -10, -378> }
    bounded_by { box { -1, 1 scale <140, 20, 1000> translate <-665, 0, -988> } }
  }
  union {
    object { Plank_B rotate x*90 translate <-12, -10, -38> }
    object { Plank_A rotate x*90 translate <50, -10, -138> }
    object { Plank_C rotate x*90 translate <112, -10, 88> }
    object { Plank_A rotate x*90 translate <174, -10, -108> }
    bounded_by { box { -1, 1 scale <140, 20, 1000> translate <81, 0, -988> } }
  }
  union {
    object { Plank_B rotate x*90 translate <236, -10, 378> }
    object { Plank_C rotate x*90 translate <298, -10, 38> }
    object { Plank_A rotate x*90 translate <360, -10, 138> }
    object { Plank_C rotate x*90 translate <422, -10, -88> }
    bounded_by { box { -1, 1 scale <140, 20, 1000> translate <331, 0, -988> } }
  }
  union {
    object { Plank_A rotate x*90 translate <484, -10, 108> }
    object { Plank_B rotate x*90 translate <546, -10, -378> }
    bounded_by { box { -1, 1 scale <140, 20, 1000> translate <557, 0, -988> } }
  }
  bounded_by { box { -1, 1 scale <1100, 20, 1000> translate <89, 0, -988> } }
  rotate y*-30
}