//--- Tonka Toy Truck..............11/08/92 M.Miller




//--- Dumby Truck
#declare Dumb1 =
object {
  union {
    box { UnitBox scale <180 64 50> translate <-44 106 0> }
    box { UnitBox scale <42 35 45> translate <10 199 0> }
    box { UnitBox scale <44 41 100> translate <260 41 0> }
    intersection { Disk_Z scale <62 62 22> translate <-100 62 -80> }
    intersection { Disk_Z scale <62 62 22> translate <-100 62 80> }
    intersection { Disk_Z scale <62 62 22> translate <126 62 -80> }
    intersection { Disk_Z scale <62 62 22> translate <126 62 80> }
   }
      texture { 
	color Gold
	ambient .1
	phong 1
      }
	   bounded_by {
	   box { UnitBox scale <300 128 151> translate <64 122 0> }
           }
}






#declare Gold2 = color red .9 green .56 blue .1



//----------------------------------- Truck Textures

#declare Truck_Yellow =
texture {
	color Gold2
        ambient .15
	phong 1
	phong_size 70
//	reflection .1
}

#declare Gloss_Black =
texture {
	color Black
   	ambient .1
	diffuse .6
	reflection .25	
	phong 1
	phong_size 70
}

#declare Tire_Texture =
texture {
        image_map { <1 -1 0> gif "tire.gif" interpolate 4 }
	scale <130 130 1>
	translate <-65 -65 1>
	ambient .2
	diffuse .4
	phong .5
	phong_size 10
        .06
}

#declare Truck_Glass =
texture {
	color Gray95 alpha .95
	ambient .8
	diffuse .1
	phong 1
	phong_size 100
        reflection .2
        refraction .9
        .001
}

#declare B_Silver =
texture {
	color Gray70
	ambient .1
	diffuse .5
	phong 1
	phong_size 60
        reflection .5
        .05
}


#declare Bumble =
texture {
	gradient <1 0 0>
	   color_map {
	   [0 .5 color Black color Black]
	   [.5 1 color Gold2 color Gold2]
	   }
	scale <300 1 1>
	translate <-310 140 0>
	rotate <0 0 10>
        ambient .1
	phong 1
	phong_size 70
//	reflection .1
}

#declare Head_Texture =
texture {
	image_map { <1 -1 0> gif "faceskin.gif" interpolate 4 }
	scale <26 26 1>
	translate <-13 -13 1>
        ambient .35
	diffuse .4
	phong 1
	phong_size 80
//	reflection .1
}

#declare Skin_Texture =
texture {
	image_map { <1 -1 0> gif "skin.gif" }
        ambient .35
	diffuse .4
	phong 1
	phong_size 80
//	reflection .1
}


#declare Chest_Texture =
texture {
	color SteelBlue
   	ambient .2
	diffuse .6
//	reflection .1	
	phong 1
	phong_size 90
}

#declare Legs_Texture =
texture {
	color Navy
   	ambient .2
	diffuse .6
//	reflection .1	
	phong 1
	phong_size 90
}


#declare YourTexture = texture { Truck_Yellow }




#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }




#include "p20.inc"

//---- Round Pipe for back bed
#declare Pipe1 =
   composite {
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 0.000000  98.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 212.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 0.000000  98.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-212.000000  98.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 36.878178  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -77.471192>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-212.000000  98.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-220.000000  62.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 220.000000  4.000000  4.000000>
         translate <-220.000000  62.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 0.000000  62.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 127.789514  127.789514  127.789514>
            translate <-110.000000  80.000000  0.000000>
         }
      }
   }




#declare P1 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -3514.250000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        3458.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -3514.250000 0.000000 2989441.000000 >
   }


//--- Skirt Around Back Bed
#declare Pipe2 =
   composite {
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-22.000000  52.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 14.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate <-22.000000  52.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-22.000000  66.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 8.485281  4.000000  4.000000>
         rotate    < 0.000000  0.000000  45.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-22.000000  66.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-28.000000  72.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 192.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-28.000000  72.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-220.000000  72.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 6.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -90.000000>
         translate <-220.000000  72.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-220.000000  66.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 198.494332  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -4.044486>
         translate <-220.000000  66.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-22.000000  52.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 114.426439  114.426439  114.426439>
            translate <-121.000000  62.000000  0.000000>
         }
      }
   }

//--- Stack exhalst
#declare Stack_Pipe =
object {
   union {
     quadric {
     Dot
     scale     < 6.000000  6.000000  6.000000>
     translate <-120.000000  170.000000  18.000000>
     }

     intersection { 
     quadric { Connector_2 }
     plane {     < 1.000000  0.000000  0.000000>  5.997685 }
     plane {     < 1.000000  0.000000  0.000000>  4.998071 inverse }
     translate <-5.997685  0.000000  0.000000>
     scale     < 35.986108  1.000000  1.000000>
     translate <-0.166667  0.000000  0.000000>
     rotate    < 0.000000  180.000000  0.000000>
     rotate    < 0.000000  0.000000  90.000000>
     translate <-120.000000  170.000000  18.000000>
     }

     quadric {
     Dot
     scale     < 5.000000  5.000000  5.000000>
     translate <-120.000000  206.000000  18.000000>
     }

     intersection {
     quadric { Connector_2 }
     plane {     < 1.000000  0.000000  0.000000>  4.994997 }
     plane {     < 1.000000  0.000000  0.000000>  3.995998 inverse }
     translate <-4.994997  0.000000  0.000000>
     scale     < 22.338308  1.000000  1.000000>
     translate <-0.223607  0.000000  0.000000>
     rotate    < 0.000000  180.000000  0.000000>
     rotate    < 0.000000  0.000000  26.565051>
     rotate    < 0.000000 -180.000000  0.000000>
     translate <-120.000000  206.000000  18.000000>
     }

     quadric {
     Dot
     scale     < 4.000000  4.000000  4.000000>
     translate <-140.000000  216.000000  18.000000>
     }
   }
       texture { Gloss_Black reflection .05 }
  	     bounded_by {
               quadric { Dot
               scale < 35.559106  35.559106  35.559106>
               translate <-129.000000  192.000000  18.000000>
               }
             }
}


#declare Pipe3 =
   composite {
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-74.000000  100.000000  0.000000>
         }
         texture {

         }
      }
      object {
         Connector_1
         scale     < 66.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate <-74.000000  100.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-74.000000  166.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      object {
         Connector_1
         scale     < 22.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-74.000000  166.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-96.000000  166.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      object {
         Connector_1
         scale     < 66.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -90.000000>
         translate <-96.000000  166.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-96.000000  100.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      object {
         Connector_1
         scale     < 8.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-96.000000  100.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-104.000000  100.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      object {
         Connector_1
         scale     < 66.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate <-104.000000  100.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-104.000000  166.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      object {
         Connector_1
         scale     < 110.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-104.000000  166.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-214.000000  166.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      object {
         Connector_1
         scale     < 57.271284  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -77.905243>
         translate <-214.000000  166.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-202.000000  110.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      object {
         Connector_1
         scale     < 11.661904  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -59.036243>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-202.000000  110.000000  0.000000>
         texture {
            Bumble
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-208.000000  100.000000  0.000000>
         }
         texture {
            Bumble
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 91.114269  91.114269  91.114269>
            translate <-144.000000  133.000000  0.000000>
         }
      }
   }

//--- Vent on Engine Hood
#declare Pipe4 =
   composite {
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-190.000000  154.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 78.000000  4.000000  4.000000>
         translate <-190.000000  154.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-112.000000  154.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 38.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -90.000000>
         translate <-112.000000  154.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-112.000000  116.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 70.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-112.000000  116.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-182.000000  116.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 38.832976  4.000000  4.000000>
         rotate    < 0.000000  0.000000  78.111342>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-182.000000  116.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-190.000000  154.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 53.821371  53.821371  53.821371>
            translate <-151.000000  135.000000  0.000000>
         }
      }
   }

//-- Rib for Vent on Engine Hood
#declare Pipe5 =
   composite {
      object {
         quadric {
            Dot
            scale     < 2.500000  2.500000  2.500000>
            translate <-183.000000  152.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 34.928498  2.500000  2.500000>
         rotate    < 0.000000  0.000000 -76.759480>
         translate <-183.000000  152.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.500000  2.500000  2.500000>
            translate <-175.000000  118.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 22.776907  22.776907  22.776907>
            translate <-179.000000  135.000000  0.000000>
         }
      }
   }

//-- Rib for Vent on Engine Hood
#declare Pipe5 =
   composite {
      object {
         quadric {
            Dot
            scale     < 2.500000  2.500000  2.500000>
            translate <-183.000000  152.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 34.928498  2.500000  2.500000>
         rotate    < 0.000000  0.000000 -76.759480>
         translate <-183.000000  152.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.500000  2.500000  2.500000>
            translate <-175.000000  118.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 22.776907  22.776907  22.776907>
            translate <-179.000000  135.000000  0.000000>
         }
      }
   }

//--- Cab Base
#declare Pipe7 =
   composite {
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-32.000000  164.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 92.000000  4.000000  4.000000>
         translate <-32.000000  164.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 60.000000  164.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 133.775932  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -58.448615>
         translate < 60.000000  164.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 130.000000  50.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 6.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -90.000000>
         translate < 130.000000  50.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 130.000000  44.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 96.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 130.000000  44.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 34.000000  44.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 6.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate < 34.000000  44.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 34.000000  50.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 26.000000  4.000000  4.000000>
         translate < 34.000000  50.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 60.000000  50.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 58.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate < 60.000000  50.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 60.000000  108.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 92.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 60.000000  108.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-32.000000  108.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 56.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate <-32.000000  108.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-32.000000  164.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
      box { UnitBox scale <95 70 5> translate <47 104 0> } 
      }
   }


//--- Cab

#declare Pipe8 =
composite {
   composite {
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-18.000000  230.000000  10.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 64.000000  4.000000  4.000000>
         translate <-18.000000  230.000000  10.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 46.000000  230.000000  10.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 2.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -90.000000>
         translate < 46.000000  230.000000  10.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 46.000000  228.000000  10.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 10.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 46.000000  228.000000  10.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 36.000000  228.000000  10.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 62.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000 -75.407449>
         rotate    < 0.000000  39.805571  0.000000>
         translate < 36.000000  228.000000  10.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate < 48.000000  168.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 76.000000  4.000000  4.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 48.000000  168.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-28.000000  168.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 61.644140  4.000000  4.000000>
         rotate    < 0.000000  0.000000  76.737324>
         rotate    < 0.000000 -45.000000  0.000000>
         translate <-28.000000  168.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-18.000000  228.000000  10.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 2.000000  4.000000  4.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate <-18.000000  228.000000  10.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-18.000000  230.000000  10.000000>
         }
         texture {
            YourTexture
         }
      }
	bounded_by {
	box { UnitBox scale <50 38 12> translate <10 200 0> }
	}
translate <0 0 -44>
   }
	bounded_by {
	box { UnitBox scale <50 38 50> translate <10 200 0> }
	}
}

//--- Cab Window

#declare Pipe9 =
   composite {
      object {
         quadric {
            Dot
            scale     < 3.000000  3.000000  3.000000>
            translate <-49.000000  47.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 36.000000  3.000000  3.000000>
         translate <-49.000000  47.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 3.000000  3.000000  3.000000>
            translate <-13.000000  47.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 45.122057  3.000000  3.000000>
         rotate    < 0.000000  0.000000 -77.195734>
         translate <-13.000000  47.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 3.000000  3.000000  3.000000>
            translate <-3.000000  3.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 54.000000  3.000000  3.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-3.000000  3.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 3.000000  3.000000  3.000000>
            translate <-57.000000  3.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 44.721360  3.000000  3.000000>
         rotate    < 0.000000  0.000000  79.695154>
         translate <-57.000000  3.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 3.000000  3.000000  3.000000>
            translate <-49.000000  47.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 10.000000  3.000000  3.000000>
         translate <-49.000000  47.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 3.000000  3.000000  3.000000>
            translate <-39.000000  47.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 45.122057  3.000000  3.000000>
         rotate    < 0.000000  0.000000 -77.195734>
         translate <-39.000000  47.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 3.000000  3.000000  3.000000>
            translate <-29.000000  3.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 43.082943  43.082943  43.082943>
            translate <-30.000000  25.000000  0.000000>
         }
      }
   scale <1 1 .6>
   }

//-- Shovel Head & a few toruss

#declare S1 =
   composite {
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 20.000000 -22.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 14.142136  2.000000  2.000000>
         rotate    < 0.000000  0.000000 -45.000000>
         translate < 20.000000 -22.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 30.000000 -32.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 62.000000  2.000000  2.000000>
         translate < 30.000000 -32.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 92.000000 -32.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 10.000000  2.000000  2.000000>
         rotate    < 0.000000  0.000000  36.869898>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 92.000000 -32.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 84.000000 -26.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 58.855756  2.000000  2.000000>
         rotate    < 0.000000  0.000000  80.217593>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 84.000000 -26.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 74.000000  32.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 7.211103  2.000000  2.000000>
         rotate    < 0.000000  0.000000  33.690068>
         translate < 74.000000  32.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 80.000000  36.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 8.246211  2.000000  2.000000>
         rotate    < 0.000000  0.000000  75.963757>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 80.000000  36.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 78.000000  44.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 61.351447  2.000000  2.000000>
         rotate    < 0.000000  0.000000 -19.025606>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 78.000000  44.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 20.000000  24.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      object {
         Connector_1
         scale     < 46.000000  2.000000  2.000000>
         rotate    < 0.000000  0.000000 -90.000000>
         translate < 20.000000  24.000000  0.000000>
         texture {
            Gloss_Black
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 20.000000 -22.000000  0.000000>
         }
         texture {
            Gloss_Black
         }
      }
      bounded_by {
      box { UnitBox scale <58 46 5> translate <40 6 0> }
      }
   }



//--- Torus for Tire
#declare TR2 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -3764.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        2320.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -3764.000000 0.000000 1345600.000000 >
rotate <90 0 0>
   }


#declare TR3 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -259.250000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        247.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -259.250000 0.000000 15252.250000 >
   }



#declare Spoke = 
quadric { Cylinder_Y scale <5 1 16> translate <0 0 -22> inverse }

#declare Spoke1 = 
quadric { Cylinder_Y scale <5 1 16> rotate <0 0 10> translate <0 0 22> inverse }

//-- Cut-out for cab window
#declare Window =
intersection {
   plane { <1 0 0> 0 rotate <0 0 12.7> translate <37 177 0> }
   plane { <1 0 0> 0 rotate <0 0 -10.8> translate <-17 177 0> inverse }
   plane { <0 1 0> 177 inverse }
   plane { <0 1 0> 221 }
   plane { <0 0 1> -100 inverse }
   plane { <0 0 1> 100 }
}


#declare Axle =
object {
   intersection { Disk_Z scale <3 3 85> }
     texture { B_Silver }
} 


//--------------------------- Truck Tires
#declare Tire =
composite {
 object {
   union {
     quartic { TR2 scale <1 1 1.15> }
     intersection {
       quadric { Sphere scale <62 61 62>  }
       plane { <0 0 1> 22 }
       plane { <0 0 1> -22 inverse }
       quadric { Cylinder_Z scale <39 39 1> inverse }
       quadric { Spoke rotate <0 0 0> }
       quadric { Spoke rotate <0 0 20> }
       quadric { Spoke rotate <0 0 40> }
       quadric { Spoke rotate <0 0 60> }
       quadric { Spoke rotate <0 0 80> }
       quadric { Spoke rotate <0 0 100> }
       quadric { Spoke rotate <0 0 120> }
       quadric { Spoke rotate <0 0 140> }
       quadric { Spoke rotate <0 0 160> }

       quadric { Spoke1 rotate <0 0 0> }
       quadric { Spoke1 rotate <0 0 20> }
       quadric { Spoke1 rotate <0 0 40> }
       quadric { Spoke1 rotate <0 0 60> }
       quadric { Spoke1 rotate <0 0 80> }
       quadric { Spoke1 rotate <0 0 100> }
       quadric { Spoke1 rotate <0 0 120> }
       quadric { Spoke1 rotate <0 0 140> }
       quadric { Spoke1 rotate <0 0 160> }
     }
   }
	texture { Tire_Texture }
    		bounded_by {
		box { UnitBox scale <65 65 30> }
		}
 }
 object {
   union {
   difference {
     intersection { Disk_Z scale <24 24 15> }
     intersection { Disk_Z scale <20 20 15> translate <0 0 -2> }
   }
     intersection { Disk_Z scale <9 7 5> translate <18 0 -5> rotate <0 0 0> }     
     intersection { Disk_Z scale <9 7 5> translate <18 0 -5> rotate <0 0 72> }     
     intersection { Disk_Z scale <9 7 5> translate <18 0 -5> rotate <0 0 144> }     
     intersection { Disk_Z scale <9 7 5> translate <18 0 -5> rotate <0 0 215> }     
     intersection { Disk_Z scale <9 7 5> translate <18 0 -5> rotate <0 0 288> }     
   } 
       texture { Truck_Yellow }
	 bounded_by {
	 box { UnitBox scale <25 25 18> }
         }
  }
}






//-------------------------- One Complete Truck

#declare Truck =
composite {
composite {
composite {

   composite { Pipe1 translate <0 0 -42> }
   composite { Pipe1 translate <0 0 42> }
   object {
     union {
       quartic { P1 translate <0 98 0> }
       intersection { Disk_Y scale <42 4 42> translate <0 98 0> }
       intersection { Disk_Y scale <46 18 46> translate <0 80 0> }
     }
        texture { Truck_Yellow }
	  bounded_by {
	  box { UnitBox scale <50 30 50> translate <0 75 0> }
          }
    }   
   object {
     union {
       triangle { <0 98 -46> <-212 98 -46> <-220 62 -46> }
       triangle { <0 98 -46> <0 62 -46> <-220 62 -46> }
       triangle { <0 98 46> <-212 98 46> <-220 62 46> }
       triangle { <0 98 46> <0 62 46> <-220 62 46> }
       triangle { <0 102 -42> <-212 102 -42> <-212 102 42> }
       triangle { <0 102 -42> <0 102 42> <-212 102 42> }
       triangle { <-224 62 -42> <-216 98 -42> <-224 62 42> }
       triangle { <-216 98 42> <-216 98 -42> <-224 62 42> }
       intersection { Disk_Z scale <4 4 42> translate <-212 98 0> }

     }
        texture { Truck_Yellow }
   }   
   //--- Side Skirt around back bed
   composite {
      composite { Pipe2 translate <0 0 -50> }
      composite { Pipe2 translate <0 0 50> }
      object {
        union {
         triangle { <-22 52 -54> <-28 72 -54> <-22 62 -54> }
         triangle { <-22 52 -54> <-220 66 -54> <-28 72 -54> }
         triangle { <-28 72 -54> <-220 72 -54> <-220 66 -54> }
         triangle { <-22 52 54> <-28 72 54> <-22 62 54> }
         triangle { <-22 52 54> <-220 66 54> <-28 72 54> }
         triangle { <-28 72 54> <-220 72 54> <-220 66 54> }
        }
          texture { Truck_Yellow }
        	  bounded_by {
	          box { UnitBox scale <108 21 55> translate <-120 63 0> }
                  }

      } 
   }

   //--- Back Engine Hood
   composite {
      composite { Pipe3 translate <0 0 -40> }
      composite { Pipe3 translate <0 0 40> }
      object {
        union {
         intersection { Disk_Z scale <4 4 40> translate <-74 166 0> }
         intersection { Disk_Z scale <4 4 40> translate <-96 166 0> }
         intersection { Disk_Z scale <4 4 40> translate <-104 166 0> }
         intersection { Disk_Z scale <4 4 40> translate <-214 166 0> }
         triangle { <-74 100 -44> <-96 100 -44> <-74 166 -44> }
         triangle { <-96 100 -44> <-74 166 -44> <-96 166 -44> }
         triangle { <-104 100 -44> <-208 100 -44> <-104 166 -44> }
         triangle { <-208 100 -44> <-104 166 -44> <-202 110 -44> }
         triangle { <-202 110 -44> <-104 166 -44> <-214 166 -44> }
         triangle { <-74 100 44> <-96 100 44> <-74 166 44> }
         triangle { <-96 100 44> <-74 166 44> <-96 166 44> }
         triangle { <-104 100 44> <-208 100 44> <-104 166 44> }
         triangle { <-208 100 44> <-104 166 44> <-202 110 44> }
         triangle { <-202 110 44> <-104 166 44> <-214 166 44> }
         triangle { <-70 100 -40> <-70 100 40> <-70 166 40> }
         triangle { <-70 100 -40> <-70 166 -40> <-70 166 40> }
         triangle { <-74 170 -40> <-96 170 -40> <-96 170 40> }
         triangle { <-74 170 -40> <-74 170 40> <-96 170 40> }
         triangle { <-104 170 -40> <-214 170 -40> <-214 170 40> }
         triangle { <-214 170 40> <-104 170 40> <-104 170 -40> }
        }
          texture { Bumble }
        	  bounded_by {
	          box { UnitBox scale <80 42 55> translate <-144 134 0> }
                  }
      } 
   }

  //--- Vent Panel & Vents on Engine Cover
  composite {
   composite { Pipe4 translate <0 0 -44> }
   composite { Pipe5 translate <0 0 -48> }
   composite { Pipe5 translate <10 0 -48> }
   composite { Pipe5 translate <20 0 -48> }
   composite { Pipe5 translate <30 0 -48> }
   composite { Pipe5 translate <40 0 -48> }
   composite { Pipe5 translate <50 0 -48> }
   composite { Pipe5 translate <60 0 -48> }
   object {
     union {
       triangle { <-112 154 -48> <-190 154 -48> <-182 116 -48> }
       triangle { <-112 154 -48> <-112 116 -48> <-182 116 -48> }
     }
          texture { Truck_Yellow }
    }
    		bounded_by {
		box { UnitBox scale <45 27 8> translate <-151 135 -48>
		}
    }  
   }
  //--- Vent Panel & Vents on Engine Cover "Back"


  composite {
   composite { Pipe4 translate <0 0 44> }
   composite { Pipe5 translate <0 0 48> }
   composite { Pipe5 translate <10 0 48> }
   composite { Pipe5 translate <20 0 48> }
   composite { Pipe5 translate <30 0 48> }
   composite { Pipe5 translate <40 0 48> }
   composite { Pipe5 translate <50 0 48> }
   composite { Pipe5 translate <60 0 48> }
   object {
     union {
       triangle { <-112 154 48> <-190 154 48> <-182 116 48> }
       triangle { <-112 154 48> <-112 116 48> <-182 116 48> }
     }
          texture { Truck_Yellow }
    }
    		bounded_by {
		box { UnitBox scale <45 27 8> translate <-151 135 48>
		}
  } 	
 }

        	bounded_by {
		box { UnitBox scale <145 75 55> translate <-87 106 0> }
		}
   }
   object { Stack_Pipe }
   composite { Tire translate <-100 60.5 -78> }
   composite { Tire rotate <0 180 0> translate <-100 60.5 78> }
   object { Axle translate <-100 60.5 0> }
   rotate <0 20 0> //-----Use to rotate back bed
}

//--- Cab Base
composite {
 composite {
 composite {
  composite {
    composite { Pipe7 translate <0 0 47> }
    composite { Pipe7 translate <0 0 -47> }
    bounded_by { 
    box { UnitBox scale <95 70 53> translate <47 104 0> }
    }
  }
     object {
      union {
       intersection { Disk_Z scale <4 4 47> translate <34 44 0> }
       intersection { Disk_Z scale <4 4 47> translate <34 50 0> }
       intersection { Disk_Z scale <4 4 47> translate <60 50 0> }
       intersection { Disk_Z scale <4 4 47> translate <60 108 0> }
       intersection { Disk_Z scale <4 4 47> translate <-32 108 0> }
       intersection { Disk_Z scale <4 4 47> translate <-32 164 0> }
       intersection { Disk_Z scale <4 4 47> translate <60 164 0> }
       intersection { Disk_Z scale <4 4 47> translate <130 50 0> }
       intersection { Disk_Z scale <4 4 47> translate <130 44 0> }
     }
        texture { Truck_Yellow }
	bounded_by { 
	box { UnitBox scale <95 70 53> translate <47 104 0> }
	}
    } 

    object {
      union {
       triangle { <-36 164 -47> <-36 108 -47> <-36 164 47> }
       triangle { <-36 108 -47> <-36 164 47> <-36 108 47> }
       triangle { <-32 108 51> <-32 164 51> <60 164 51> }
       triangle { <-32 108 51> <60 108 51> <60 164 51> }      
       triangle { <-32 108 -51> <-32 164 -51> <60 164 -51> }
       triangle { <-32 108 -51> <60 108 -51> <60 164 -51> }      
       triangle { <34 54 -47> <60 54 -47> <34 54 47> }
       triangle { <60 54 -47> <34 54 47> <60 54 47> }
       triangle { <34 50 -51> <34 44 -51> <130 50 -51> }
       triangle { <34 44 -51> <130 44 -51> <130 50 -51> }
       triangle { <60 164 -51> <60 50 -51> <130 50 -51> }
       triangle { <34 50 51> <34 44 51> <130 50 51> }
       triangle { <34 44 51> <130 44 51> <130 50 51> }
       triangle { <60 164 51> <60 50 51> <130 50 51> }

       triangle { <64.5 164 -47> <134.5 50 -47> <64.5 164 47> }
       triangle { <64.5 164 47> <134.5 50 -47> <134.5 50 47> }
       intersection { Disk_Y scale <40 7 40> translate <30 47 0> }

       triangle { <60 168 -47> <26 168 -47> <26 168 47> }
       triangle { <60 168 -47> <60 168 47> <26 168 47> }


      }
        texture { Truck_Yellow }
	bounded_by { 
	box { UnitBox scale <95 70 53> translate <47 104 0> }
	}
    } 
  }

//--- Cab & Windsheld
composite {
  composite { Pipe8 }
  composite { P20 translate <0 0 44> }
  composite { Pipe9 rotate <9.3 0 0> translate <40 174 -47> }
  composite { Pipe9 rotate <-9.3 0 0> translate <40 174 47> }

  //--- Stering Wheel
  object {
    quartic { TR3 }
      texture { Gloss_Black }
	bounded_by {
	box { UnitBox scale <14 5 14> }
	}
  rotate <0 0 10> translate <29 178 0> 
  }

  object {
   union {
    intersection { Disk_Z scale <4 4 34> translate <-18 230 0> }
    intersection { Disk_Z scale <4 4 34> translate <-18 228 0> }
    intersection { Disk_Z scale <4 4 34> translate <46 230 0> }
    intersection { Disk_Z scale <4 4 34> translate <46 228 0> }
    intersection { Disk_Z scale <4 4 34> translate <36 228 0> }
    intersection { Disk_Z scale <4 4 40> translate <-28 168 0> }
    intersection { Disk_Z scale <4 4 40> translate <48 168 0> }

   }
     texture { Truck_Yellow }
	bounded_by { 
	box { UnitBox scale <50 38 50> translate <10 200 0> }
	}
  }  

  object {
   union {
       triangle { <-28 168 -48.4> <-18 228 -38.4> <36 228 -38.4> }
       triangle { <-28 168 -48.4> <48 168 -48.4> <36 228 -38.4> }
       triangle { <-18 228 -38> <46 228 -38> <-18 230 -38> }
       triangle { <-18 230 -38> <46 228 -38> <46 230 -38> }
       triangle { <-28 168 48.4> <-18 228 38.4> <36 228 38.4> }
       triangle { <-28 168 48.4> <48 168 48.4> <36 228 38.4> }
       triangle { <-18 228 38> <46 228 38> <-18 230 38> }
       triangle { <-18 230 38> <46 228 38> <46 230 38> }
       triangle { <-18 234 -34> <46 234 -34> <-18 234 34> }    
       triangle { <-18 234 34> <46 234 34> <46 234 -34> }
   }
     texture { Truck_Yellow }
	bounded_by { 
	box { UnitBox scale <50 38 50> translate <10 200 0> } 
	}
	   clipped_by {
	   intersection { Window inverse }
	   }
  }  

  //--- Glass
  object {
   intersection {
     plane { <1 0 0> 0 rotate <0 0 -9.6> translate <-28 168 0> inverse }
     plane { <1 0 0> 0 rotate <0 0 9.6> translate <48 168 0> }
     plane { <0 1 0> 168 inverse }
     plane { <0 1 0> 228 }
     plane { <0 0 1> 0 rotate <9.7 0 0> translate <0 168 -47> inverse }
     plane { <0 0 1> 0 rotate <-9.7 0 0> translate <0 168 47> }
   }
      texture { Truck_Glass }
	bounded_by { 
	box { UnitBox scale <50 38 50> translate <10 200 0> } 
	}
  }   


 composite { Tire translate <123 60.5 -78> }
 composite { Tire rotate <0 180 0> translate <123 60.5 78> }
 object { Axle translate <123 60.5 0> } 
  }
	bounded_by { 
	box { UnitBox scale <135 125 111> translate <88 119 0> } 
	}
 
 rotate <0 0 0> //---- rotates whole cab & cab base
}


composite {
 composite {
   composite {
    //--- Front Arm
    object {
      union {
        intersection { Disk_Z scale <14 14 .1> translate <0 -2 -53> }
        intersection { Disk_Z scale <14 14 .1> translate <160 -120 -53> }
	triangle { <0 -16 -53> <0 12 -53> <80 12 -53> }
	triangle { <0 -16 -53> <80 12 -53> <80 -32 -53> }
	triangle { <80 12 -53> <80 -56 -53> <138 -46 -53> }
      	triangle { <80 -56 -53> <138 -46 -53> <116 -96 -53> }
	triangle { <116 -96 -53> <154 -96 -53> <138 -46 -53> }
	triangle { <116 -96 -53> <174 -96 -53> <116 -104 -53> }
	triangle { <116 -104 -53> <174 -96 -53> <150 -132 -53> }
	triangle { <150 -132 -53> <174 -122 -53> <174 -96 -53> }
	triangle { <22 12 -53> <80 12 -53> <22 12 -48> }
	triangle { <80 12 -53> <22 12 -48> <80 12 -48> }
     }
       texture { Truck_Yellow }
	  bounded_by {
	  box { UnitBox scale <100 80 6> translate <81 -61 -53> }
          }
   }

   //--- Back Arm
   object {
     union {
        intersection { Disk_Z scale <14 14 .1> translate <0 -2 53> }
        intersection { Disk_Z scale <14 14 .1> translate <160 -120 53> }
	triangle { <0 -16 53> <0 12 53> <80 12 53> }
	triangle { <0 -16 53> <80 12 53> <80 -32 53> }
	triangle { <80 12 53> <80 -56 53> <138 -46 53> }
      	triangle { <80 -56 53> <138 -46 53> <116 -96 53> }
	triangle { <116 -96 53> <154 -96 53> <138 -46 53> }
	triangle { <116 -96 53> <174 -96 53> <116 -104 53> }
	triangle { <116 -104 53> <174 -96 53> <150 -132 53> }
	triangle { <150 -132 53> <174 -122 53> <174 -96 53> }
	triangle { <22 12 53> <80 12 53> <22 12 48> }
	triangle { <80 12 53> <22 12 48> <80 12 48> }
     }
       texture { Truck_Yellow }
	  bounded_by {
	  box { UnitBox scale <100 80 6> translate <81 -61 53> }
          }
   }


   //--- Middle Plate on Shovel Arm
   object {
     union {
	triangle { <80 12 -53> <138 -46 -53> <80 12 53> }
	triangle { <138 -46 -53> <138 -46 53> <80 12 53> }
     }
       texture { Truck_Yellow }
         clipped_by {
         box { UnitBox scale <18 26 2.5> translate <108 -16 -45> inverse }
         box { UnitBox scale <18 26 2.5> translate <108 -16 45> inverse }
         }
   }

   //--- Pivot Pins on Arm
   object {
     union {
       quadric { Sphere scale <5 5 2> translate <0 0 -53> }
       quadric { Sphere scale <5 5 2> translate <118 -38 -53> }
       quadric { Sphere scale <5 5 2> translate <160 -120 -53> }
       quadric { Sphere scale <5 5 2> translate <0 0 53> }
       quadric { Sphere scale <5 5 2> translate <118 -38 53> }
       quadric { Sphere scale <5 5 2> translate <160 -120 53> }
       quadric { Sphere scale <5 5 2> translate <160 -120 51> }
       quadric { Sphere scale <5 5 2> translate <160 -120 51> }

     }
        texture { B_Silver }
	  bounded_by {
	  box { UnitBox scale <100 80 60> translate <81 -61 0> }
          }
   }
	  bounded_by {
	  box { UnitBox scale <100 80 60> translate <81 -61 0> }
          }
     }    
    

   //-- Shovle Mouth Handle     
   object {
     union {
       triangle { <111 -6 -45> <108 -18 -45> <174 -22 -45> }
       triangle { <108 -18 -45> <174 -22 -45> <172 -32 -45> }
       intersection { Disk_Z scale <15 15 .1> translate <107 -21 -45> }
       triangle { <111 -6 45> <108 -18 45> <174 -22 45> }
       triangle { <108 -18 45> <174 -22 45> <172 -32 45> }
       intersection { Disk_Z scale <15 15 .1> translate <107 -21 45> }
       triangle { <174 -22 -45> <172 -32 -45> <174 -22 45> }
       triangle { <172 -32 -45> <174 -22 45> <172 -32 45> }
       triangle { <174 -22 -45> <172 -18 -45> <172 -18 45> }
       triangle { <174 -22 -45> <172 -18 45> <174 -22 45> }
     }
   	texture { Gloss_Black }
	  bounded_by {
	  box { UnitBox scale <45 19 50> translate <132 -21 0> }
          }
   translate <-107 21 0>
   rotate <0 0 0> //--- rotate handle +z to pull back as the shovel drops
   translate <107 -21 0>
   }
}




 //--- Shovel Mouth
 composite {
   composite { S1 translate <0 0 102> }
   composite { S1 translate <0 0 -102> }
   object {
    union {
     intersection { Disk_Z scale <2 2 102> translate <20 -22 0> }
     intersection { Disk_Z scale <2 2 102> translate <30 -32 0> }
     intersection { Disk_Z scale <2 2 102> translate <92 -32 0> }
     intersection { Disk_Z scale <2 2 102> translate <84 -30 0> }
     intersection { Disk_Z scale <2 2 102> translate <80 36 0> }
     intersection { Disk_Z scale <2 2 102> translate <78 44 0> }
     intersection { Disk_Z scale <2 2 102> translate <20 24 0> }
    }
       texture { Gloss_Black }
	  bounded_by {
	  box { UnitBox scale <58 46 110> translate <40 6 0> }
          }
   } 
   object {
     union {
       triangle { <20 24 -104> <78 44 -104> <80 36 -104> }
       triangle { <20 24 -104> <80 36 -104> <74 32 -104> }
       triangle { <20 24 -104> <20 -22 -104> <74 32 -104> }
       triangle { <20 -22 -104> <74 32 -104> <84 -26 -104> }
       triangle { <20 -22 -104> <84 -26 -104> <30 -32 -104> }
       triangle { <30 -32 -104> <84 -26 -104> <92 -32 -104> }
     }
         texture { Gloss_Black }
	   bounded_by {
	   box { UnitBox scale <58 46 2> translate <40 6 -104> }
           }
   } 

   object {
     union {
       triangle { <20 24 104> <78 44 104> <80 36 104> }
       triangle { <20 24 104> <80 36 104> <74 32 104> }
       triangle { <20 24 104> <20 -22 104> <74 32 104> }
       triangle { <20 -22 104> <74 32 104> <84 -26 104> }
       triangle { <20 -22 104> <84 -26 104> <30 -32 104> }
       triangle { <30 -32 104> <84 -26 104> <92 -32 104> }
     }
         texture { Gloss_Black }
	   bounded_by {
	   box { UnitBox scale <58 46 2> translate <40 6 104> }
           }
   } 

   object {
     union {
       triangle { <80 44 -102> <82 36 -102> <80 44 102> }
       triangle { <82 36 -102> <80 44 102> <82 36 102> }
       triangle { <18 24 -102> <18 -22 -102> <18 24 102> }
       triangle { <18 -22 -102> <18 24 102> <18 -22 102> }
       triangle { <20 26 -102> <78 46 -102> <20 26 102> }
       triangle { <78 46 -102> <78 46 102> <20 26 102> }
       triangle { <30 -34 -102> <92 -34 -102> <30 -34 102> }
       triangle { <92 -34 -102> <30 -34 102> <92 -34 102> }
       triangle { <20 -22 -102> <30 -32 -102> <20 -22 102> }
       triangle { <30 -32 -102> <20 -22 102> <30 -32 102> }
       
       intersection { Disk_Z scale <16 16 1> translate <0 0 -52> }
       box { UnitBox scale <9 16 1> translate <9 0 -52> } 
       intersection { Disk_Z scale <16 16 1> translate <0 0 52> }
       box { UnitBox scale <9 16 1> translate <9 0 52> } 
     }
         texture { Gloss_Black }
	   bounded_by {
	   box { UnitBox scale <58 46 110> translate <40 6 0> }
           }
   } 
  bounded_by {
  box { UnitBox scale <58 46 110> translate <40 6 0> }
  }

  rotate <0 0 -30> //--- rotate shovel head -z to dump load
  translate <160 -120 0>

  }

  rotate <0 0 30> //--- rotate shovel arm & shovel +z for up direction
  translate <46 154 0>
  }
  rotate <0 -25 0> //--- rotate cab & shovel +y to turn in -y to turn out
}
	   bounded_by {
	   box { UnitBox scale <300 128 151> translate <64 122 0> }
           }
}








