//------ Wall Socket, Plug End, & Plug Wire


#declare CoverColor =
texture {
	color DustyRose
	ambient .1
	diffuse .5
	phong 1
}


//--- Round Corners on Plate
#declare PlateCorners =
object {
   union {
     difference {
	quadric { Cylinder_X scale <1 5 5> translate <0 49 0> }
	plane { <0 1 0> 0 rotate <0 0 45> translate <0 19 0> }
	plane { <0 1 0> 0 rotate <0 0 -45> translate <0 19 0> }
     }
     difference {
	quadric { Cylinder_X scale <1 5 5> translate <0 -49 0> }
	plane { <0 1 0> 0 rotate <0 0 45> translate <0 -19 0> inverse }
	plane { <0 1 0> 0 rotate <0 0 -45> translate <0 -19 0> inverse }
     }

     difference {
	quadric { Cylinder_Y scale <5 1 5> translate <-30 0 0> }
	plane { <0 1 0> 0 rotate <0 0 -45> translate <0 19 0> inverse }
	plane { <0 1 0> 0 rotate <0 0 45> translate <0 -19 0> }
     }

     difference {
	quadric { Cylinder_Y scale <5 1 5> translate <30 0 0> }
	plane { <0 1 0> 0 rotate <0 0 45> translate <0 19 0> inverse }
	plane { <0 1 0> 0 rotate <0 0 -45> translate <0 -19 0> }
     }
   }
	   texture { CoverColor }
		bounded_by {
		box { UnitBox scale <37.5 56.5 6> }
		}
}


//---- Front of Receptical Plate
#declare FacePlate =
object {
   union {
     difference {
	box { UnitBox scale <30 49 5> }
	quadric { Cylinder_Z scale <17 17 1> translate <0 -19 0> }
	quadric { Cylinder_Z scale <17 17 1> translate <0 19 0> }
     }
	box { UnitBox scale <17 5 5> translate <0 0 0> }
	box { UnitBox scale <17 5 5> translate <0 38 0> }
	box { UnitBox scale <17 5 5> translate <0 -38 0> }
     difference {
        quadric { Sphere scale <4 4 2> translate <0 0 -5> }
	box { UnitBox scale <.5 4.5 2> translate <0 0 -7> rotate <0 0 30> }
     }
   }
	   texture { CoverColor }	
		bounded_by {
		box { UnitBox scale <37.5 56.5 8> }
		}
}


#declare SocketCover =
composite {
object { PlateCorners }
object { FacePlate }
	bounded_by {
	box { UnitBox scale <37.5 56.5 8> }
	}
}



//---- Standard Socket with Ground
#declare Socket =
object {
   union {
     difference {
	intersection { Disk_Z scale <16 16 6> }
	quadric { Sphere scale <14 14 3> translate <0 0 -6> }
	box { UnitBox scale <1.1 4 8> translate <-6 3.5 0> }
	box { UnitBox scale <1.1 4 8> translate <6 3.5 0> }
	plane { <0 1 0> -13 }
	plane { <0 -1 0> -13 }
	quadric { Cylinder_Z scale <3 3 1> translate <0 -8 0> }
	box { UnitBox scale <3 1.5 8> translate <0 -9.5 0> }
     }
	box { UnitBox scale <9 1 6> translate <0 -12 0> }
	box { UnitBox scale <9 1 6> translate <0 12 0> }
	difference {
	  union {
		intersection { Disk_Y scale <4.5 12 4.5> translate <0 0 -1.8> }
		intersection { Disk_Z scale <5 5 6> translate <0 -8 0> }
		box { UnitBox scale <5 2.5 6> translate <0 -10.5 0> }
	  }
		plane { <0 0 1> -6 }
		quadric { Cylinder_Z scale <3 3 1> translate <0 -8 0> }
		box { UnitBox scale <3 1.5 8> translate <0 -9.5 0> }
	}
   }
	   texture { CoverColor }
		bounded_by {
		box { UnitBox scale <19 19 7> }
		}

}


//--- Plug End

#declare PlugTexture = 
    texture {
       color White	
       ambient   0.1
       diffuse   0.7
       phong 1
    }

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }


#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }

#declare RR =
   composite {
      object {
         quadric {
            Dot
            translate < 4.500000  0.000000  0.000000>
         }
         texture {
            PlugTexture
         }
      }
      object {
         Connector_1
         scale     < 8.246211  1.000000  1.000000>
         rotate    < 0.000000  0.000000  75.963757>
         translate < 4.500000  0.000000  0.000000>
         texture {
            PlugTexture
         }
      }
      object {
         quadric {
            Dot
            translate < 6.500000  8.000000  0.000000>
         }
         texture {
            PlugTexture
         }
      }
      object {
         Connector_1
         scale     < 12.093387  1.000000  1.000000>
         rotate    < 0.000000  0.000000  82.874984>
         translate < 6.500000  8.000000  0.000000>
         texture {
            PlugTexture
         }
      }
      object {
         quadric {
            Dot
            translate < 8.000000  20.000000  0.000000>
         }
         texture {
            PlugTexture
         }
      }
      object {
         Connector_1
         scale     < 16.000000  1.000000  1.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 8.000000  20.000000  0.000000>
         texture {
            PlugTexture
         }
      }
      object {
         quadric {
            Dot
            translate <-8.000000  20.000000  0.000000>
         }
         texture {
            PlugTexture
         }
      }
      object {
         Connector_1
         scale     < 12.093387  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -82.874984>
         translate <-8.000000  20.000000  0.000000>
         texture {
            PlugTexture
         }
      }
      object {
         quadric {
            Dot
            translate <-6.500000  8.000000  0.000000>
         }
         texture {
            PlugTexture
         }
      }
      object {
         Connector_1
         scale     < 8.246211  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -75.963757>
         translate <-6.500000  8.000000  0.000000>
         texture {
            PlugTexture
         }
      }
      object {
         quadric {
            Dot
            translate <-4.500000  0.000000  0.000000>
         }
         texture {
            PlugTexture
         }
      }
      object {
         Connector_1
         scale     < 9.000000  1.000000  1.000000>
         translate <-4.500000  0.000000  0.000000>
         texture {
            PlugTexture
         }
      }
      object {
         quadric {
            Dot
            translate < 4.500000  0.000000  0.000000>
         }
         texture {
            PlugTexture
         }
      }
	   bounded_by {
	   box { UnitBox scale <14 14 10> translate <0 11 0> }
	   }

   }


//--- Side Corners
#declare Sides =
object {
   intersection { Disk_Z scale <1 1 5> }
      texture { PlugTexture }
}



#declare PlugSkin =
object {
   union {
    triangle { <-4.5 0 -6> <4.5 0 -6> <-6.5 8 -6> }
    triangle { <4.5 0 -6> <6.5 8 -6> <-6.5 8 -6> }
    triangle { <6.5 8 -6> <-6.5 8 -6> <-8 20 -6> }
    triangle { <-8 20 -6> <6.5 8 -6> <8 20 -6> }
    triangle { <-4.5 0 6> <4.5 0 6> <-6.5 8 6> }
    triangle { <4.5 0 6> <6.5 8 6> <-6.5 8 6> }
    triangle { <6.5 8 6> <-6.5 8 6> <-8 20 6> }
    triangle { <-8 20 6> <6.5 8 6> <8 20 6> }
    triangle { <-4.5 -1 -5> <4.5 -1 -5> <-4.5 -1 5> }
    triangle { <-4.5 -1 5> <4.5 -1 5> <4.5 -1 -5> }
    triangle { <-5.5 0 -5> <-5.5 0 5> <-7.5 8 -5> }
    triangle { <-7.5 8 -5> <-5.5 0 5> <-7.5 8 5> }
    triangle { <-7.5 8 -5> <-7.5 8 5> <-9 20 -5> }
    triangle { <-9 20 -5> <-7.5 8 5> <-9 20 5> }
    triangle { <5.5 0 -5> <5.5 0 5> <7.5 8 -5> }
    triangle { <7.5 8 -5> <5.5 0 5> <7.5 8 5> }
    triangle { <7.5 8 -5> <7.5 8 5> <9 20 -5> }
    triangle { <9 20 -5> <7.5 8 5> <9 20 5> }
   }
      texture { PlugTexture }
	   bounded_by {
	   box { UnitBox scale <14 14 10> translate <0 11 0> }
	   }
}



#declare PlugFace =
object {
   union {
    intersection { Disk_Y scale <2.5 1 2.5> translate <9.5 21 -6.5> }
    intersection { Disk_Y scale <2.5 1 2.5> translate <-9.5 21 -6.5> }
    intersection { Disk_Y scale <2.5 1 2.5> translate <9.5 21 6.5> }
    intersection { Disk_Y scale <2.5 1 2.5> translate <-9.5 21 6.5> }
    box { UnitBox scale <12 1 6.5> translate <0 21 0> }
    box { UnitBox scale <9.5 1 9> translate <0 21 0> }
    box { UnitBox scale <3.5 1 9> translate <0 -1 0> }
    box { UnitBox scale <3.5 1 7> translate <0 3 0> }
    box { UnitBox scale <3.5 1 7> translate <0 7 0> }
    box { UnitBox scale <3.5 1 7> translate <0 11 0> }
    box { UnitBox scale <3.5 1 7> translate <0 15 0> }
  }
	texture { PlugTexture }
	   bounded_by {
	   box { UnitBox scale <14 14 10> translate <0 11 0> }
	   }
}

//---- Complete Plug End
#declare PlugEnd =
composite {
   composite { RR translate <0 0 -5> }
   composite { RR translate <0 0 5> }
   object { Sides translate <-4.5 0 0> }
   object { Sides translate <4.5 0 0> }
   object { Sides translate <6.5 8 0> }
   object { Sides translate <-6.5 8 0> }
   object { Sides translate <8 20 0> }
   object { Sides translate <-8 20 0> }
   object { PlugSkin }
   object { PlugFace }
  	   bounded_by {
	   box { UnitBox scale <14 14 10> translate <0 11 0> }
	   }
}


//--- Plug Wire

#declare TT1 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2398.500000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        2362.500000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2398.500000 0.000000 1395351.562500 >
   }


#declare TT2 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2538.500000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        2502.500000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2538.500000 0.000000 1565626.562500 >
   }

#declare TT3 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -8338.500000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        8302.500000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -8338.500000 0.000000 17232876.562500 >
   }

#declare Wire1 =
object {
  union {
    difference {
      quartic { TT1 rotate <90 0 0> translate <0 -34.5 0> }
      plane { <0 1 0> 0 rotate <0 0 90> }
      plane { <0 1 0> 0 rotate <0 0 -142> translate <0 -34.5 0> inverse}	
    }

    difference {
      quartic { TT2 rotate <90 0 0> translate <-55.160755 -77.596298 0> }
      plane { <0 1 0> 0 rotate <0 0 -142> translate <0 -34.5 0> }	       
      plane { <0 1 0> 0 rotate <0 0 -124.6> translate <-55.160755 -77.596298 0 > }	
    }

    difference {
      quartic { TT3 rotate <90 0 0> translate <-111.945129 -159.909943 0> }
      plane { <0 1 0> 0 rotate <0 0 -124.6> translate <-55.160755 -77.596298 0 > inverse }	
      plane { <0 1 0> 0 rotate <0 0 124.2> translate <-111.945129 -159.909943 0 > inverse }	
    }

    difference {
      quartic { TT2 rotate <90 0 0> translate <-168.153458 -77.201881 0> }
      plane { <0 1 0> 0 rotate <0 0 124.2> translate <-111.945129 -159.909943 0> }	       
      plane { <0 1 0> 0 rotate <0 0 -90> translate <-168.153458 -77.201881 0 > }	
    }
    	
    intersection { Disk_X scale <400 3 3> translate <-568.153458 -112.701881 0> }

  }
	texture { PlugTexture }
	  bounded_by {
	  box { UnitBox scale <335.5 68 5> translate <-325.5 -57 0> }
	  }
}




//--- Double Strand insulated Wire
#declare Wire =
composite {
  object { Wire1 translate <0 0 2> }
  object { Wire1 translate <0 0 -2> }
	  bounded_by {
	  box { UnitBox scale <335.5 68 7> translate <-325.5 -57 0> }
	  }
}


//---- Complete Receptical with Plug & Wire
#declare Receptical =
composite {
  composite { SocketCover }
  object { Socket translate <0 19 -1> }
  object { Socket translate <0 -19 -1> }
		bounded_by {
		box { UnitBox scale <37.5 56.5 6> }
		}
}

//--- Receptical, Plug & Plug Wire

#declare Plugin =
composite {
  composite { Receptical }
//  composite { PlugEnd rotate <90 0 0> translate <0 -19 -31> }
//  composite { Wire rotate <0 -90 0> translate <0 -19 -30> }

}




