//----- Roman Marble Pool
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare Cap_Color = texture { T_Stone12 }
#declare Base_Color = texture { T_Stone3 }
#declare C_Rib_Color = texture { T_Stone12 }
#declare Main_Column_Color = texture { T_Stone2 }
#declare Footer_Color = texture { T_Stone2 }

#declare gold2 =
texture {
  pigment { color rgb <0.64, 0.51, 0.05> }
  finish { crand 0.02 ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8 specular 0.5 }
}

#declare Pool_Water =
texture {
  pigment { color CadetBlue }
  finish { ambient 0.2 diffuse 0.6 phong 0.3 reflection { 0.5 } }
}

#declare Ground_Floor =
texture {
  pigment { color DarkGreen }
  finish { ambient 0.3 diffuse 0.6 crand 0.07 }
}

//--- Single Cap Section
#declare Cap_Sec =
union {
  sphere { y, 1 }
  object { Disk_Y scale <1, 2, 1> translate y*3 }
  sphere { <-1, 5, 0>, 1 }
  translate x*-3
}

//--- Column Capital
#declare Cap =
union {
  object { Cap_Sec }
  object { Cap_Sec rotate y*20 }
  object { Cap_Sec rotate y*40 }
  object { Cap_Sec rotate y*60 }
  object { Cap_Sec rotate y*80 }
  object { Cap_Sec rotate y*100 }
  object { Cap_Sec rotate y*120 }
  object { Cap_Sec rotate y*140 }
  object { Cap_Sec rotate y*160 }
  object { Cap_Sec rotate y*180 }
  object { Cap_Sec rotate y*200 }
  object { Cap_Sec rotate y*220 }
  object { Cap_Sec rotate y*240 }
  object { Cap_Sec rotate y*260 }
  object { Cap_Sec rotate y*280 }
  object { Cap_Sec rotate y*300 }
  object { Cap_Sec rotate y*320 }
  object { Cap_Sec rotate y*340 }
  box { -1, 1 scale <5, 1, 5> translate y*7 }
  texture { Cap_Color scale <3, 2, 3> }
  bounded_by { sphere { y*3, 9 } }
}

//--- Ribbing for lower column
#declare Rib = box { -1, 1 scale <5, 7, 0.5> translate y*8 }

//--- Column Base
#declare Base =
union {
  difference {
    union {
      box { -1, 1 scale <6, 2, 6> translate y*2 }
      box { -1, 1 scale <5, 9, 5> translate y*13 }
      box { -1, 1 scale <6, 1, 6> translate y*19 }
    }
    box { -1, 1 scale <3, 5, 1> translate <0, 11, -5> }
  }
  sphere { 0, 1 scale <3, 5, 1> translate <0, 11, -4> }
  texture { Base_Color scale <7, 8, 6> }
  bounded_by { box { -1, 1 scale <7, 12, 7> translate y*10 }  }
}

//--- Lower Rib Section of Column
#declare C_Ribs =
union {
  intersection {
    union {
      object { Rib }
      object { Rib rotate y*30 }
      object { Rib rotate y*60 }
      object { Rib rotate y*90 }
      object { Rib rotate y*120 }
      object { Rib rotate y*150 }
    }
    object { Cylinder_Y scale <4, 1, 4> }
  }     
  object { Disk_Y scale <4, 1, 4> translate y*14 }
  object { Disk_Y scale <4, 1, 4> translate y*3 }
  object { Disk_Y scale <3.5, 7, 3.5> translate y*8 }
  sphere { 0, 1 scale <5, 3.5, 5> }
  texture { C_Rib_Color scale <3, 6, 2> }
  bounded_by { sphere { y*8, 11 } }
}

//--- The Main Column
#declare Main_Column =
object {
   intersection { Disk_Y scale <3.5, 12, 3.5> }
   texture { Main_Column_Color scale <4, 5, 4> }
}

//--- Top Base
#declare T_Base =
intersection {
   object { Cylinder_Y scale <59, 1, 59> }
   object { Cylinder_Y scale <49, 1, 49> inverse }
   plane { y, 0 inverse }
   plane { y, 2 }
   plane { x, 8 inverse }
   plane { z, 8 inverse }
}

//--- Top Cap
#declare T_Cap =
intersection {
   object { Cylinder_Y scale <61, 1, 61> }
   object { Cylinder_Y scale <46, 1, 46> inverse }
   plane { y, 0 inverse }
   plane { y, 2 }
   plane { x, 8 inverse }
   plane { z, 8 inverse }
}

//--- Small Top Dentiles
#declare Dentile = box { -1, 1 scale <7, 1, 0.8> translate <54, 3, 0> }

#declare Top =
object {
  union {
    object { T_Base }
    object { T_Cap translate y*4 }
    object { Dentile rotate y*-13 }
    object { Dentile rotate y*-17 }
    object { Dentile rotate y*-21 }
    object { Dentile rotate y*-25 }
    object { Dentile rotate y*-29 }
    object { Dentile rotate y*-33 }
    object { Dentile rotate y*-37 }
    object { Dentile rotate y*-41 }
    object { Dentile rotate y*-45 }
    object { Dentile rotate y*-49 }
    object { Dentile rotate y*-53 }
    object { Dentile rotate y*-57 }
    object { Dentile rotate y*-61 }
    object { Dentile rotate y*-65 }
    object { Dentile rotate y*-69 }
    object { Dentile rotate y*-73 }
    object { Dentile rotate y*-77 }
  }
  texture { Cap_Color scale <10, 10, 6> }
  bounded_by { box { -1, 1 scale <30, 5, 30> translate <35, 2, 35> } }
}

//------ Complete Column
#declare Column =
union {
  object { Cap translate y*60 }
  //object { Base }
  object { C_Ribs translate y*22 }
  object { Main_Column translate y*48 }
  bounded_by { box { -1, 1 scale <9, 35, 9> translate y*35 }  }
}


//--- Colums & Top in one complete structure
#declare Structure_1 =
union {
  object { Column translate z*54 rotate y*18 }
  object { Column translate z*54 rotate y*36 }
  object { Column translate z*54 rotate y*54 }
  object { Column translate z*54 rotate y*72 }
  object { Top translate y*68 }
  bounded_by { box { -1, 1 scale <30, 40, 30> translate <35, 36, 35> } }
}

//--- Pool & Walk
//--- Concrete Footer around Pool
#declare Pool =
union{
  union{
    intersection {
      object { Cylinder_Y scale <62, 1, 62> }
      object { Cylinder_Y scale <44, 1, 44> inverse }
      plane { y, 0 inverse }
      plane { y, 3 }
    }
    intersection {
      object { Cylinder_Y scale <62, 1, 62> }
      object { Cylinder_Y scale <41, 1, 41> inverse }
      plane { y, -4 inverse }
      plane { y, 0 }
    }
    texture { Footer_Color scale <8, 9, 9> }
    bounded_by { object { UnitBox scale <75, 8, 75> } }
    translate y*-3
  }
  //--- Water in the Pool
  object { Disk_Y scale <45, 0.01, 45> translate y*-4 texture { Pool_Water } }
}
