//------ Plants............. Miller 7/7/91
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//------------- Plant Leaf
#declare Leaf_Texture =
texture {
  pigment { color ForestGreen }
  finish { ambient 0.2 diffuse 0.5 bumps 1 scale 3 phong 1 phong_size 50 }
}

#declare LEAF_BODY =
object {
  intersection {
    sphere { 0, 20 }
    plane { z, 0 rotate y*26 translate z*-10 inverse }
    plane { z, 0 rotate y*-26 translate z*10 }
  }
  texture { Leaf_Texture }
  clipped_by {
    plane { y, 0 rotate z*22.5 translate y*8 inverse }
    sphere { 0, 19.9 inverse }
    bounded_by { sphere {0, 21 } }
  }
}

#declare STEM =
object {
  intersection { Disk_Z scale <77, 77, 0.7> translate <-40, -40, 0> }
  texture { Leaf_Texture }
  clipped_by {
    plane { x, 0 rotate z*22.5 translate x*20 inverse }
    object { Cylinder_Z scale <76.5, 76.5, 1> translate <-40, -40, 0> inverse }
  }
}

//------- One Leaf & Stem
#declare LEAF =
union {
  object { LEAF_BODY }
  object { STEM }
  translate <-37, 40, 0 >
}

//------- 4 Leafs in a bunch
#declare BUNCH4=
union {
  object { LEAF }
  object { LEAF rotate y*90 }
  object { LEAF rotate y*180 }
  object { LEAF rotate y*270 }
  bounded_by { sphere {0, 70 translate y*20 } }
}

//------- 3 Leafs in a bunch
#declare BUNCH3=
union {
  object { LEAF rotate y*120 }
  object { LEAF rotate y*240 }
  object { LEAF }
  bounded_by { sphere {0, 70 translate y*20 } }
}

#declare Plant1 =
union {
  object { BUNCH4 }
  object { BUNCH4 rotate y*45 }
  object { BUNCH4 rotate y*45 scale 0.95 translate y*20 }
  object { BUNCH3 rotate y*5 scale 0.9 translate y*35 }
  object { BUNCH3 rotate y*50 scale 0.7 translate y*48 }
  object { BUNCH3 rotate y*110 scale 0.65 translate y*60 }
  object { BUNCH3 rotate y*50 scale 0.35 translate y*72 }
}
