//--- Mountains for Bug3
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare JungleGreen =
texture {
  pigment { color DarkGreen }
  finish { phong 0.5 phong_size 20 ambient 0.1 crand 0.05 }
}

#declare Swamp =
texture {
  pigment { color MidnightBlue }
  finish { phong 0.5 phong_size 70 ambient 0.1 diffuse 0.5 reflection { 0.55 } }
  normal { ripples 0.01 frequency 0.1 scale 0.1 }
}

//------------- Light Tan Rock
#declare rock2 =
texture { T_Grnt0 scale <2, 3, 2> rotate z*40 finish { ambient 0.2 } }
texture { T_Grnt7a scale <1.3, 2, 1.3> rotate z*-30 rotate x*40  finish { ambient 0.2 } }

//--- Mountain Range
object {
  height_field {
    tga "map19.tga"
    smooth // added "smooth" - Colin Fleming, cj_fleming@btinternet.com
  }
  texture {
    rock2  
    finish { phong 0.9 phong_size 100 }
    scale 0.2
  }
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.2 color DimGray filter 0.5 color DimGray filter 0.5]
        [0.2 0.4 color DimGray filter 0.5 color Clear]
        [0.4 1 color Clear color Clear]
      }
    }
    finish { phong 0.5 phong_size 20 ambient 0.1 crand 0.05 }
  }
  scale <3000, 300, 3000>
  translate <-1500, -10, -1500>
  // rotate y*210
  rotate y*314
  translate z*200
}

//--- Ground
object {
  plane { y, -8.5 translate <20, 0, -20> }
  texture { Swamp }
}
