// ----- Bugs at high tide......... Miller 7/14/92
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "Mount2CJF.inc"
#include "World66CJF.inc"
#include "BugCJF.inc"
#include "PoolCJF.inc"

camera {
  location <0, 45, -250>
  direction z*1.8
  up y
  right x*image_width/image_height
  look_at y*35
}

//-------lights
light_source { <5000, 1200, -1000> color rgb 1  }
light_source { <-7000, 3000, -600> color rgb <0.8, 0.498039, 0.196078> }
light_source { <-30, 100, -100> color rgb 1 }

#declare gold2 =
texture {
  pigment { colour rgb <0.64, 0.51, 0.05> }
  finish { ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8 specular 0.5 crand 0.02 }
}

//--- Bug on Column
#declare Bug_Column =
union {
  object { Column }
  object { Bug
  scale 0.2
  rotate y*90
  rotate x*-90
  translate <0, 52, -2>
  }
}

//**************** Build Scene **************************************
object {
  Bug_Column
  scale 4
  rotate y*60
  rotate z*-30
  rotate x*30
  translate <-100, -160, -135>
}

object {
  Structure_1
  scale 4
  translate <0, -140, 150>
}

//--- Back Bug
object {
  Bug
  scale 1.2
  rotate y*-50
  translate <130, -19, 200>
}
