//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare JungleGreen =
texture {
  pigment { color DarkGreen }
  finish { phong 0.5 phong_size 20 ambient 0.1 crand 0.05 }
}

#declare Swamp =
texture {
  pigment { color MidnightBlue }
  finish { phong 0.5 phong_size 80 ambient 0.3 diffuse 0.5 reflection { 0.6 } }
  normal { ripples 0.02 frequency 0.01 scale 0.1 }
}

//------------- Light Tan Rock
#declare rock2 =
texture { T_Grnt0 scale <2, 3, 2> rotate z*40 finish { ambient 0.1 diffuse 0.7 } }
texture { T_Grnt7a scale <1.3, 2, 1.3> rotate z*-30 rotate x*40 finish { ambient 0.1 diffuse 0.7 } }

//--- Mountain Range
object {
  height_field {
    tga "world3.tga"
    smooth  // added "smooth" - Colin Fleming, cj_fleming@btinternet.com
  }
  texture { rock2 scale 0.2 finish { phong 0.05 phong_size 100 } }
  texture {
    pigment {
     gradient y
      color_map {
        [0.0 0.3 color Black filter 0.5 color DimGray filter 0.5]
        [0.3 0.6 color DimGray filter 0.5 color Clear]
        [0.6 1.0 color Clear color Clear]
      }
    }
    finish { crand 0.05 }
  }
  /*
  texture {
    pigment { color Gray }
    finish { ambient 0.1 diffuse 0.5 }
  }
  */
  scale <6000, 1800, 6000>
  translate <-3000, -10, -3000>
  rotate y*300
  translate z*200
}

//--- Ground
object {
  Square_Y
  texture { Swamp }
  scale <3000, 1, 3000>
  translate y*400
}
