//----- Bugs find the way out......... Miller 7/14/92
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "stones.inc"
#include "Hill5CJF.inc"
#include "World66CJF.inc"
#include "BugCJF.inc"
#include "Stem1CJF.inc"

camera {
  location <0, 1600, -3500>
  direction z*1.8
  up y
  right x*image_width/image_height
  look_at y*800
 }


//-------lights
light_source { <500, 50000, 1000> color White }
light_source { <-7000, 60000, -6000> color Gold }
light_source { <6000, 3000, -100> color White }

#declare gold2 =
texture {
  pigment { colour rgb <0.64, 0.51, 0.05> }
  finish { crand 0.02 ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8 specular 0.5 }
}

//**************** Build Scene **************************************
/*
//---- Locator Poles
#declare Pole =
union {
  object { Cylinder_Y scale <20, 1, 20>
    texture {
      pigment {
        gradient y
        color_map {
          [0.00 0.25 color Green color Green]
          [0.25 0.50 color Yellow color Yellow]
          [0.50 0.75 color Red color Red]
          [0.75 0.95 color Blue color Blue]
          [0.95 1.00 color White color White]
        }
      }
      finish { ambient 0.8 diffuse 0.5 phong 1 }
    }
    scale 100
  }
  //--- Fixed Mark
  object {
    Square_Y scale <100, 1, 100> translate y*1200
    texture { pigment { color Violet } finish { ambient 0.5 } }
  }
}

object { Pole translate <700, 0, 1500> }
object { Pole translate <-850, 0, 1000> }
object { Pole translate <-1300, 0, 650> }
object { Pole translate <750, 0, -900> }
*/

//---- Back right Bug
object { Bug
  scale 12
  rotate y*-90
  translate <740, 620, 1550>
}

//----  Bug leaving water
object { Bug
  scale 12
  rotate y*180
  rotate z*60
  translate <800, 400, 550>
}

//----  Left Bug thinking about going into the water
object { Bug
  scale 12
  rotate y*-160
  translate <-1300, 660, 800>
}

//--- Front Bug getting the hell out of there
object { Bug
  scale 12
  rotate y*-110
  rotate x*40
  translate <0, 550, -1600>
}

object { stem1
  scale 40
  translate <-1000, 400, 1800>
}

object { stem1
  scale 30
  rotate y*50
  translate <-800, 500, 1900>
}

