//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
global_settings {
  //assumed_gamma 1
  //ambient_light 0
  max_trace_level 20
}
    
#version 3.1;    
    
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "Tex.inc"
#include "FinHead.inc"
#include "Mound.inc"

camera {
  location <0, 30, -210>
  direction z*1.8 
  up y
  right x*image_width/image_height
  look_at y*10
}

light_source { <-150, 450, -250> color rgb 1 }  //----- Light 1
light_source { < 700, 450, -850> color rgb 1 }  //----- Light 2
light_source { <-200,  10,  -50> color rgb 1 }  //----- Light 3

//-------- World
#declare WORLD =
sphere { 0, 1 hollow on
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.2 color red 1    green 0.751 blue 1    color red 0.69 green 0.44 blue 0.69 ] 
        [0.2 0.3 color red 0.69 green 0.44  blue 0.69 color red 0.41 green 0.16 blue 0.62 ] 
        [0.3 0.4 color red 0.41 green 0.16  blue 0.62 color rgb 0 ] 
        [0.4 1.0 color rgb 0                          color rgb 0 ] 
      }
    }
    scale <1, 1.3, 1>
    finish { ambient 1 diffuse 0 }
  }
  scale <8000, 2000, 8000>
  translate y*-500
}


//----- water level
#declare WATER =
plane { y, -20.5
  texture {
    // Water
    pigment { color CadetBlue }
    normal  { ripples 0.3  frequency 0.03 }
    finish { reflection 0.7 phong 1 ambient 0.3 diffuse 0.6 phong_size 50 }
  }
  interior { ior 1.5 }
}

object { WORLD rotate z*30 rotate x*20 }
object { WATER }
object { FIN_HEAD translate y*32 rotate y*25 }
object { MOUNDS translate y*-30 }