#version 1.0;

#include "colors.inc"
// #include "shapes.old"
#include "textures.inc"
// #include "shapesq.inc"
#include "tex.inc"
#include "finhead.inc"
#include "mound.inc"

camera {
location <0 30 -210> direction <0 0 1.8> 
up <0 1 0> right <1.3 0 0> look_at <0 10 0> }

//----- Light 1
object { light_source { <-150 450 -250> color White }}

//----- Light 2
object { light_source { <700 450 -850> color White }}

//----- Light 3
object { light_source { <-200 10 -50> color White }}


max_trace_level 3

//-------- World
#declare WORLD =
object {
quadric { Sphere scale <1 1 1> }
texture {
gradient <0 1 0>
color_map {
[0 0.2 color red 1.0 green 0.751 blue 1.0   color red 0.69 green 0.44 blue 0.69 ] 
[0.2 0.3 color red 0.69 green 0.44 blue 0.69   color red 0.41 green 0.16 blue 0.62 ] 
[0.3 0.4 color red 0.41 green 0.16 blue 0.62    color Black ] 
[0.4 1.0 color Black    color Black ] 
}
scale <1 1.3 1> ambient 1.0 diffuse 0.0 
}

scale <8000 2000 8000> translate <0 -500 0> rotate <0 0 0> 
}


//----- water level
#declare WATER =
object {
plane { <0 1 0> -20.5 }
texture { Water color CadetBlue reflection 0.7 ripples 0.3 
frequency 0.03 phong 1 ambient 0.3 diffuse 0.6 phong_size 50
}}


object { WORLD rotate <0 0 30> rotate <20 0 0> }
object { WATER }
composite { FIN_HEAD translate <0 32 0> rotate <0 25 0> }
composite { MOUNDS translate <0 -30 0> }

