// 	A 1955 Negative Enlarger .......5/23/92 M. Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "en_tex.inc"

camera {
   location <-160, 120, -300> 
   direction z*1.95 
   up y
   right x*image_width/image_height
   look_at <-40, 60, 0> 
}

light_source { <  600,  100, -300> color White }     //----- Light 1
light_source { < -300, 1000, -350> color White }     //----- Light 2
light_source { <-1300, -200,  100> color Firebrick } //----- Light 3

#declare SPOT =
light_source {
  0
  color White
  spotlight
  point_at -y
  tightness 40
  radius 11
  falloff 50
}
 
//-------- Handle for Mouth Gap Release
#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

//----- Handle For Carrage Release
#declare ROD =
union {
  sphere { 0, 1 texture { Chrome } }
  cylinder { -x, x, 1 scale <10, 1, 1> rotate y*90 texture { Chrome } }
  sphere { 0, 1 translate z*-10 texture { Chrome } }
  cylinder { -x, x, 1 scale <21.189620, 1, 1> rotate z*-19.290046 rotate y*143.130102 translate z*-10 texture { Chrome } }
  sphere { 0,  2 translate <-16, -7, -22>  texture { Chrome } }
  //bounded_by { sphere { 0, 17.226506 translate <-8, -3.5, -11> } }
}

//----- Cutter for Hood ...thx Dan
#declare  HOLE = object { sphere { 0, 19.5 inverse } }

//----- Mouth Rim 
#declare RIM = 
object {
  difference {
    union {
      cylinder { 0, y, 1 scale <20.5, 2, 20.5> }
      box { -1, 1 scale <5, 2, 10> translate x*22.5 }
    }
    object { Cylinder_Y scale <11, 1, 11> translate <27.5, 0, -15> }
    object { Cylinder_Y scale <11, 1, 11> translate <27.5, 0, 15> }
  }
  texture { DGray }
  //bounded_by { sphere { 0, 1 scale <30, 8, 30> translate x*3 } }
}

//------ Knob Grip
#declare KB = cylinder { 0, z, 1 scale <0.75, 0.75, 1> translate <-3.2, 0, -3> }

//------ Pin Bolts
#declare PIN_BOLT = 
sphere { 0, 1
  scale <1, 1, 0.5>
  texture { Chrome }
}

//------ Small Knob
#declare S_KNOB = 
object {
  union {
    cylinder { 0, z, 1 scale <2, 2, 1> translate z*-1 }
    cylinder { 0, z, 1 scale <4, 4, 0.1> translate z*-2 }
    cylinder { 0, z, 1 scale <3, 3, 1.2> translate z*-3 }
    sphere { 0, 1 scale <2.5, 2.5, 1> translate z*-4.2 }
    object { KB }
    object { KB rotate z*30 }
    object { KB rotate z*60 }
    object { KB rotate z*90 }
    object { KB rotate z*120 }
    object { KB rotate z*150 }
    object { KB rotate z*180 }
    object { KB rotate z*210 }
    object { KB rotate z*240 }
    object { KB rotate z*270 }
    object { KB rotate z*300 }
    object { KB rotate z*330 }
  }
  texture { Kidney }
  //bounded_by { sphere { z*-2, 6 } }
}

//************************************************
//------ Build Light Hood
#declare L_HOOD = 
union {
  //----- Top Light Socket Trim
  object {
    union {
      sphere { 0, 1 scale <6, 2, 6> translate y*40 } 
      cylinder { 0, y, 1 scale <6,   0.5, 6>   translate y*39.5 }
      cylinder { 0, y, 1 scale <6.5, 0.5, 6.5> translate y*38.5 }
      cylinder { 0, x, 1 scale <2,   1.5, 2>   translate <5.5, 35.5, 0> }
      cylinder { 0, y, 1 scale <6.5, 0.5, 6.5> translate y*32.5 }
    }
    texture { GOLD }
    //bounded_by { sphere { y*35, 11 } }
  } // end object
  //----- Hood with HeatSink Fins
  object {
    union {
      difference {
        union {
          box { -1, 1 scale <20, 20, 0.5> translate y*11 }
          box { -1, 1 scale <20, 20, 0.5> translate <0, 11, 3> }
          box { -1, 1 scale <20, 20, 0.5> translate <0, 11, -3> }
          box { -1, 1 scale <0.5, 20, 20> translate y*11 }
          box { -1, 1 scale <0.5, 20, 20> translate <3, 11, 0> }
          box { -1, 1 scale <0.5, 20, 20> translate <-3, 11, 0> }
          sphere { y*11, 16 } 
        }
        plane { y, 11 }
        object { HOLE translate y*11 }
      }
      cylinder { 0, y, 1 scale <7.5, 4, 7.5> translate y*28 }
      cylinder { 0, y, 1 scale <19.5, 3.5, 19.5> translate y*7.5 }
    }
    texture { WrinkleGray }
    //bounded_by { sphere { y*11, 26.5 } }
  }
  //------ Socket & Cord Support
  object {
    union{
      cylinder { 0, y, 1 scale <5.5, 2.5, 5.5> translate y*35.5 }
      cylinder { 0, x, 1 scale <2.5, 1, 1> translate <7.5, 35.5, 0> }
    }
    texture { Chrome }
    //bounded_by { sphere { y*35.5, 12 } }
  }
  //----- Add Top Mouth Rim
  object { RIM translate y*2 }
  //bounded_by { sphere { y*11, 38 } }
} //end composite
 
//******************************************************
//------ Hieght Adjustment
#declare H_ADJUST = 
union {
  //------ Slider
  object {
    difference {
      union {
        object { Cylinder_Y scale <6, 1, 6> }
        box { -1, 1 scale <8, 20, 2.5> translate y*18 }
      }
      plane { y, 0 }
      plane { y, 35 inverse }
      box { -1, 1 scale <1, 12.5, 15> translate <-4, 17.5, 0> }
      box { -1, 1 scale <5, 12.5, 15> translate <8, 17.5, 0> }
      box { -1, 1 scale <25, 52.5, 0.6> }
    }
    texture { WrinkleGray }
    //bounded_by { sphere { y*12.5, 25 } } 
  }
  //---- Angle Brace
  object {
    union {
      box { -1, 1 scale <0.5, 16, 1.5> translate <-8.5, 19, 0> } 
      box { -1, 1 scale <2, 0.5, 1.5> translate <-11, 34.5, 0> } 
      box { -1, 1 scale <0.5, 2, 1.5> translate <-13.5, 36, 0> } 
      box { -1, 1 scale <0.5, 20, 1.5> rotate z*24.5 translate <-16, 19, 0> } 
      triangle { <-9, 4, 0>, <-9, 34, 0>, <-23, 34, 0> }
      triangle { <-23, 34, 0>, <-24.5, 38, 0>, <-14, 38, 0> }
      triangle { <-23, 34, 0>, <-14, 34, 0>, <-14, 38, 0> }
      cylinder { 0, x, 1 scale <6, 3, 3> translate <-19, 40, 0> }
    }
    texture { WrinkleGray }
    //bounded_by { sphere { <-14, 21, 0>, 28 } }
  }
  object { S_KNOB translate <0, 24, -7.6> }
  object { S_KNOB translate <-19, 40, -4.5> }
  object { PIN_BOLT translate <-6.5, 2.5, -2.5> }
  object { PIN_BOLT translate <-6.5, 32.5, -2.5> }
  object { PIN_BOLT translate <6.5, 2.5, -2.5> }
  object { PIN_BOLT translate <6.5, 32.5, -2.5> }
} // end composite

//************************************************************
//------- Bottom Mouth & Support Bars
#declare SUPPORT = 
union {
  //------- Place Bottom Rim
  object { RIM }
  //------- Vertical Gap Rod Support
  object {
    Cube scale <3.5, 4, 4> translate <24, -6, 0>
    texture { WrinkleGray }
  }
  //------- Vertical Gap Rods
  object {
    difference {
      union {
        object { Cylinder_Y scale 1 translate <22.5, 0, -2> }
        object { Cylinder_Y scale 1 translate <22.5, 0, 2> }
      }
      plane { y, -20 }
      plane { y, 9 inverse }
    }
    texture { Chrome }
    //bounded_by { sphere { <23, -6, 0>, 19 } }
  }
  //------- Horizonal Adjustment Bar
  object {
    Disk_X scale <10, 1.5, 1.5> translate <36.5, -1, 0>
    texture { Chrome }
  }
  //bounded_by { object { Sphere scale <40, 25, 40> translate x*13 } }
}

//***************************************************
//------ Bellow Side
#declare BS = 
object {
  union {
    triangle { < -8,  0,  0>, <  8,  0,  0>, <-12,  4, -4> }
    triangle { <-12,  4, -4>, < 12,  4, -4>, <  8,  0,  0> }
    triangle { <-12,  4, -4>, < 12,  4, -4>, <  9,  8, -1> }
    triangle { <  9,  8, -1>, < -9,  8, -1>, <-12,  4, -4> }
    triangle { < -9,  8, -1>, <  9,  8, -1>, < 13, 12, -5> }
    triangle { < 13, 12, -5>, <-13, 12, -5>, < -9,  8, -1> }
    triangle { <-13, 12, -5>, < 13, 12, -5>, <-10, 16, -2> }
    triangle { <-10, 16, -2>, < 10, 16, -2>, < 13, 12, -5> }
    triangle { <-10, 16, -2>, < 10, 16, -2>, < 14, 20, -6> }
    triangle { < 14, 20, -6>, <-14, 20, -6>, <-10, 16, -2> }
    triangle { <-14, 20, -6>, < 14, 20, -6>, <-11, 24, -3> }
    triangle { <-11, 24, -3>, < 11, 24, -3>, < 14, 20, -6> }
    triangle { <-11, 24, -3>, < 11, 24, -3>, < 15, 28, -7> }
    triangle { < 15, 28, -7>, <-15, 28, -7>, <-11, 24, -3> }
    triangle { <-15, 28, -7>, < 15, 28, -7>, <-12, 32, -4> }
    triangle { <-12, 32, -4>, < 12, 32, -4>, < 15, 28, -7> }
    triangle { <-12, 32, -4>, < 12, 32, -4>, < 13, 36, -5> }
    triangle { < 13, 36, -5>, <-13, 36, -5>, <-12, 32, -4> }
  }
  texture { BELL }
  //bounded_by { box { -1, 1 scale <20, 24, 10> translate <0, 20, -2> } }
}

//------- Put Bellow Sides Together
#declare BELLOW = 
union {
  object { BS translate z*-8 }
  object { BS translate z*8 }
  object { BS rotate y*90 translate x*-8 }
  object { BS rotate y*-90 translate x*8 }
}

//***********************************************
//------ Lens Support & Adjuster
#declare LENS_S = 
union {
  object {
    difference {
      union {
        box { -1, 1 scale <10.5, 1.5, 10.5> translate y*-1.5 }
        box { -1, 1 scale <2.5, 1.5, 8> translate <13, -1.5, 0> }
        box { -1, 1 scale <4, 6.5, 3> translate <16.5, -6.5, 0> }
      }
      object { Cylinder_Y scale <5, 1, 5> translate <15.5, 0, -8> }
      object { Cylinder_Y scale <5, 1, 5> translate <15.5, 0, 8> }
      object { Cylinder_Y scale <5, 1, 5> translate <0, 0, 0> }
      box { -1, 1 scale <9.5, 2, 9.5> translate y*-3 }
    }
    texture { WrinkleGray }
    //bounded_by { sphere { <5, -7, 0>, 23 } }
  }
  //------ Add Knob & Vertical Rod for Lens Adjustment
  object { S_KNOB scale 1.2 translate <19, -10, -11> }
  object {
    union {
      cylinder { 0, y, 1 scale <1.5, 30, 1.5> translate <16, 9, 0> }
      cylinder { 0, z, 1 scale <1, 1, 5> translate <19, -10, -7> }
    }
    texture { Chrome }
    //bounded_by { box { -1, 1 scale <10, 35, 15> translate <19, 9, -6> }}
  }
}

//*************************************************
//------ Main Vertical Support Post
#declare M_POST = 
union {
  //---- Crown
  object {
    union {
      difference {
        object { Cone_Y scale <7, 9, 7> }
        plane { y, 0 }
        plane { y, 9 inverse }
      }
      difference {
        sphere { y*9, 7 }
        plane { y, 9 }
      }
      cylinder { 0, y, 1 scale <6, 0.5, 6> translate y*6.5 }
    }
    texture { GOLD }
    //bounded_by { sphere { y*8, 10 } }
    translate y*150 
  }
  //---- Post
  object {
    Disk_Y scale <5, 78, 5> translate y*78
    texture { Chrome }
  }
  //bounded_by { box { -1, 1 scale <8, 90, 8> translate y*85 } }
}

//******************************************
//----Lens
#declare LENS = 
union {
  object {
    difference {
      union {
        cylinder { 0, y, 1 scale <5.5, 2, 5.5> translate y*-2 }
        cylinder { 0, y, 1 scale <6.8, 0.5, 6.8> translate y*-4.5 }
        cylinder { 0, y, 1 scale <6.5, 0.5, 6.5> translate y*-8.5 }
        cylinder { 0, y, 1 scale <6, 1.5, 6> translate y*-6.5 }
      }
      object { Cylinder_Y  scale <5, 1, 5> }
    }
    texture { Chrome }
    //bounded_by { sphere { y*-4, 11 } } 
  }

  object {
    Sphere scale <5.1, 1, 5.1> translate y*-8
    texture { GLASS }
    interior { ior 0.5 }
  }

  //bounded_by { sphere { y*-4, 11 } } 
}


//**********************************************************
//------- Negative Carrage

#declare CARRAGE = 
object {
  union {
    cylinder { 0, y, 1 scale <19, 1, 19> }
    cylinder { 0, x, 1 scale <8, 0.3, 0.3> translate x*-26.5 }
    sphere { x*-34, 1.5 }
  }
  texture { Chrome }
  //bounded_by { box { -1, 1 scale <35, 2, 20> translate x*-5 } }
}


//**********************************************
//-----Base Collar
#declare COLLAR = 
union {
  object {
    difference {
      union {
        cylinder { 0, y, 1 scale <6, 7, 6> translate y*7 }
        box { -1, 1 scale <3, 2.5, 1> translate <-8, 2.5, 0> }
      }
      object { Cylinder_Z scale <4, 4, 1> translate <-11, 5, 0> }
    }
    texture { WrinkleGray }
    //bounded_by { sphere { <-1, 5, 0>, 19 } }
  }

  //---- Plate & Bolts
  object {
    union {
      box { -1, 1 scale <12.5, 1, 12> translate <-3.5, -1, 0> }
      sphere { 0, 1 scale <2, 1.5, 2> translate <-13.5, 0, 0> }
      sphere { 0, 1 scale <2, 1.5, 2> translate z*9 }
      sphere { 0, 1 scale <2, 1.5, 2> translate z*-9 }
      cylinder { 0, z, 1 scale <1, 1, 3> translate <0, 7, -8> }
    }
    texture { Chrome }
    //bounded_by { sphere { y*3, 20 } }
  }
  object { S_KNOB translate <0, 7, -10> }
  //bounded_by { sphere { y*3, 20 } }
}

//***********************************************
//----- Base
#declare BASE = 
union {
  box { -1, 1 scale <60, 3.5, 50> texture { WOOD11 } }
  box { -1, 1 scale <56, 1, 46> translate y*3.5 texture { BLACK_G }  }
}

//***********************************************
//------ Side Walls
#declare WALL = 
union {
  plane { z, 0
    texture { 
      pigment { color Black }
      finish { ambient 1.0 reflection 0.5 }
    }
  }
  plane { z, -4000
    texture {
      pigment { color CadetBlue }
      finish { ambient 1.0 reflection 0.5 }
    }
  }
}

#declare REF = 
box { -1, 1
  scale <200, 200, 1>
  texture { pigment { color Black } }
  texture { 
    pigment {
      gradient y
      color_map {
        [0.0 0.2 color Black color Black filter 0.2 ]
        [0.2 1.0 color Black filter 0.2 color Clear ]
      }
    }
    finish { reflection 0.3 }
    scale <1, 250, 33>
    translate y*-60
  }
}

#declare REF1 = 
box { -1, 1
  scale <200, 200, 1>
  texture { pigment { color red 0.05 green 0.0 blue 0.05 } }
  texture { 
    pigment {
      gradient y
      color_map {
        [0.0 0.2 color Black color Black filter 0.2 ]
        [0.2 1.0 color Black filter 0.2 color Clear ]
      }
    }
    finish { reflection 0.1 }
    scale <1, 250, 33>
    translate <0, -60, 0> 
  }
}
#declare REF2 = 
box { -1, 1
  scale <200, 200, 1>
  texture { pigment { color red 0.1 green 0.0 blue 0.05 } }
  texture { 
    pigment {
      gradient y
      color_map {
        [0.0 0.2 color Black color Black filter 0.2 ]
        [0.2 1.0 color Black filter 0.2 color Clear ]
      }
    }
    scale <1, 250, 33>
    translate y*-60
  }
}

//***********************************************************
//-------- ASSEMBLE COMPOSITES
union {
  union {
    object { L_HOOD  translate <-70.5, 152, 0> }
    object { H_ADJUST translate <-14, 107, 0> }
    object { SUPPORT translate <-70.5, 148, 0> } 
    object { BELLOW translate <-70.5, 110, 0> }
    object { LENS_S translate <-70.5, 110, 0> }
    object { WALL rotate y*60 translate z*2000 }
    object { LENS translate <-70.5, 109, 0> }
    object { CARRAGE translate <-70.5, 151, 0> }
    object { ROD translate <-45, 140, -4> }
    object { SPOT translate <-70.5, 102, 0>  }
    translate y*-50
  }  // this raises & lowers enlarger head
  object { M_POST translate <-14, -30, 0> } //---should be <-14, 7, 0>
  object { COLLAR translate <-14, 6, 0> }
  object { BASE translate <-58, -0.5, 0> }
  object { REF translate z*70 }
  object { REF1 translate <150, 0, 65> }
  object { REF2 translate <200, 0, 60> }
  rotate y*-15
}

sphere { 0, 1
  hollow on
  scale <5000, 3000, 6000> inverse
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.2 color Black color Black]
        [0.2 0.6 color Black color red 0.3 green 0.1 blue 0.1 ]
        [0.6 1.0 color red 0.3 green 0.1 blue 0.1 color LightBlue]
      }
    }
    finish {
      ambient 1 
      diffuse 0
    }
    scale <4000, 6000, 1000> 
    translate 0
  }
}