// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//---------------- sky for dormer

//---------------- clouds 
#declare cl =
texture {
  pigment {
    bozo
    turbulence 0.9
    colour_map {
      [0.000 0.112 colour rgbf <0.243, 0.145, 0.275, 1> colour rgbf <0.243, 0.145, 0.275, 1>]
      [0.112 0.190 colour rgbf <0.243, 0.145, 0.275, 1> colour rgbf <0.243, 0.145, 0.275, 0.992>]
      [0.190 0.276 colour rgbf <0.243, 0.145, 0.275, 0.992> colour rgbf <0.243, 0.145, 0.275, 0.880>]
      [0.276 0.483 colour rgbf <0.243, 0.145, 0.275, 0.880> colour rgbf <0.302, 0.180, 0.341, 0.804>]
      [0.483 0.767 colour rgbf <0.302, 0.180, 0.341, 0.804> colour rgbf <0.271, 0.278, 0.455, 0.771>]
      [0.767 0.991 colour rgbf <0.271, 0.278, 0.455, 0.771> colour rgbf <0.490, 0.502, 0.631, 0.645>]
      [0.991 1.001 colour rgbf <0.490, 0.502, 0.631, 0.645> colour rgbf <0.243, 0.145, 0.275, 1>]
    }
  }
}

//--------------- gradient black-purple-cream
#declare gr1 =
texture {
  pigment {
    gradient y
    colour_map {
      [0.000 0.179 colour rgbf <0, 0, 0, 0> colour rgbf <0, 0, 0, 0>]
      [0.179 0.436 colour rgbf <0, 0, 0, 0> colour rgbf <0.263, 0, 0.243, 0>]
      [0.436 0.641 colour rgbf <0.263, 0, 0.243, 0> colour rgbf <0.604, 0.310, 0.373, 0>]
      [0.641 0.846 colour rgbf <0.604, 0.310, 0.373, 0> colour rgbf <0.976, 0.600, 0.384, 0>]
      [0.846 0.991 colour rgbf <0.976, 0.600, 0.384, 0> colour rgbf <0.984, 0.702, 0.780, 0>]
      [0.991 1.001 colour rgbf <0.984, 0.702, 0.780, 0> colour rgbf <0, 0, 0, 0>]
    }
  }
}

#declare TheOriginalWorld =
object {
  Ellipsoid scale <20000, 2000, 9000>
  texture {
    cl
    scale <6000, 9000, 2000>
    translate <49000, 100, 1000>
    rotate z*60
  }
  texture { 
    gr1
    finish { ambient 1.0 diffuse 0.0 crand 0.03 }
    scale <50000, 5000, 50000> 
    translate y*-17000
  }
  rotate z*180
}

#declare TheWorld =
union {
  sphere { 0, 1
    texture {
      pigment {
        gradient y 
        color_map {
          [0.00 0.05 color Black color Black]
          [0.05 0.10 color Black color Violet]
          [0.10 0.20 color Violet color CadetBlue]
          [0.20 0.30 color CadetBlue color Violet]
          [0.30 0.40 color Violet color Black]
          [0.40 1.00 color Black color Black]
        }
        scale <0.1, 2, 0.1>
        translate y*-2
        turbulence 0.1
      }
      finish {
        ambient 0.6
        diffuse 0
      }
    }
    scale 10000
    rotate x*35
    rotate z*25
  } 
  //--- Ceiling
  plane { y, 2000
    texture {
      pigment {
        gradient y
	    color_map {
          [0.00 0.05 color Black color Black]
          [0.05 0.10 color Black color Violet]
          [0.10 0.20 color Violet color CadetBlue]
          [0.20 0.50 color CadetBlue color Violet]
          [0.50 0.70 color Violet color Black]
          [0.70 1.00 color Black color Black]
        }
	    scale <0.3, 2, 0.3>
	    turbulence 0.1
      }
      finish {
        ambient 0.8
        diffuse 0
      }
    }
    scale 10000
  }
}