// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare YourTexture =
texture { 
  pigment { colour <0.2, 0.2, 0.23> }
  finish { phong 1.0 ambient 0.15 }
}

#declare Dot = sphere { 0, 1 }
//quadric { 1, 0, 0, -1.0 }

#declare Connector_1 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane { x, 0 inverse }
  plane { x, 1}
}

#declare Connector_2 = 
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare YourThing1 =
object {
  union {
    sphere { y*10, 0.75 }
    object { Connector_1 scale <3.441562, 0.75, 0.75> rotate z*80.999980 translate y*10 }
    sphere { <0.53838, 13.39919, 0>, 0.75 }
    object { Connector_1 scale <3.407531, 0.75, 0.75> rotate z*58.011424 translate <0.53838, 13.39919, 0> }
    sphere { <2.34352, 16.2893, 0>, 0.75 }
    object { Connector_1 scale <3.31404, 0.75, 0.75> rotate z*39.870496 translate <2.34352, 16.2893, 0> }
    sphere { <4.88703, 18.41378, 0>, 0.75 }
    object { Connector_1 scale <3.220569, 0.75, 0.75> rotate z*21.720966 translate <4.88703, 18.41378, 0> }
    sphere { <7.87893, 19.60567, 0>, 0.75 }
    object { Connector_1 scale <3.127114, 0.75, 0.75> rotate z*3.562859 translate <7.87893, 19.60567, 0> }
    sphere { <11, 19.8, 0>, 0.75 }
    object { Connector_1 scale <3.033688, 0.75, 0.75> rotate z*-14.605078 translate <11, 19.8, 0> }
    sphere { <13.93566, 19.03504, 0>, 0.75 }
    object { Connector_1 scale <2.94029, 0.75, 0.75> rotate z*-32.783792 translate <13.93566, 19.03504, 0> }
    sphere { <16.40762, 17.44296, 0>, 0.75 }
    object { Connector_1 scale <2.846929, 0.75, 0.75> rotate z*-50.974116 translate <16.40762, 17.44296, 0> }
    sphere { <18.20025, 15.23129, 0>, 0.75 }
    object { Connector_1 scale <2.753588, 0.75, 0.75> rotate z*-69.177477 translate <18.20025, 15.23129, 0> }
    sphere { <19.17908, 12.65755, 0>, 0.75 }
    object { Connector_1 scale <2.6603, 0.75, 0.75> rotate z*-87.394807 translate <19.17908, 12.65755, 0> }
    sphere { <19.3, 10, 0>, 0.75 }
    object { Connector_1 scale <2.567045, 0.75, 0.75> rotate z*-74.371707 rotate y*-180 translate <19.3, 10, 0> }
    sphere { <18.60845, 7.52786, 0>, 0.75 }
    object { Connector_1 scale <2.473829, 0.75, 0.75> rotate z*-56.120820 rotate y*-180 translate <18.60845, 7.52786, 0> }
    sphere { <17.22943, 5.47405, 0>, 0.75 }
    object { Connector_1 scale <2.380666, 0.75, 0.75> rotate z*-37.850055 rotate y*-180 translate <17.22943, 5.47405, 0> }
    sphere { <15.34961, 4.01328, 0>, 0.75 }
    object { Connector_1 scale <2.287572, 0.75, 0.75> rotate z*-19.557739 rotate y*-180 translate <15.34961, 4.01328, 0> }
    sphere { <13.19402, 3.2475, 0>, 0.75 }
    object { Connector_1 scale <2.194534, 0.75, 0.75> rotate z*-1.240246 rotate y*-180 translate <13.19402, 3.2475, 0> }
    sphere { <11, 3.2, 0>, 0.75 }
    object { Connector_1 scale <2.101574, 0.75, 0.75> rotate z*17.105495 rotate y*-180 translate <11, 3.2, 0> }
    sphere { <8.99139, 3.81814, 0>, 0.75 }
    object { Connector_1 scale <2.008693, 0.75, 0.75> rotate z*35.482701 rotate y*-180 translate <8.99139, 3.81814, 0> }
    sphere { <7.35573, 4.9841, 0>, 0.75 }
    object { Connector_1 scale <1.915906  0.75  0.75> rotate z*53.896838 rotate y*-180 translate <7.35573, 4.9841, 0> }
    sphere { <6.2268, 6.53207, 0>, 0.75 }
    object { Connector_1 scale <1.823235, 0.75, 0.75> rotate z*72.353224 rotate y*-180 translate <6.2268, 6.53207, 0> }
    sphere { <5.67409, 8.26951, 0>  0.75 }
    object { Connector_1 scale <1.730684, 0.75, 0.75> rotate z*89.142195 translate <5.67409, 8.26951, 0> }
    sphere { <5.7, 10, 0>, 0.75 }
    object { Connector_1 scale <1.638289, 0.75, 0.75> rotate z*70.579830 translate <5.7, 10, 0> }
    sphere { <6.24472, 11.54508, 0>, 0.75 }
    object { Connector_1 scale <1.546075, 0.75, 0.75> rotate z*51.951029 translate <6.24472, 11.54508, 0> }
    sphere { <7.19762, 12.76259, 0>, 0.75 }
    object { Connector_1 scale <1.454066, 0.75, 0.75> rotate z*33.241769 translate <7.19762, 12.76259, 0> }
    sphere { <8.41375, 13.55967, 0>, 0.75 }
    object { Connector_1 scale <1.362303, 0.75, 0.75> rotate z*14.437741 translate <8.41375, 13.55967, 0> }
    sphere { <9.73303, 13.89933, 0>, 0.75 }
    object { Connector_1 scale <1.270858, 0.75, 0.75> rotate z*-4.482799 translate <9.73303, 13.89933, 0> }
    sphere { <11, 13.8, 0>, 0.75 }
    object { Connector_1 scale <1.179790, 0.75, 0.75> rotate z*-23.546065 translate <11, 13.8, 0> }
    sphere { <12.08156, 13.32869, 0>, 0.75 }
    object { Connector_1 scale <1.089185, 0.75, 0.75> rotate z*-42.785865 translate <12.08156, 13.32869, 0> }
    sphere { <12.88091, 12.58885, 0>, 0.75 }
    object { Connector_1 scale <0.999199, 0.75, 0.75> rotate z*-62.250112 translate <12.88091, 12.58885, 0> }
    sphere { <13.34615, 11.70457, 0>, 0.75 }
    object { Connector_1 scale <0.909978, 0.75, 0.75> rotate z*-82.003464 translate <13.34615, 11.70457, 0> }
    sphere { <13.47274, 10.80344, 0>, 0.75 }
    object { Connector_1 scale <0.821800, 0.75, 0.75> rotate z*-77.866093 rotate y*-180 translate <13.47274, 10.80344, 0> }
    sphere { <13.3, 10, 0>, 0.75 }
  }
  texture { YourTexture }
  bounded_by { sphere { <9.65, 11.5, 0>, 15.187371 } }
 }

/*
#declare YourThing2 =
object {
  union { }
  texture { YourTexture }
  bounded_by { sphere { 0, 1.428942 } }
}
*/

#declare YourThing3 =
union {
  object { Connector_1 scale <24, 0.75, 0.75> rotate z*90 }
  sphere { y*24, 0.75 }
  texture { YourTexture }
  bounded_by { sphere { y*12, 14.073446 } }
}

/*
#declare YourThing4 =
object {
  union { }
  texture { YourTexture }
  bounded_by { sphere { y*13.75, 15.303941 } }
}
*/

#declare YourThing5 =
union {
  intersection {
    object { Connector_2 }
    plane { x, 1.390537 }
    plane { x, 0.695269 inverse }
    translate x*-0.695269
    scale <2.472066, 1, 1>
    translate x*0.28125
    rotate z*90
    translate y*24
  }
  sphere { y*26, 1.5 }
  texture { YourTexture }
  bounded_by { sphere { y*13.75, 15.303941 } }
}

#declare fence_section =
union {
  object { YourThing1 }
  //object { YourThing2 }
  object { YourThing3 }
  //object { YourThing4 }
  object { YourThing5 }
  bounded_by { sphere { <9.275, 13.375, 0>, 19.611684 } }
}

#declare h_rail =
object {
  Disk_X
  scale <200, 0.75, 0.75>
  texture { 
   pigment { color rgb <0.2, 0.2, 0.23> }
   finish { phong 1.0 ambient 0.15 }
 }
}

#declare fence1 =
union {
  object { fence_section translate 0 }
  object { fence_section translate x*20 }
  object { fence_section translate x*40 }
  object { fence_section translate x*60 }
  object { fence_section translate x*80 }
  object { fence_section translate x*-20 }
  object { fence_section translate x*-40 }
  object { fence_section translate x*-60 }
  object { fence_section translate x*-80 }
  object { h_rail translate <-100, 20, 0> }
  object { h_rail translate x*-100 }
  bounded_by { sphere { y*10.75, 115 } }
}