// Persistence of Vision Raytracer
//---------- The Dormer....Toys in the attic..4/4/92 m. Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "shapes_old.inc"
#include "textures.inc"

#declare DCone = /*---------CONE POINT DOWN /POINT at 000--------*/
intersection {
  object { QCone_Y scale 1 }
  plane { -y, 0 }
  plane {  y, 1 }
}

#include "dormc.inc"
#include "3turns.inc"
#include "fence1.inc"
#include "sky77.inc"
#include "jake.inc"
#include "body1.inc"

global_settings { max_trace_level 20 }

camera {
  location <0, 20, -300>
  direction z*1.5
  up y
  right x*image_width/image_height
  look_at y*60
}

//-------lights
light_source { <200, 600, -1200> colour White }
light_source { <-700, 1600, -2200> colour White }

//--------- sky
//object { TheOriginalWorld }  //sky77.inc
object { TheWorld }          //cyjack - worl77.inc
/*
object {
  sphere { 0, 20000 inverse
    texture {
      pigment { colour MidnightBlue }
      finish { ambient 1 diffuse 0 crand 0.03 }
    }
  }
}
*/

/*-------------------- DECLARED SHAPES ----------------------*/
#declare q1 = object { Cylinder_Z scale <8, 8, 1>  }
#declare q2 = object { Cylinder_Z scale <6, 6, 1>  }
#declare d1 = box { -1, 1 scale <2, 2.5, 6.5>  } //dentiles

#declare UCone = /*---------CONE POINT UP /POINT at 000--------*/
intersection {
  object { QCone_Y scale 1 }
  plane { y,  0 }
  plane { y, -1 inverse }
}

/*------------------- DECLARED TEXTURES --------------------
#declare tex1 = texture { pigment { colour Salmon } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex2 = texture { pigment { colour CadetBlue } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex3 = texture { pigment { colour Gold } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex4 = texture { pigment { colour Orchid } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex5 = texture { pigment { colour Red } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex6 = texture { pigment { colour Orange } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex7 = texture { pigment { colour DimGray } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex8 = texture { pigment { colour Green } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex9 = texture { pigment { colour Salmon } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex10 = texture { pigment { colour CadetBlue } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex11 = texture { pigment { colour Gold } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
#declare tex12 = texture { pigment { colour Orchid } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
*/

union {
  //--------- house roof
  
  object {
    difference {
      box { -1, 1 scale <200, 110, 1> rotate x*30 translate <-100, 62, 62> }
      box { -1, 1 scale <31, 45, 30> translate <0, 46, 53> }
      box { -1, 1 scale <31, 45, 30> translate <-120, 46, 53> }
    }
    texture {
      pigment { image_map { gif "roof2.original.gif" } }
      finish { ambient 0.2 crand 0.02 diffuse 0.6 phong 0.5 }
      scale <150, 220, 1>
      rotate x*30
      translate <-100, -50, -1>
    }
  }
  //--------- roof crown molding
  
  box { -1, 1
    scale <200, 5, 2.5>
    translate y*112
    rotate x*30
    translate <-100, 62, 62>
    texture { pigment { colour crust } finish { ambient 0.15 diffuse 0.4 phong 1.0 } }
  }
  
  //--------- flashing
  box { -1, 1
    scale <190, 10, 2.5>
    translate <-100, -40.01, 10>
    texture { pigment { colour crust } finish { ambient 0.15 diffuse 0.4 phong 1.0 } }
  }
  
  object { fence1 translate <0, 170, 120> }
  
  //----------- body section coming through dormer
  union {
    object { body1 translate x*-2 }
    object { body1 translate x*2 }
    rotate z*35
    translate <-100, -10, -10> 
  }
 
  rotate y*-38
}


//------------- add left and right dormer
#include "dormer_left.inc"
#include "dormer_right.inc"

//------------- add creatures
#include "jake.inc"
object { fish07 
  scale 1.8 
  rotate y*-110
  rotate x*-20
  translate <100, 110, 170>
}