// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//------------ body1

#declare Truman = colour rgb <0.556, 0.419, 0.137>;

#declare YourTexture2 = //texture { devil_2  }
//#declare devil_2 =
texture {
  pigment {
    marble
    turbulence 0.4
    colour_map {
      [0.000 0.139 colour rgbf <0.569, 0.486, 0.333, 0> colour rgbf <0.839, 0.576, 0.384, 0>]
      [0.139 0.296 colour rgbf <0.839, 0.576, 0.384, 0> colour rgbf <0.898, 0.733, 0.525, 0>]
      [0.296 0.426 colour rgbf <0.898, 0.733, 0.525, 0> colour rgbf <0.945, 0.851, 0.737, 0>]
      [0.426 0.670 colour rgbf <0.945, 0.851, 0.737, 0> colour rgbf <0.918, 0.761, 0.843, 0>]
      [0.670 0.783 colour rgbf <0.918, 0.761, 0.843, 0> colour rgbf <0.898, 0.604, 0.525, 0>]
      [0.783 0.878 colour rgbf <0.898, 0.604, 0.525, 0> colour rgbf <0.757, 0.518, 0.518, 0>]
      [0.878 0.983 colour rgbf <0.757, 0.518, 0.518, 0> colour rgbf <0.569, 0.486, 0.333, 0>]
      [0.983 1.001 colour rgbf <0.569, 0.486, 0.333, 0> colour rgbf <0.569, 0.486, 0.333, 0>]
    }
    scale <20, 20, 5>
  }
}
texture {
  pigment {
    gradient y
    color_map {
      [0.0 0.3 color Truman color Truman]
      [0.3 0.5 color Truman color Truman filter 0.7]
      [0.5 1.0 color Truman filter 0.7 color Truman ]
    }
  }
  finish { phong 1.0 ambient 0.2 phong_size 80 }
  scale <100, 60, 100>
  translate <-50, -30, 0>
}

#declare Dot = sphere { 0, 1 }
//quadric { 1, 0, 0, -1.0 }

#declare Connector_1 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane { x, 0 inverse }
  plane { x, 1}
}

#declare Connector_2 = 
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

/*----------------------------------------------------------------------------*/

#declare body1 =
union {
  sphere { <0,  0,         35>,       4       texture { YourTexture2 } }
  sphere { <0,  4.78082,   34.71327>, 4.14286 texture { YourTexture2 } }
  sphere { <0,  9.4931,    33.85719>, 4.28571 texture { YourTexture2 } }
  sphere { <0, 14.06928,   32.44403>, 4.42857 texture { YourTexture2 } }
  sphere { <0, 18.44376,   30.49405>, 4.57143 texture { YourTexture2 } }
  sphere { <0, 22.55382,   28.03521>, 4.71429 texture { YourTexture2 } }
  sphere { <0, 26.34053,   25.10276>, 4.85714 texture { YourTexture2 } }
  sphere { <0, 29.74962,   21.73874>, 5       texture { YourTexture2 } }
  sphere { <0, 32.73219,   17.99138>, 5.14286 texture { YourTexture2 } }
  sphere { <0, 35.2455,    13.9144>,  5.28571 texture { YourTexture2 } }
  sphere { <0, 37.25351,    9.56626>, 5.42857 texture { YourTexture2 } }
  sphere { <0, 38.72744,    5.00929>, 5.57143 texture { YourTexture2 } }
  sphere { <0, 39.64614,    0.30881>, 5.71428 texture { YourTexture2 } }
  sphere { <0, 39.99646,   -4.46777>, 5.85714 texture { YourTexture2 } }
  sphere { <0, 39.77337,   -9.25198>, 6       texture { YourTexture2 } }
  sphere { <0, 38.98006,  -13.97524>, 6.14286 texture { YourTexture2 } }
  sphere { <0, 37.62791,  -18.56982>, 6.28571 texture { YourTexture2 } }
  sphere { <0, 35.73632,  -22.96985>, 6.42857 texture { YourTexture2 } }
  sphere { <0, 33.33238,  -27.11227>, 6.57143 texture { YourTexture2 } }
  sphere { <0, 30.45058,  -30.93766>, 6.71428 texture { YourTexture2 } }
  sphere { <0, 27.13222,  -34.3912>,  6.85714 texture { YourTexture2 } }
  sphere { <0, 23.42487,  -37.42338>, 7       texture { YourTexture2 } }
  sphere { <0, 19.3817,   -39.99071>, 7.14286 texture { YourTexture2 } }
  sphere { <0, 15.06066,  -42.0564>,  7.28571 texture { YourTexture2 } }
  sphere { <0, 10.5237,   -43.59082>, 7.42857 texture { YourTexture2 } }
  sphere { <0,  5.83586,  -44.57199>, 7.57143 texture { YourTexture2 } }
  sphere { <0,  1.06437,  -44.98584>, 7.71428 texture { YourTexture2 } }
  sphere { <0, -3.72239,  -44.82642>, 7.85714 texture { YourTexture2 } }
  sphere { <0, -8.45578,  -44.09603>, 8       texture { YourTexture2 } }
  sphere { <0, -13.06795, -42.80514>, 8.14286 texture { YourTexture2 } }
  sphere { <0, -17.49277, -40.97226>, 8.28571 texture { YourTexture2 } }
  sphere { <0, -21.6668,  -38.62365>, 8.42857 texture { YourTexture2 } }
  sphere { <0, -25.5302,  -35.793>,   8.57143 texture { YourTexture2 } }
  sphere { <0, -29.02759, -32.52089>, 8.71429 texture { YourTexture2 } }
  sphere { <0, -32.10882, -28.85422>, 8.85714 texture { YourTexture2 } }
  sphere { <0, -34.72972, -24.84556>, 9       texture { YourTexture2 } }
  bounded_by { sphere { <0, 1.06194, -6.85006>, 71.199159 } }
/*
   Fudge factor:  10 percent 
   Maximum x coordinate:  9
           y coordinate:  45.8536
           z coordinate:  39
   Minimum x coordinate: -9
           y coordinate: -43.72972
           z coordinate: -52.700120
   Center  x coordinate:  0
           y coordinate:  1.06194
           z coordinate: -6.85006
*/
}