// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//-------------- 3 turns side by side

//------- turn texture {
#declare YourTexture =  
texture { 
  pigment { color warm_gold }
  finish { ambient 0.2 diffuse 0.7 phong 1 phong_size 70 crand 0.01 }
}

#declare Dot = sphere { 0, 1 }
//quadric { 1, 0, 0, -1.0 }

#declare Connector_1 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane { x, 0 inverse }
  plane { x, 1}
}

#declare Connector_2 = 
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

//------------- start turns
#declare turn441 =
object {
   union {
      sphere { 0, 2 translate z*5 }
      object {
         Connector_1
         scale <7, 2, 2>
         rotate z*90
         translate z*5
      }
      sphere { 0, 2 translate <0, 7, 5> }
      intersection {
         quadric { Connector_2 }
         plane { x, 1.999744 }
         plane { x, 1.971178 inverse }
         translate x*-1.999744
         scale <62.489923, 1, 1>
         translate x*-0.032001
         rotate y*180
         rotate z*79.714125
         rotate y*90
         translate <0, 7, 5>
      }
      sphere { 0, 1.97143 translate <0, 8.75687, 4.68117> }
      intersection {
         object { Connector_2 }
         plane { x, 1.971172 }
         plane { x, 1.942606 inverse }
         translate x*-1.971172
         scale <61.793135, 1, 1>
         translate x*-0.0319
         rotate y*180
         rotate z*54.577074
         rotate y*90
         translate <0, 8.75687, 4.68117>
      }
      sphere { 0, 1.94286 translate <0, 10.1957, 3.65778> }
      intersection {
         object { Connector_2 }
         plane { x, 1.942590 }
         plane { x, 1.914024 inverse }
         translate x*-1.94259
         scale <60.013457, 1, 1>
         translate x*-0.032369
         rotate y*180
         rotate z*33.869659
         rotate y*90
         translate <0, 10.1957, 3.65778>
      }
      sphere { 0, 1.91429 translate <0, 11.15138, 2.23395> }
      intersection {
         object { Connector_2 }
         plane { x, 1.914008 }
         plane { x, 1.885432 inverse }
         translate x*-1.914008
         scale <58.212967, 1, 1>
         translate x*-0.032879
         rotate y*180
         rotate z*13.154399
         rotate y*90
         translate <0, 11.15138, 2.23395>
      }
      sphere { 0, 1.88571 translate <0, 11.53006, 0.61364> }
      intersection {
         object { Connector_2 }
         plane { x, 1.885414 }
         plane { x, 1.856849 inverse }
         translate x*-1.885414
         scale <56.454224, 1, 1>
         translate x*-0.033397
         rotate y*180
         rotate z*-7.570281
         rotate y*90
         translate <0, 11.53006, 0.613640>
      }
      sphere { 0, 1.85714 translate <0, 11.31754, -0.98545> }
      intersection {
         object { Connector_2 }
         plane { x, 1.856829 }
         plane { x, 1.828264 inverse }
         translate x*-1.856829
         scale <54.675363, 1, 1>
         translate x*-0.033961
         rotate y*180
         rotate z*-28.304780
         rotate y*90
         translate <0, 11.31754, -0.98545>
      }
      sphere { 0, 1.82857 translate <0, 10.57674, -2.36099> }
      intersection {
         object { Connector_2 }
         plane { x, 1.828243 }
         plane { x, 1.799678 inverse }
         translate x*-1.828243
         scale <52.896553, 1, 1>
         translate x*-0.034563
         rotate y*180
         rotate z*-49.050173
         rotate y*90
         translate <0, 10.57674, -2.36099>
      }
      sphere { 0, 1.8 translate <0, 9.43511, -3.35164> }
      intersection {
         object { Connector_2 }
         plane { x, 1.799656 }
         plane { x, 1.771091 inverse }
         translate x*-1.799656
         scale <51.118649, 1, 1>
         translate x*-0.035205
         rotate y*180
         rotate z*-69.807549
         rotate y*90
         translate <0, 9.43511, -3.35164>
      }
      sphere { 0, 1.77143 translate <0, 8.06415, -3.85585> }
      intersection {
         object { Connector_2 }
         plane { x, 1.771066 }
         plane { x, 1.742502 inverse }
         translate x*-1.771066
         scale <49.341348, 1, 1>
         translate x*-0.035894
         rotate y*180
         rotate z*-89.421738
         rotate y*-90
         translate <0, 8.06415, -3.85585>
      }
      sphere { 0, 1.74286 translate <0, 6.65425, -3.84162> }
      intersection {
         object { Connector_2 }
         plane { x, 1.742475 }
         plane { x, 1.713911 inverse }
         translate x*-1.742475
         scale <47.564628, 1, 1>
         translate x*-0.036634
         rotate y*180
         rotate z*-68.635693
         rotate y*-90
         translate <0, 6.65425, -3.84162>
      }
      sphere { 0, 1.71429 translate <0, 5.38843, -3.34646> }
      intersection {
         object { Connector_2 }
         plane { x, 1.713881 }
         plane { x, 1.685308 inverse }
         translate x*-1.713881
         scale <45.772425, 1, 1>
         translate x*-0.037444
         rotate y*180
         rotate z*-47.832997
         rotate y*-90
         translate <0, 5.38843, -3.34646>
      }
      sphere { 0, 1.68571 translate <0, 4.41859, -2.46808> }
      intersection {
         object { Connector_2 }
         plane { x, 1.685275 }
         plane { x, 1.656712 inverse }
         translate x*-1.685275
         scale <44.013206, 1, 1>
         translate x*-0.03829
         rotate y*180
         rotate z*-27.012220
         rotate y*-90
         translate <0, 4.41859, -2.46808>
      }
      sphere { 0, 1.65714 translate <0, 3.84733, -1.34751> }
      intersection {
         object { Connector_2 }
         plane { x, 1.656676 }
         plane { x, 1.628114 inverse }
         translate x*-1.656676
         scale <42.238517, 1, 1>
         translate x*-0.039222
         rotate y*180
         rotate z*-6.17015
         rotate y*-90
         translate <0, 3.84733, -1.34751>
      }
      sphere { 0, 1.62857 translate <0, 3.71759, -0.14741> }
      intersection {
         object { Connector_2 }
         plane { x, 1.628073 }
         plane { x, 1.599512 inverse }
         translate x*-1.628073
         scale <40.465082, 1, 1>
         translate x*-0.040234
         rotate y*180
         rotate z*14.695599
         rotate y*-90
         translate <0, 3.71759, -0.14741>
      }
      sphere { 0, 1.6 translate <0, 4.01096, 0.9712> }
      intersection {
         object { Connector_2 }
         plane { x, 1.599466 }
         plane { x, 1.570905 inverse }
         translate x*-1.599466
         scale <38.692595, 1, 1>
         translate x*-0.041338
         rotate y*180
         rotate z*35.588453
         rotate y*-90
         translate <0, 4.01096, 0.9712>
      }
      sphere { 0, 1.57143 translate <0, 4.6545, 1.87047> }
      intersection {
         object { Connector_2 }
         plane { x, 1.570854 }
         plane { x, 1.542294 inverse }
         translate x*-1.570854
         scale <36.921627, 1, 1>
         translate x*-0.042546
         rotate y*180
         rotate z*56.512027
         rotate y*-90
         translate <0, 4.6545, 1.87047>
      }
      sphere { 0, 1.54286 translate <0, 5.53457, 2.45271> }
      intersection {
         object { Connector_2 }
         plane { x, 1.542236 }
         plane { x, 1.513667 inverse }
         translate x*-1.542236
         scale <35.139970, 1, 1>
         translate x*-0.043888
         rotate y*180
         rotate z*77.470697
         rotate y*-90
         translate <0, 5.53457, 2.45271>
      }
      sphere { 0, 1.51428 translate <0, 6.51535, 2.67067> }
      intersection {
         object { Connector_2 }
         plane { x, 1.513601 }
         plane { x, 1.485044 inverse }
         translate x*-1.513601
         scale <33.384025, 1, 1>
         translate x*-0.045339
         rotate y*180
         rotate z*81.529209
         rotate y*90
         translate <0, 6.51535, 2.67067>
      }
      sphere { 0, 1.48571 translate <0, 7.45915, 2.53011> }
      intersection {
         object { Connector_2 }
         plane { x, 1.484967 }
         plane { x, 1.456412 inverse }
         translate x*-1.484967
         scale <31.617939, 1, 1>
         translate x*-0.046966
         rotate y*180
         rotate z*60.481111
         rotate y*90
         translate <0, 7.45915, 2.53011>
      }
      sphere { 0, 1.45714 translate <0, 8.24561, 2.08481> }
      intersection {
         object { Connector_2 }
         plane { x, 1.456323 }
         plane { x, 1.427769 inverse }
         translate x*-1.456323
         scale <29.854689, 1, 1>
         translate x*-0.048780
         rotate y*180
         rotate z*39.376889
         rotate y*90
         translate <0, 8.24561, 2.08481>
      }
      sphere { 0, 1.42857 translate <0, 8.78704, 1.42512> }
      intersection {
         object { Connector_2 }
         plane { x, 1.427666 }
         plane { x, 1.399114 inverse }
         translate x*-1.427666
         scale <28.093829, 1, 1>
         translate x*-0.050818
         rotate y*180
         rotate z*18.206648
         rotate y*90
         translate <0, 8.78704, 1.42512>
      }
      sphere { 0, 1.4 translate <0, 9.03798, 0.66218> }
      intersection {
         object { Connector_2 }
         plane { x, 1.398992 }
         plane { x, 1.370442 inverse }
         translate x*-1.398992
         scale <26.336383, 1, 1>
         translate x*-0.053120
         rotate y*180
         rotate z*-3.044382
         rotate y*90
         translate <0, 9.03798, 0.66218>
      }
      sphere { 0, 1.37143 translate <0, 8.99799, -0.08973> }
      intersection {
         object { Connector_2 }
         plane { x, 1.370297 }
         plane { x, 1.341750 inverse }
         translate x*-1.370297
         scale <24.582835, 1, 1>
         translate x*-0.055742
         rotate y*180
         rotate z*-24.392281
         rotate y*90
         translate <0, 8.99799, -0.08973>
      }
      sphere { 0, 1.34286 translate <0, 8.7077, -0.7299> }
      intersection {
         object { Connector_2 }
         plane { x, 1.341573 }
         plane { x, 1.313021 inverse }
         translate x*-1.341573
         scale <22.826803, 1, 1>
         translate x*-0.058772
         rotate y*180
         rotate z*-45.858690
         rotate y*90
         translate <0, 8.7077, -0.7299>
      }
      sphere { 0, 1.31428 translate <0, 8.23908, -1.18468> }
      intersection {
         object { Connector_2 }
         plane { x, 1.312805 }
         plane { x, 1.284267 inverse }
         translate x*-1.312805
         scale <21.092542, 1, 1>
         translate x*-0.062240
         rotate y*180
         rotate z*-67.473208
         rotate y*90
         translate <0, 8.23908, -1.18468,>
      }
      sphere { 0, 1.28571 translate <0, 7.68182, -1.41581> }
      intersection {
         object { Connector_2 }
         plane { x, 1.283998 }
         plane { x, 1.255466 inverse }
         translate x*-1.283998
         scale <19.358311, 1, 1>
         translate x*-0.066328
         rotate y*180
         rotate z*-89.274736
         rotate y*90
         translate <0, 7.68182, -1.41581>
      }
      sphere { 0, 1.25714 translate <0, 7.12806, -1.42282> }
      intersection {
         object { Connector_2 }
         plane { x, 1.255124 }
         plane { x, 1.226599 inverse }
         translate x*-1.255124
         scale <17.634679, 1, 1>
         translate x*-0.071174
         rotate y*180
         rotate z*-68.683945
         rotate y*-90
         translate <0, 7.12806, -1.42282>
      }
      sphere { 0, 1.22857 translate <0, 6.65795, -1.23938> }
      intersection {
         object { Connector_2 }
         plane { x, 1.226155 }
         plane { x, 1.197641 inverse }
         translate x*-1.226155
         scale <15.924265, 1, 1>
         translate x*-0.076999
         rotate y*180
         rotate z*-46.326145
         rotate y*-90
         translate <0, 6.65795, -1.23938>
      }
      sphere { 0, 1.2 translate <0, 6.32824, -0.92459> }
      intersection {
         object { Connector_2 }
         plane { x, 1.197049 }
         plane { x, 1.168549 inverse }
         translate x*-1.197049
         scale <14.232207, 1, 1>
         translate x*-0.084108
         rotate y*180
         rotate z*-23.541889
         rotate y*-90
         translate <0, 6.32824, -0.92459>
      }
      sphere { 0, 1.17143 translate <0, 6.16543, -0.5509> }
      intersection {
         object { Connector_2 }
         plane { x, 1.167739 }
         plane { x, 1.139259 inverse }
         translate x*-1.167739
         scale <12.566913, 1, 1>
         translate x*-0.092922
         rotate y*180
         rotate z*-0.171806
         rotate y*-90
         translate <0, 6.16543, -0.5509>
      }
      sphere { 0, 1.14286 translate <0, 6.16435, -0.19073> }
      intersection {
         object { Connector_2 }
         plane { x, 1.138111 }
         plane { x, 1.109650 inverse }
         translate x*-1.138111
         scale <10.934933, 1, 1>
         translate x*-0.104080
         rotate y*180
         rotate z*24.037195
         rotate y*-90
         translate <0, 6.16435, -0.19073>
      }
      sphere { 0, 1.11428 translate <0, 6.29218, 0.09588> }
      intersection {
         object { Connector_2 }
         plane { x, 1.107986 }
         plane { x, 1.079577 inverse }
         translate x*-1.107986
         scale <9.368649, 1, 1>
         translate x*-0.118265
         rotate y*180
         rotate z*49.477663
         rotate y*-90
         translate <0, 6.29218, 0.09588>
      }
      sphere { 0, 1.08571 translate <0, 6.4968, 0.27078> }
      intersection {
         object { Connector_2 }
         plane { x, 1.077096 }
         plane { x, 1.048752 inverse }
         translate x*-1.077096
         scale <7.891117, 1, 1>
         translate x*-0.136495
         rotate y*180
         rotate z*76.780124
         rotate y*-90
         translate <0, 6.4968, 0.27078>
      }
      sphere { 0, 1.05714 translate <0, 6.71803, 0.32275>
      }
      intersection {
         object { Connector_2 }
         plane { x, 1.045095 }
         plane { x, 1.016850 inverse }
         translate x*-1.045095
         scale <6.567621, 1, 1>
         translate x*-0.159128
         rotate y*180
         rotate z*73.076379
         rotate y*90
         translate <0, 6.71803, 0.32275>
      }
      sphere { 0, 1.02857 translate <0, 6.89961, 0.2675> }
      intersection {
         object { Connector_2 }
         plane { x, 1.012048 }
         plane { x, 0.983937 inverse }
         translate x*-1.012048
         scale <5.511752, 1, 1>
         translate x*-0.183616
         rotate y*180
         rotate z*38.849347
         rotate y*90
         translate <0, 6.89961, 0.2675>
      }
      sphere { 0, 1 translate <0, 7, 0.14286>
      }
   }
   texture { YourTexture }
   bounded_by { sphere { 0, 11.178595 translate <0, 5.707885, 0.68636> } }
 }

/*
#declare turn442 =
object {
  union { }
  texture { YourTexture }
  bounded_by { sphere { 0, 4.95 translate <2, 0, 3.5> } }
}
*/

#declare turn443 =
object {
   union {
      intersection {
         object { Connector_2 }
         plane { x, 1.986901 }
         plane { x, 0.993450 inverse }
         translate x*-0.993450
         scale <8.694355, 1, 1>
         translate x*0.114264
         rotate z*-53.115487
         rotate y*-67.619853
         translate <0, 7, 0.14286>
      }
      sphere { 0, 2 translate <2, 0, 5> }
      object {
         Connector_1
         scale <7, 2, 2>
         rotate z*90
         translate <2, 0, 5>
      }
      sphere { 0, 2 translate <2, 7, 5> }
      intersection {
         object { Connector_2 }
         plane { x, 1.999745 }
         plane { x, 1.974748 inverse }
         translate x*-1.999745
         scale <62.565615, 1, 1>
         translate x*-0.031962
         rotate y*180
         rotate z*80.999878
         rotate y*90
         translate <2, 7, 5>
      }
      sphere { 0, 1.975 translate <2, 8.54508, 4.75528> }
      intersection {
         object { Connector_2 }
         plane { x, 1.974744 }
         plane { x, 1.949747 inverse }
         translate x*-1.974744
         scale <62.066108, 1, 1>
         translate x*-0.031817
         rotate y*180
         rotate z*59.351003
         rotate y*90
         translate < 2  8.545080  4.755280>
      }
      sphere { 0, 1.95 translate <2, 9.88015, 3.96418> }
      intersection {
         object { Connector_2 }
         plane { x, 1.949736 }
         plane { x, 1.924740 inverse }
         translate x*-1.949736
         scale <60.816570, 1, 1>
         translate x*-0.032059
         rotate y*180
         rotate z*41.275851
         rotate y*90
         translate <2, 9.88015, 3.96418>
      }
      sphere { 0, 1.925 translate <2, 10.88328, 2.82137> }
      intersection {
         object { Connector_2 }
         plane { x, 1.924729 }
         plane { x, 1.899732 inverse }
         translate x*-1.924729
         scale <59.567962, 1, 1>
         translate x*-0.032311
         rotate y*180
         rotate z*23.197883
         rotate y*90
         translate <2, 10.88328, 2.82137>
      }
      sphere { 0, 1.9 translate <2, 11.46997, 1.45238> }
      intersection {
         object { Connector_2 }
         plane { x, 1.899721 }
         plane { x, 1.874724 inverse }
         translate x*-1.899721
         scale <58.318991, 1, 1>
         translate x*-0.032575
         rotate y*180
         rotate z*5.115989
         rotate y*90
         translate <2, 11.46997, 1.45238>
      }
      sphere { 0, 1.875 translate <2, 11.6, 0> }
      intersection {
         object { Connector_2 }
         plane { x, 1.874712 }
         plane { x, 1.849716 inverse }
         translate x*-1.874712
         scale <57.070452, 1, 1>
         translate x*-0.032849
         rotate y*180
         rotate z*-12.969066
         rotate y*90
         translate <2, 11.6, 0>
      }
      sphere { 0, 1.85 translate <2, 11.27975, -1.39058> }
      intersection {
         object { Connector_2 }
         plane { x, 1.849703 }
         plane { x, 1.824707 inverse }
         translate x*-1.849703
         scale <55.821522, 1, 1>
         translate x*-0.033136
         rotate y*180
         rotate z*-31.057459
         rotate y*90
         translate <2, 11.27975, -1.39058>
      }
      sphere { 0, 1.825 translate <2, 10.55968, -2.58626> }
      intersection {
         object { Connector_2 }
         plane { x, 1.824694 }
         plane { x, 1.799698 inverse }
         translate x*-1.824694
         scale <54.573047, 1, 1>
         translate x*-0.033436
         rotate y*180
         rotate z*-49.151087
         rotate y*90
         translate <2, 10.55968, -2.58626>
      }
      sphere { 0, 1.8 translate <2, 9.52748, -3.47877> }
      intersection {
         object { Connector_2 }
         plane { x, 1.799684 }
         plane { x, 1.774688 inverse }
         translate x*-1.799684
         scale <53.325136, 1, 1>
         translate x*-0.033749
         rotate y*180
         rotate z*-67.247950
         rotate y*90
         translate <2, 9.52748, -3.47877>
      }
      sphere { 0, 1.775 translate <2, 8.29787, -3.99444> }
      intersection {
         object { Connector_2 }
         plane { x, 1.774673 }
         plane { x, 1.749677 inverse }
         translate x*-1.774673
         scale <52.076627, 1, 1>
         translate x*-0.034078
         rotate y*180
         rotate z*-85.350182
         rotate y*90
         translate <2, 8.29787, -3.99444>
      }
      sphere { 0, 1.75 translate <2, 7, -4.1> }
      intersection {
         object { Connector_2 }
         plane { x, 1.749661 }
         plane { x, 1.724666 inverse }
         translate x*-1.749661
         scale <50.828715, 1, 1>
         translate x*-0.034423
         rotate y*180
         rotate z*-76.543140
         rotate y*-90
         translate <2, 7, -4.1>
      }
      sphere { 0, 1.725 translate <2, 5.76393, -3.80423> }
      intersection {
         object { Connector_2 }
         plane { x, 1.724649 }
         plane { x, 1.699654 inverse }
         translate x*-1.724649
         scale <49.580681, 1, 1>
         translate x*-0.034785
         rotate y*180
         rotate z*-58.430464
         rotate y*-90
         translate <2, 5.76393, -3.80423>
      }
      sphere { 0, 1.7 translate <2, 4.70764, -3.15517> }
      intersection {
         object { Connector_2 }
         plane { x, 1.699636 }
         plane { x, 1.674642 inverse }
         translate x*-1.699636
         scale <48.333614, 1, 1>
         translate x*-0.035165
         rotate y*180
         rotate z*-40.312468
         rotate y*-90
         translate <2, 4.70764, -3.15517>
      }
      sphere { 0, 1.675 translate <2, 3.92573, -2.23358>
      }
      intersection {
         object { Connector_2 }
         plane { x, 1.674622 }
         plane { x, 1.649628 inverse }
         translate x*-1.674622
         scale <47.085614, 1, 1>
         translate x*-0.035565
         rotate y*180
         rotate z*-22.187811
         rotate y*-90
         translate <2, 3.92573, -2.23358>
      }
      sphere { 0, 1.65 translate <2, 3.48109, -1.14336> }
      intersection {
         object { Connector_2 }
         plane { x, 1.649607 }
         plane { x, 1.624613 inverse }
         translate x*-1.649607
         scale <45.838371, 1, 1>
         translate x*-0.035987
         rotate y*180
         rotate z*-4.05677
         rotate y*-90
         translate <2, 3.48109, -1.14336>
      }
      sphere { 0, 1.625 translate <2, 3.4, 0> }
      intersection {
         object { Connector_2 }
         plane { x, 1.624592 }
         plane { x, 1.599598 inverse }
         translate x*-1.624592
         scale <44.591492, 1, 1>
         translate x*-0.036433
         rotate y*180
         rotate z*14.081606
         rotate y*-90
         translate <2, 3.4, 0>
      }
      sphere { 0, 1.6 translate <2, 3.6713, 1.08156> }
      intersection {
         object { Connector_2 }
         plane { x, 1.599574 }
         plane { x, 1.574581 inverse }
         translate x*-1.599574
         scale <43.344743, 1, 1>
         translate x*-0.036904
         rotate y*180
         rotate z*32.228223
         rotate y*-90
         translate <2, 3.6713, 1.08156>
      }
      sphere { 0, 1.575 translate <2, 4.24934, 1.99847> }
      intersection {
         object { Connector_2 }
         plane { x, 1.574556 }
         plane { x, 1.549563 inverse }
         translate x*-1.574556
         scale <42.098506, 1, 1>
         translate x*-0.037402
         rotate y*180
         rotate z*50.383341
         rotate y*-90
         translate <2, 4.24934, 1.99847>
      }
      sphere { 0, 1.55 translate <2, 5.06031, 2.66976> }
      intersection {
         object { Connector_2 }
         plane { x, 1.549536 }
         plane { x, 1.524543 inverse }
         translate x*-1.549536
         scale <40.852194, 1, 1>
         translate x*-0.037930
         rotate y*180
         rotate z*68.548311
         rotate y*-90
         translate <2, 5.06031, 2.66976>
      }
      sphere { 0, 1.525 translate <2, 6.01115, 3.04338> }
      intersection {
         object { Connector_2 }
         plane { x, 1.524514 }
         plane { x, 1.499522 inverse }
         translate x*-1.524514
         scale <39.606164, 1, 1>
         translate x*-0.038492
         rotate y*180
         rotate z*86.722912
         rotate y*-90
         translate <2, 6.01115, 3.04338>
      }
      sphere { 0, 1.5 translate <2, 7, 3.1>
      }
   }
   texture { YourTexture }
   bounded_by { sphere { 0, 11.279669 translate <2, 5.7375, 0.575> } }
 }

/*
#declare turn444 =
object {
  union { }
  texture { YourTexture }
  bounded_by { sphere { 0, 5.527432 translate <3, 0, 3.5> } }
}
*/

#declare turn445 =
object {
   union {
      intersection {
         object { Connector_2 }
         plane { x, 1.995579 }
         plane { x, 1.496684 inverse }
         translate x*-1.496684
         scale <15.014660, 1, 1>
         translate x*0.099682
         rotate z*-68.491147
         rotate y*-43.531199
         translate <2, 7, 3.1>
      }
      sphere { 0, 2 translate <4, 0, 5> }
      object {
         Connector_1
         scale <7, 2, 2>
         rotate z*90
         translate <4, 0, 5>
      }
      sphere { 0, 2 translate <4, 7, 5>
      }
      intersection {
         object { Connector_2 }
         plane { x, 1.999745 }
         plane { x, 1.974748 inverse }
         translate x*-1.999745
         scale <62.565615, 1, 1>
         translate x*-0.031962
         rotate y*180
         rotate z*80.999878
         rotate y*90
         translate <4, 7, 5>
      }
      sphere { 0, 1.975 translate <4, 8.54508, 4.75528> }
      intersection {
         object { Connector_2 }
         plane { x, 1.974744 }
         plane { x, 1.949747 inverse }
         translate x*-1.974744
         scale <62.066108, 1, 1>
         translate x*-0.031817
         rotate y*180
         rotate z*59.351003
         rotate y*90
         translate <4, 8.54508, 4.75528>
      }
      sphere { 0, 1.95 translate <4, 9.88015, 3.96418> }
      intersection {
         object { Connector_2 }
         plane { x, 1.949736 }
         plane { x, 1.924740 inverse }
         translate x*-1.949736
         scale <60.816570, 1, 1>
         translate x*-0.032059
         rotate y*180
         rotate z*41.275851
         rotate y*90
         translate <4, 9.88015, 3.96418>
      }
      sphere { 0, 1.925 translate <4, 10.88328, 2.82137> }
      intersection {
         object { Connector_2 }
         plane { x, 1.924729 }
         plane { x, 1.899732 inverse }
         translate x*-1.924729
         scale <59.567962, 1, 1>
         translate x*-0.032311
         rotate y*180
         rotate z*23.197883
         rotate y*90
         translate <4, 10.88328, 2.82137>
      }
      sphere { 0, 1.9 translate <4, 11.46997, 1.452380> }
      intersection {
         object { Connector_2 }
         plane { x, 1.899721 }
         plane { x, 1.874724 inverse }
         translate x*-1.899721
         scale <58.318991, 1, 1>
         translate x*-0.032575
         rotate y*180
         rotate z*5.115989
         rotate y*90
         translate <4, 11.46997, 1.45238>
      }
      sphere { 0, 1.875 translate <4, 11.6, 0> }
      intersection {
         object { Connector_2 }
         plane { x, 1.874712 }
         plane { x, 1.849716 inverse }
         translate x*-1.874712
         scale <57.070452, 1, 1>
         translate x*-0.032849
         rotate y*180
         rotate z*-12.969066
         rotate y*90
         translate <4, 11.6, 0>
      }
      sphere { 0, 1.85 translate <4, 11.27975, -1.39058> }
      intersection {
         object { Connector_2 }
         plane { x, 1.849703 }
         plane { x, 1.824707 inverse }
         translate x*-1.849703
         scale <55.821522, 1, 1>
         translate x*-0.033136
         rotate y*180
         rotate z*-31.057459
         rotate y*90
         translate <4, 11.27975, -1.39058>
      }
      sphere { 0, 1.825 translate <4, 10.55968, -2.58626> }
      intersection {
         object { Connector_2 }
         plane { x, 1.824694 }
         plane { x, 1.799698 inverse }
         translate x*-1.824694
         scale <54.573047, 1, 1>
         translate x*-0.033436
         rotate y*180
         rotate z*-49.151087
         rotate y*90
         translate <4, 10.55968, -2.58626>
      }
      sphere { 0, 1.8 translate <4, 9.52748, -3.47877> }
      intersection {
         object { Connector_2 }
         plane { x, 1.799684 }
         plane { x, 1.774688 inverse }
         translate x*-1.799684
         scale <53.325136, 1, 1>
         translate x*-0.033749
         rotate y*180
         rotate z*-67.247950
         rotate y*90
         translate <4, 9.52748, -3.47877>
      }
      sphere { 0, 1.775 translate <4, 8.29787, -3.99444> }
      intersection {
         object { Connector_2 }
         plane { x, 1.774673 }
         plane { x, 1.749677 inverse }
         translate x*-1.774673
         scale <52.076627, 1, 1>
         translate x*-0.034078
         rotate y*180
         rotate z*-85.350182
         rotate y*90
         translate <4, 8.29787, -3.99444>
      }
      sphere { 0, 1.75 translate <4, 7, -4.1> }
      intersection {
         object { Connector_2 }
         plane { x, 1.749661 }
         plane { x, 1.724666 inverse }
         translate x*-1.749661
         scale <50.828715, 1, 1>
         translate x*-0.034423
         rotate y*180
         rotate z*-76.543140
         rotate y*-90
         translate <4, 7, -4.1>
      }
      sphere { 0, 1.725 translate <4, 5.76393, -3.80423> }
      intersection {
         object { Connector_2 }
         plane { x, 1.724649 }
         plane { x, 1.699654 inverse }
         translate x*-1.724649
         scale <49.580681, 1, 1>
         translate x*-0.034785
         rotate y*180
         rotate z*-58.430464
         rotate y*-90
         translate <4, 5.76393, -3.80423>
      }
      sphere { 0, 1.7 translate <4, 4.70764, -3.15517> }
      intersection {
         object { Connector_2 }
         plane { x, 1.699636 }
         plane { x, 1.674642 inverse }
         translate x*-1.699636
         scale <48.333614, 1, 1>
         translate x*-0.035165
         rotate y*180
         rotate z*-40.312468
         rotate y*-90
         translate <4, 4.70764, -3.15517>
      }
      sphere { 0, 1.675 translate <4, 3.92573, -2.23358> }
      intersection {
         object { Connector_2 }
         plane { x, 1.674622 }
         plane { x, 1.649628 inverse }
         translate x*-1.674622
         scale <47.085614, 1, 1>
         translate x*-0.035565
         rotate y*180
         rotate z*-22.187811
         rotate y*-90
         translate <4, 3.92573, -2.23358>
      }
      sphere { 0, 1.65 translate <4, 3.48109, -1.14336> }
      intersection {
         object { Connector_2 }
         plane { x, 1.649607 }
         plane { x, 1.624613 inverse }
         translate x*-1.649607
         scale <45.838371, 1, 1>
         translate x*-0.035987
         rotate y*180
         rotate z*-4.056770
         rotate y*-90
         translate <4, 3.48109, -1.14336>
      }
      sphere { 0, 1.625 translate <4, 3.4, 0>
      }
      intersection {
         object { Connector_2 }
         plane { x, 1.624592 }
         plane { x, 1.599598 inverse }
         translate x*-1.624592
         scale <44.591492, 1, 1>
         translate x*-0.036433
         rotate y*180
         rotate z*14.081606
         rotate y*-90
         translate <4, 3.4, 0>
      }
      sphere { 0, 1.6 translate <4, 3.6713, 1.08156> }
      intersection {
         object { Connector_2 }
         plane { x, 1.599574 }
         plane { x, 1.574581 inverse }
         translate x*-1.599574
         scale <43.344743, 1, 1>
         translate x*-0.036904
         rotate y*180
         rotate z*32.228223
         rotate y*-90
         translate <4, 3.6713, 1.08156>
      }
      sphere { 0, 1.575 translate <4, 4.24934, 1.99847>
      }
      intersection {
         object { Connector_2 }
         plane { x, 1.574556 }
         plane { x, 1.549563 inverse }
         translate x*-1.574556
         scale <42.098506, 1, 1>
         translate x*-0.037402
         rotate y*180
         rotate z*50.383341
         rotate y*-90
         translate <4, 4.24934, 1.99847>
      }
      sphere { 0, 1.55 translate <4, 5.06031, 2.66976> }
      intersection {
         object { Connector_2 }
         plane { x, 1.549536 }
         plane { x, 1.524543 inverse }
         translate x*-1.549536
         scale <40.852194, 1, 1>
         translate x*-0.037930
         rotate y*180
         rotate z*68.548311
         rotate y*-90
         translate <4, 5.06031, 2.66976>
      }
      sphere { 0, 1.525 translate <4, 6.01115, 3.04338>
      }
      intersection {
         object { Connector_2 }
         plane { x, 1.524514 }
         plane { x, 1.499522 inverse }
         translate x*-1.524514
         scale <39.606164, 1, 1>
         translate x*-0.038492
         rotate y*180
         rotate z*86.722912
         rotate y*-90
         translate <4, 6.01115, 3.043380>
      }
      sphere { 0, 1.5 translate <4, 7, 3.1>
      }
   }
   texture { YourTexture }
   bounded_by { sphere { 0, 11.544736 translate <3, 5.7375, 0.575> } }
 }

#declare turns =
union {
  object { turn441 }
  //object { turn442 }
  object { turn443 }
  //object { turn444 }
  object { turn445 }
  bounded_by { sphere { 0, 11.90592 translate <2, 5.7375, 0.575> } }
}