// Persistence of Vision Raytracer

#declare YourTexture =
texture {  color red 0.2 green 0.2 blue 0.23 
phong 1.0 ambient 0.15
 }

#declare Dot =             
quadric {
   < 1.0  1.0  1.0>
   < 0.0  0.0  0.0>
   < 0.0  0.0  0.0>
    -1.0
 }

#declare Connector_1 =  
intersection {
   quadric {
      < 0.0  1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
       -1.0
    }
   plane { < 1.0  0.0  0.0> 0.0 inverse  }
   plane { < 1.0  0.0  0.0> 1.0          }
 }

#declare Connector_2 =       /*used to connect points with unequal radii*/ 
quadric {
   < 1.0 -1.0  1.0>
   < 0.0  0.0  0.0>
   < 0.0  0.0  0.0>
     0.0
   rotate < 0.0  0.0  90.0>
 }

#declare YourThing1 =
object {
   union {
      sphere { < 0.000000  10.000000  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 3.441562  0.750000  0.750000>
         rotate    < 0.000000  0.000000  80.999980>
         translate < 0.000000  10.000000  0.000000>
       }
      sphere { < 0.538380  13.399190  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 3.407531  0.750000  0.750000>
         rotate    < 0.000000  0.000000  58.011424>
         translate < 0.538380  13.399190  0.000000>
       }
      sphere { < 2.343520  16.289300  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 3.314040  0.750000  0.750000>
         rotate    < 0.000000  0.000000  39.870496>
         translate < 2.343520  16.289300  0.000000>
       }
      sphere { < 4.887030  18.413780  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 3.220569  0.750000  0.750000>
         rotate    < 0.000000  0.000000  21.720966>
         translate < 4.887030  18.413780  0.000000>
       }
      sphere { < 7.878930  19.605670  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 3.127114  0.750000  0.750000>
         rotate    < 0.000000  0.000000  3.562859>
         translate < 7.878930  19.605670  0.000000>
       }
      sphere { < 11.000000  19.800000  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 3.033688  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -14.605078>
         translate < 11.000000  19.800000  0.000000>
       }
      sphere { < 13.935660  19.035040  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.940290  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -32.783792>
         translate < 13.935660  19.035040  0.000000>
       }
      sphere { < 16.407620  17.442960  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.846929  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -50.974116>
         translate < 16.407620  17.442960  0.000000>
       }
      sphere { < 18.200250  15.231290  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.753588  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -69.177477>
         translate < 18.200250  15.231290  0.000000>
       }
      sphere { < 19.179080  12.657550  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.660300  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -87.394807>
         translate < 19.179080  12.657550  0.000000>
       }
      sphere { < 19.300000  10.000000  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.567045  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -74.371707>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 19.300000  10.000000  0.000000>
       }
      sphere { < 18.608450  7.527860  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.473829  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -56.120820>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 18.608450  7.527860  0.000000>
       }
      sphere { < 17.229430  5.474050  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.380666  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -37.850055>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 17.229430  5.474050  0.000000>
       }
      sphere { < 15.349610  4.013280  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.287572  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -19.557739>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 15.349610  4.013280  0.000000>
       }
      sphere { < 13.194020  3.247500  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.194534  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -1.240246>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 13.194020  3.247500  0.000000>
       }
      sphere { < 11.000000  3.200000  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.101574  0.750000  0.750000>
         rotate    < 0.000000  0.000000  17.105495>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 11.000000  3.200000  0.000000>
       }
      sphere { < 8.991390  3.818140  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 2.008693  0.750000  0.750000>
         rotate    < 0.000000  0.000000  35.482701>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 8.991390  3.818140  0.000000>
       }
      sphere { < 7.355730  4.984100  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.915906  0.750000  0.750000>
         rotate    < 0.000000  0.000000  53.896838>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 7.355730  4.984100  0.000000>
       }
      sphere { < 6.226800  6.532070  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.823235  0.750000  0.750000>
         rotate    < 0.000000  0.000000  72.353224>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 6.226800  6.532070  0.000000>
       }
      sphere { < 5.674090  8.269510  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.730684  0.750000  0.750000>
         rotate    < 0.000000  0.000000  89.142195>
         translate < 5.674090  8.269510  0.000000>
       }
      sphere { < 5.700000  10.000000  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.638289  0.750000  0.750000>
         rotate    < 0.000000  0.000000  70.579830>
         translate < 5.700000  10.000000  0.000000>
       }
      sphere { < 6.244720  11.545080  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.546075  0.750000  0.750000>
         rotate    < 0.000000  0.000000  51.951029>
         translate < 6.244720  11.545080  0.000000>
       }
      sphere { < 7.197620  12.762590  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.454066  0.750000  0.750000>
         rotate    < 0.000000  0.000000  33.241769>
         translate < 7.197620  12.762590  0.000000>
       }
      sphere { < 8.413750  13.559670  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.362303  0.750000  0.750000>
         rotate    < 0.000000  0.000000  14.437741>
         translate < 8.413750  13.559670  0.000000>
       }
      sphere { < 9.733030  13.899330  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.270858  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -4.482799>
         translate < 9.733030  13.899330  0.000000>
       }
      sphere { < 11.000000  13.800000  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.179790  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -23.546065>
         translate < 11.000000  13.800000  0.000000>
       }
      sphere { < 12.081560  13.328690  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 1.089185  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -42.785865>
         translate < 12.081560  13.328690  0.000000>
       }
      sphere { < 12.880910  12.588850  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 0.999199  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -62.250112>
         translate < 12.880910  12.588850  0.000000>
       }
      sphere { < 13.346150  11.704570  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 0.909978  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -82.003464>
         translate < 13.346150  11.704570  0.000000>
       }
      sphere { < 13.472740  10.803440  0.000000>  0.750000  }
      intersection {
         Connector_1
         scale     < 0.821800  0.750000  0.750000>
         rotate    < 0.000000  0.000000 -77.866093>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 13.472740  10.803440  0.000000>
       }
      sphere { < 13.300000  10.000000  0.000000>  0.750000  }
    }
   texture {
      YourTexture
    }
   bounded_by {
      sphere { < 9.650000  11.500000  0.000000>  15.187371  }
    }
 }

#declare YourThing2 =
object {
   union {
    }
   texture {
      YourTexture
    }
   bounded_by {
      sphere { < 0.000000  0.000000  0.000000>  1.428942  }
    }
 }

#declare YourThing3 =
object {
   union {
      intersection {
         Connector_1
         scale     < 24.000000  0.750000  0.750000>
         rotate    < 0.000000  0.000000  90.000000>
       }
      sphere { < 0.000000  24.000000  0.000000>  0.750000  }
    }
   texture {
      YourTexture
    }
   bounded_by {
      sphere { < 0.000000  12.000000  0.000000>  14.073446  }
    }
 }

#declare YourThing4 =
object {
   union {
    }
   texture {
      YourTexture
    }
   bounded_by {
      sphere { < 0.000000  13.750000  0.000000>  15.303941  }
    }
 }

#declare YourThing5 =
object {
   union {
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.390537  }
         plane {     < 1.000000  0.000000  0.000000>  0.695269 inverse  }
         translate <-0.695269  0.000000  0.000000>
         scale     < 2.472066  1.000000  1.000000>
         translate < 0.281250  0.000000  0.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate < 0.000000  24.000000  0.000000>
       }
      sphere { < 0.000000  26.000000  0.000000>  1.500000  }
    }
   texture {
      YourTexture
    }
   bounded_by {
      sphere { < 0.000000  13.750000  0.000000>  15.303941  }
    }
 }

#declare fence_section =
composite {
   object { YourThing1  }
   object { YourThing3  }
   object { YourThing4  }
   object { YourThing5  }
   bounded_by {
      sphere { < 9.275000  13.375000  0.000000>  19.611684  }
    }
 }



#declare h_rail = object { intersection { X_Disk scale <200 0.75 0.75>
 }
texture {  color red 0.2 green 0.2 blue 0.23 
phong 1.0 ambient 0.15
 }
 }


#declare fence1 = composite {

composite { fence_section translate <0 0 0>  }
composite { fence_section translate <20 0 0>  }
composite { fence_section translate <40 0 0>  }
composite { fence_section translate <60 0 0>  }
composite { fence_section translate <80 0 0>  }
composite { fence_section translate <-20 0 0>  }
composite { fence_section translate <-40 0 0>  }
composite { fence_section translate <-60 0 0>  }
composite { fence_section translate <-80 0 0>  }

object { h_rail translate <-100 20 0>  }
object { h_rail translate <-100 0 0>  }

bounded_by {
sphere { < 0.000000  10.750000  0.000000>  115  }
 }
 }




