// Persistence of Vision Raytracer
//---------- The Dormer....Toys in the attic..4/4/92 m. Miller

#include "colors.inc"
#include "shapes.inc"
#include "shapes.old"
#include "textures.inc"

#declare DCone = /*---------CONE POINT DOWN /POINT at 000--------*/
intersection {
quadric { QCone_Y scale <1 1 1>  }
plane { <0 -1 0> 0  }
plane { <0 1 0> 1   }
 }

#include "dormc.inc"
#include "3turns.inc"
#include "fence1.inc"
#include "sky77.inc"
#include "jake.inc"
#include "body1.inc"

camera {
location <0 20 -300> direction <0 0 1.6>
up <0 1 0> right <1.33 0 0>
look_at <0 60 0>
 }

//-------light
object
{
	union
	{
		sphere
		{
			<200 600 -1200> 1
			texture 
			{
				color White
			}
		}
		light_source
		{
			<200 600 -1200>
			color White
		}
	}
	no_shadow
}


//-------light
object
{
	union
	{
		sphere
		{
			<-700 1600 -2200> 1
			texture 
			{
				color White
			}
		}
		light_source
		{
			<-700 1600 -2200>
			color White
		}
	}
	no_shadow
}

//--------- sky
object {
sphere { <0 0 0> 20000 inverse  }
texture { color MidnightBlue ambient 1.0 diffuse 0.0 0.03  }
 }

/*-------------------- DECLARED SHAPES ----------------------*/
#declare q1 = quadric { Cylinder_Z scale <8 8 1>  }
#declare q2 = quadric { Cylinder_Z scale <6 6 1>  }
#declare d1 = intersection { Cube scale <2 2.5 6.5>  } //dentiles


#declare UCone = /*---------CONE POINT UP /POINT at 000--------*/
intersection {
quadric { QCone_Y scale <1 1 1>  }
plane { <0 1 0> 0    }
plane { <0 1 0> -1 inverse  }
 }






/*------------------- DECLARED TEXTURES --------------------*/
#declare tex1 = texture { color Salmon phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex2 = texture { color CadetBlue phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex3 = texture { color Gold phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex4 = texture { color Orchid phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex5 = texture { color Red phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex6 = texture { color Orange phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex7 = texture { color DimGray phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex8 = texture { color Green phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex9 = texture { color Salmon phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex10 = texture { color CadetBlue phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex11 = texture { color Gold phong 1.0 ambient 0.2 diffuse 0.6  }
#declare tex12 = texture { color Orchid phong 1.0 ambient 0.2 diffuse 0.6  }

//-------------------- start dormer
composite {

//------ginger bread cut
object {
difference {
union {
quadric { q1 translate <0 114 0>  }
quadric { q1 translate <-9.5 103.5 0>  }
quadric { q1 translate <-19 93 0>  }
quadric { q1 translate <9.5 103.5 0>  }
quadric { q1 translate <19 93 0>  }
 }
quadric { q2 translate <0 114 0>  }
quadric { q2 translate <-9.5 103.5 0>  }
quadric { q2 translate <-19 93 0>  }
quadric { q2 translate <9.5 103.5 0>  }
quadric { q2 translate <19 93 0>  }
intersection { Cube rotate <0 0 45> scale <15.4 16.9 20> translate <0 90.2 0>  }
plane { <0 0 1> -3.5  }
plane { <0 0 1> -1.5 inverse  }
 }
texture { 
color b_moss_green ambient 0.2 diffuse 0.7 phong 1.0 0.03
 }
bounded_by { sphere { <0 95 0> 30  }  }
 }

//------facade for ginger cut
object {
difference {
intersection { Cube rotate <0 0 45> scale <23.6 25.9 1> translate <0 91.7 -2>  }
quadric { q1 translate <0 114 0>  }
quadric { q1 translate <-9.5 103.5 0>  }
quadric { q1 translate <-19 93 0>  }
quadric { q1 translate <9.5 103.5 0>  }
quadric { q1 translate <19 93 0>  }
intersection { Cube rotate <0 0 45> scale <15.4 16.9 20> translate <0 90.2 0>  }
plane { <0 1 0> 91  }
 }
texture { 
color d_cream ambient 0.2 diffuse 0.7 phong 1.0
 }
bounded_by { sphere { <0 95 0> 35  }  }
 }

//-------------- top peek molding
object {
difference {
intersection { Cube rotate <0 0 45> scale <29 31.9 7.3> translate <0 90 1.7>  }
intersection { Cube rotate <0 0 45> scale <24.8 27.3 15> translate <0 90 -3>  }
plane { <0 1 0> 93  }
 }
texture { 
color m_g_teal phong 1.0 ambient 0.2 diffuse 0.6 0.01
 }
bounded_by { sphere { <0 95 0> 45  }  }
 }

//--------------- dentiles & peek headers
object {
union {
intersection { Cube scale <35 1.5 40.5> translate <0 91.5 35>  }
intersection { d1 translate <-20 87.5 2>  }
intersection { d1 translate <-12 87.5 2>  }
intersection { d1 translate <-4 87.5 2>  }
intersection { d1 translate <4 87.5 2>  }
intersection { d1 translate <12 87.5 2>  }
intersection { d1 translate <20 87.5 2>  }
intersection { Cube scale <5 8 58.5> translate <-26 82 53>  }
intersection { Cube scale <5 8 58.5> translate <26 82 53>  }
intersection { Cube scale <3 5 48> translate <31 85 50>  }
intersection { Cube scale <3 5 48> translate <-31 85 50>  }
 }

texture { 
gradient <0 1 0>
color_map {
[0.0 0.15 color warm_gold color warm_gold]
[0.15 0.25 color tara_red color tara_red]
[0.25 0.35 color warm_gold color warm_gold]
[0.35 0.8 color m_g_teal color m_g_teal]
[0.8 1.0 color tara_red color toffe]
 }
scale <1000 20 1000> translate <0 74 0>
ambient 0.2 diffuse 0.8 
phong 1.0 
 }


bounded_by {
intersection { Cube scale <38 12 63> translate <0 83.7 52>  }
 }
 }

//---------- inside wall in peek
object {
difference {
intersection { Cube rotate <0 0 45> scale <24.8 27.3 1> translate <0 90 9>  }
plane { <0 1 0> 91.5  }
 }
texture { 
gradient <0 1 0>
color_map {
[0.0 0.1 color shadow_teal color shadow_teal]
[0.1 1.01 color m_g_gray color m_g_gray ]
 }
scale <200 5 200> translate <0 92 0>
0.01 ambient 0.2 diffuse 0.8
phong 1.0 
 }
 }


//------------- peek roof
object {
difference {
intersection { Cube rotate <0 0 45> scale <27.8 30.85 52> translate <0 90.5 61.5>  }
plane { <0 1 0> 93.5  }
 }
texture { 
 
image_map { <1 -1 0> gif "roof2.gif"  }
scale <150 220 1> rotate <0 90 0> rotate <30 0 0> translate <-100 90 -1>
ambient 0.2 0.02 diffuse 0.6 phong 0.5  }

 }


//------------ dormer front wall
object {
difference {
intersection { Cube scale <32 42.5 1> translate <0 47.5 10>  }
quadric { Cylinder_Z scale <20 20 1> translate <0 60 0>  }
intersection { Cube scale <20 35 5> translate <0 25 10>  }
 }

texture { 
gradient <0 1 0>
color_map {
[0.0 0.099 color shadow_teal color shadow_teal]
[0.099 1.01 color m_g_gray color m_g_gray ]
 }
scale <200 5 200> translate <0 5 0>
0.03 ambient 0.2 diffuse 0.6
phong 1.0 
 }

bounded_by { 
intersection { Cube scale <33 44 2> translate <0 47.5 10>  }
 }
 }

//----------- columns
composite {
//-----------right column molding
object {
union {
intersection { Y_Disk scale <5 3 5> translate <26 57 7>  }
intersection { Y_Disk scale <4.5 3 4.5> translate <26 54 7>  }
intersection { Y_Disk scale <5 5 5> translate <26 5 7>  }
 }

texture { color b_moss_green 0.01 phong 1.0 phong_size 70 
ambient 0.2 diffuse 0.6  }

bounded_by {
intersection { Y_Disk scale <6 60 6> translate <26 3 7>  }
 }
 }
//----------- right column
object {
intersection { Y_Disk scale <4 46 4> translate <26 9 7>  }
texture { 
gradient <0 1 0>
color_map {
[0.0 0.1 color b_moss_green color b_moss_green]
[0.1 0.15 color tara_red color tara_red]
[0.15 0.85 color d_cream color d_cream]
[0.85 0.9 color tara_red color tara_red]
[0.9 1.01 color b_moss_green color b_moss_green]
 }
scale <10 46 10>
translate <0 9 0>
phong 1.0 phong_size 65 ambient 0.2 diffuse 0.6
 }
 }
bounded_by {
intersection { Y_Disk scale <6 60 6> translate <26 3 7>  }
 }
 }


composite {
//-----------left column molding
object {
union {
intersection { Y_Disk scale <5 3 5> translate <-26 57 7>  }
intersection { Y_Disk scale <4.5 3 4.5> translate <-26 54 7>  }
intersection { Y_Disk scale <5 5 5> translate <-26 5 7>  }
 }

texture { color b_moss_green 0.01 phong 1.0 phong_size 70 
ambient 0.2 diffuse 0.6  }

bounded_by {
intersection { Y_Disk scale <6 60 6> translate <-26 3 7>  }
 }
 }
//----------- left column
object {
intersection { Y_Disk scale <4 46 4> translate <-26 9 7>  }

texture { 
gradient <0 1 0>
color_map {
[0.0 0.1 color b_moss_green color b_moss_green]
[0.1 0.15 color tara_red color tara_red]
[0.15 0.85 color d_cream color d_cream]
[0.85 0.9 color tara_red color tara_red]
[0.9 1.01 color b_moss_green color b_moss_green]
 }
scale <10 46 10>
translate <0 9 0>
phong 1.0 phong_size 65 ambient 0.2 diffuse 0.6
 }


 }
bounded_by {
intersection { Y_Disk scale <6 60 6> translate <-26 3 7>  }
 }
 }


//------------ arched door frame
object {
union {
difference {
union {
intersection { Z_Disk scale <20 20 4> translate <0 60 8>  }
intersection { Cube scale <20 30 2> translate <0 30 10>  }
 }
quadric { Cylinder_Z scale <17 17 1> translate <0 60 0>  }
intersection { Cube scale <17 30 4> translate <0 30 10>  }
 }
intersection { Cube scale <19 1.5 1> translate <0 58.5 10>  }
intersection { Cube scale <1 10 1> rotate <0 0 0> translate <0 69 10>  }
intersection { Cube scale <1 10 1> rotate <0 0 45> translate <-6 65 10>  }
intersection { Cube scale <1 10 1> rotate <0 0 -45> translate <6 65 10>  }
 }
texture { 
color d_cream ambient 0.2 diffuse 0.6 phong 1.0 0.03 phong 1.0
 }
bounded_by { 
intersection { Cube scale <22 40 6> translate <0 42 10>  }
 }
 }


 
//--------- dormer side walls
object {
intersection { Cube scale <1 42.5 44> translate <31 47.5 53>  }

texture { 
gradient <0 1 0>
color_map {
[0.0 0.099 color shadow_teal color shadow_teal]
[0.099 1.01 color m_g_gray color m_g_gray ]
 }
scale <200 5 200> translate <0 5 0>
0.03 ambient 0.2 diffuse 0.6
phong 1.0 
 }

 }

object {
intersection { Cube scale <1 42.5 44> translate <-31 47.5 53>  }
texture { 
gradient <0 1 0>
color_map {
[0.0 0.099 color shadow_teal color shadow_teal]
[0.099 1.01 color m_g_gray color m_g_gray ]
 }
scale <200 5 200> translate <0 5 0>
0.03 ambient 0.2 diffuse 0.6
phong 1.0 
 }

 }


//---------- dormer sill & truss
object {
union {
intersection { Cube scale <7 2.5 46> translate <26 2.5 44>  }
intersection { Cube scale <7 2.5 46> translate <-26 2.5 44>  }
intersection { Cube scale <6 2 6> translate <26 -2 7>  }
intersection { Cube scale <6 2 6> translate <-26 -2 7>  }
intersection { Cube scale <20 2.5 5> translate <0 2.5 12>  }
 }

texture { 
gradient <0 1 0>
color_map {
[0.0 0.1 color b_moss_green color b_moss_green]
[0.1 0.15 color tara_red color tara_red]
[0.15 0.85 color d_cream color d_cream]
[0.85 0.9 color tara_red color tara_red]
[0.9 1.01 color b_moss_green color b_moss_green]
 }
scale <100 13 100>
translate <0 -12.5 0>
phong 1.0 phong_size 65 ambient 0.2 diffuse 0.6

 }
bounded_by { 
intersection { Cube scale <35 10 60> translate <0 -3 50>  }
 }
 }


//--------- dormer testicals
object {
union {
sphere { <26 -8 7> 4.5  }
sphere { <-26 -8 7> 4.5  }
 }
texture {
color b_moss_green ambient 0.2 diffuse 0.7 phong 1.0
 }
 }


//--------- house roof
object {
difference {
intersection { Cube scale <200 110 1> rotate <30 0 0> translate <-100 62 62>  }
intersection { Cube scale <31 45 30> translate <0 46 53>  }
intersection { Cube scale <31 45 30> translate <-120 46 53>  }

 }
texture { 
image_map { <1 -1 0> gif "roof2.gif"  }
scale <150 220 1> rotate <30 0 0> translate <-100 -50 -1>
ambient 0.2 0.02 diffuse 0.6 phong 0.5  }
 }

//--------- roof crown molding
object {
intersection { Cube scale <200 5 2.5> translate <0 112 0> 
rotate <30 0 0> translate <-100 62 62>  }
texture { color crust ambient 0.15 diffuse 0.4 phong 1.0  }
 }

//--------- flashing
object {
intersection { Cube scale <190 10 2.5> translate <-100 -40 10>  }
texture { color crust ambient 0.15 diffuse 0.4 phong 1.0  }
 }

composite { turns translate <-28 61 0>  }
composite { turns translate <24 61 0>  }
composite { fence1 translate <0 170 120>  }

//----------- body section coming through dormer
composite {
composite { body1 translate <-2 0 0>  }
composite { body1 translate <2 0 0>  }
rotate <0 0 35> translate <-100 -10 -10> 
 }

rotate <0 -38 0>
 }


//------------- add left dormer
#include "dormer.inc"




//------------- add creatures
#include "jake.inc"
composite { fish07 
scale <1.8 1.8 1.8> rotate <0 -110 0> rotate <-20 0 0> translate <100 110 170>
 }


















