// Persistence of Vision Raytracer
//-------------- 3 turns side by side


//------- turn texture {
#declare YourTexture =  
texture { color warm_gold ambient 0.2 diffuse 0.7 phong 1.0 
phong_size 70 0.01
 }

#declare Dot =               
quadric {
   < 1.0  1.0  1.0>
   < 0.0  0.0  0.0>
   < 0.0  0.0  0.0>
    -1.0
 }

#declare Connector_1 = 
intersection {
   quadric {
      < 0.0  1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
       -1.0
    }
   plane { < 1.0  0.0  0.0> 0.0 inverse  }
   plane { < 1.0  0.0  0.0> 1.0          }
 }

#declare Connector_2 = 
quadric {
   < 1.0 -1.0  1.0>
   < 0.0  0.0  0.0>
   < 0.0  0.0  0.0>
     0.0
   rotate < 0.0  0.0  90.0>
 }


//------------- start turns
#declare turn441 =
object {
   union {
      quadric {
         Dot
         scale     < 2.000000  2.000000  2.000000>
         translate < 0.000000  0.000000  5.000000>
       }
      intersection {
         Connector_1
         scale     < 7.000000  2.000000  2.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate < 0.000000  0.000000  5.000000>
       }
      quadric {
         Dot
         scale     < 2.000000  2.000000  2.000000>
         translate < 0.000000  7.000000  5.000000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.999744  }
         plane {     < 1.000000  0.000000  0.000000>  1.971178 inverse  }
         translate <-1.999744  0.000000  0.000000>
         scale     < 62.489923  1.000000  1.000000>
         translate <-0.032001  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  79.714125>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  7.000000  5.000000>
       }
      quadric {
         Dot
         scale     < 1.971430  1.971430  1.971430>
         translate < 0.000000  8.756870  4.681170>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.971172  }
         plane {     < 1.000000  0.000000  0.000000>  1.942606 inverse  }
         translate <-1.971172  0.000000  0.000000>
         scale     < 61.793135  1.000000  1.000000>
         translate <-0.031900  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  54.577074>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  8.756870  4.681170>
       }
      quadric {
         Dot
         scale     < 1.942860  1.942860  1.942860>
         translate < 0.000000  10.195700  3.657780>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.942590  }
         plane {     < 1.000000  0.000000  0.000000>  1.914024 inverse  }
         translate <-1.942590  0.000000  0.000000>
         scale     < 60.013457  1.000000  1.000000>
         translate <-0.032369  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  33.869659>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  10.195700  3.657780>
       }
      quadric {
         Dot
         scale     < 1.914290  1.914290  1.914290>
         translate < 0.000000  11.151380  2.233950>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.914008  }
         plane {     < 1.000000  0.000000  0.000000>  1.885432 inverse  }
         translate <-1.914008  0.000000  0.000000>
         scale     < 58.212967  1.000000  1.000000>
         translate <-0.032879  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  13.154399>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  11.151380  2.233950>
       }
      quadric {
         Dot
         scale     < 1.885710  1.885710  1.885710>
         translate < 0.000000  11.530060  0.613640>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.885414  }
         plane {     < 1.000000  0.000000  0.000000>  1.856849 inverse  }
         translate <-1.885414  0.000000  0.000000>
         scale     < 56.454224  1.000000  1.000000>
         translate <-0.033397  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -7.570281>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  11.530060  0.613640>
       }
      quadric {
         Dot
         scale     < 1.857140  1.857140  1.857140>
         translate < 0.000000  11.317540 -0.985450>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.856829  }
         plane {     < 1.000000  0.000000  0.000000>  1.828264 inverse  }
         translate <-1.856829  0.000000  0.000000>
         scale     < 54.675363  1.000000  1.000000>
         translate <-0.033961  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -28.304780>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  11.317540 -0.985450>
       }
      quadric {
         Dot
         scale     < 1.828570  1.828570  1.828570>
         translate < 0.000000  10.576740 -2.360990>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.828243  }
         plane {     < 1.000000  0.000000  0.000000>  1.799678 inverse  }
         translate <-1.828243  0.000000  0.000000>
         scale     < 52.896553  1.000000  1.000000>
         translate <-0.034563  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -49.050173>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  10.576740 -2.360990>
       }
      quadric {
         Dot
         scale     < 1.800000  1.800000  1.800000>
         translate < 0.000000  9.435110 -3.351640>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.799656  }
         plane {     < 1.000000  0.000000  0.000000>  1.771091 inverse  }
         translate <-1.799656  0.000000  0.000000>
         scale     < 51.118649  1.000000  1.000000>
         translate <-0.035205  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -69.807549>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  9.435110 -3.351640>
       }
      quadric {
         Dot
         scale     < 1.771430  1.771430  1.771430>
         translate < 0.000000  8.064150 -3.855850>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.771066  }
         plane {     < 1.000000  0.000000  0.000000>  1.742502 inverse  }
         translate <-1.771066  0.000000  0.000000>
         scale     < 49.341348  1.000000  1.000000>
         translate <-0.035894  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -89.421738>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  8.064150 -3.855850>
       }
      quadric {
         Dot
         scale     < 1.742860  1.742860  1.742860>
         translate < 0.000000  6.654250 -3.841620>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.742475  }
         plane {     < 1.000000  0.000000  0.000000>  1.713911 inverse  }
         translate <-1.742475  0.000000  0.000000>
         scale     < 47.564628  1.000000  1.000000>
         translate <-0.036634  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -68.635693>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  6.654250 -3.841620>
       }
      quadric {
         Dot
         scale     < 1.714290  1.714290  1.714290>
         translate < 0.000000  5.388430 -3.346460>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.713881  }
         plane {     < 1.000000  0.000000  0.000000>  1.685308 inverse  }
         translate <-1.713881  0.000000  0.000000>
         scale     < 45.772425  1.000000  1.000000>
         translate <-0.037444  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -47.832997>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  5.388430 -3.346460>
       }
      quadric {
         Dot
         scale     < 1.685710  1.685710  1.685710>
         translate < 0.000000  4.418590 -2.468080>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.685275  }
         plane {     < 1.000000  0.000000  0.000000>  1.656712 inverse  }
         translate <-1.685275  0.000000  0.000000>
         scale     < 44.013206  1.000000  1.000000>
         translate <-0.038290  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -27.012220>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  4.418590 -2.468080>
       }
      quadric {
         Dot
         scale     < 1.657140  1.657140  1.657140>
         translate < 0.000000  3.847330 -1.347510>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.656676  }
         plane {     < 1.000000  0.000000  0.000000>  1.628114 inverse  }
         translate <-1.656676  0.000000  0.000000>
         scale     < 42.238517  1.000000  1.000000>
         translate <-0.039222  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -6.170150>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  3.847330 -1.347510>
       }
      quadric {
         Dot
         scale     < 1.628570  1.628570  1.628570>
         translate < 0.000000  3.717590 -0.147410>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.628073  }
         plane {     < 1.000000  0.000000  0.000000>  1.599512 inverse  }
         translate <-1.628073  0.000000  0.000000>
         scale     < 40.465082  1.000000  1.000000>
         translate <-0.040234  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  14.695599>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  3.717590 -0.147410>
       }
      quadric {
         Dot
         scale     < 1.600000  1.600000  1.600000>
         translate < 0.000000  4.010960  0.971200>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.599466  }
         plane {     < 1.000000  0.000000  0.000000>  1.570905 inverse  }
         translate <-1.599466  0.000000  0.000000>
         scale     < 38.692595  1.000000  1.000000>
         translate <-0.041338  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  35.588453>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  4.010960  0.971200>
       }
      quadric {
         Dot
         scale     < 1.571430  1.571430  1.571430>
         translate < 0.000000  4.654500  1.870470>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.570854  }
         plane {     < 1.000000  0.000000  0.000000>  1.542294 inverse  }
         translate <-1.570854  0.000000  0.000000>
         scale     < 36.921627  1.000000  1.000000>
         translate <-0.042546  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  56.512027>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  4.654500  1.870470>
       }
      quadric {
         Dot
         scale     < 1.542860  1.542860  1.542860>
         translate < 0.000000  5.534570  2.452710>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.542236  }
         plane {     < 1.000000  0.000000  0.000000>  1.513667 inverse  }
         translate <-1.542236  0.000000  0.000000>
         scale     < 35.139970  1.000000  1.000000>
         translate <-0.043888  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  77.470697>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  5.534570  2.452710>
       }
      quadric {
         Dot
         scale     < 1.514280  1.514280  1.514280>
         translate < 0.000000  6.515350  2.670670>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.513601  }
         plane {     < 1.000000  0.000000  0.000000>  1.485044 inverse  }
         translate <-1.513601  0.000000  0.000000>
         scale     < 33.384025  1.000000  1.000000>
         translate <-0.045339  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  81.529209>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  6.515350  2.670670>
       }
      quadric {
         Dot
         scale     < 1.485710  1.485710  1.485710>
         translate < 0.000000  7.459150  2.530110>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.484967  }
         plane {     < 1.000000  0.000000  0.000000>  1.456412 inverse  }
         translate <-1.484967  0.000000  0.000000>
         scale     < 31.617939  1.000000  1.000000>
         translate <-0.046966  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  60.481111>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  7.459150  2.530110>
       }
      quadric {
         Dot
         scale     < 1.457140  1.457140  1.457140>
         translate < 0.000000  8.245610  2.084810>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.456323  }
         plane {     < 1.000000  0.000000  0.000000>  1.427769 inverse  }
         translate <-1.456323  0.000000  0.000000>
         scale     < 29.854689  1.000000  1.000000>
         translate <-0.048780  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  39.376889>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  8.245610  2.084810>
       }
      quadric {
         Dot
         scale     < 1.428570  1.428570  1.428570>
         translate < 0.000000  8.787040  1.425120>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.427666  }
         plane {     < 1.000000  0.000000  0.000000>  1.399114 inverse  }
         translate <-1.427666  0.000000  0.000000>
         scale     < 28.093829  1.000000  1.000000>
         translate <-0.050818  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  18.206648>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  8.787040  1.425120>
       }
      quadric {
         Dot
         scale     < 1.400000  1.400000  1.400000>
         translate < 0.000000  9.037980  0.662180>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.398992  }
         plane {     < 1.000000  0.000000  0.000000>  1.370442 inverse  }
         translate <-1.398992  0.000000  0.000000>
         scale     < 26.336383  1.000000  1.000000>
         translate <-0.053120  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -3.044382>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  9.037980  0.662180>
       }
      quadric {
         Dot
         scale     < 1.371430  1.371430  1.371430>
         translate < 0.000000  8.997990 -0.089730>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.370297  }
         plane {     < 1.000000  0.000000  0.000000>  1.341750 inverse  }
         translate <-1.370297  0.000000  0.000000>
         scale     < 24.582835  1.000000  1.000000>
         translate <-0.055742  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -24.392281>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  8.997990 -0.089730>
       }
      quadric {
         Dot
         scale     < 1.342860  1.342860  1.342860>
         translate < 0.000000  8.707700 -0.729900>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.341573  }
         plane {     < 1.000000  0.000000  0.000000>  1.313021 inverse  }
         translate <-1.341573  0.000000  0.000000>
         scale     < 22.826803  1.000000  1.000000>
         translate <-0.058772  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -45.858690>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  8.707700 -0.729900>
       }
      quadric {
         Dot
         scale     < 1.314280  1.314280  1.314280>
         translate < 0.000000  8.239080 -1.184680>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.312805  }
         plane {     < 1.000000  0.000000  0.000000>  1.284267 inverse  }
         translate <-1.312805  0.000000  0.000000>
         scale     < 21.092542  1.000000  1.000000>
         translate <-0.062240  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -67.473208>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  8.239080 -1.184680>
       }
      quadric {
         Dot
         scale     < 1.285710  1.285710  1.285710>
         translate < 0.000000  7.681820 -1.415810>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.283998  }
         plane {     < 1.000000  0.000000  0.000000>  1.255466 inverse  }
         translate <-1.283998  0.000000  0.000000>
         scale     < 19.358311  1.000000  1.000000>
         translate <-0.066328  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -89.274736>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  7.681820 -1.415810>
       }
      quadric {
         Dot
         scale     < 1.257140  1.257140  1.257140>
         translate < 0.000000  7.128060 -1.422820>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.255124  }
         plane {     < 1.000000  0.000000  0.000000>  1.226599 inverse  }
         translate <-1.255124  0.000000  0.000000>
         scale     < 17.634679  1.000000  1.000000>
         translate <-0.071174  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -68.683945>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  7.128060 -1.422820>
       }
      quadric {
         Dot
         scale     < 1.228570  1.228570  1.228570>
         translate < 0.000000  6.657950 -1.239380>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.226155  }
         plane {     < 1.000000  0.000000  0.000000>  1.197641 inverse  }
         translate <-1.226155  0.000000  0.000000>
         scale     < 15.924265  1.000000  1.000000>
         translate <-0.076999  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -46.326145>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  6.657950 -1.239380>
       }
      quadric {
         Dot
         scale     < 1.200000  1.200000  1.200000>
         translate < 0.000000  6.328240 -0.924590>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.197049  }
         plane {     < 1.000000  0.000000  0.000000>  1.168549 inverse  }
         translate <-1.197049  0.000000  0.000000>
         scale     < 14.232207  1.000000  1.000000>
         translate <-0.084108  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -23.541889>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  6.328240 -0.924590>
       }
      quadric {
         Dot
         scale     < 1.171430  1.171430  1.171430>
         translate < 0.000000  6.165430 -0.550900>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.167739  }
         plane {     < 1.000000  0.000000  0.000000>  1.139259 inverse  }
         translate <-1.167739  0.000000  0.000000>
         scale     < 12.566913  1.000000  1.000000>
         translate <-0.092922  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -0.171806>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  6.165430 -0.550900>
       }
      quadric {
         Dot
         scale     < 1.142860  1.142860  1.142860>
         translate < 0.000000  6.164350 -0.190730>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.138111  }
         plane {     < 1.000000  0.000000  0.000000>  1.109650 inverse  }
         translate <-1.138111  0.000000  0.000000>
         scale     < 10.934933  1.000000  1.000000>
         translate <-0.104080  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  24.037195>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  6.164350 -0.190730>
       }
      quadric {
         Dot
         scale     < 1.114280  1.114280  1.114280>
         translate < 0.000000  6.292180  0.095880>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.107986  }
         plane {     < 1.000000  0.000000  0.000000>  1.079577 inverse  }
         translate <-1.107986  0.000000  0.000000>
         scale     < 9.368649  1.000000  1.000000>
         translate <-0.118265  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  49.477663>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  6.292180  0.095880>
       }
      quadric {
         Dot
         scale     < 1.085710  1.085710  1.085710>
         translate < 0.000000  6.496800  0.270780>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.077096  }
         plane {     < 1.000000  0.000000  0.000000>  1.048752 inverse  }
         translate <-1.077096  0.000000  0.000000>
         scale     < 7.891117  1.000000  1.000000>
         translate <-0.136495  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  76.780124>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  6.496800  0.270780>
       }
      quadric {
         Dot
         scale     < 1.057140  1.057140  1.057140>
         translate < 0.000000  6.718030  0.322750>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.045095  }
         plane {     < 1.000000  0.000000  0.000000>  1.016850 inverse  }
         translate <-1.045095  0.000000  0.000000>
         scale     < 6.567621  1.000000  1.000000>
         translate <-0.159128  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  73.076379>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  6.718030  0.322750>
       }
      quadric {
         Dot
         scale     < 1.028570  1.028570  1.028570>
         translate < 0.000000  6.899610  0.267500>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.012048  }
         plane {     < 1.000000  0.000000  0.000000>  0.983937 inverse  }
         translate <-1.012048  0.000000  0.000000>
         scale     < 5.511752  1.000000  1.000000>
         translate <-0.183616  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  38.849347>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  6.899610  0.267500>
       }
      quadric {
         Dot
         translate < 0.000000  7.000000  0.142860>
       }
    }
   texture {
      YourTexture
    }
   bounded_by {
      quadric {
         Dot
         scale < 11.178595  11.178595  11.178595>
         translate < 0.000000  5.707885  0.686360>
       }
    }
 }



#declare turn442 =
object {
   union {
    }
   texture {
      YourTexture
    }
   bounded_by {
      quadric {
         Dot
         scale < 4.950000  4.950000  4.950000>
         translate < 2.000000  0.000000  3.500000>
       }
    }
 }



#declare turn443 =
object {
   union {
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.986901  }
         plane {     < 1.000000  0.000000  0.000000>  0.993450 inverse  }
         translate <-0.993450  0.000000  0.000000>
         scale     < 8.694355  1.000000  1.000000>
         translate < 0.114264  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -53.115487>
         rotate    < 0.000000 -67.619853  0.000000>
         translate < 0.000000  7.000000  0.142860>
       }
      quadric {
         Dot
         scale     < 2.000000  2.000000  2.000000>
         translate < 2.000000  0.000000  5.000000>
       }
      intersection {
         Connector_1
         scale     < 7.000000  2.000000  2.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate < 2.000000  0.000000  5.000000>
       }
      quadric {
         Dot
         scale     < 2.000000  2.000000  2.000000>
         translate < 2.000000  7.000000  5.000000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.999745  }
         plane {     < 1.000000  0.000000  0.000000>  1.974748 inverse  }
         translate <-1.999745  0.000000  0.000000>
         scale     < 62.565615  1.000000  1.000000>
         translate <-0.031962  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  80.999878>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  7.000000  5.000000>
       }
      quadric {
         Dot
         scale     < 1.975000  1.975000  1.975000>
         translate < 2.000000  8.545080  4.755280>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.974744  }
         plane {     < 1.000000  0.000000  0.000000>  1.949747 inverse  }
         translate <-1.974744  0.000000  0.000000>
         scale     < 62.066108  1.000000  1.000000>
         translate <-0.031817  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  59.351003>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  8.545080  4.755280>
       }
      quadric {
         Dot
         scale     < 1.950000  1.950000  1.950000>
         translate < 2.000000  9.880150  3.964180>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.949736  }
         plane {     < 1.000000  0.000000  0.000000>  1.924740 inverse  }
         translate <-1.949736  0.000000  0.000000>
         scale     < 60.816570  1.000000  1.000000>
         translate <-0.032059  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  41.275851>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  9.880150  3.964180>
       }
      quadric {
         Dot
         scale     < 1.925000  1.925000  1.925000>
         translate < 2.000000  10.883280  2.821370>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.924729  }
         plane {     < 1.000000  0.000000  0.000000>  1.899732 inverse  }
         translate <-1.924729  0.000000  0.000000>
         scale     < 59.567962  1.000000  1.000000>
         translate <-0.032311  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  23.197883>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  10.883280  2.821370>
       }
      quadric {
         Dot
         scale     < 1.900000  1.900000  1.900000>
         translate < 2.000000  11.469970  1.452380>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.899721  }
         plane {     < 1.000000  0.000000  0.000000>  1.874724 inverse  }
         translate <-1.899721  0.000000  0.000000>
         scale     < 58.318991  1.000000  1.000000>
         translate <-0.032575  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  5.115989>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  11.469970  1.452380>
       }
      quadric {
         Dot
         scale     < 1.875000  1.875000  1.875000>
         translate < 2.000000  11.600000  0.000000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.874712  }
         plane {     < 1.000000  0.000000  0.000000>  1.849716 inverse  }
         translate <-1.874712  0.000000  0.000000>
         scale     < 57.070452  1.000000  1.000000>
         translate <-0.032849  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -12.969066>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  11.600000  0.000000>
       }
      quadric {
         Dot
         scale     < 1.850000  1.850000  1.850000>
         translate < 2.000000  11.279750 -1.390580>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.849703  }
         plane {     < 1.000000  0.000000  0.000000>  1.824707 inverse  }
         translate <-1.849703  0.000000  0.000000>
         scale     < 55.821522  1.000000  1.000000>
         translate <-0.033136  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -31.057459>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  11.279750 -1.390580>
       }
      quadric {
         Dot
         scale     < 1.825000  1.825000  1.825000>
         translate < 2.000000  10.559680 -2.586260>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.824694  }
         plane {     < 1.000000  0.000000  0.000000>  1.799698 inverse  }
         translate <-1.824694  0.000000  0.000000>
         scale     < 54.573047  1.000000  1.000000>
         translate <-0.033436  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -49.151087>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  10.559680 -2.586260>
       }
      quadric {
         Dot
         scale     < 1.800000  1.800000  1.800000>
         translate < 2.000000  9.527480 -3.478770>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.799684  }
         plane {     < 1.000000  0.000000  0.000000>  1.774688 inverse  }
         translate <-1.799684  0.000000  0.000000>
         scale     < 53.325136  1.000000  1.000000>
         translate <-0.033749  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -67.247950>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  9.527480 -3.478770>
       }
      quadric {
         Dot
         scale     < 1.775000  1.775000  1.775000>
         translate < 2.000000  8.297870 -3.994440>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.774673  }
         plane {     < 1.000000  0.000000  0.000000>  1.749677 inverse  }
         translate <-1.774673  0.000000  0.000000>
         scale     < 52.076627  1.000000  1.000000>
         translate <-0.034078  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -85.350182>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 2.000000  8.297870 -3.994440>
       }
      quadric {
         Dot
         scale     < 1.750000  1.750000  1.750000>
         translate < 2.000000  7.000000 -4.100000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.749661  }
         plane {     < 1.000000  0.000000  0.000000>  1.724666 inverse  }
         translate <-1.749661  0.000000  0.000000>
         scale     < 50.828715  1.000000  1.000000>
         translate <-0.034423  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -76.543140>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  7.000000 -4.100000>
       }
      quadric {
         Dot
         scale     < 1.725000  1.725000  1.725000>
         translate < 2.000000  5.763930 -3.804230>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.724649  }
         plane {     < 1.000000  0.000000  0.000000>  1.699654 inverse  }
         translate <-1.724649  0.000000  0.000000>
         scale     < 49.580681  1.000000  1.000000>
         translate <-0.034785  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -58.430464>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  5.763930 -3.804230>
       }
      quadric {
         Dot
         scale     < 1.700000  1.700000  1.700000>
         translate < 2.000000  4.707640 -3.155170>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.699636  }
         plane {     < 1.000000  0.000000  0.000000>  1.674642 inverse  }
         translate <-1.699636  0.000000  0.000000>
         scale     < 48.333614  1.000000  1.000000>
         translate <-0.035165  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -40.312468>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  4.707640 -3.155170>
       }
      quadric {
         Dot
         scale     < 1.675000  1.675000  1.675000>
         translate < 2.000000  3.925730 -2.233580>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.674622  }
         plane {     < 1.000000  0.000000  0.000000>  1.649628 inverse  }
         translate <-1.674622  0.000000  0.000000>
         scale     < 47.085614  1.000000  1.000000>
         translate <-0.035565  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -22.187811>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  3.925730 -2.233580>
       }
      quadric {
         Dot
         scale     < 1.650000  1.650000  1.650000>
         translate < 2.000000  3.481090 -1.143360>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.649607  }
         plane {     < 1.000000  0.000000  0.000000>  1.624613 inverse  }
         translate <-1.649607  0.000000  0.000000>
         scale     < 45.838371  1.000000  1.000000>
         translate <-0.035987  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -4.056770>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  3.481090 -1.143360>
       }
      quadric {
         Dot
         scale     < 1.625000  1.625000  1.625000>
         translate < 2.000000  3.400000  0.000000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.624592  }
         plane {     < 1.000000  0.000000  0.000000>  1.599598 inverse  }
         translate <-1.624592  0.000000  0.000000>
         scale     < 44.591492  1.000000  1.000000>
         translate <-0.036433  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  14.081606>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  3.400000  0.000000>
       }
      quadric {
         Dot
         scale     < 1.600000  1.600000  1.600000>
         translate < 2.000000  3.671300  1.081560>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.599574  }
         plane {     < 1.000000  0.000000  0.000000>  1.574581 inverse  }
         translate <-1.599574  0.000000  0.000000>
         scale     < 43.344743  1.000000  1.000000>
         translate <-0.036904  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  32.228223>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  3.671300  1.081560>
       }
      quadric {
         Dot
         scale     < 1.575000  1.575000  1.575000>
         translate < 2.000000  4.249340  1.998470>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.574556  }
         plane {     < 1.000000  0.000000  0.000000>  1.549563 inverse  }
         translate <-1.574556  0.000000  0.000000>
         scale     < 42.098506  1.000000  1.000000>
         translate <-0.037402  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  50.383341>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  4.249340  1.998470>
       }
      quadric {
         Dot
         scale     < 1.550000  1.550000  1.550000>
         translate < 2.000000  5.060310  2.669760>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.549536  }
         plane {     < 1.000000  0.000000  0.000000>  1.524543 inverse  }
         translate <-1.549536  0.000000  0.000000>
         scale     < 40.852194  1.000000  1.000000>
         translate <-0.037930  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  68.548311>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  5.060310  2.669760>
       }
      quadric {
         Dot
         scale     < 1.525000  1.525000  1.525000>
         translate < 2.000000  6.011150  3.043380>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.524514  }
         plane {     < 1.000000  0.000000  0.000000>  1.499522 inverse  }
         translate <-1.524514  0.000000  0.000000>
         scale     < 39.606164  1.000000  1.000000>
         translate <-0.038492  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  86.722912>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 2.000000  6.011150  3.043380>
       }
      quadric {
         Dot
         scale     < 1.500000  1.500000  1.500000>
         translate < 2.000000  7.000000  3.100000>
       }
    }
   texture {
      YourTexture
    }
   bounded_by {
      quadric {
         Dot
         scale < 11.279669  11.279669  11.279669>
         translate < 2.000000  5.737500  0.575000>
       }
    }
 }



#declare turn444 =
object {
   union {
    }
   texture {
      YourTexture
    }
   bounded_by {
      quadric {
         Dot
         scale < 5.527432  5.527432  5.527432>
         translate < 3.000000  0.000000  3.500000>
       }
    }
 }



#declare turn445 =
object {
   union {
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.995579  }
         plane {     < 1.000000  0.000000  0.000000>  1.496684 inverse  }
         translate <-1.496684  0.000000  0.000000>
         scale     < 15.014660  1.000000  1.000000>
         translate < 0.099682  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -68.491147>
         rotate    < 0.000000 -43.531199  0.000000>
         translate < 2.000000  7.000000  3.100000>
       }
      quadric {
         Dot
         scale     < 2.000000  2.000000  2.000000>
         translate < 4.000000  0.000000  5.000000>
       }
      intersection {
         Connector_1
         scale     < 7.000000  2.000000  2.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate < 4.000000  0.000000  5.000000>
       }
      quadric {
         Dot
         scale     < 2.000000  2.000000  2.000000>
         translate < 4.000000  7.000000  5.000000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.999745  }
         plane {     < 1.000000  0.000000  0.000000>  1.974748 inverse  }
         translate <-1.999745  0.000000  0.000000>
         scale     < 62.565615  1.000000  1.000000>
         translate <-0.031962  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  80.999878>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  7.000000  5.000000>
       }
      quadric {
         Dot
         scale     < 1.975000  1.975000  1.975000>
         translate < 4.000000  8.545080  4.755280>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.974744  }
         plane {     < 1.000000  0.000000  0.000000>  1.949747 inverse  }
         translate <-1.974744  0.000000  0.000000>
         scale     < 62.066108  1.000000  1.000000>
         translate <-0.031817  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  59.351003>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  8.545080  4.755280>
       }
      quadric {
         Dot
         scale     < 1.950000  1.950000  1.950000>
         translate < 4.000000  9.880150  3.964180>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.949736  }
         plane {     < 1.000000  0.000000  0.000000>  1.924740 inverse  }
         translate <-1.949736  0.000000  0.000000>
         scale     < 60.816570  1.000000  1.000000>
         translate <-0.032059  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  41.275851>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  9.880150  3.964180>
       }
      quadric {
         Dot
         scale     < 1.925000  1.925000  1.925000>
         translate < 4.000000  10.883280  2.821370>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.924729  }
         plane {     < 1.000000  0.000000  0.000000>  1.899732 inverse  }
         translate <-1.924729  0.000000  0.000000>
         scale     < 59.567962  1.000000  1.000000>
         translate <-0.032311  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  23.197883>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  10.883280  2.821370>
       }
      quadric {
         Dot
         scale     < 1.900000  1.900000  1.900000>
         translate < 4.000000  11.469970  1.452380>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.899721  }
         plane {     < 1.000000  0.000000  0.000000>  1.874724 inverse  }
         translate <-1.899721  0.000000  0.000000>
         scale     < 58.318991  1.000000  1.000000>
         translate <-0.032575  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  5.115989>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  11.469970  1.452380>
       }
      quadric {
         Dot
         scale     < 1.875000  1.875000  1.875000>
         translate < 4.000000  11.600000  0.000000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.874712  }
         plane {     < 1.000000  0.000000  0.000000>  1.849716 inverse  }
         translate <-1.874712  0.000000  0.000000>
         scale     < 57.070452  1.000000  1.000000>
         translate <-0.032849  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -12.969066>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  11.600000  0.000000>
       }
      quadric {
         Dot
         scale     < 1.850000  1.850000  1.850000>
         translate < 4.000000  11.279750 -1.390580>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.849703  }
         plane {     < 1.000000  0.000000  0.000000>  1.824707 inverse  }
         translate <-1.849703  0.000000  0.000000>
         scale     < 55.821522  1.000000  1.000000>
         translate <-0.033136  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -31.057459>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  11.279750 -1.390580>
       }
      quadric {
         Dot
         scale     < 1.825000  1.825000  1.825000>
         translate < 4.000000  10.559680 -2.586260>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.824694  }
         plane {     < 1.000000  0.000000  0.000000>  1.799698 inverse  }
         translate <-1.824694  0.000000  0.000000>
         scale     < 54.573047  1.000000  1.000000>
         translate <-0.033436  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -49.151087>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  10.559680 -2.586260>
       }
      quadric {
         Dot
         scale     < 1.800000  1.800000  1.800000>
         translate < 4.000000  9.527480 -3.478770>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.799684  }
         plane {     < 1.000000  0.000000  0.000000>  1.774688 inverse  }
         translate <-1.799684  0.000000  0.000000>
         scale     < 53.325136  1.000000  1.000000>
         translate <-0.033749  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -67.247950>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  9.527480 -3.478770>
       }
      quadric {
         Dot
         scale     < 1.775000  1.775000  1.775000>
         translate < 4.000000  8.297870 -3.994440>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.774673  }
         plane {     < 1.000000  0.000000  0.000000>  1.749677 inverse  }
         translate <-1.774673  0.000000  0.000000>
         scale     < 52.076627  1.000000  1.000000>
         translate <-0.034078  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -85.350182>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 4.000000  8.297870 -3.994440>
       }
      quadric {
         Dot
         scale     < 1.750000  1.750000  1.750000>
         translate < 4.000000  7.000000 -4.100000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.749661  }
         plane {     < 1.000000  0.000000  0.000000>  1.724666 inverse  }
         translate <-1.749661  0.000000  0.000000>
         scale     < 50.828715  1.000000  1.000000>
         translate <-0.034423  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -76.543140>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  7.000000 -4.100000>
       }
      quadric {
         Dot
         scale     < 1.725000  1.725000  1.725000>
         translate < 4.000000  5.763930 -3.804230>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.724649  }
         plane {     < 1.000000  0.000000  0.000000>  1.699654 inverse  }
         translate <-1.724649  0.000000  0.000000>
         scale     < 49.580681  1.000000  1.000000>
         translate <-0.034785  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -58.430464>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  5.763930 -3.804230>
       }
      quadric {
         Dot
         scale     < 1.700000  1.700000  1.700000>
         translate < 4.000000  4.707640 -3.155170>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.699636  }
         plane {     < 1.000000  0.000000  0.000000>  1.674642 inverse  }
         translate <-1.699636  0.000000  0.000000>
         scale     < 48.333614  1.000000  1.000000>
         translate <-0.035165  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -40.312468>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  4.707640 -3.155170>
       }
      quadric {
         Dot
         scale     < 1.675000  1.675000  1.675000>
         translate < 4.000000  3.925730 -2.233580>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.674622  }
         plane {     < 1.000000  0.000000  0.000000>  1.649628 inverse  }
         translate <-1.674622  0.000000  0.000000>
         scale     < 47.085614  1.000000  1.000000>
         translate <-0.035565  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -22.187811>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  3.925730 -2.233580>
       }
      quadric {
         Dot
         scale     < 1.650000  1.650000  1.650000>
         translate < 4.000000  3.481090 -1.143360>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.649607  }
         plane {     < 1.000000  0.000000  0.000000>  1.624613 inverse  }
         translate <-1.649607  0.000000  0.000000>
         scale     < 45.838371  1.000000  1.000000>
         translate <-0.035987  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -4.056770>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  3.481090 -1.143360>
       }
      quadric {
         Dot
         scale     < 1.625000  1.625000  1.625000>
         translate < 4.000000  3.400000  0.000000>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.624592  }
         plane {     < 1.000000  0.000000  0.000000>  1.599598 inverse  }
         translate <-1.624592  0.000000  0.000000>
         scale     < 44.591492  1.000000  1.000000>
         translate <-0.036433  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  14.081606>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  3.400000  0.000000>
       }
      quadric {
         Dot
         scale     < 1.600000  1.600000  1.600000>
         translate < 4.000000  3.671300  1.081560>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.599574  }
         plane {     < 1.000000  0.000000  0.000000>  1.574581 inverse  }
         translate <-1.599574  0.000000  0.000000>
         scale     < 43.344743  1.000000  1.000000>
         translate <-0.036904  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  32.228223>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  3.671300  1.081560>
       }
      quadric {
         Dot
         scale     < 1.575000  1.575000  1.575000>
         translate < 4.000000  4.249340  1.998470>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.574556  }
         plane {     < 1.000000  0.000000  0.000000>  1.549563 inverse  }
         translate <-1.574556  0.000000  0.000000>
         scale     < 42.098506  1.000000  1.000000>
         translate <-0.037402  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  50.383341>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  4.249340  1.998470>
       }
      quadric {
         Dot
         scale     < 1.550000  1.550000  1.550000>
         translate < 4.000000  5.060310  2.669760>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.549536  }
         plane {     < 1.000000  0.000000  0.000000>  1.524543 inverse  }
         translate <-1.549536  0.000000  0.000000>
         scale     < 40.852194  1.000000  1.000000>
         translate <-0.037930  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  68.548311>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  5.060310  2.669760>
       }
      quadric {
         Dot
         scale     < 1.525000  1.525000  1.525000>
         translate < 4.000000  6.011150  3.043380>
       }
      intersection {
         quadric { Connector_2  }
         plane {     < 1.000000  0.000000  0.000000>  1.524514  }
         plane {     < 1.000000  0.000000  0.000000>  1.499522 inverse  }
         translate <-1.524514  0.000000  0.000000>
         scale     < 39.606164  1.000000  1.000000>
         translate <-0.038492  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  86.722912>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 4.000000  6.011150  3.043380>
       }
      quadric {
         Dot
         scale     < 1.500000  1.500000  1.500000>
         translate < 4.000000  7.000000  3.100000>
       }
    }
   texture {
      YourTexture
    }
   bounded_by {
      quadric {
         Dot
         scale < 11.544736  11.544736  11.544736>
         translate < 3.000000  5.737500  0.575000>
       }
    }
 }



#declare turns =
composite {
   object { turn441  }
   object { turn442  }
   object { turn443  }
   object { turn444  }
   object { turn445  }
   bounded_by {
      quadric {
         Dot
         scale < 11.905920  11.905920  11.905920>
         translate < 2.000000  5.737500  0.575000>
       }
    }
 }







