//----------- one fish include....3/13/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//------------ FISH SKIN-----------------------
#declare YourTexture =
texture {
   pigment { image_map { gif "FinSkin2.gif" } }
   //pigment { image_map { png "FishHead2.png" } }  // taken from station.pov
   finish { ambient 0.2 diffuse 0.5 phong 1 phong_size 80 }
   scale <100, 60, 1>
   translate <-50, -30, -1>
}

//------------- CTDS INFO -----------------------

// Infinite cone in Y axis, rotated to X axis
#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

//------------ START THE BODY CURVES OF FISH-----------
#declare YourThing1 =
object {
  union {
    difference {
      union {
        sphere { 0,  7    translate <-37.00001, -8,       0> }
        sphere { 0,  7.6  translate <-35.00583, -8.06659, 0> }
        sphere { 0,  8.2  translate <-33.01163, -8.00077, 0> }
        sphere { 0,  8.8  translate <-31.02618, -7.80283, 0> }
        sphere { 0,  9.4  translate <-29.05824, -7.47364, 0> }
        sphere { 0, 10.0  translate <-27.11646, -7.01465, 0> }
        sphere { 0, 10.6  translate <-25.20940, -6.42788, 0> }
        sphere { 0, 11.2  translate <-23.34546, -5.71591, 0> }
        sphere { 0, 11.8  translate <-21.53284, -4.88188, 0> }
        sphere { 0, 12.4  translate <-19.77953, -3.92947, 0> }
        sphere { 0, 13    translate <-18.09325, -2.86286, 0> }
        sphere { 0, 12.72 translate <-16.76339, -1.98805, 0> }
        sphere { 0, 12.44 translate <-15.39894, -1.16823, 0> }
        sphere { 0, 12.16 translate <-14.00216, -0.40478, 0> }
        sphere { 0, 11.88 translate <-12.57539,  0.30104, 0> }
        sphere { 0, 11.6  translate <-11.12101,  0.94805, 0> }
        sphere { 0, 11.32 translate < -9.64144,  1.53517, 0> }
        sphere { 0, 11.04 translate < -8.13914,  2.06141, 0> }
        sphere { 0, 10.76 translate < -6.61662,  2.52592, 0> }
        sphere { 0, 10.48 translate < -5.07640,  2.92791, 0> }
      }
      //----------------- chops off front face & hollow mouth
      plane { x, 0 translate <-30, -10, 0> rotate z*45 }
      sphere { 0, 10 translate <-27, -7, 0> }
    }
    //---------------- add chin
    union {
      difference {
        sphere { 0, 11 }
        plane { y, 0 inverse translate y*-7 rotate z*23 }
        translate <-30, -6, 0>
      }
      //----------------- lower lip
      difference {
        cylinder { 0, y, 1 scale <11, 1.5, 9> rotate z*23 translate <-29, -14, 0> }
        sphere {0, 8.5 translate <-31, -7, 0> }
      }
    }
  }
  texture { YourTexture }
}

#declare YourThing =
union {
   sphere { 0, 10.2     translate <-3.52107,  3.2667,  0> texture { YourTexture } }
   sphere { 0, 9.92     translate <-1.95321,  3.54175, 0> texture { YourTexture } }
   sphere { 0, 9.64     translate <-0.37543,  3.75258, 0> texture { YourTexture } }
   sphere { 0, 9.36     translate < 1.20964,  3.89886, 0> texture { YourTexture } }
   sphere { 0, 9.08     translate < 2.79936,  3.98032, 0> texture { YourTexture } }
   sphere { 0, 8.8      translate < 4.39108,  3.99685, 0> texture { YourTexture } }
   sphere { 0, 8.52     translate < 5.98215,  3.94841, 0> texture { YourTexture } }
   sphere { 0, 8.24     translate < 7.56991,  3.83507, 0> texture { YourTexture } }
   sphere { 0, 7.96     translate < 9.15173,  3.65704, 0> texture { YourTexture } }
   sphere { 0, 7.68     translate <10.72497,  3.41461, 0> texture { YourTexture } }
   sphere { 0, 7.4      translate <12.287,    3.10817, 0> texture { YourTexture } }
   sphere { 0, 7.12     translate <13.83522,  2.73825, 0> texture { YourTexture } }
   sphere { 0, 6.84     translate <15.36706,  2.30546, 0> texture { YourTexture } }
   sphere { 0, 6.56     translate <16.87996,  1.81051, 0> texture { YourTexture } }
   sphere { 0, 6.28     translate <18.37141,  1.25424, 0> texture { YourTexture } }
   sphere { 0, 6        translate <19.83891,  0.63757, 0> texture { YourTexture } }
   sphere { 0, 5.75     translate <21.20012,  0.0009,  0> texture { YourTexture } }
   sphere { 0, 5.5      translate <22.53579, -0.68773, 0> texture { YourTexture } }
   sphere { 0, 5.25     translate <23.84394, -1.42731, 0> texture { YourTexture } }
   sphere { 0, 5.0      translate <25.12262, -2.21674, 0> texture { YourTexture } }
   sphere { 0, 4.75     translate <26.36994, -3.05485, 0> texture { YourTexture } }
   sphere { 0, 4.5      translate <27.58405, -3.94038, 0> texture { YourTexture } }
   sphere { 0, 4.25     translate <28.76314, -4.87204, 0> texture { YourTexture } }
   sphere { 0, 4        translate <29.90546, -5.84843, 0> texture { YourTexture } }
   sphere { 0, 3.75     translate <31.00932, -6.8681,  0> texture { YourTexture } }
   sphere { 0, 3.5      translate <32.07307, -7.92954, 0> texture { YourTexture } }
   sphere { 0, 3.775    translate <30.65799, -7.04318, 0> texture { YourTexture } }
   sphere { 0, 4.05     translate <29.20569, -6.21921, 0> texture { YourTexture } }
   sphere { 0, 4.325    translate <27.71892, -5.45921, 0> texture { YourTexture } }
   sphere { 0, 4.6      translate <26.2005,  -4.7646,  0> texture { YourTexture } }
   sphere { 0, 4.875    translate <24.65329, -4.1367,  0> texture { YourTexture } }
   sphere { 0, 5.15     translate <23.08024, -3.5767,  0> texture { YourTexture } }
   sphere { 0, 5.425    translate <21.48431, -3.08567, 0> texture { YourTexture } }
   sphere { 0, 5.7      translate <19.86854, -2.66452, 0> texture { YourTexture } }
   sphere { 0, 5.975    translate <18.23597, -2.31407, 0> texture { YourTexture } }
   sphere { 0, 6.25     translate <16.5897,  -2.03496, 0> texture { YourTexture } }
   sphere { 0, 6.525    translate <14.93285, -1.82774, 0> texture { YourTexture } }
   sphere { 0, 6.8      translate <13.26856, -1.69279, 0> texture { YourTexture } }
   sphere { 0, 7.075    translate <11.59997, -1.63037, 0> texture { YourTexture } }
   sphere { 0, 7.35     translate < 9.93024, -1.64059, 0> texture { YourTexture } }
   sphere { 0, 7.625    translate < 8.26254, -1.72344, 0> texture { YourTexture } }
   sphere { 0, 7.9      translate < 6.60002, -1.87876, 0> texture { YourTexture } }
   sphere { 0, 8.175    translate < 4.94583, -2.10626, 0> texture { YourTexture } }
   sphere { 0, 8.45     translate < 3.3031,  -2.4055,  0> texture { YourTexture } }
   sphere { 0, 8.725    translate < 1.67495, -2.77592, 0> texture { YourTexture } }
   sphere { 0, 9        translate < 0.06445, -3.21682, 0> texture { YourTexture } }
   sphere { 0, 9.57143  translate <-2.33701, -4.57577, 0> texture { YourTexture } }
   sphere { 0, 10.14286 translate <-4.93599, -5.50266, 0> texture { YourTexture } }
   sphere { 0, 10.71428 translate <-7.65543, -5.96999, 0> texture { YourTexture } }
   sphere { 0, 11.28571 translate <-10.41473,-5.96393, 0> texture { YourTexture } }
   sphere { 0, 11.85714 translate <-13.1321, -5.48465, 0> texture { YourTexture } }
   sphere { 0, 12.42857 translate <-15.72697,-4.54635, 0> texture { YourTexture } }
   sphere { 0, 13       translate <-18.12244,-3.17686, 0> texture { YourTexture } }
}

//----------- COMBINES BODY SECTION IN ONE COMPOSITE ----
#declare fish_body =
union {
   object { YourThing1 }
   object { YourThing }
}

//----------- ENDS BODY ------------------------------

// ----------- 2 lower dangling fins
#declare spike1 =
union {
  sphere { 0, 0.1 translate <-5, -7.00001, 5> texture { YourTexture } }
  object { Connector_2
      clipped_by {
         plane { x, 0.279490 }
         plane { x, 0.099818 inverse }
      }
      translate x*-0.099818
      scale <16.543659, 1, 1>
      translate x*0.006034
      rotate z*69.224366
      rotate y*109.091249
      translate <-5, -7.00001, 5>
      texture { YourTexture }
  }
  sphere { 0, 0.28 translate <-5.34611, -4.2107, 4> texture { YourTexture } }
  object { Connector_2
     clipped_by {
        plane { x, 0.459162 }
        plane { x, 0.279490 inverse }
     }
     translate x*-0.27949
     scale <16.543617, 1, 1>
     translate x*0.016894
     rotate z*70.110802
     rotate y*99.836716
     translate <-5.34611, -4.2107, 4>
     texture { YourTexture }
  }
  sphere { 0, 0.46 translate <-5.5195, -1.40536, 3> texture { YourTexture } }
  object { Connector_2
     clipped_by {
        plane { x, 0.638834 }
        plane { x, 0.459162 inverse }
     }
     translate x*-0.459162
     scale <16.543652, 1, 1>
     translate x*0.027755
     rotate z*70.415293
     rotate y*90
     translate <-5.5195, -1.40536, 3>
     texture { YourTexture }
  }
  sphere { 0, 0.64 translate <-5.5195, 1.40534, 2> texture { YourTexture } }
  object { Connector_2
     clipped_by {
        plane { x, 0.818506 }
        plane { x, 0.638834 inverse }
     }
     translate x*-0.638834
     scale <16.543666, 1, 1>
     translate x*0.038615
     rotate z*70.110898
     rotate y*80.16384
     translate <-5.5195, 1.40534, 2>
     texture { YourTexture }
  }
  sphere { 0, 0.82 translate <-5.34612, 4.21069, 1> texture { YourTexture } }
  object { Connector_2
     clipped_by {
        plane { x, 0.998178 }
        plane { x, 0.818506 inverse }
     }
     translate x*-0.818506
     scale <16.543614, 1, 1>
     translate x*0.049476
     rotate z*69.224239
     rotate y*70.908240
     translate <-5.34612, 4.21069, 1>
     texture { YourTexture }
  }
  sphere { 0, 1 translate <-5, 6.99999, 0> texture { YourTexture } }
}

#declare spike2 =
union {
   cylinder { -x, x, 1
      scale <10, 1, 1>
      rotate z*0.000057
      translate <-5, 6.99999, 0>
      texture { YourTexture }
   }
   sphere { 0, 1 translate <5, 7, 0> texture { YourTexture } }
   object { Connector_2
      clipped_by {
         plane { x, 0.998178 }
         plane { x, 0.818506 inverse }
      }
      translate x*-0.998178
      scale <16.543666, 1, 1>
      translate x*-0.060336
      rotate y*180
      rotate z*-69.224308
      rotate y*-70.90824
      translate <5, 7, 0>
      texture { YourTexture }
   }
   sphere { 0, 0.82 translate <5.34612, 4.21069, 1> texture { YourTexture } }
   object { Connector_2
      clipped_by {
         plane { x, 0.818506 }
         plane { x, 0.638834 inverse }
      }
      translate x*-0.818506
      scale <16.543666, 1, 1>
      translate x*-0.049475
      rotate y*180
      rotate z*-70.110898
      rotate y*-80.16384
      translate <5.34612, 4.21069, 1>
      texture { YourTexture }
   }
   sphere { 0, 0.64 translate <5.5195, 1.40534, 2> texture { YourTexture } }
   object { Connector_2
      clipped_by {
         plane { x, 0.638834 }
         plane { x, 0.459162 inverse }
      }
      translate x*-0.638834
      scale <16.543652, 1, 1>
      translate x*-0.038615
      rotate y*180.0
      rotate z*-70.415293
      rotate y*-90
      translate <5.5195, 1.40534, 2>
      texture { YourTexture }
   }
   sphere { 0, 0.46 translate <5.5195, -1.40536, 3> texture { YourTexture } }
   object { Connector_2
      clipped_by {
         plane { x, 0.459162 }
         plane { x, 0.279490 inverse }
      }
      translate x*-0.459162
      scale <16.543617, 1, 1>
      translate x*-0.027755
      rotate y*180.0
      rotate z*-70.110802
      rotate y*-99.836716
      translate <5.519500, -1.40536, 3>
      texture { YourTexture }
   }
   sphere { 0, 0.28 translate <5.34611, -4.2107, 4> texture { YourTexture } }
   object { Connector_2
      clipped_by {
         plane { x, 0.279490 }
         plane { x, 0.099818 inverse }
      }
      translate x*-0.27949
      scale <16.543659, 1, 1>
      translate x*-0.016894
      rotate y*180
      rotate z*-69.224366
      rotate y*-109.091249
      translate <5.34611, -4.2107, 4>
      texture { YourTexture }
   }
   sphere { 0, 1 scale 0.1 translate <5, -7.00001, 5> texture { YourTexture } }
}

//-------------- COMBINE SPIKE -----------------------
#declare l_fin =
union {
   object { spike1 }
   object { spike2 }
}

//--------------- Bass Fins...Spiked fingers, bloody fingers
//-------------- MAKE POINTS --------------------------------
#declare bf1 =
object {
   Connector_2
   clipped_by {
      plane { x, 0.995942 }
      plane { x, 0.099594 inverse }
   }
   translate x*-0.99594
   scale <11.066020, 1, 1>
   translate x*-0.09
   rotate y*180
   rotate z*90
   texture { YourTexture }
}

#declare bf2 =
object {
   Connector_2
   clipped_by {
      plane { x, 0.997018 }
      plane { x, 0.099702 inverse }
   }
   translate x*-0.997018
   scale <12.919026, 1, 1>
   translate x*-0.077174
   rotate y*180
   rotate z*59.036243
   translate <3, 1, 0>
   texture { YourTexture }
}

#declare bf3 =
object {
   Connector_2
   clipped_by {
      plane { x, 0.995439 }
      plane { x, 0.099544 inverse }
   }
   translate x*-0.995439
   scale < 10.434392, 1, 1>
   translate x*-0.095400
   rotate y*180
   rotate z*57.994617
   translate < 9.0,  2.0,  0>
   texture { YourTexture }
}

#declare bf4 =
object {
   Connector_2
   clipped_by {
      plane { x, 0.993750 }
      plane { x, 0.099375 inverse }
   }
   translate x*-0.99375
   scale <8.902074, 1, 1>
   translate x*-0.111631
   rotate y*180
   rotate z*60.255119
   translate <13, 2, 0>
   texture { YourTexture }
}

#declare bf5 =
object {
   Connector_2
   clipped_by {
      plane { x, 0.993338 }
      plane { x, 0.099334 inverse }
   }
   translate x*-0.993338
   scale <8.620246, 1, 1>
   translate x*-0.115233
   rotate y*180
   rotate z*50.194429
   translate <17, 2, 0>
   texture { YourTexture }
}

#declare bf6 =
object {
   Connector_2
   clipped_by {
      plane { x, 0.994512 }
      plane { x, 0.099451 inverse }
   }
   translate x*-0.994512
   scale <9.505684, 1, 1>
   translate x*-0.104623
   rotate y*180
   rotate z*35.537678
   translate <20, 2, 0>
   texture { YourTexture }
}

#declare bf7 =
object {
   Connector_2
   clipped_by {
      plane { x, 0.992993 }
      plane { x, 0.099299 inverse }
   }
   translate x*-0.992993
   scale <8.402674, 1, 1>
   translate x*-0.118176
   rotate y*180
   rotate z*23.198591
   translate <23, 1, 0>
   texture { YourTexture }
}

//-------------------- COMBINE ALL SPIKES ---------------
#declare pnts =
union {
   object { bf1 }
   object { bf2 }
   object { bf3 }
   object { bf4 }
   object { bf5 }
   object { bf6 }
   object { bf7 }
}

//------------ THIN SKIN BETWEEN THE SPIKES------------------------------------
#declare fin_skin =
object {
  difference {
    box { -1, 1 scale <15, 5, 0.1> translate <15, 5, 0> }
    cylinder { z, -z, 1 scale <4,   6,   1> rotate z*-32 translate <5,    12,   0> }
    cylinder { z, -z, 1 scale <2.5, 3.5, 1> rotate z*-32 translate <11.5, 11,   0> }
    cylinder { z, -z, 1 scale <1.6, 2.5, 1> rotate z*-31 translate <15.5, 10,   0> }
    cylinder { z, -z, 1 scale <2.5, 3.5, 1> rotate z*-38 translate <20,    9.5, 0> }
    cylinder { z, -z, 1 scale <3,   4.1, 1> rotate z*-40 translate <26,   10,   0> }
    cylinder { z, -z, 1 scale <3,   4.5, 1> rotate z*-51 translate <30.5,  7.5, 0> }
    cylinder { z, -z, 1 scale <3,   4,   1> rotate z*-39 translate <32,    2,   0> }
  }
  texture { YourTexture }
}

#declare fin = union {
  object { pnts }
  object { fin_skin }
}

#declare tail =
object {
  difference {
    union {
      sphere { 0, 1 scale <10, 5, 0.5> rotate z*-14 translate <9, -4, 0> }
      sphere { 0, 1 scale <10, 5, 0.5> rotate z*-52 translate <7, -8, 0> }
    }
    plane { y, 0 rotate z*53 translate <14, -9, 0> }
  }
}

//------------ upper lip

#declare u_lip =
object {
  difference {
    sphere { 0, 11 }
    sphere { 0, 1 scale <10, 18, 20> rotate z*30 translate <-9, -6, 0> }
    plane { y, 0 rotate z*-48 translate x*1.6 inverse }
  }
}

//--------------- GLASS FISH EYE --------------
#declare eye =
union {
  //-------------- extra skin around eye
  sphere { 0, 1 scale <5, 5, 3> texture { YourTexture } }
  //-------------- color pupil
  sphere { 0, 4
    texture { pigment { image_map { gif "FishEye.gif" } } scale <8, 8, 1> translate <-4, -4, -1> }
    //texture { pigment { image_map { png "FishEye.png" } } scale <8, 8, 1> translate <-4, -4, -1> } // taken from station.pov
  }
  //-------------- glass sphere {
  sphere { 0, 5 
    material {
      texture {
        pigment { color rgbf <0.98, 1, 0.98, 1> }
        finish { diffuse 0 specular 1 roughness 0.001 reflection { 0, 1 fresnel on } }
      }
      interior { ior 1.47 }
    }
  }
}

//------ BUILD THE FISH---------------
#declare fish = 
union {
  object { fish_body scale <1, 1, 0.6> }
  object { eye translate <-26, -2, -4> }
  object { eye translate <-26, -2, 4> }
  object { pnts scale <1.3, 1.7, 0.4> translate <-17, 7, 0> }
  object { fin_skin scale <1.3, 1.7, 0.4> translate <-17, 7, 0> texture { YourTexture } }
  object { fin scale <0.7, 1, 0.7> rotate x*180 rotate z*20 translate <-6, -10, 0> }
  object { l_fin rotate y*90 scale 1 translate <-14, -20, 0> }
  object { tail translate <33, -8, 0> texture { YourTexture } }
  object { u_lip rotate z*5 scale <1, 0.96, 0.65> translate <-32, -8.5, 0> texture { YourTexture } }
}