//--------- world sphere w/ Violet Clouds---3/10/92 miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Violet_Sky =
pigment {
  gradient y
  colour_map {
    [0.000, 0.339  colour rgb <0.208, 0.067, 0.235> colour rgb <0.498, 0.165, 0.514>]
    [0.339, 0.559  colour rgb <0.498, 0.165, 0.514> colour rgb <0.624, 0.165, 0.514>]
    [0.559, 0.686  colour rgb <0.624, 0.165, 0.514> colour rgb <0.835, 0.400, 0.514>]
    [0.686, 0.983  colour rgb <0.835, 0.400, 0.514> colour rgb <0.988, 0.651, 0.631>]
    [0.983, 1.001  colour rgb <0.988, 0.651, 0.631> colour rgb <0.208, 0.067, 0.235>]
  }
}

#declare deeper12 =
pigment {
  gradient y
  colour_map {
    [0.000, 0.558  colour rgbt <0.133, 0.008, 0.212, 0.375> colour rgbt <0.471, 0.400, 0.506, 0.9>]
    [0.558, 0.983  colour rgbt <0.471, 0.400, 0.506, 0.9>   colour rgbt <1.000, 0.996, 0.996, 0.8>]
    [0.983, 1.001  colour rgbt <1.000, 0.996, 0.996, 0.8>   colour rgbt <0.133, 0.008, 0.212, 0.375>]
  }
}

#declare cloud12 =
pigment {
  bozo
  turbulence 0.8
  colour_map {
    [0.000, 0.212  colour rgbt <1.000, 1.000, 1.000, 1.000> colour rgbt <1.000, 1.000, 1.000, 1.000>]
    [0.212, 0.534  colour rgbt <1.000, 1.000, 1.000, 1.000> colour rgbt <0.341, 0.137, 0.302, 0.604>]
    [0.534, 0.627  colour rgbt <0.341, 0.137, 0.302, 0.604> colour rgbt <0.259, 0.196, 0.302, 0.471>]
    [0.627, 0.983  colour rgbt <0.259, 0.196, 0.302, 0.471> colour rgbt <0.271, 0.216, 0.365, 0.404>]
    [0.983, 1.001  colour rgbt <0.271, 0.216, 0.365, 0.404> colour rgbt <1.000, 1.000, 1.000, 1.000>]
  }
  phase 0.5
}

#declare world12 =
sphere { 0, 1
  hollow on
  scale <20000, 10000, 20000>
  texture { 
    pigment { Violet_Sky } 
    finish { ambient 1 diffuse 0 } 
    scale <40000, 8000, 400000> 
    translate y*5000
  }
  texture { 
    pigment { cloud12 } 
    scale <20000, 8000, 10000> 
    translate <20000, 3000, 0> 
    rotate 0
  }
  texture { 
    pigment { deeper12 } 
    finish { ambient 0.2 diffuse 0.3 } 
    scale <40000, 10000, 10000> 
    translate <6000, 6000, 0> 
    rotate z*20
  }
}

// world taken from cyjack.pov
#declare world_cyjack =
union {
  sphere { 0, 1
    texture {
      pigment {
        gradient y 
        color_map {
          [0,    0.05 color rgb 0 color rgb 0]
          [0.05, 0.1  color rgb 0 color rgb <0.309804, 0.184314, 0.309804>]
          [0.1,  0.2  color rgb <0.309804, 0.184314, 0.309804> color rgb <0.372549, 0.623529, 0.623529>]
          [0.2,  0.3  color rgb <0.372549, 0.623529, 0.623529> color rgb <0.309804, 0.184314, 0.309804>]
          [0.3,  0.4  color rgb <0.309804, 0.184314, 0.309804> color rgb 0]
          [0.4,  1    color rgb 0 color rgb 0]
        }
        scale <0.1, 2, 0.1>
        translate <0, -2, 0>
        turbulence 0.1
      }
      finish {
        ambient 0.6
        diffuse 0
      }
    }
    scale <10000, 10000, 10000>
    rotate x*35
    rotate z*25
  } 
  //--- Ceiling
   plane { y, 2000
     texture {
       pigment {
         gradient y
	     color_map {
           [0,    0.05 color rgb 0 color rgb 0]
           [0.05, 0.1  color rgb 0 color rgb <0.309804, 0.184314, 0.309804>]
           [0.1,  0.2  color rgb <0.309804, 0.184314, 0.309804> color rgb <0.372549, 0.623529, 0.623529>]
           [0.2,  0.5  color rgb <0.372549, 0.623529, 0.623529> color rgb <0.309804, 0.184314, 0.309804>]
           [0.5,  0.7  color rgb <0.309804, 0.184314, 0.309804> color rgb 0]
           [0.7,  1    color rgb 0 color rgb 0]
         }
	 scale <0.3, 2, 0.3>
	 turbulence 0.1
       }
       finish {
         ambient 0.8
         diffuse 0
       }
    }
    scale 10000
  }
  rotate <0,90,20>
}