// --------------- THIS DATA PRODUCES A SHELL W/SLIMMY SNAIL -----------
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Dot = sphere { 0, 1 }

#declare Connector_1 =
object { 
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

// --------------------- FOLLOWING DECLARES COLORS FOR SHELL & SNAIL----

// ----THE BALL JOINTS CONNECTORS---
#declare SNAIL_SKIN =
texture {
  pigment { colour rgb <0.733, 0.486, 0.447> }
  finish { phong 0.7 phong_size 30  ambient 0.15 diffuse 0.9 }
}

// ----THE LONG CONNECTORS---
#declare SNAIL_BONE = 
texture {
  pigment {
    gradient x
    colour_map {
      [0.000 0.244  colour rgbf <0.733, 0.486, 0.447, 0>  colour rgbf <0.545, 0.467, 0.612, 0>]
      [0.244 0.395  colour rgbf <0.545, 0.467, 0.612, 0>  colour rgbf <0.816, 0.612, 0.565, 0>]
      [0.395 0.580  colour rgbf <0.816, 0.612, 0.565, 0>  colour rgbf <0.643, 0.498, 0.569, 0>]
      [0.580 1.001  colour rgbf <0.643, 0.498, 0.569, 0>  colour rgbf <0.733, 0.486, 0.447, 0>]
    }
    scale <0.3, 20, 0.3>
  }
  finish { ambient 0.15 diffuse 0.9 }
}

// ----------------THE_SNAIL's BODY texture ------------
#declare SLIME =
texture {
  pigment {
    gradient x
    colour_map {
      [0.000 0.179  colour rgbf <0.482, 0.349, 0.353, 0>  colour rgbf <0.322, 0.180, 0.278, 0>]
      [0.179 0.368  colour rgbf <0.322, 0.180, 0.278, 0>  colour rgbf <0.365, 0.294, 0.396, 0>]
      [0.368 0.538  colour rgbf <0.365, 0.294, 0.396, 0>  colour rgbf <0.322, 0.180, 0.278, 0>]
      [0.538 0.701  colour rgbf <0.322, 0.180, 0.278, 0>  colour rgbf <0.365, 0.294, 0.318, 0>]
      [0.701 0.846  colour rgbf <0.365, 0.294, 0.318, 0>  colour rgbf <0.322, 0.180, 0.278, 0>]
      [0.846 1.001  colour rgbf <0.322, 0.180, 0.278, 0>  colour rgbf <0.482, 0.349, 0.353, 0>]
    }
  }
}

//#declare BONE2 = texture { pigment { colour CRed filter 1 } finsih { phong 0.7 phong_size 30 }

// -------- antennae color -------------------------------------
#declare ANTLER_COLOR =
texture {
  pigment { color red 0.322 green 0.18 blue 0.278 }
  normal { bumps 0.4 frequency 5 }
  finish { phong 1 }
}

// ------ THE START OF SEA SHELL -----------------------
// -------------- LOCATION OF Rim on SHEEL -------------
#declare snail =
union {
  sphere { 0, 1
    texture { 
      pigment { color red 0.714 green 0.447 blue 0.408 }
      finish { ambient 0.15 phong 1 }
    }
    scale <21, 21, 10>
    translate x*21.5
  }
  object { Connector_2 texture { SNAIL_BONE }
    clipped_by {
      plane { x, 19.971935 }
      plane { x, 19.642398 inverse }
    }
    translate <-19.971935, 0, 0>
    scale     <18.856352, 1, 1>
    translate <-1.059162, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 4.602336>
    rotate <0, 102.281736, 0>
    translate <20, 0, 0>
  }
  object { Dot texture { SNAIL_SKIN } scale <19.670000, 19.670000, 19.670000> translate <18.678750, 0.5,-6.069094> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 19.641377 }
      plane { x, 19.311857 inverse }
    }
    translate <-19.641377, 0, 0>
    scale <18.516243, 1, 1>
    translate <-1.060765, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 4.686815>
    rotate <0, 120.342307, 0>
    translate <18.678750, 0.5,-6.069094>
  }
  object { Dot texture { SNAIL_SKIN } scale <19.340000, 19.340000, 19.340000> translate <15.597848, 1,-11.332500> }
  object { Connector_2 texture { SNAIL_BONE }
    clipped_by {
      plane { x, 19.310796 }
      plane { x, 18.981295 inverse }
    }
    translate <-19.310796, 0, 0>
    scale <18.176180, 1, 1>
    translate <-1.062423, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 4.774441>
    rotate <0, 138.405161, 0>
    translate <15.597848, 1,-11.332500>
  }
  object { Dot texture { SNAIL_SKIN } scale <19.010000, 19.010000, 19.010000> translate <11.120897, 1.5,-15.306602> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 18.980192 }
      plane { x, 18.650710 inverse }
    }
    translate <-18.980192, 0, 0>
    scale <17.836164, 1, 1>
    translate <-1.064141, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 4.865392>
    rotate <0, 156.470421, 0>
    translate <11.120897, 1.5,-15.306602>
  }
  object { Dot texture { SNAIL_SKIN } scale <18.680000, 18.680000, 18.680000> translate <5.735355, 2,-17.651609> }
  object { Connector_2 texture { SNAIL_BONE }
     clipped_by {
       plane { x, 18.649563 }
       plane { x, 18.320101 inverse }
     }
     translate <-18.649563, 0, 0>
     scale <17.496197, 1, 1>
     translate <-1.065921, 0, 0>
     rotate <0, 180, 0>
     rotate <0, 0, 4.959860>
     rotate <0, 174.538218, 0>
     translate <5.735355, 2,-17.651609>
  }
  object { Dot texture { SNAIL_SKIN } scale <18.35, 18.35, 18.35> translate <-0, 2.5,-18.2> }
  object { Connector_2 texture { SNAIL_BONE }
    clipped_by {
      plane { x, 18.318908 }
      plane { x, 17.989467 inverse }
    }
    translate <-18.318908, 0, 0>
    scale <17.156285, 1, 1>
    translate <-1.067767, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.058051>
    rotate <0,-167.391278, 0>
    translate <-0, 2.5,-18.2>
  }
  object { Dot texture { SNAIL_SKIN } scale <18.020000, 18.020000, 18.020000> translate <-5.512863, 3,-16.966848> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 17.988223 }
      plane { x, 17.658805 inverse }
    }
    translate <-17.988223, 0, 0>
    scale <16.816430, 1, 1>
    translate <-1.069681, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.160189>
    rotate <0,-149.317919, 0>
    translate <-5.512863, 3,-16.966848>
  }
  object { Dot texture { SNAIL_SKIN } scale <17.690000, 17.690000, 17.690000> translate <-10.274486, 3.5,-14.141617> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 17.657509 }
      plane { x, 17.328115 inverse }
    }
    translate <-17.657509, 0, 0>
    scale <16.476635, 1, 1>
    translate <-1.071670, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.266517>
    rotate <0,-131.241520, 0>
    translate <-10.274486, 3.5,-14.141617>
  }
  object { Dot texture { SNAIL_SKIN } scale <17.360000, 17.360000, 17.360000> translate <-13.850371, 4,-10.062884> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 17.326762 }
      plane { x, 16.997394 inverse }
    }
    translate <-17.326762, 0, 0>
    scale <16.136905, 1, 1>
    translate <-1.073735, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.377295>
    rotate <0,-113.161873, 0>
    translate <-13.850371, 4,-10.062884>
  }
  object { Dot texture { SNAIL_SKIN } scale <17.030000, 17.030000, 17.030000> translate <-15.939707, 4.5,-5.179125> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 16.995981 }
      plane { x, 16.666640 inverse }
    }
    translate <-16.995981, 0, 0>
    scale <15.797242, 1, 1>
    translate <-1.075883, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.492809>
    rotate <0,-95.078799, 0>
    translate <-15.939707, 4.5,-5.179125>
  }
  object { Dot texture { SNAIL_SKIN } scale <16.7, 16.7, 16.7> translate <-16.4, 5, 0> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 16.665163 }
      plane { x, 16.335852 inverse }
    }
    translate <-16.665163, 0, 0>
    scale <15.457652, 1, 1>
    translate <-1.078117, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.613365>
    rotate <0,-76.992054, 0>
    translate <-16.4, 5, 0>
  }
  object { Dot texture { SNAIL_SKIN } scale <16.370000, 16.370000, 16.370000> translate <-15.254947, 5.5, 4.956633> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 16.334306 }
      plane { x, 16.005025 inverse }
    }
    translate <-16.334306, 0, 0>
    scale <15.118139, 1, 1>
    translate <-1.080444, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.739299>
    rotate <0,-58.901369, 0>
    translate <-15.254947, 5.5, 4.956633>
  }
  object { Dot texture { SNAIL_SKIN } scale <16.040000, 16.040000, 16.040000> translate <-12.685386, 6, 9.216473> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 16.003406 }
      plane { x, 15.674159 inverse }
    }
    translate <-16.003406, 0, 0>
    scale <14.778706, 1, 1>
    translate <-1.082869, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 5.870980>
    rotate <0,-40.806519, 0>
    translate <-12.685386, 6, 9.216473>
  }
  object { Dot texture { SNAIL_SKIN } scale <15.710000, 15.710000, 15.710000> translate <-9.004870, 6.5, 12.394140> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 15.672460 }
      plane { x, 15.343249 inverse }
    }
    translate <-15.672460, 0, 0>
    scale <14.439367, 1, 1>
    translate <-1.085398, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 6.008802>
    rotate <0,-22.707174, 0>
    translate <-9.004870, 6.5, 12.394140>
  }
  object { Dot texture { SNAIL_SKIN } scale <15.380000, 15.380000, 15.380000> translate <-4.622894, 7, 14.227805> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 15.341466 }
      plane { x, 15.012293 inverse }
    }
    translate <-15.341466, 0, 0>
    scale <14.100120, 1, 1>
    translate <-1.088038, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 6.153207>
    rotate <0,-4.603027, 0>
    translate <-4.622894, 7, 14.227805>
  }
  object { Dot texture { SNAIL_SKIN } scale <15.050000, 15.050000, 15.050000> translate <0, 7.5, 14.6> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 15.010419 }
      plane { x, 14.681286 inverse }
    }
    translate <-15.010419, 0, 0>
    scale <13.760977, 1, 1>
    translate <-1.090796, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 6.304672>
    rotate <0, 13.506302, 0>
    translate <0, 7.5, 14.6>
  }
  object { Dot texture { SNAIL_SKIN } scale <14.720000, 14.720000, 14.720000> translate <4.400402, 8, 13.543045> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 14.679314 }
      plane { x, 14.350226 inverse }
    }
    translate <-14.679314, 0, 0>
    scale <13.421942, 1, 1>
    translate <-1.093680, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 6.463725>
    rotate <0, 31.621196, 0>
    translate <4.400402, 8, 13.543045>
  }
  object { Dot texture { SNAIL_SKIN } scale <14.390000, 14.390000, 14.390000> translate <8.158459, 8.5, 11.229156> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 14.348148 }
      plane { x, 14.019108 inverse }
    }
    translate <-14.348148, 0, 0>
    scale <13.083027, 1, 1>
    translate <-1.096699, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 6.630945>
    rotate <0, 49.742072, 0>
    translate <8.158459, 8.5, 11.229156>
  }
  object { Dot texture { SNAIL_SKIN } scale <14.060000, 14.060000, 14.060000> translate <10.937910, 9, 7.946857> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 14.016915 }
      plane { x, 13.687926 inverse }
    }
    translate <-14.016915, 0, 0>
    scale <12.744239, 1, 1>
    translate <-1.099863, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 6.806973>
    rotate <0, 67.869444, 0>
    translate <10.937910, 9, 7.946857>          
  }
  object { Dot texture { SNAIL_SKIN } scale <13.730000, 13.730000, 13.730000> translate <12.515904, 9.5, 4.066664> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 13.685609 }
      plane { x, 13.356676 inverse }
    }
    translate <-13.685609, 0, 0>
    scale <12.405591, 1, 1>
    translate <-1.103181, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 6.992516>
    rotate <0, 86.003826, 0>
    translate <12.515904, 9.5, 4.066664>
  }
  object { Dot texture { SNAIL_SKIN } scale <13.4, 13.4, 13.4> translate <12.8, 10,-0> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 13.354224 }
      plane { x, 13.025351 inverse }
    }
    translate <-13.354224, 0, 0>
    scale <12.067089, 1, 1>
    translate <-1.106665, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 7.188362>
    rotate <0, 104.145808, 0>
    translate <12.8, 10,-0>
  }
  object { Dot texture { SNAIL_SKIN } scale <13.070000, 13.070000, 13.070000> translate <11.831143, 10.5,-3.844171> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 13.022752 }
      plane { x, 12.693945 inverse }
    }
    translate <-13.022752, 0, 0>
    scale <11.728756, 1, 1>
    translate <-1.110327, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 7.395380>
    rotate <0, 122.296057, 0>
    translate <11.831143, 10.5,-3.844171>
  }
  object { Dot texture { SNAIL_SKIN } scale <12.740000, 12.740000, 12.740000> translate <9.772925, 11,-7.100446> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 12.691186 }
      plane { x, 12.362450 inverse }
    }
    translate <-12.691186, 0, 0>
    scale <11.390594, 1, 1>
    translate <-1.114181, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 7.614551>
    rotate <0, 140.455326, 0>
    translate <9.772925, 11,-7.100446>
  }
  object { Dot texture { SNAIL_SKIN } scale <12.410000, 12.410000, 12.410000> translate <6.888843, 11.5,-9.481679> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 12.359516 }
      plane { x, 12.030858 inverse }
    }
    translate <-12.359516, 0, 0>
    scale <11.052630, 1, 1>
    translate <-1.118242, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 7.846957>
    rotate <0, 158.624429, 0>
    translate <6.888843, 11.5,-9.481679>
  }
  object { Dot texture { SNAIL_SKIN } scale <12.080000, 12.080000, 12.080000> translate <3.510433, 12,-10.804002> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 12.027732 }
      plane { x, 11.699160 inverse }
    }
    translate <-12.027732, 0, 0>
    scale <10.714877, 1, 1>
    translate <-1.122526, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 8.093823>
    rotate <0, 176.804323, 0>
    translate <3.510433, 12,-10.804002>
  }
  object { Dot texture { SNAIL_SKIN } scale <11.75, 11.75, 11.75> translate <-0, 12.5,-11> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 11.695822 }
      plane { x, 11.367344 inverse }
    }
    translate <-11.695822, 0, 0>
    scale <10.377358, 1, 1>
    translate <-1.127052, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 8.356523>
    rotate <0,-165.003937, 0>
    translate <-0, 12.5,-11>
  }
  object { Dot texture { SNAIL_SKIN } scale <11.420000, 11.420000, 11.420000> translate <-3.287941, 13,-10.119241> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 11.363773 }
      plane { x, 11.035398 inverse }
    }
    translate <-11.363773, 0, 0>
    scale <10.040091, 1, 1>
    translate <-1.131840, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 8.636612>
    rotate <0,-146.799161, 0>
    translate <-3.287941, 13,-10.119241>
  }
  object { Dot texture { SNAIL_SKIN } scale <11.090000, 11.090000, 11.090000> translate <-6.042432, 13.5,-8.316695> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 11.031570 }
      plane { x, 10.703309 inverse }
    }
    translate <-11.031570, 0, 0>
    scale <9.703114, 1, 1>
    translate <-1.136910, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 8.935839>
    rotate <0,-128.579963, 0>
    translate <-6.042432, 13.5,-8.316695>
  }
  object { Dot texture { SNAIL_SKIN } scale <10.760000, 10.760000, 10.760000> translate <-8.025449, 14,-5.830830> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 10.699195 }
      plane { x, 10.371060 inverse }
    }
    translate <-10.699195, 0, 0>
    scale <9.366447, 1, 1>
    translate <-1.142290, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 9.256214>
    rotate <0,-110.344734, 0>
    translate <-8.025449, 14,-5.830830>
  }
  object { Dot texture { SNAIL_SKIN } scale <10.430000, 10.430000, 10.430000> translate <-9.092100, 14.5,-2.954202> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 10.366628 }
      plane { x, 10.038633 inverse }
    }
    translate <-10.366628, 0, 0>
    scale <9.030126, 1, 1>
    translate <-1.148005, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 9.600018>
    rotate <0,-92.091755, 0>
    translate <-9.092100, 14.5,-2.954202>
  }
  object { Dot texture { SNAIL_SKIN } scale <10.1, 10.1, 10.1> translate <-9.2, 15, 0> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 10.033847 }
      plane { x, 9.706008 inverse }
    }
    translate <-10.033847, 0, 0>
    scale <8.694197, 1, 1>
    translate <-1.154085, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 9.969862>
    rotate <0,-73.818862, 0>
    translate <-9.2, 15, 0>
  }
  object { Dot texture { SNAIL_SKIN } scale <9.770000, 9.770000, 9.770000> translate <-8.407340, 15.5, 2.731710> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 9.700824 }
      plane { x, 9.373161 inverse }
    }
    translate <-9.700824, 0, 0>
    scale <8.358707, 1, 1>
    translate <-1.160565, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 10.368759>
    rotate <0,-55.523638, 0>
    translate <-8.407340, 15.5, 2.731710>
  }
  object { Dot texture { SNAIL_SKIN } scale <9.440000, 9.440000, 9.440000> translate <-6.860464, 16, 4.984419> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 9.367528 }
      plane { x, 9.040062 inverse }
    }
    translate <-9.367528, 0, 0>
    scale <8.023703, 1, 1>
    translate <-1.167482, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 10.800200>
    rotate <0,-37.203272, 0>
    translate <-6.860464, 16, 4.984419>
  }
  object { Dot texture { SNAIL_SKIN } scale <9.110000, 9.110000, 9.110000> translate <-4.772816, 16.5, 6.569218> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 9.033923 }
      plane { x, 8.706679 inverse }
    }
    translate <-9.033923, 0, 0>
    scale <7.689255, 1, 1>
    translate <-1.174876, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 11.268229>
    rotate <0,-18.854426, 0>
    translate <-4.772816, 16.5, 6.569218>
  }
  object { Dot texture { SNAIL_SKIN } scale <8.780000, 8.780000, 8.780000> translate <-2.397972, 17, 7.380199> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 8.699966 }
      plane { x, 8.372974 inverse }
    }
    translate <-8.699966, 0, 0>
    scale <7.355440, 1, 1>
    translate <-1.182793, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 11.777573>
    rotate <0,-0.473103, 0>
    translate <-2.397972, 17, 7.380199>
  }
  object { Dot texture { SNAIL_SKIN } scale <8.45, 8.45, 8.45> translate <0, 17.5, 7.4> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 8.365605 }
      plane { x, 8.038901 inverse }
    }
    translate <-8.365605, 0, 0>
    scale <7.022345, 1, 1>
    translate <-1.191284, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 12.333789>
    rotate <0, 17.945328, 0>
    translate <0, 17.5, 7.4>
  }
  object { Dot texture { SNAIL_SKIN } scale <8.120000, 8.120000, 8.120000> translate <2.175480, 18, 6.695438> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 8.030780 }
      plane { x, 7.704406 inverse }
    }
    translate <-8.030780, 0, 0>
    scale <6.690073, 1, 1>
    translate <-1.200402, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 12.943441>
    rotate <0, 36.406587, 0>
    translate <2.175480, 18, 6.695438>
  }
  object { Dot texture { SNAIL_SKIN } scale <7.790000, 7.790000, 7.790000> translate <3.926405, 18.5, 5.404234> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 7.695421 }
      plane { x, 7.369427 inverse }
    }
    translate <-7.695421, 0, 0>
    scale <6.358767, 1, 1>
    translate <-1.210206, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 13.614295>
    rotate <0, 54.917483, 0>
    translate <3.926405, 18.5, 5.404234>
  }
  object { Dot texture { SNAIL_SKIN } scale <7.460000, 7.460000, 7.460000> translate <5.112987, 19, 3.714803> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 7.359439 }
      plane { x, 7.033888 inverse }
    }
    translate <-7.359439, 0, 0>
    scale <6.028575, 1, 1>
    translate <-1.220759, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 14.355670>
    rotate <0, 73.486397, 0>
    translate <5.112987, 19, 3.714803>
  }
  object { Dot texture { SNAIL_SKIN } scale <7.130000, 7.130000, 7.130000> translate <5.668297, 19.5, 1.841741> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 7.022732 }
      plane { x, 6.697697 inverse }
    }
    translate <-7.022732, 0, 0>
    scale <5.699689, 1, 1>
    translate <-1.232126, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 15.178751>
    rotate <0, 92.123718, 0>
    translate <5.668297, 19.5, 1.841741>
  }
  object { Dot texture { SNAIL_SKIN } scale <6.8, 6.8, 6.8> translate <5.6, 20,-0> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 6.685174 }
      plane { x, 6.360747 inverse }
    }
    translate <-6.685174, 0, 0>
    scale <5.372357, 1, 1>
    translate <-1.244365, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 16.097039>
    rotate <0, 110.842321, 0>
    translate <5.6, 20,-0>
  }
  object { Dot texture { SNAIL_SKIN } scale <6.470000, 6.470000, 6.470000> translate <4.983536, 20.5,-1.619249> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 6.346614 }
      plane { x, 6.022907 inverse }
    }
    translate <-6.346614, 0, 0>
    scale <5.046876, 1, 1>
    translate <-1.257533, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 17.126987>
    rotate <0, 129.658554, 0>
    translate <4.983536, 20.5,-1.619249>
  }
  object { Dot texture { SNAIL_SKIN } scale <6.140000, 6.140000, 6.140000> translate <3.948003, 21,-2.868392> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 6.006869 }
      plane { x, 5.684024 inverse }
    }
    translate <-6.006869, 0, 0>
    scale <4.723632, 1, 1>
    translate <-1.271663, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 18.288684>
    rotate <0, 148.593386, 0>
    translate <3.948003, 21,-2.868392>
  }
  object { Dot texture { SNAIL_SKIN } scale <5.810000, 5.810000, 5.810000> translate <2.656789, 21.5,-3.656757> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 5.665718 }
      plane { x, 5.343913 inverse }
    }
    translate <-5.665718, 0, 0>
    scale <4.403111, 1, 1>
    translate <-1.286754, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 19.606835>
    rotate <0, 167.674035, 0>
    translate <2.656789, 21.5,-3.656757>
  }
  object { Dot texture { SNAIL_SKIN } scale <5.480000, 5.480000, 5.480000> translate <1.285511, 22,-3.956395> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 5.322903 }
      plane { x, 5.002363 inverse }
    }
    translate <-5.322903, 0, 0>
    scale <4.085966, 1, 1>
    translate <-1.302728, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 21.111749>
    rotate <0,-173.063496, 0>
    translate <1.285511, 22,-3.956395>
  }
  object { Dot texture { SNAIL_SKIN } scale <5.15, 5.15, 5.15> translate <-0, 22.5,-3.8> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 4.978122 }
      plane { x, 4.659135 inverse }
    }
    translate <-4.978122, 0, 0>
    scale <3.773035, 1, 1>
    translate <-1.319395, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 22.840766>
    rotate <0,-153.570633, 0>
    translate <-0, 22.5,-3.8>
  }
  object { Dot texture { SNAIL_SKIN } scale <4.820000, 4.820000, 4.820000> translate <-1.063018, 23,-3.271634> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 4.631047 }
      plane { x, 4.313984 inverse }
    }
    translate <-4.631047, 0, 0>
    scale <3.465471, 1, 1>
    translate <-1.336340, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 24.839270>
    rotate <0,-133.780866, 0>
    translate <-1.063018, 23,-3.271634>
  }
  object { Dot texture { SNAIL_SKIN } scale <4.490000, 4.490000, 4.490000> translate <-1.810379, 23.5,-2.491772> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 4.281360 }
      plane { x, 3.966695 inverse }
    }
    translate <-4.281360, 0, 0>
    scale <3.164827, 1, 1>
    translate <-1.352794, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 27.161540>
    rotate <0,-113.600358, 0>
    translate <-1.810379, 23.5,-2.491772>
  }
  object { Dot texture { SNAIL_SKIN } scale <4.160000, 4.160000, 4.160000> translate <-2.200526, 24,-1.598776> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 3.928854 }
      plane { x, 3.617190 inverse }
    }
    translate <-3.928854, 0, 0>
    scale <2.873290, 1, 1>
    translate <-1.367371, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 29.869268>
    rotate <0,-92.894757, 0>
    translate <-2.200526, 24,-1.598776>
  }
  object { Dot texture { SNAIL_SKIN } scale <3.830000, 3.830000, 3.830000> translate <-2.244493, 24.5,-0.729280> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 3.573633 }
      plane { x, 3.265723 inverse }
    }
    translate <-3.573633, 0, 0>
    scale <2.593922, 1, 1>
    translate <-1.377695, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 33.025855>
    rotate <0,-71.466140, 0>
    translate <-2.244493, 24.5,-0.729280>
  }
  object { Dot texture { SNAIL_SKIN } scale <3.5, 3.5, 3.5> translate <-2, 25, 0> }
  bounded_by { object { Dot scale <60.445726, 60.445726, 60.445726> translate <3.45, 4.25,-3.45> } }
}

// ------------------ THE END OF THE SEA SHELL ---------------------------

//------------- THE SLIMMY BOBY ATTACHED TO THE SHELL -----

#declare SLIME_BODY =
object {
  union {
    object { Dot scale <19.75, 19.75, 19.75> }  
    difference {
      object {  Connector_2 }  
      plane { x, 18.974120 inverse }
      plane { x, 17.052691 }
      translate <-18.974120, 0, 0>
      scale <3.461575, 1, 1>
      translate <-5.481355, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0,-2.385944>
    }
    object { Dot scale <17.75, 17.75, 17.75> translate <7.2,-0.3, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 17.745302 inverse }
      plane { x, 17.495368 }
      translate <-17.745302, 0, 0>
      scale <43.454344, 1, 1>
      translate <-0.408367, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0,-6.340192>
      translate <7.2,-0.3, 0>
    }
    object { Dot scale <17.5, 17.5, 17.5> translate <18,-1.5, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 17.320524 inverse }
      plane { x, 15.835908 }
      translate <-17.320524, 0, 0>
      scale <6.928524, 1, 1>
      translate <-2.499887, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0,-0.545658>
      translate <18,-1.5, 0>
    }
    object { Dot scale <16, 16, 16> translate <28.5,-1.6, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 15.993736 inverse }
      plane { x, 15.493932 }
      translate <-15.993736, 0, 0>
      scale <35.727860, 1, 1>
      translate <-0.447654, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0, 9.989407>
      translate <28.5,-1.6, 0>
    }
    object { Dot scale <15.5, 15.5, 15.5> translate <46.1, 1.5, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 15.215923 inverse }
      plane { x, 12.565407 }
      translate <-15.215923, 0, 0>
      scale <5.151078, 1, 1>
      translate <-2.953930, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0, 26.855115>
      rotate <0, 4.537773, 0>
      translate <46.1, 1.5, 0>
    }
    object { Dot scale <12.8, 12.8, 12.8> translate <58.7, 7.9,-1> }  
    difference {
      object { Connector_2 }
      plane { x, 12.656484 inverse }
      plane { x, 10.876666 }
      translate <-12.656484, 0, 0>
      scale <6.621607, 1, 1>
      translate <-1.911392, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0, 42.219572>
      rotate <0, 9.673355, 0>
      translate <58.7, 7.9,-1>
    }
    object { Dot scale <11, 11, 11> translate <67.5, 16,-2.5> }  
    difference {
      object { Connector_2 }
      plane { x, 10.929158 inverse }
      plane { x, 9.438819 }
      translate <-10.929158, 0, 0>
      scale <8.768631, 1, 1>
      translate <-1.246393, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0, 65.021660>
      rotate <0, 26.565051, 0>
      translate <67.5, 16,-2.5>
    }
    object { Dot scale <9.5, 9.5, 9.5> translate <72.5, 28,-5> }  
    difference {
      object { Connector_2 }
      plane { x, 10.467692 inverse }
      plane { x, 9.470769 }
      translate <-9.470769, 0, 0>
      scale <12.718097, 1, 1>
      translate <0.744669, 0, 0>
      rotate <0, 0, 64.348141>
      rotate <0, 84.805571, 0>
      translate <72.5, 28,-5>
    }
    object { Dot scale <10.5, 10.5, 10.5> translate <73, 39.5,-10.5> }  
    difference {        
      object { Connector_2 }
      plane { x, 9.613702 inverse }
      plane { x, 6.180237 }
      translate <-9.613702, 0, 0>
      scale <2.276957, 1, 1>
      translate <-4.222171, 0, 0>
      rotate <0, 180, 0>
      rotate <0, 0, 46.816209>
      rotate <0, 54.566686, 0>
      translate <73, 39.5,-10.5>
    }
    object { Dot scale <6.75, 6.75, 6.75> translate <76.7, 46.3,-15.7> }  
  }
  texture { SLIME rotate 0 scale <80,10,80> }
  texture { pigment { color Orange filter 0.9 } finish { phong 1.0 phong_size 20 } normal { bumps 0.6 frequency 20 } }
  bounded_by { object { Dot scale <73.257941, 73.257941, 73.257941> translate <31.875, 16.65,-1.35> } }
}
// ---------------------- END OF SLIMMY BODY ---------------

// ----------- MAKE SNAIL ANTLERS ---------------------------
#declare ANTLERS =
object {
  union {
    difference {
      object { UCone scale <3, 40, 3> }
      plane { y, -10 inverse }
    }
    sphere { 0, 3 translate y*-10 }
  }
  texture { SLIME rotate 0 scale <8, 1, 8> }
  texture { pigment { color Orange filter 0.9 } finish { phong 1.0 phong_size 20 } normal { bumps 0.6 frequency 20 } }
  translate y*40
}

#declare EYEB =
sphere { 0, 1
  scale <2, 1.5, 2>
  texture { pigment { color Black } finish { phong 1 } }
  translate y*32.2
}

// ----------------------COMPOSITE THE SNAIL-------------------------
#declare BODY =
union {
  object { SLIME_BODY rotate y*-90 }
  object { ANTLERS rotate z*35 rotate x*-35 translate <13.6, 45, 70> }
  object { ANTLERS rotate z*-45 rotate x*-25 translate <17, 45, 70> }
  object { EYEB rotate z*35 rotate x*-35 translate <13.6, 45, 70> }
  object { EYEB rotate z*-45 rotate x*-25 translate <17, 45, 70> }
}
 
#declare THESNAIL = 
union {
  object { BODY rotate 0 translate <26, 0, 3> }
  object { snail scale <1.12, 1.1, 1.1> rotate 0 }
}

// ----------- THE TOTAL SNAIN / I AM SNAIL-SEE ME CRAWL----
//object { THESNAIL rotate 0 }