//--------- Jack Thinks 'what would go good with snail?-- M.Miller 2/17/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.5
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "skies.inc"

camera {
  location <45, -20, -250>
  direction z*1.2
  up y*1.1
  right x*image_width/image_height
  look_at <45, 12, 0>
}

// --------------------- textures -----------------
#declare GOLD = // ------Bright Reflective Gold---------------
texture { 
  pigment { colour rgb <0.7, 0.6, 0> }
  finish { metallic 0.03 ambient 0.4 diffuse 0.7 reflection { 0.6 } brilliance 8 phong 0.8 phong_size 50 }
}

#declare SILVER = // ---------Bright REFLECTIVE SILVER-----------
texture {
  pigment { colour rgb 0.7 }
  finish { crand 0.08 ambient 0.4 diffuse 0.7 reflection { 0.9 } brilliance 7 specular 0.5 }
}

#declare Red_Gloss =
texture {
  pigment { color rgb <0.8, 0.1, 0.1> }
  finish { ambient 0.3 diffuse 0.5 phong 1 phong_size 70 }
}

#include "HandleCJF.INC"
#include "ClawCJF.INC"
#include "HeadCJF.INC"
#include "FrenchCJF.INC"
#include "TheSnailCJF.INC"
#include "WorldCJF.INC" // Taken from Mike Millers Station.POV

// ------------- LIGHTS ----------------------------
light_source { < 800, 900,  -800> color White }
light_source { <-100, 430, -1000> color White }
//light_source { <-220,  10,   500> color White }  //not sure this helps?

// ------------- FATTER 10 sided poly -------------------------------
#declare Decagon2 =
intersection {
  plane { y, 10 }
  plane { -y, 10  }
  plane { y, 0 rotate z*52 translate x*-20 }
  plane { y, 0 rotate z*-52 translate x*20 }
  plane { y, 0 rotate z*-52 translate x*-20 inverse }
  plane { y, 0 rotate z*52 translate x*20 inverse }
  plane { y, 0 rotate x*-52 translate z*-20 }
  plane { y, 0 rotate x*52 translate z*-20 inverse }
  plane { y, 0 rotate x*52 translate z*20 }
  plane { y, 0 rotate x*-52 translate z*20 inverse }
}

// -------------BASE BELLOW color -----------------
#declare AYANK = 
texture {
  pigment { color rgb <0.95, 0.53, 0.3> }
  finish { ambient 0.2 diffuse 0.6 }
}

// ------------ SINGLE BELLOW ----------------------
#declare BELLOW1 =
object { Decagon2
  texture { AYANK }
  translate x*-40
  bounded_by { sphere { x*-40, 30 } }
}

// ------------ SINGLE BELLOW AJUST-----------------
#declare BELLOW2 =
object { Decagon2
  texture { AYANK }
  rotate z*-15
  translate x*-40
  bounded_by { sphere { x*-40, 30 } }
}

// ------------ SINGLE BELLOW AJUST----------------
#declare BELLOW3 =
object { Decagon2
  texture { AYANK }
  rotate z*15
  translate 0
  bounded_by { sphere { 0, 30 } }
}

// ------------ JACKS NECK-------------------------
#declare NECK =
union {
  union {
    object { BELLOW1 rotate z*20   texture { pigment { color Scarlet filter 0.2  } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1               texture { pigment { color Scarlet filter 0.25 } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-20  texture { pigment { color Scarlet filter 0.3  } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-40  texture { pigment { color Scarlet filter 0.35 } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-60  texture { pigment { color Scarlet filter 0.4  } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-80  texture { pigment { color Scarlet filter 0.45 } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-100 texture { pigment { color Scarlet filter 0.5  } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-120 texture { pigment { color Scarlet filter 0.55 } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-140 texture { pigment { color Scarlet filter 0.6  } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-160 texture { pigment { color Scarlet filter 0.65 } finish { ambient 0.2 phong 1 } } }
    
    object { BELLOW3 rotate z*-140 texture { pigment { color Scarlet filter 0.7  } finish { ambient 0.2 phong 1 } } translate <45.5, 4.6, 0> } 
    object { BELLOW3 rotate z*-140 texture { pigment { color Scarlet filter 0.75 } finish { ambient 0.2 phong 1 } } translate <53.4, -8.1, 0> } 
    object { BELLOW3 rotate z*-140 texture { pigment { color Scarlet filter 0.8  } finish { ambient 0.2 phong 1 } } translate <63.4, -20.1, 0> } 
  }
  union {
    object { BELLOW2 rotate z*-140 texture { pigment { color Scarlet filter 0.2  } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-160 texture { pigment { color Scarlet filter 0.15 } finish { ambient 0.2 phong 1 } } }
    object { BELLOW1 rotate z*-180 texture { pigment { color Scarlet filter 0.1  } finish { ambient 0.2 phong 1 } } }
    translate <-61.4, -51.4, 0>
    bounded_by { box { -1, 1 scale <70, 70, 50> } }
  }
}

// ---------------- SILKSCREENED WALLS ---------------------
#declare S_WALL =
box { -1, 1
  texture {
    //pigment { image_map { gif "box14.gif" once } }
    pigment { image_map { gif "BoxTestCJF.gif" once } }
    finish { ambient 0.2 diffuse 1 }
    scale 2
    translate <-1, -1, 1>
  }
  scale <38.1, 38.1, 0.5> 
}

// -------------- BUILD JACK'S BOX ------------------
#declare JACKBOX =
union {
  object { S_WALL translate z*-40 }
  object { S_WALL translate z*40 }
  object { S_WALL rotate y*90 translate x*-40 }
  object { S_WALL rotate y*90 translate x*40 }
  object { S_WALL rotate x*90 translate y*40 }
  object { S_WALL rotate x*90 translate y*-40 }
  bounded_by { sphere { 0, 70 } }
}

// --------- GOLD FLAT TRIM AROUND BOX -----------
#declare G_TRIM =
difference {
  box { -1, 1 scale 42 }
  box { -1, 1 scale <38, 38, 45> }
  box { -1, 1 scale <45, 38, 38> }
  box { -1, 1 scale <38, 45, 38> }
  texture { GOLD }
  //texture { pigment { color Gold } finish { phong 1 } }
  bounded_by { box { -1, 1 scale 43 } }
}

// ---------- KNOB ON HANDLE ---------------
#declare KNOB =
union { 
  sphere { 0, 1 scale <1, 3.5, 3.5> }
  sphere { 0, 1 scale <1, 3.5, 3.5> translate -x }
  sphere { 0, 1 scale <1, 4.5, 4.5> translate x*-2 }
  sphere { 0, 1 scale <1, 4.5, 4.5> translate x*-5 }
  object { X_Disk scale <3, 4.5, 4.5> translate x*-5 }
  texture { Red_Gloss }
  bounded_by { sphere { x*-3, 6 } }
}

// ----------- COMBINE HANDLE & KNOB ------------------
#declare CRANK = 
union {
  object { HANDLE scale <1, 1, 0.25> rotate y*90 texture { GOLD } }
  object { KNOB translate <-2, -29.5, 0> }
  scale 1.2
}

// ---------- POST FOR HANDLE ------------------------
#declare POST =
union {
  object { X_Disk scale <20, 1, 1> }
  sphere { 0, 1 scale <1, 3, 3> }
  texture { GOLD }
  bounded_by { sphere { x*-4, 17 } }
}

#declare Glass =
texture { 
  //pigment { color rgb 1 filter 0.7 }
  //finish { ambient 0 diffuse 0 reflection 0.3 /* refraction 1 ior 1.5 */ transmit 0 }
  pigment { color rgbf <0.90, 0.94, 1.0, 0.8> }
  finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } /* refraction 0.9 */ crand 0.001 }  
}

// ------------------------ The Wet Spots ------------------------
#declare PUDDLE =
union {
  sphere { 0, 1 scale <88.5, 4, 39> }
  sphere { 0, 1 scale <41.3, 4, 12> translate <-74.8, 0, 43> }
  sphere { 0, 1 scale <10.5, 5, 6.3> translate <-119, 0, 27.8> }
  texture { Glass
    finish { reflection 0.43 phong 0.5 phong_size 50 }
    normal { ripples 0.5 frequency 0.05 }
  }
  interior { ior 1.5 }
  bounded_by { box { -1, 1 scale <114.5, 5, 57.25> translate <-20.5, 0, 1.2> } }
  scale <0.4, 0.4, 1.4>
  rotate y*180
}

/*
Not baring much sense, and befriended by the Jack, the Snail slims
the brass leg of the Jack ... blood swirls with slim as the Jack bites
the snails head off...leaving him speechless.
*/

// -------------- BUILD JACK ----------------
#declare JACK =
union {
  object { NECK translate <20, 91.8, 0> }
  union {
    object { JACKBOX }
    object { CRANK rotate x*130 translate x*-50 }
    object { POST translate x*-51 }
    object { CLAW rotate y*-45 translate <-40, -35, -40> }
    object { CLAW rotate y*-135 translate <40, -35, -40> }
    object { CLAW rotate y*45 translate <-40, -35, 40> }
    object { CLAW rotate y*135 translate <40, -35, 40> }
    object { G_TRIM }
    scale 0.9
    rotate y*-90
    translate y*20
  }
  object { JHEAD scale 2.3 rotate y*-70 rotate z*-45 translate <85, 50, 0> }
  //rotate y*50 
}

// ----------------- BUILD SCENE -------------------------
object { JACK rotate y*50 }
object { FRENCH scale 7.1 translate <700, -42, 1800> }
object { FRENCH scale 7.1 translate <-1200, -42, 1800> }
object { F_DOOR scale 7.1 translate <700, -42, 1800> }
object { TOP_ARCH scale 7.1 translate <700, -42, 1800> }
object { THESNAIL scale 0.45 rotate y*-140 translate <100, -36, -100> }
//object { PUDDLE scale 1 translate <50, -41.5, -120> }
//object { FLY scale 0.09 rotate x*-90 rotate y*-60 translate <15, -42, -160> }

// ---------- CEILING ----------------------
/*
plane { y,  1800
  texture { pigment { color Scarlet } finish { ambient 0.1 diffuse 0.5 } }
}
*/
// --------- CLOUDS BEHIND FRENCH DOORS ---------------------
object { TheWorld scale 1000 hollow } // Taken from Mike Millers Station.POV
/*
box { -1, 1
  scale <2000, 1000, 1>
  texture {
    pigment {
      image_map { gif "sky10.gif" }
      scale <4000, 2000, 1>
      translate <-2000, -1000, -1>
    }
    finish { ambient 1 diffuse 0 }
  }
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.3 color Clear color MidnightBlue filter 0.5]
        [0.3 0.5 color MidnightBlue filter 0.5 color Black filter 0.6]
        [0.5 1.0 color Black filter 0.6 color Black]
      }
    }
    finish { ambient 0.5 diffuse 0 }
    scale <4000, 2000, 1>
    translate y*-1600
  }
  translate <0, 950, 2000>
  scale <1, 1.1, 1>
}*/ 

// --------- WALL TO TINT FRENCH DOORS ---------------------
plane { z, 1650 inverse
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.3 color Clear color Black filter 0.6]
        [0.3 0.5 color Black filter 0.6 color Black filter 0.6]
        [0.5 1.0 color Black filter 0.4 color Black filter 0.3]
      }
    }
    finish { ambient 0.5 diffuse 0 }
    scale <4000, 5000, 1>
    translate y*-50
  }
} 

// -------------  FLOOR -----------------
box { -1, 1 scale <500 1 2000>
  texture {
    pigment { 
      checker
        color rgb 0.2
        color Black
    }
    finish {
      reflection 0.4
      ambient 0.2
      diffuse 0.5
    }
    scale <40, 11.76543, 40>
    rotate y*45
  }
  translate <0, -42, 1000>
}