// -------------------- CLAW FOOT
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare Dot = sphere { 0, 1 }

#declare Connector_1 =
object { 
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane { x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare FOOT =
union {
  sphere { 0, 7.6 }
  object { Connector_2
    clipped_by {
      plane { x, 7.522754 }
      plane { x, 7.225803 inverse }
    }
    translate <-7.522754, 0, 0>
    scale <6.960204, 1, 1>
    translate <-1.080824, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -84.559668>
  }
  sphere { 0, 7.3 translate <0.2, -2.1, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 6.750837 }
      plane { x, 6.011019 inverse }
    }
    translate <-6.750837, 0, 0>
    scale <2.430278, 1, 1>
    translate <-2.777805, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -87.273689>
    translate <0.2, -2.1, 0>
  }
  sphere { 0, 6.5 translate <0.3, -4.2, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 6.053078 }
      plane { x, 5.214960 inverse }
    }
    translate <-6.053078, 0, 0>
    scale <2.555556, 1, 1>
    translate <-2.368596, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -58.240520>
    translate <0.3, -4.2, 0>
  }
  sphere { 0, 5.6 translate <1.6, -6.3, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 5.440221 }
      plane { x, 5.003060 inverse }
    }
    translate <-5.440221, 0, 0>
    scale <4.096069, 1, 1>
    translate <-1.328157, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -71.565051>
    rotate <0, -180, 0>
    translate <1.6, -6.3, 0>
  }
  sphere { 0, 5.15 translate <1, -8.1, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 4.935818 }
      plane { x, 4.360771 inverse }
    }
    translate <-4.935818, 0, 0>
    scale <3.358240, 1, 1>
    translate <-1.469763, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -87.273689>
    translate <1, -8.1, 0>
  }
  sphere { 0, 4.55 translate <1.1, -10.2, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 4.509555 }
      plane { x, 4.311333 inverse }
    }
    translate <-4.509555, 0, 0>
    scale <7.449832, 1, 1>
    translate <-0.605323, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -86.185925>
    rotate <0, -180, 0>
    translate <1.1, -10.2, 0>
  }
  sphere { 0, 4.35 translate <1, -11.7, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 4.234607 }
      plane { x, 3.893892 inverse }
    }
    translate <-4.234607, 0, 0>
    scale <4.254649, 1, 1>
    translate <-0.995289, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -78.690068>
    rotate <0, -180, 0>
    translate <1, -11.7, 0>
  }
  sphere { 0, 4 translate <0.7, -13.2, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 3.911840 }
      plane { x, 3.569554 inverse }
    }
    translate <-3.911840, 0, 0>
    scale <4.683885, 1, 1>
    translate <-0.835170, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -72.645975>
    rotate <0, -180, 0>
    translate <0.7, -13.2, 0>
  }
  sphere { 0, 3.65 translate <0.2, -14.8, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 3.547523 }
      plane { x, 3.158754 inverse }
    }
    translate <-3.547523, 0, 0>
    scale <4.130678, 1, 1>
    translate <-0.858824, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -61.927513>
    rotate <0, -180, 0>
    translate <0.2, -14.8, 0>
  }
  sphere { 0, 3.25 translate <-0.6, -16.3, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 3.199847 }
      plane { x, 2.855248 inverse }
    }
    translate <-3.199847, 0, 0>
    scale <5.626105, 1, 1>
    translate <-0.568750, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -53.130102>
    rotate <0, -180, 0>
    translate <-0.6, -16.3, 0>
  }
  sphere { 0, 2.9 translate <-1.8, -17.9, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 2.828596 }
      plane { x, 2.340907 inverse }
    }
    translate <-2.828596, 0, 0>
    scale <4.422669, 1, 1>
    translate <-0.639568, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -41.423666>
    rotate <0, -180, 0>
    translate <-1.8, -17.9, 0>
  }
  sphere { 0, 2.4 translate <-3.5, -19.4, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 2.369469 }
      plane { x, 2.073285 inverse }
    }
    translate <-2.369469, 0, 0>
    scale <6.209312, 1, 1>
    translate <-0.381599, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -32.005383>
    rotate <0, -180, 0>
    translate <-3.5, -19.4, 0>
  }
  sphere { 0, 2.1 translate <-5.1, -20.4, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 2.063220 }
      plane { x, 1.817598 inverse }
    }
    translate <-2.063220, 0, 0>
    scale <5.272571, 1, 1>
    translate <-0.391312, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -26.565051>
    rotate <0, -180, 0>
    translate <-5.1, -20.4, 0>
  }
  sphere { 0, 1.85 translate <-6.3, -21, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 1.841007 }
      plane { x, 1.691736 inverse }
    }
    translate <-1.841007, 0, 0>
    scale <10.105004, 1, 1>
    translate <-0.182188, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -23.198591>
    rotate <0, -180, 0>
    translate <-6.3, -21, 0>
  }
  sphere { 0, 1.7 translate <-7.7, -21.6, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 1.699118 }
      plane { x, 1.649144 inverse }
    }
    translate <-1.699118, 0, 0>
    scale <31.032241, 1, 1>
    translate <-0.054753, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -14.931417>
    rotate <0, -180, 0>
    translate <-7.7, -21.6, 0>
  }
  sphere { 0, 1.65 translate <-9.2, -22, 0> }
  object { Connector_1
    scale <1.431782, 1.650000, 1.650000>
    rotate <0, 0, -24.775141>
    rotate <0, -180, 0>
    translate <-9.2, -22, 0>
  }
  sphere { 0, 1.65 translate <-10.5, -22.6, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 1.642683 }
      plane { x, 1.543126 inverse }
    }
    translate <-1.642683, 0, 0>
    scale <10.583005, 1, 1>
    translate <-0.155219, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -41.185925>
    rotate <0, -180, 0>
    translate <-10.5, -22.6, 0>
  }
  sphere { 0, 1.55 translate <-11.3, -23.3, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 1.540855 }
      plane { x, 1.441445 inverse }
    }
    translate <-1.540855, 0, 0>
    scale <9.165151, 1, 1>
    translate <-0.168121, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -40.601295>
    rotate <0, -180, 0>
    translate <-11.3, -23.3, 0>
  }
  sphere { 0, 1.45 translate <-12, -23.9, 0> }
  object { Connector_1
    scale <1.476482, 1.450000, 1.450000>
    rotate <0, 0, -61.699244>
    rotate <0, -180, 0>
    translate <-12, -23.9, 0>
  }
  sphere { 0, 1.45 translate <-12.7, -25.2, 0> }
  bounded_by { sphere{ 0, 23.829444 translate <-3.275, -9.525, 0> } }
}

// ---------------- ONE TOE -----------------

#declare TOE = 
union {

  sphere { 0, 1.65 translate <-10.5, -22.6, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 1.642683 }
      plane { x, 1.543126 inverse }
    }
    translate <-1.642683, 0, 0>
    scale <10.583005, 1, 1>
    translate <-0.155219, 0, 0>
    rotate <0, 180,  0>
    rotate <0, 0, -41.185925>
    rotate <0, -180, 0>
    translate <-10.5, -22.6, 0>
  }
  sphere { 0, 1.55 translate <-11.3, -23.3, 0> }
  object { Connector_2
    clipped_by {
      plane { x, 1.540855 }
      plane { x, 1.441445 inverse }
    }
    translate <-1.540855, 0, 0>
    scale <9.165151, 1, 1>
    translate <-0.168121, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -40.601295>
    rotate <0, -180, 0>
    translate <-11.3, -23.3, 0>
  }
  sphere { 0, 1.45 translate <-12, -23.9, 0> }
  object { Connector_1
    scale <1.476482, 1.45, 1.45>
    rotate <0, 0, -61.699244>
    rotate <0, -180, 0>
    translate <-12, -23.9, 0>
  }
  sphere { 0, 1.45 translate <-12.7, -25.2, 0> }
  bounded_by { sphere { 0, 10 translate <-3.275, -22.525, 0> } }
}

// -------- COMBINE 3 LEGS TO CREATE CLAW ---------
#declare CLAW = 
union{
  object { FOOT }
  object { TOE rotate y*15 translate -z }
  object { TOE rotate y*-15 translate z }
  sphere { <-8.2, -28, 0>, 5 }
  bounded_by { sphere { <-3.6, -12.7, 0>, 22.3 } }
  texture { GOLD }
}