//-------------- FRENCH DOOR & WALL FROM PARLOR





{------------- DECLARED COLORS --------------------------}

#declare TRIM_PAINT = TEXTURE COLOR Gray AMBIENT 0.1 DIFFUSE 0.9 PHONG 1.0 END_TEXTURE
#declare WALL_PAINT = TEXTURE COLOR RED 0.78 GREEN 0.71 BLUE 0.71 0.03 AMBIENT 0.2   END_TEXTURE
#declare PAPER = TEXTURE COLOR LightBlue PHONG 0.2 END_TEXTURE
#declare DOOR_PAINT = TEXTURE COLOR Gray AMBIENT 0.1 DIFFUSE 0.7 PHONG 1.0 END_TEXTURE


{--------------- START FRENCH DOOR ------------------------------}
#declare SPOKE = INTERSECTION Cube SCALE <18 1 2> END_INTERSECTION


#declare TOP_ARCH = OBJECT
UNION
DIFFERENCE
INTERSECTION Z_Disk SCALE <40 40 8> TRANSLATE <0 136 -4> END_INTERSECTION
QUADRIC Cylinder_Z SCALE <34 34 1> TRANSLATE <0 136 0> END_QUADRIC
PLANE <0 1 0> 136 END_PLANE
END_DIFFERENCE
DIFFERENCE
INTERSECTION Z_Disk SCALE <6 6 8> TRANSLATE <0 136 -4> END_INTERSECTION
PLANE <0 1 0> 136 END_PLANE
END_DIFFERENCE
INTERSECTION SPOKE TRANSLATE <18 0 0> ROTATE <0 0 45> TRANSLATE <0 136 0> END_INTERSECTION
INTERSECTION SPOKE TRANSLATE <18 0 0> ROTATE <0 0 90> TRANSLATE <0 136 0> END_INTERSECTION
INTERSECTION SPOKE TRANSLATE <18 0 0> ROTATE <0 0 135> TRANSLATE <0 136 0> END_INTERSECTION
END_UNION
BOUNDED_BY 
INTERSECTION Cube SCALE <41 21 5> TRANSLATE <0 156 0> END_INTERSECTION
END_BOUND
TEXTURE  DOOR_PAINT END_TEXTURE
END_OBJECT


{----------- DOOR PANELS-------------------------------}
#declare F_DOOR = OBJECT
UNION
DIFFERENCE
INTERSECTION Cube SCALE <40 68 4> TRANSLATE <0 68 0> END_INTERSECTION
INTERSECTION Cube SCALE <34 60 5> TRANSLATE <0 70 0> END_INTERSECTION
END_DIFFERENCE
INTERSECTION Cube SCALE <35 1 2> TRANSLATE <0 100 0> END_INTERSECTION
INTERSECTION Cube SCALE <35 1 2> TRANSLATE <0 70 0> END_INTERSECTION
INTERSECTION Cube SCALE <35 1 2> TRANSLATE <0 40 0> END_INTERSECTION
INTERSECTION Cube SCALE <1 61 2> TRANSLATE <-18.5 70 0> END_INTERSECTION
INTERSECTION Cube SCALE <1 61 2> TRANSLATE <18.5 70 0> END_INTERSECTION
INTERSECTION Cube SCALE <3 61 2> TRANSLATE <0 70 0> END_INTERSECTION
END_UNION
BOUNDED_BY 
INTERSECTION Cube SCALE <41 70 5> TRANSLATE <0 69 0> END_INTERSECTION
END_BOUND
TEXTURE DOOR_PAINT END_TEXTURE
END_OBJECT

{----------------- WALL PANEL FRAME -------------------}
#declare FRAME = OBJECT
UNION
DIFFERENCE
UNION
QUADRIC Cylinder_X SCALE <1 1 1> TRANSLATE <0 12 0> END_QUADRIC
QUADRIC Cylinder_X SCALE <1 1 1> TRANSLATE <0 -12 0> END_QUADRIC
END_UNION
PLANE <1 0 0> 9 INVERSE END_PLANE
PLANE <1 0 0> -9 END_PLANE
END_DIFFERENCE
DIFFERENCE
UNION
QUADRIC Cylinder_Y SCALE <1 1 1> TRANSLATE <9 0 0> END_QUADRIC
QUADRIC Cylinder_Y SCALE <1 1 1> TRANSLATE <-9 0 0> END_QUADRIC
END_UNION
PLANE <0 1 0> 12 INVERSE END_PLANE
PLANE <0 1 0> -12 END_PLANE
END_DIFFERENCE
QUADRIC QSphere SCALE <1 1 1> TRANSLATE <9 12 0> END_QUADRIC
QUADRIC QSphere SCALE <1 1 1> TRANSLATE <9 -12 0> END_QUADRIC
QUADRIC QSphere SCALE <1 1 1> TRANSLATE <-9 12 0> END_QUADRIC
QUADRIC QSphere SCALE <1 1 1> TRANSLATE <-9 -12 0> END_QUADRIC
//INTERSECTION Cube SCALE <6.5 9.5 1> END_INTERSECTION
END_UNION
TEXTURE TRIM_PAINT END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <11 15 2> END_INTERSECTION
END_BOUND
END_OBJECT


{---------- BOTTOM POST MOLDING -----------------}
#declare B_POST = OBJECT
UNION
INTERSECTION Cube SCALE <8 5 8> TRANSLATE <0 5 0> END_INTERSECTION
INTERSECTION Cube SCALE <7 1 7> TRANSLATE <0 11 0> END_INTERSECTION
INTERSECTION Cube SCALE <6 1 6> TRANSLATE <0 13 0> END_INTERSECTION
END_UNION
TEXTURE TRIM_PAINT END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <9 8 9> TRANSLATE <0 7 0> END_INTERSECTION
END_BOUND
END_OBJECT


{---------- TOP POST MOLDING -----------------}
#declare T_POST = OBJECT
UNION
INTERSECTION Cube SCALE <6.5 1 6.5> TRANSLATE <0 1 0> END_INTERSECTION
INTERSECTION Cube SCALE <5.5 1 5.5> TRANSLATE <0 3 0> END_INTERSECTION
INTERSECTION Cube SCALE <5 1 5> TRANSLATE <0 5 0> END_INTERSECTION
INTERSECTION Cube SCALE <6 1 6> TRANSLATE <0 7 0> END_INTERSECTION
END_UNION
TEXTURE TRIM_PAINT END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <7 5 7> TRANSLATE <0 4 0> END_INTERSECTION
END_BOUND
END_OBJECT


{-------------- LOWER POST ---------------------------}
#declare L_POST = OBJECT
INTERSECTION Cube SCALE <5.5 18 5.5> END_INTERSECTION
TEXTURE TRIM_PAINT END_TEXTURE
END_OBJECT

{-------------- LOWER POST ---------------------------}
#declare U_POST = OBJECT
INTERSECTION Cube SCALE <4 37 4> END_INTERSECTION
TEXTURE TRIM_PAINT END_TEXTURE
END_OBJECT

{-------------- ARCHED MOLDING ----------------------}
#declare A_MOLD = OBJECT
DIFFERENCE
INTERSECTION Z_Disk SCALE <48 48 8> END_INTERSECTION
QUADRIC Cylinder_Z SCALE <40 40 1> END_QUADRIC
PLANE <0 1 0> 0 END_PLANE
END_DIFFERENCE
TRANSLATE <0 0 -4>
TEXTURE TRIM_PAINT END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <49 25 5> TRANSLATE <0 24 0> END_INTERSECTION
END_BOUND
END_OBJECT

{----------  DISTANT CHAIR MOLDING--------------------------}
#declare C_MOLD = OBJECT
UNION
INTERSECTION Cube SCALE <50 1 6> TRANSLATE <0 1 0> END_INTERSECTION
INTERSECTION Cube SCALE <48.2 1 4.1> TRANSLATE <0 3 0> END_INTERSECTION
INTERSECTION Cube SCALE <50 1 6> TRANSLATE <0 5 0> END_INTERSECTION
END_UNION
TEXTURE TRIM_PAINT END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <51 4 7> TRANSLATE <0 3 0> END_INTERSECTION
END_BOUND
END_OBJECT

{

{-------------------- CLOSE-UP CHAIR MOLDING--------------------}
#declare C_M = UNION
INTERSECTION Cube SCALE <55 3 0.25> TRANSLATE <0 0 -0.25> END_INTERSECTION
INTERSECTION Cube SCALE <55 2.5 0.25> TRANSLATE <0 0 -0.75> END_INTERSECTION
QUADRIC Cylinder_X SCALE <110 1 1> TRANSLATE <-55 1 -0.75> END_QUADRIC
QUADRIC Cylinder_X SCALE <110 1 1> TRANSLATE <-55 -1 -0.5> END_QUADRIC
END_UNION

#declare CHAIR_MOLD = OBJECT
UNION
DIFFERENCE 
UNION C_M TRANSLATE <0 0 -4> END_UNION
PLANE <1 0 0> 0 ROTATE <0 -45 0> TRANSLATE <50 0 -4> INVERSE END_PLANE
END_DIFFERENCE
DIFFERENCE 
UNION C_M ROTATE <0 -90 0> TRANSLATE <50 0 0> END_UNION
PLANE <1 0 0> 0 ROTATE <0 -45 0> TRANSLATE <50 0 -4> END_PLANE
PLANE <1 0 0> 0 ROTATE <0 45 0> TRANSLATE <50 0 4>  END_PLANE
END_DIFFERENCE
DIFFERENCE 
UNION C_M ROTATE <0 180 0> TRANSLATE <0 0 4> END_UNION
PLANE <1 0 0> 0 ROTATE <0 45 0> TRANSLATE <50 0 4> INVERSE END_PLANE
END_DIFFERENCE
END_UNION
TEXTURE TRIM_PAINT END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <65 12 14> TRANSLATE <0 6 0> END_INTERSECTION
END_BOUND
SCALE <1 1.1 1>
END_OBJECT

}






{---------- WALL BASE --------------------------------------------}
#declare W_BASE = OBJECT
UNION
INTERSECTION Cube SCALE <51 5 7> TRANSLATE <0 5 0> END_INTERSECTION
INTERSECTION Cube SCALE <50 1 5> TRANSLATE <0 11 0> END_INTERSECTION
INTERSECTION Cube SCALE <49 1 5> TRANSLATE <0 13 0> END_INTERSECTION
END_UNION
TEXTURE TRIM_PAINT END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <52 8 8> TRANSLATE <0 7 0> END_INTERSECTION
END_BOUND
END_OBJECT

{---------- LOWER WALL ---------------------- -----------------}
#declare L_WALL = OBJECT
INTERSECTION Cube SCALE <48 20 4> TRANSLATE <0 5 0> END_INTERSECTION
TEXTURE WALL_PAINT AMBIENT 0.2 DIFFUSE 0.4 END_TEXTURE
END_OBJECT


{

{---------- MIDDLE WALLPAPERED WALL---------------------------}
#declare P_WALL = OBJECT
INTERSECTION Cube SCALE <48 50 4> END_INTERSECTION

TEXTURE 
IMAGEMAP <1 -1 0> gif "wall3.gif" END_MAP
SCALE <30 63 4> TRANSLATE <-48 -50 -4>
AMBIENT 0.2 DIFFUSE 0.3 
PHONG 0.2 PHONGSIZE 10
END_TEXTURE

TEXTURE
GRADIENT <0 1 0>
COLOR_MAP
[0.0 0.5 COLOR Clear COLOR Clear]
[0.5 1.01 COLOR Clear COLOR Black]
END_COLOR_MAP
SCALE <100 63 5> TRANSLATE <0 -50 0>
AMBIENT 0.2
DIFFUSE 0.5
END_TEXTURE

END_OBJECT

{---------- FRONT WALLPAPERED WALL---------------------------}
#declare F_WALL = OBJECT
INTERSECTION Cube SCALE <48 50 4> END_INTERSECTION
TEXTURE 
IMAGEMAP <1 -1 0> gif "wall3.gif" END_MAP
SCALE <15 30 1> TRANSLATE <-48 -50 -4>
AMBIENT 0.4 DIFFUSE 0.6 
PHONG 0.2 PHONGSIZE 10
END_TEXTURE
TEXTURE
GRADIENT <0 1 0>
COLOR_MAP
[0.0 0.7 COLOR Black COLOR Black ALPHA 1.0]
[0.7 1.01 COLOR Black ALPHA 1.0 COLOR Black ALPHA 1.0]
END_COLOR_MAP
SCALE <100 29 5> TRANSLATE <0 -25 0>
END_TEXTURE
END_OBJECT

}


{----------- BUILD THE ROOM-----------------------------}
{*******************************************************}

#declare FRENCH = COMPOSITE

COMPOSITE
OBJECT F_DOOR END_OBJECT
OBJECT TOP_ARCH END_OBJECT

COMPOSITE
OBJECT B_POST TRANSLATE <44 0 -7.9> END_OBJECT
OBJECT L_POST TRANSLATE <44 31 -7.9> END_OBJECT
OBJECT T_POST TRANSLATE <44 48 -7.9> END_OBJECT
BOUNDED_BY 
INTERSECTION Cube SCALE <9 30 9> TRANSLATE <44 28 -7.9> END_INTERSECTION
END_BOUND
END_COMPOSITE


COMPOSITE
OBJECT B_POST TRANSLATE <-44 0 -7.9> END_OBJECT
OBJECT L_POST TRANSLATE <-44 31 -7.9> END_OBJECT
OBJECT T_POST TRANSLATE <-44 48 -7.9> END_OBJECT
BOUNDED_BY 
INTERSECTION Cube SCALE <9 30 9> TRANSLATE <-44 28 -7.9> END_INTERSECTION
END_BOUND
END_COMPOSITE


OBJECT U_POST TRANSLATE <44 92 -7.9> END_OBJECT
OBJECT U_POST TRANSLATE <-44 92 -7.9> END_OBJECT
OBJECT T_POST ROTATE <0 0 180> TRANSLATE <44 136 -7.9> END_OBJECT
OBJECT T_POST ROTATE <0 0 180> TRANSLATE <-44 136 -7.9> END_OBJECT
OBJECT A_MOLD TRANSLATE <0 136 -7.9> END_OBJECT


//---END COMPOSITE FOR DOOR AREA
BOUNDED_BY 
INTERSECTION Cube SCALE <53 105 20> TRANSLATE <0 104 -3> END_INTERSECTION
END_BOUND
ROTATE <0 0 0>
END_COMPOSITE

{------------------ UPPER WALL AROUND FRENCH DOOR --------------------}
OBJECT
DIFFERENCE
INTERSECTION Cube SCALE <140 85 4> END_INTERSECTION
INTERSECTION Cube SCALE <40 50 5> TRANSLATE <0 -39 0> END_INTERSECTION
QUADRIC Cylinder_Z SCALE <40 40 1> END_QUADRIC
END_DIFFERENCE
TEXTURE WALL_PAINT AMBIENT 0.1 DIFFUSE 0.6 PHONG 0.0 END_TEXTURE
TEXTURE
GRADIENT <0 1 0>
COLOR_MAP
[0.0 0.3 COLOR Clear COLOR Black ALPHA 0.5]
[0.3 1.0 COLOR Black ALPHA 0.5 COLOR Black]

END_COLOR_MAP
SCALE <300 170 5> TRANSLATE <0 -85 0>
AMBIENT 0.2 DIFFUSE 0.4
END_TEXTURE
BOUNDED_BY 
INTERSECTION Cube SCALE <141 86 5> END_INTERSECTION
END_BOUND
TRANSLATE <0 137 0>
END_OBJECT


{--------------- LOWER RIGHT WALL SECTIONS ---------------------------}
COMPOSITE
OBJECT W_BASE TRANSLATE <94 0 0> END_OBJECT
OBJECT L_WALL TRANSLATE <94 28 0> END_OBJECT
OBJECT C_MOLD TRANSLATE <94 50 0> END_OBJECT
OBJECT FRAME TRANSLATE <64 32 -4> END_OBJECT
OBJECT FRAME TRANSLATE <94 32 -4> END_OBJECT

BOUNDED_BY 
INTERSECTION Cube SCALE <60 30 10> TRANSLATE <94 29 0> END_INTERSECTION
END_BOUND
END_COMPOSITE


{--------------- LOWER LEFT WALL SECTIONS ---------------------------}
COMPOSITE
OBJECT W_BASE TRANSLATE <-94 0 0> END_OBJECT
OBJECT L_WALL TRANSLATE <-94 28 0> END_OBJECT
OBJECT C_MOLD TRANSLATE <-94 50 0> END_OBJECT
OBJECT FRAME TRANSLATE <-64 32 -4> END_OBJECT
OBJECT FRAME TRANSLATE <-94 32 -4> END_OBJECT

BOUNDED_BY 
INTERSECTION Cube SCALE <60 30 10> TRANSLATE <-94 29 0> END_INTERSECTION
END_BOUND
END_COMPOSITE

END_COMPOSITE

