// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapes2.inc"
//#include "shapes_old.inc"

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

camera {
  location <0, 220,-1150>
  direction z*2
  up y
  /* look_at 0*/
  right x*image_width/image_height
}

sphere { 0, 2000 inverse
  texture {
    pigment { color MidnightBlue }
    finish { ambient 1 diffuse 0 }
  }                                   
}    

/* light source 1 */
light_source { <100, 800,  -50> color White }

/* light source 2 */
light_source { <-80, 200, -400> color White }

sphere { 0, 40 translate < 20, 250,   0> texture { pigment { color Blue } finish { reflection 0.95 ambient 0.6 phong 1.0 } } }
sphere { 0, 60 translate <250, 350, -50> texture { pigment { color Blue } finish { reflection 0.9  ambient 0.4 phong 1.0 } } }

#declare globe =
/*---TOP GLOBE ON POST---*/
union {
  sphere { 0, 1 scale <10, 6, 10> }
  sphere { 0, 4 }
  texture { pigment { color Red } finish { phong 1 } }
}

#declare t_post =
union {    /*---TOP POST---*/
  box { -1, 1 scale <10, 15, 10> }
  box { -1, 1 scale <12,  2, 12> translate y*14}
  texture { pigment { color Gold } finish { phong 1.0 } }
}

#declare rail_v =    /*---VERTICAL RAILS---*/
box { -1, 1 scale <1.6, 11, 1.6> }

#declare rail_h =    /*---HORIZONTAL RAIL---*/
box { -1, 1 scale <40, 1.6, 1.6> }

#declare t_floor =
box { -1, 1
  scale <118, 5, 118>
  texture { pigment { color Blue } finish { phong 1.0 } }
}

#declare t_rail =
union {    /*---TOP RAIL---*/
  object { rail_h }
  object { rail_h translate y*25 }
  object { rail_v translate < -5, 12.5, 0> }
  object { rail_v translate <-15, 12.5, 0> }
  object { rail_v translate <-25, 12.5, 0> }
  object { rail_v translate <  5, 12.5, 0> }
  object { rail_v translate < 15, 12.5, 0> }
  object { rail_v translate < 25, 12.5, 0>  }
  texture { pigment { color Violet } finish { phong 1.0 ambient 0.6 } }
}

#declare post = 
union {   /*---POST W/GLOBE---*/
  object { t_post  }
  object { globe translate y*20 }
}

union {
  object { post translate <-90, 445, -90>  }
  object { post translate <  0, 445, -90>  }
  object { post translate < 90, 445, -90>  }
  object { post translate <-90, 445,   0>  }
  object { post translate <-90, 445,  90>  }
  object { t_rail translate < 47.5, 432, -90>  }
  object { t_rail translate <-47.5, 432, -90>  }
  object { t_rail rotate y*90 translate <-90, 432, -47.5>  }
  object { t_rail rotate y*90 translate <-90, 432,  47.5>  }
  object { t_floor translate <0, 425, 0>  }
  bounded_by { box { -1, 1 scale <122, 35, 122> translate y*447.5 } }
  rotate y*-35
}

#declare truss = 
difference { /*---MAKE SMALL TRUSS---*/
  box { -1, 1 scale <10, 10, 5> }
  object { Cylinder_Z scale <13, 13, 20> translate <-10, -10, 0>  }
  texture { pigment { color Red } finish { phong 1.0 } }
}

#declare tf_floor = 
box { -1, 1 /*---TOP FLOOR SUPPORT---*/
  scale <100, 15, 100>
  translate y*405
  texture { pigment { color green 1.0 red 0.3 } finish { phong 1.0 } }
}

union {
  object { truss translate <-110, 410, -95>  }
  object { truss translate <-110, 410, -47.5>  }
  object { truss translate <-110, 410,   0>  }
  object { truss translate <-110, 410,  47.5>  }		
  object { truss translate <-110, 410,  95>  }
  object { truss rotate y*-90 translate <-95,   410, -110> }
  object { truss rotate y*-90 translate <-47.5, 410, -110> }
  object { truss rotate y*-90 translate <  0,   410, -110> }
  object { truss rotate y*-90 translate < 47.5, 410, -110> }
  object { truss rotate y*-90 translate < 95,   410, -110> }
  object { truss rotate  y*90 translate <-95,   410,  110> }
  object { truss rotate y*180 translate <110,   410,  -95> }
  object { tf_floor  }
  bounded_by { box { -1, 1 scale <125, 16, 125> translate <0, 405, 0> } }
  rotate y*-35
}

#declare capital = 
union { /*---------MAKE CAPS FROR COLUM-----------*/
  object { Disk_Y scale <17, 30, 17> }
  object { Disk_Y scale <18,  3, 18> translate y*-2 }
  object { Disk_Y scale <17,  3, 17> translate y*11 }
  sphere { 0, 1 scale <22, 10, 22> translate y*20 }
  box { -1, 1 scale <25, 5, 25> translate y*25 }
  texture { pigment { color Gray scale 5 } finish { phong 1.0 } }
}

#declare colum =
object { /*---------MAKE COLUM-----------*/
  Disk_Y scale <15, 140, 15>
  texture { pigment { color Gold } scale <5, 20, 5> finish { phong 1.0 } }
}

#declare colum_a = 
union {
  object { capital translate <-75, 360, -75>  }
  object { capital rotate x*180 translate <-75, 220, -75>  }
  object { colum translate <-75, 220, -75>  }
 }

union {
  object { colum_a  }
  object { colum_a translate x*150 } 
  object { colum_a translate z*150 }
  object { colum_a translate <150, 0, 150> }
  rotate y*-35
}

#declare wedge = 
intersection { /*--------------MAKE WEDGE---------------*/
  plane {  z, 1 }
  plane { -z, 1 }
  plane {  y, 1 }
  plane { -y, 1 }
  plane {  x, 1 rotate z*-20 }
  plane { -x, 1 rotate  z*20 }
  scale 1
}

#declare wedge_g = 
union { /*----------WEDGE GROUP--------------*/
  object { wedge scale <10, 10,   14> }
  object { wedge scale <20,  7.5, 12> translate <0, -2, -2>  }
  texture { pigment { color Green } finish { phong 1.0 } } 
 }

#declare n_wall =
difference {  /*--------MAKE INNER WALL--------------*/
  box { -1, 1 scale <70, 100, 10> }
  object { Cylinder_Z scale <40, 40, 100> translate y*30 }
  box { -1, 1 scale <40, 65.5, 15> translate y*-35 }
  texture { pigment { color Blue } finish { phong 1.0 } }
}
  
#declare molding_1 =
union {
  box { -1, 1 scale <12, 8, 12> translate y*8 }
  box { -1, 1 scale <15, 3, 15> translate y*16 }
  texture { pigment { color Green } finish { phong 1.0 } }
}

#declare wall =
union {    /*---------MAKE WALL W/TRIM-------*/
  object { n_wall  }
  object { wedge_g translate y*78 }
  object { molding_1 translate <50, 5, 0> }
  object { molding_1 translate <-50, 5, 0> }
  bounded_by { box { -1, 1 scale <71, 101, 16> } }
}

union {   /*------------PUT UP THE WALLS---------------------------*/
  object { wall translate <0, 290, -60>  } 
  object { wall rotate y*180 translate <  0, 290, 60> }
  object { wall rotate  y*90 translate <-60, 290,  0> }
  object { wall rotate y*-90 translate < 60, 290,  0> }
  rotate y*-35
}

#declare c_floor = 
box { -1, 1   /*--------CHECKER FLOOR---------*/
  scale <110, 10, 110>
  translate y*185
  texture { pigment { checker color Black color White } finish { phong 1.0 reflection 0.4 } scale <15.71, 15.71, 15.71> }
}

#declare inner_b =
union {   /*-------MAKE INSIDE BASE---------*/
  box { -1, 1 scale <115, 58, 115> translate y*125 }
  box { -1, 1 scale <120, 10, 120> translate y*170 }
  texture { pigment { color Gold } finish { phong 1.0 ambient 0.6 reflection 0.4 } }
}

#declare mosaic_1 =
box { -1, 1  /*---CREATE MOSAIC PANEL----*/
  scale <116, 15, 1>
  translate <0, 145, -115.5>
  texture { 
    // image_map { <1 -1 0> gif "mosaic1.gif"  }
    pigment { image_map { gif "mosaic1.gif" } }
    scale <116, 100, 2>
    translate <-116, 60, -116>
  }
} 

union {
  object { c_floor  }
  object { inner_b  }
  object { mosaic_1  }
  object { mosaic_1 rotate y*90 /*TRANSLATE <-115.5, 145, 0>*/ }
  bounded_by { box { -1, 1 scale <121, 70, 121> translate y*125 } }
  rotate y*-35
} 

/*------------------START POST & VASE----------------------------*/

#declare b_post = 
union {  /*-----------BOTTOM POST -------------*/
  box { -1, 1 scale <20, 30, 20>  }
  box { -1, 1 scale <25, 3,  25> translate  y*20 }
  box { -1, 1 scale <25, 4,  25> translate y*-26 }
  texture { pigment { color Red } finish { phong 1.0 ambient 0.5 } }
}

#declare b_vase =
difference {  /*----------------BOTTOM OF VASE----------*/
  union {
    sphere { 0, 1 scale <15, 20, 22>  }
    sphere { 0, 1 scale <15, 20, 22> rotate  y*45 }
    sphere { 0, 1 scale <15, 20, 22> rotate  y*90 }
    sphere { 0, 1 scale <15, 20, 22> rotate y*135 }
  }
  plane { -y, 0.2 }
}

#declare t_vase = 
union {   /*------------------TOP OF VASE--------*/
  sphere { 0, 1 scale <13, 4, 13> }
  sphere { 0, 1 scale < 6, 8,  6> translate y*6 }
}

#declare /*-----------JOIN TOP & BOTTOM OF VASE -----------*/
bt_vase =
union {
  object { b_vase translate y*50 }
  object { t_vase translate y*50 }   
}

#declare vase = 
object {
  bt_vase
  texture { pigment { color Blue } finish { ambient 0.6 phong 1.0 } }
}

#declare v_post = 
union {  /*-----------JOIN VASE & POST-------------*/
  object { b_post  }
  object { vase  }
  bounded_by { box { -1, 1 scale <26, 50, 26> translate y*20 } }
}

/*---------------------- CREATE CLIPPED CONES FOR NEW RAILING--------------*/

#declare u_cone =  /*-------- CONE POINT UP ( point is 0 0 0 ) --------*/
difference {
  object { QCone_Y scale 1 }
  plane { y, -1  }
}

#declare d_cone =   /*----------CONE POINT DOWN ( point is 0 0 0 )---------*/
difference {
  object { QCone_Y scale 1 rotate x*180 }
  plane { y, 1 inverse  }
}

#declare post =
union {    /*------------MAKE LOWER POSTS-------------*/
  //object { u_cone scale 7.5 translate y*7.5 }
  sphere { 0, 7.5 translate y*12.5 }
  object { u_cone scale <7.5, 27.5, 7.5> translate y*40 }
}

#declare  hor_rail = box{ -1, 1 scale <170, 3.5, 10> }

#declare l_rail =
union {
  object { hor_rail translate  y*22 }
  object { hor_rail translate y*-22 }
  object { post translate <-140, -20, 0> }
  object { post translate <-105, -20, 0> }
  object { post translate < -70, -20, 0> }
  object { post translate < -35, -20, 0> }
  object { post translate <  -0, -20, 0> }
  object { post translate <  35, -20, 0> }
  object { post translate <  70, -20, 0> }
  object { post translate < 105, -20, 0> }
  object { post translate < 140, -20, 0> }
}

#declare f_rail = 
object {  /*------MAKE RAIL AN OBJECT w/COLOR & BOUND----*/
  l_rail
  texture { pigment { color Violet } finish { ambient 0.6 phong 1.0 } }
  bounded_by { box { -1, 1 scale <172, 22, 10.5> } }
}

union {
  object { v_post translate <-190, 95, -190> }
  object { v_post translate < 190, 95, -190> }  
  object { v_post translate <-190, 95,  190> }  
  object { v_post translate < 190, 95,  190> } 

  object { f_rail translate <0, 95, -190> }
  object { f_rail translate <0, 95,  190> }
  object { f_rail rotate y*90 translate <-190, 95, 0> }
  object { f_rail rotate y*90 translate < 190, 95, 0> }

  rotate y*-35
}

#declare b_floor =
box { -1, 1
  scale <210, 5, 210>
  texture { pigment { checker color Black color White } scale <21, 21, 12> finish { phong 1.0 ambient 0.6 reflection 0.6 } }
}

#declare sill = 
box { -1, 1
  scale <220, 15, 220>
  texture { pigment { color Gray } finish { phong 1.0 ambient 0.6 } }
}

#declare b_motif = 
box { -1, 1
  scale <210, 20, 2.5>
  texture { 
    //image_map { <1 -1 0> gif "mosaic_3.gif" }
    pigment { image_map { gif "mosaic_3.gif" } }
    scale <105, 80, 3>
    translate <-210, -37, -210.3>
    finish { phong 1.0 ambient 0.6 }
  }
}

#declare b_slab = 
box { -1, 1
  scale <205, 50, 205>
  texture { pigment { color Gold } finish { phong 1.0 ambient 0.6 } }
}

#declare n_slab = 
box { -1, 1
  scale <190, 50, 190>
  texture { pigment { color Blue } finish { phong 1.0 ambient 0.6 } }
}

union {
  object { b_floor translate y*72 }
  object { sill translate y*59 }
  object { b_motif translate <0, 20, -207.5> }  
  object { b_motif rotate y*90 translate <-207.5, 20, 0> }
  object { b_slab translate y*-10 }
  bounded_by { box { -1, 1 scale <225, 80, 225> translate y*-25 } }
  rotate y*-35
}
