// Persistence of Vision Raytracer
#include "shapes.inc"
#include "shapes.old"
#include "colors.inc"
#include "textures.inc"

camera {
   location <0 220  -1150>
   direction <0 0 2.0>
   up  <0.0  1.0  0.0>
rotate <0 0 0>   
   
  /* LOOK_AT <0 0 0>*/
   right <1.33333 0.0 0.0>
 }

object {
   sphere { <0.0 0.0 0.0> 2000.0 inverse  }
   texture {
   color MidnightBlue
   ambient 1.0
   diffuse 0.0
    }                                   
 }    

/* light source 1 */
object
{
	union
	{
		sphere
		{
			<100.0 800.0 -50.0> 2.0
			texture
			{
				color White
				ambient 1.0
				diffuse 0.0
			}
		}
		light_source
		{
			<100.0 800.0 -50.0>
			color White
		}
	}
	no_shadow
}

/* light source 2 */
object
{
	union
	{
		sphere
		{
			<-80 200 -400> 2.0
			texture
			{
				color White
				ambient 1.0
				diffuse 0.0
			}
		}
		light_source
		{
			<-80 200 -400>
			color White
		}
	}
	no_shadow
}

object {
  quadric { Sphere  scale <40 40 40> translate <20 250 0> 
   }
  texture { color Blue reflection 0.95  ambient 0.6 phong 1.0  }
 }

object {
  quadric { Sphere  scale <60 60 60> translate <250 350 -50> 
   } 
  texture { color Blue reflection 0.9 ambient 0.4 phong 1.0  }
 }




#declare globe = object {    /*---TOP GLOBE ON POST---*/
	union { quadric { Sphere 
	scale <10 6 10> translate <0 0 0>
	 }
		quadric { Sphere  scale <4 4 4>
		translate <0 9 0>  }
		 }
		texture { color Red phong 1.0  }
                 }

#declare t_post = object {    /*---TOP POST---*/
	union { intersection { Cube
	scale <10 15 10> translate <0 0 0>
	 }
	intersection { Cube scale <12 2 12>
	translate <0 14 0>
	 }
	 }
	texture { color Gold phong 1.0  }
	 }


#declare rail_v =    /*---VERTICAL RAILS---*/
	intersection { Cube scale <1.6 11 1.6>
	translate <0 0 0>  }

#declare rail_h =    /*---HORIZONTAL RAIL---*/
	intersection { Cube scale <40 1.6 1.6>
	translate <0 0 0>  }

#declare t_floor = object {
	intersection { Cube scale <118 5 118>
	translate <0 0 0>  }
		texture { color Blue phong 1.0  }  }

#declare t_rail = object {    /*---TOP RAIL---*/
	union {
		intersection { rail_h translate <0 0 0>
		 }
			intersection { rail_h translate <0 25 0>
			 }
	intersection { rail_v translate <-5 12.5 0>  }
	intersection { rail_v translate <-15 12.5 0>  }
	intersection { rail_v translate <-25 12.5 0>  }
	intersection { rail_v translate <5 12.5 0>  }
	intersection { rail_v translate <15 12.5 0>  }
	intersection { rail_v translate <25 12.5 0>  }
		 }
		texture { color Violet phong 1.0 ambient 0.6  }
		 }

#declare post = composite {   /*---POST W/GLOBE---*/
	object { t_post  }
	object { globe translate <0 20 0>  }
         }

composite {
	composite { post translate <-90 445 -90>  }
	composite { post translate <0 445 -90>  }
	composite { post translate <90 445 -90>  }
	composite { post translate <-90 445 0>  }
	composite { post translate <-90 445 90>  }
	object { t_rail translate <47.5 432 -90>  }
	object { t_rail translate <-47.5 432 -90>  }
	object { t_rail rotate <0 90 0> translate <-90 432 -47.5>  }
	object { t_rail rotate <0 90 0> translate <-90 432 47.5>  }
	object { t_floor translate <0 425 0>  }

bounded_by { intersection { Cube scale <122 35 122> translate <0 447.5 0>  }
	 }
	rotate <0 -35 0>
	 }

#declare    /*---MAKE SMALL TRUSS---*/
	truss = object {
		difference {
		intersection { Cube scale <10 10 5>
		translate <0 0 0>  }
			quadric { Cylinder_Z scale <13 13 20>
			translate <-10 -10 0>  }
			 }                        
       			texture { color Red phong 1.0  }
		         }

#declare    /*---TOP FLOOR SUPPORT---*/
	tf_floor = object {
	intersection { Cube scale <100 15 100>
	translate <0 405 0>  }
        texture { color green 1.0 red 0.3 phong 1.0  }
	 }

composite {
	object { truss translate <-110 410 -95>  }
	object { truss translate <-110 410 -47.5>  }
	object { truss translate <-110 410 0>  }
	object { truss translate <-110 410 47.5>  }		
	object { truss translate <-110 410 95>  }
	object { truss rotate <0 -90 0> translate <-95 410 -110>  }
	object { truss rotate <0 -90 0> translate <-47.5 410 -110>  }
	object { truss rotate <0 -90 0> translate <0 410 -110>  }
	object { truss rotate <0 -90 0> translate <47.5 410 -110>  }
	object { truss rotate <0 -90 0> translate <95 410 -110>  }
	object { truss rotate <0 90 0> translate <-95 410 110>  }
	object { truss rotate <0 180 0> translate <110 410 -95>  }
	object { tf_floor  }
		bounded_by { intersection { Cube scale <125 16 125>
	translate <0 405 0>  }
	 }
	rotate <0 -35 0>
         }

#declare
capital = object { /*---------MAKE CAPS FROR COLUM-----------*/
union {
  intersection { Y_Disk scale <17 30 17> translate <0 0 0>  }
  intersection { Y_Disk scale <18 3 18> translate <0 -2 0>  }
  intersection { Y_Disk scale <17 3 17> translate <0 11 0>  }
  quadric { Sphere  scale <22 10 22> translate <0 20 0>  }
  intersection { Cube scale <25 5 25> translate <0 25 0>  }
 }
texture { color Gray scale <5 5 5> phong 1.0  }
 }

#declare
colum = object { /*---------MAKE COLUM-----------*/
  intersection { Y_Disk scale <15 140 15> translate <0 0 0>  }
  texture { color Gold scale <5 20 5> phong 1.0  }
 }

#declare
colum_a = composite {
  object { capital translate <-75 360 -75>  }
  object { capital rotate < 180 0 0 > translate <-75 220 -75>  }
  object { colum translate <-75 220 -75>  }
 }

composite {
  composite { colum_a  }
  composite { colum_a translate <150 0 0>  } 
  composite { colum_a translate <0 0 150>  }
  composite { colum_a translate <150 0 150>  }
rotate <0 -35 0>
 }

#declare  /*--------------MAKE WEDGE---------------*/
wedge = intersection {
  plane { <0 0 1> 1.0  }
  plane { <0 0 -1> 1.0  }
  plane { <0 1 0> 1.0  }
  plane { <0 -1 0> 1.0  }
  plane { <1 0 0> 1.0   rotate <0 0 -20>  }
  plane { <-1 0 0> 1.0  rotate <0 0 20>  }
scale <1 1 1>
 }

#declare
wedge_g = object { /*----------WEDGE GROUP--------------*/
union {
  intersection { wedge scale <10 10 14> translate <0 0 0>  }
  intersection { wedge scale <20 7.5 12> translate <0 -2 -2>  }
 }
texture { color Green phong 1.0  } 
 }

#declare n_wall = object {  /*--------MAKE INNER WALL--------------*/
difference {
 intersection { Cube scale <70 100 10> translate <0 0 0>  }
 quadric { Cylinder_Z scale <40 40 100> translate <0 30 0>  }
 intersection { Cube scale <40 65.5 15> translate <0 -35 0>  }
 }
 texture { color Blue phong 1.0  }
 }
  
#declare
molding_1 = object {
union {
intersection { Cube scale <12 8 12> translate <0 8 0>  }
intersection { Cube scale <15 3 15> translate <0 16 0>  }
 }
  texture { color Green phong 1.0  }
   }

#declare wall = composite {    /*---------MAKE WALL W/TRIM-------*/
   object { n_wall  }
   object { wedge_g translate <0 78 0>  }
   object { molding_1 translate <50 5 0>  }
   object { molding_1 translate <-50 5 0>  }
bounded_by { intersection { Cube scale <71 101 16> translate <0 0 0>
 }
 }
 }


composite {   /*------------PUT UP THE WALLS---------------------------*/
   composite { wall translate <0 290 -60>  } 
   composite { wall rotate <0 180 0> translate <0 290 60>  }
   composite { wall rotate <0 90 0> translate <-60 290 0>  }
   composite { wall rotate <0 -90 0> translate <60 290 0>  }
rotate <0 -35 0>
 }


#declare c_floor = object {   /*--------CHECKER FLOOR---------*/
  intersection { Cube scale <110 10 110> translate <0 185 0>  }
  texture { checker color Black color White phong 1.0 
  reflection 0.4  scale <15.71 15.71 15.71>  }
 }

#declare inner_b = object {   /*-------MAKE INSIDE BASE---------*/
union {
 intersection { Cube scale <115 58 115> translate <0 125 0>  }
 intersection { Cube scale <120 10 120> translate <0 170 0>  }
 }
 texture { color Gold phong 1.0 ambient 0.6 reflection 0.4  }
 }

#declare mosaic_1 = object {   /*---CREATE MOSAIC PANEL----*/
  intersection { Cube scale <116 15 1> translate <0 145 -115.5>
   }
  texture { 
     image_map { <1 -1 0> gif "mosaic1.gif"  }
     scale <116 100 2>
     translate <-116 60 -116>
     
   }
 } 

composite {
   object { c_floor  }
   object { inner_b  }
   object { mosaic_1  }
object { mosaic_1 rotate <0 90 0> /*TRANSLATE <-115.5 145 0>*/  }
bounded_by {
   intersection { Cube scale <121 70 121> translate <0 125 0>
    }
 }
rotate <0 -35 0>
 } 

/*------------------START POST & VASE----------------------------*/

#declare
b_post = object {  /*-----------BOTTOM POST -------------*/
	union {
	intersection { Cube scale <20 30 20>  }

	intersection { Cube scale <25 3 25> translate <0 20 0>
	 }

	intersection { Cube scale <25 4 25> translate <0 -26 0>
	 }
 }
texture { color Red phong 1.0 ambient 0.5  }
 }

#declare 
b_vase = intersection {  /*----------------BOTTOM OF VASE----------*/
difference {
	union {
	quadric { Sphere  scale <15 20 22>  }
	quadric { Sphere  scale <15 20 22> rotate <0 45 0>  }
	quadric { Sphere  scale <15 20 22> rotate <0 90 0>  }
	quadric { Sphere  scale <15 20 22> rotate <0 135 0>  }
 }
	plane { <0 -1 0> 0.2  }
 }
 }

#declare
t_vase = union {   /*------------------TOP OF VASE--------*/
	union {
	quadric { Sphere  scale <13 4 13> translate <0 0 0>  }
	quadric { Sphere  scale <6 8 6>  translate <0 6 0>  }
	 }
	 }

#declare /*-----------JOIN TOP & BOTTOM OF VASE -----------*/
bt_vase = union {
	intersection { b_vase translate <0 50 0>  }
	intersection { t_vase translate <0 50 0>  }   
 }

#declare
vase = object {
	union { bt_vase  }
	texture { color Blue ambient 0.6 phong 1.0  }
 }


#declare
v_post = composite {  /*-----------JOIN VASE & POST-------------*/
	object { b_post  }
	object { vase  }
bounded_by {
	intersection { Cube scale <26 50 26> translate <0 20 0>
	 }
 }
 }



/*---------------------- CREATE CLIPPED CONES FOR NEW RAILING--------------*/

#declare 
u_cone =  /*-------- CONE POINT UP ( point is 0 0 0 ) --------*/
difference {
quadric { QCone_Y
scale <1 1 1>
translate <0 0 0>  }
plane { <0 1 0> -1  }
 }


#declare
d_cone =   /*----------CONE POINT DOWN ( point is 0 0 0 )---------*/
difference {
quadric { QCone_Y
scale <1 1 1>
rotate <180 0 0>
translate <0 0 0>
 }
plane { <0 1 0> 1 inverse  }
 }



#declare
post = union {    /*------------MAKE LOWER POSTS-------------*/
union {
difference { u_cone
scale <7.5 7.5 7.5>
translate <0 7.5 0>
 }

quadric { Sphere 
scale <7.5 7.5 7.5>
translate <0 12.5 0>
 }

difference { u_cone
scale <7.5 27.5 7.5>
translate <0 40 0>
 }
 }
 }

#declare
 hor_rail = intersection {
 Cube
 scale <170 3.5 10> translate <0 0 0>  }

#declare
  l_rail = union {
  union {
  intersection { hor_rail
  translate <0 22 0>  }
  intersection { hor_rail
  translate <0 -22 0>  }
	union { post translate <-140 -20 0>  }
	union { post translate <-105 -20 0>  }
	union { post translate <-70 -20 0>  }
	union { post translate <-35 -20 0>  }
	union { post translate <-0 -20 0>  }
	union { post translate <35 -20 0>  }
	union { post translate <70 -20 0>  }
	union { post translate <105 -20 0>  }
	union { post translate <140 -20 0>  }
 }
 }

#declare
  f_rail = object {  /*------MAKE RAIL AN OBJECT w/COLOR & BOUND----*/
  union { l_rail  }
  texture { color Violet ambient 0.6 phong 1.0  }
bounded_by {
  intersection { Cube scale <172 22 10.5>  }
   }
 }


composite {
	composite { v_post translate <-190 95 -190>  }
  	composite { v_post translate <190 95 -190>  }  
  	composite { v_post translate <-190 95 190>  }  
  	composite { v_post translate <190 95 190>  } 
	
	object { f_rail translate <0 95 -190>  }
	object { f_rail translate <0 95 190>  }
	object { f_rail rotate <0 90 0> translate <-190 95 0>  }
	object { f_rail rotate <0 90 0> translate <190 95 0>  }
rotate <0 -35 0>
 }


#declare
	b_floor = object {
	intersection { Cube 
	scale <210 5 210>
	 }
	texture { checker color Black color White scale <21 21 12> phong 1.0 ambient 0.6 
	reflection 0.6  }
 }
	

#declare
	sill = object {
	intersection { Cube 
	scale <220 15 220>
	 }
	texture { color Gray phong 1.0 ambient 0.6  }
 }

#declare
	b_motif = object {
	intersection { Cube 
	scale <210 20 2.5>
	 }
	texture { 
	
	image_map { <1 -1 0> gif "mosaic_3.gif" }
	scale <105 80 3>
	translate <-210 -37 -210.3>
 phong 1.0 ambient 0.6  }
 }

#declare
	b_slab = object {
	intersection { Cube 
	scale <205 50 205>
	 }
	texture { color Gold phong 1.0 ambient 0.6  }
 }

#declare
	n_slab = object {
	intersection { Cube 
	scale <190 50 190>
	 }
	texture { color Blue phong 1.0 ambient 0.6  }
 }

composite {
	object { b_floor translate <0 72 0>  }
	object { sill translate <0 59 0>  }

	object { b_motif translate <0 20 -207.5>  }
	object { b_motif rotate <0 90 0> translate <-207.5 20 0>  }

	object { b_slab translate <0 -10 0>  }
bounded_by {
	intersection { Cube scale <225 80 225>
	translate <0 -25 0>  }
 }
rotate <0 -35 0>
 }









