// --------------- THIS DATA PRODUCES A SHELL W/SLIMMY SNAIL -----------
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Connector_1 =
object { 
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

// --------------------- FOLLOWING DECLARES COLORS FOR SHELL & SNAIL----

// ----THE BALL JOINTS CONNECTORS---
#declare SNAIL_SKIN =
texture {
  pigment { colour rgb <0.733, 0.486, 0.447> }
  finish { phong 0.7 phong_size 30 ambient 0.15 diffuse 0.9 }
}

// ----THE LONG CONNECTORS---
#declare SNAIL_BONE = 
texture {
  pigment {
    gradient x
   colour_map {
      [0.000 0.244 colour rgbf <0.733, 0.486, 0.447, 0> colour rgbf <0.545, 0.467, 0.612, 0>]
      [0.244 0.395 colour rgbf <0.545, 0.467, 0.612, 0> colour rgbf <0.816, 0.612, 0.565, 0>]
      [0.395 0.580 colour rgbf <0.816, 0.612, 0.565, 0> colour rgbf <0.643, 0.498, 0.569, 0>]
      [0.580 1.001 colour rgbf <0.643, 0.498, 0.569, 0> colour rgbf <0.733, 0.486, 0.447, 0>]
    }
    scale <0.3, 20, 0.3>
  }
  finish { ambient 0.15 diffuse 0.9 }
}

// ----------------THE_SNAIL's BODY texture ------------
#declare SLIME =
texture {
  pigment {
    gradient x
   colour_map {
      [0.000 0.179 colour rgbf <0.482, 0.349, 0.353, 0> colour rgbf <0.322, 0.180, 0.278, 0>]
      [0.179 0.368 colour rgbf <0.322, 0.180, 0.278, 0> colour rgbf <0.365, 0.294, 0.396, 0>]
      [0.368 0.538 colour rgbf <0.365, 0.294, 0.396, 0> colour rgbf <0.322, 0.180, 0.278, 0>]
      [0.538 0.701 colour rgbf <0.322, 0.180, 0.278, 0> colour rgbf <0.365, 0.294, 0.318, 0>]
      [0.701 0.846 colour rgbf <0.365, 0.294, 0.318, 0> colour rgbf <0.322, 0.180, 0.278, 0>]
      [0.846 1.001 colour rgbf <0.322, 0.180, 0.278, 0> colour rgbf <0.482, 0.349, 0.353, 0>]
    }
  }
}

//#declare BONE2 = texture { pigment { colour CRed filter 1 } finsih { phong 0.7 phong_size 30 }

// -------- antennae color -------------------------------------
#declare ANTLER_COLOR =
texture {
  pigment { color rgb <0.322, 0.18, 0.278> }
  normal { bumps 0.4 frequency 5 }
  finish { phong 1 }
}

// ------ THE START OF SEA SHELL -----------------------
// -------------- LOCATION OF Rim on SHEEL -------------
#declare snail =
union {
  sphere { 0, 1
    texture { 
      pigment { color rgb <0.714, 0.447, 0.408> }
      finish { ambient 0.15 phong 1 }
    }
    scale <21, 21, 10>
    translate x*21.5
  }
  object { Connector_2 texture { SNAIL_BONE }
    clipped_by {
      plane { x, 19.971935 }
      plane { x, 19.642398 inverse }
    }
    translate x*-19.971935
    scale <18.856352, 1, 1>
    translate x*-1.059162
    rotate y*180
    rotate z*4.602336
    rotate y*102.281736
    translate x*20
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 19.67 translate <18.678750, 0.5, -6.069094> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 19.641377 }
      plane { x, 19.311857 inverse }
    }
    translate x*-19.641377
    scale <18.516243, 1, 1>
    translate x*-1.060765
    rotate y*180
    rotate z*4.686815
    rotate y*120.342307
    translate <18.678750, 0.5, -6.069094>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 19.34 translate <15.597848, 1, -11.332500> }
  object { Connector_2 texture { SNAIL_BONE }
    clipped_by {
      plane { x, 19.310796 }
      plane { x, 18.981295 inverse }
    }
    translate x*-19.310796
    scale <18.176180, 1, 1>
    translate x*-1.062423
    rotate y*180
    rotate z*4.774441
    rotate y*138.405161
    translate <15.597848, 1, -11.332500>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 19.01 translate <11.120897, 1.5, -15.306602> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 18.980192 }
      plane { x, 18.650710 inverse }
    }
    translate x*-18.980192
    scale <17.836164, 1, 1>
    translate x*-1.064141
    rotate y*180
    rotate z*4.865392
    rotate y*156.470421
    translate <11.120897, 1.5, -15.306602>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 18.68 translate <5.735355, 2, -17.651609> }
  object { Connector_2 texture { SNAIL_BONE }
     clipped_by {
       plane { x, 18.649563 }
       plane { x, 18.320101 inverse }
     }
     translate x*-18.649563
     scale <17.496197, 1, 1>
     translate x*-1.065921
     rotate y*180
     rotate z*4.959860
     rotate y*174.538218
     translate <5.735355, 2, -17.651609>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 18.35 translate <-0, 2.5, -18.2> }
  object { Connector_2 texture { SNAIL_BONE }
    clipped_by {
      plane { x, 18.318908 }
      plane { x, 17.989467 inverse }
    }
    translate x*-18.318908
    scale <17.156285, 1, 1>
    translate x*-1.067767
    rotate y*180
    rotate z*5.058051
    rotate y*-167.391278
    translate <-0, 2.5, -18.2>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 18.02 translate <-5.512863, 3, -16.966848> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 17.988223 }
      plane { x, 17.658805 inverse }
    }
    translate x*-17.988223
    scale <16.816430, 1, 1>
    translate x*-1.069681
    rotate y*180
    rotate z*5.160189
    rotate y*-149.317919
    translate <-5.512863, 3, -16.966848>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 17.69 translate <-10.274486, 3.5, -14.141617> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 17.657509 }
      plane { x, 17.328115 inverse }
    }
    translate x*-17.657509
    scale <16.476635, 1, 1>
    translate x*-1.071670
    rotate y*180
    rotate z*5.266517
    rotate y*-131.241520
    translate <-10.274486, 3.5, -14.141617>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 17.36 translate <-13.850371, 4, -10.062884> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 17.326762 }
      plane { x, 16.997394 inverse }
    }
    translate x*-17.326762
    scale <16.136905, 1, 1>
    translate x*-1.073735
    rotate y*180
    rotate z*5.377295
    rotate y*-113.161873
    translate <-13.850371, 4, -10.062884>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 17.03 translate <-15.939707, 4.5, -5.179125> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 16.995981 }
      plane { x, 16.666640 inverse }
    }
    translate x*-16.995981
    scale <15.797242, 1, 1>
    translate x*-1.075883
    rotate y*180
    rotate z*5.492809
    rotate y*-95.078799
    translate <-15.939707, 4.5, -5.179125>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 16.7 translate <-16.4, 5, 0> }
  object { Connector_2 texture { SNAIL_BONE } 
    clipped_by {
      plane { x, 16.665163 }
      plane { x, 16.335852 inverse }
    }
    translate x*-16.665163
    scale <15.457652, 1, 1>
    translate x*-1.078117
    rotate y*180
    rotate z*5.613365
    rotate y*-76.992054
    translate <-16.4, 5, 0>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 16.37 translate <-15.254947, 5.5, 4.956633> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 16.334306 }
      plane { x, 16.005025 inverse }
    }
    translate x*-16.334306
    scale <15.118139, 1, 1>
    translate x*-1.080444
    rotate y*180
    rotate z*5.739299
    rotate y*-58.901369
    translate <-15.254947, 5.5, 4.956633>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 16.04 translate <-12.685386, 6, 9.216473> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 16.003406 }
      plane { x, 15.674159 inverse }
    }
    translate x*-16.003406
    scale <14.778706, 1, 1>
    translate x*-1.082869
    rotate y*180
    rotate z*5.870980
    rotate y*-40.806519
    translate <-12.685386, 6, 9.216473>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 15.710000 translate <-9.004870, 6.5, 12.394140> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 15.672460 }
      plane { x, 15.343249 inverse }
    }
    translate x*-15.672460
    scale <14.439367, 1, 1>
    translate x*-1.085398
    rotate y*180
    rotate z*6.008802
    rotate y*-22.707174
    translate <-9.004870, 6.5, 12.394140>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 15.38 translate <-4.622894, 7, 14.227805> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 15.341466 }
      plane { x, 15.012293 inverse }
    }
    translate x*-15.341466
    scale <14.100120, 1, 1>
    translate x*-1.088038
    rotate y*180
    rotate z*6.153207
    rotate y*-4.603027
    translate <-4.622894, 7, 14.227805>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 15.05 translate <0, 7.5, 14.6> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 15.010419 }
      plane { x, 14.681286 inverse }
    }
    translate x*-15.010419
    scale <13.760977, 1, 1>
    translate x*-1.090796
    rotate y*180
    rotate z*6.304672
    rotate y*13.506302
    translate <0, 7.5, 14.6>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 14.72 translate <4.400402, 8, 13.543045> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 14.679314 }
      plane { x, 14.350226 inverse }
    }
    translate x*-14.679314
    scale <13.421942, 1, 1>
    translate x*-1.093680
    rotate y*180
    rotate z*6.463725
    rotate y*31.621196
    translate <4.400402, 8, 13.543045>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 14.39 translate <8.158459, 8.5, 11.229156> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 14.348148 }
      plane { x, 14.019108 inverse }
    }
    translate x*-14.348148
    scale <13.083027, 1, 1>
    translate x*-1.096699
    rotate y*180
    rotate z*6.630945
    rotate y*49.742072
    translate <8.158459, 8.5, 11.229156>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 14.06 translate <10.937910, 9, 7.946857> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 14.016915 }
      plane { x, 13.687926 inverse }
    }
    translate x*-14.016915
    scale <12.744239, 1, 1>
    translate x*-1.099863
    rotate y*180
    rotate z*6.806973
    rotate y*67.869444
    translate <10.937910, 9, 7.946857>          
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 13.73 translate <12.515904, 9.5, 4.066664> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 13.685609 }
      plane { x, 13.356676 inverse }
    }
    translate x*-13.685609
    scale <12.405591, 1, 1>
    translate x*-1.103181
    rotate y*180
    rotate z*6.992516
    rotate y*86.003826
    translate <12.515904, 9.5, 4.066664>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 13.4 translate <12.8, 10, -0> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 13.354224 }
      plane { x, 13.025351 inverse }
    }
    translate x*-13.354224
    scale <12.067089, 1, 1>
    translate x*-1.106665
    rotate y*180
    rotate z*7.188362
    rotate y*104.145808
    translate <12.8, 10, -0>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 13.07 translate <11.831143, 10.5, -3.844171> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 13.022752 }
      plane { x, 12.693945 inverse }
    }
    translate x*-13.022752
    scale <11.728756, 1, 1>
    translate x*-1.110327
    rotate y*180
    rotate z*7.395380
    rotate y*122.296057
    translate <11.831143, 10.5, -3.844171>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 12.74 translate <9.772925, 11, -7.100446> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 12.691186 }
      plane { x, 12.362450 inverse }
    }
    translate x*-12.691186
    scale <11.390594, 1, 1>
    translate x*-1.114181
    rotate y*180
    rotate z*7.614551
    rotate y*140.455326
    translate <9.772925, 11, -7.100446>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 12.41 translate <6.888843, 11.5, -9.481679> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 12.359516 }
      plane { x, 12.030858 inverse }
    }
    translate x*-12.359516
    scale <11.052630, 1, 1>
    translate x*-1.118242
    rotate y*180
    rotate z*7.846957
    rotate y*158.624429
    translate <6.888843, 11.5, -9.481679>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 12.08 translate <3.510433, 12, -10.804002> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 12.027732 }
      plane { x, 11.699160 inverse }
    }
    translate x*-12.027732
    scale <10.714877, 1, 1>
    translate x*-1.122526
    rotate y*180
    rotate z*8.093823
    rotate y*176.804323
    translate <3.510433, 12, -10.804002>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 11.75 translate <-0, 12.5, -11> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 11.695822 }
      plane { x, 11.367344 inverse }
    }
    translate x*-11.695822
    scale <10.377358, 1, 1>
    translate x*-1.127052
    rotate y*180
    rotate z*8.356523
    rotate y*-165.003937
    translate <-0, 12.5, -11>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 11.42 translate <-3.287941, 13, -10.119241> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 11.363773 }
      plane { x, 11.035398 inverse }
    }
    translate x*-11.363773
    scale <10.040091, 1, 1>
    translate x*-1.131840
    rotate y*180
    rotate z*8.636612
    rotate y*-146.799161
    translate <-3.287941, 13, -10.119241>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 11.09 translate <-6.042432, 13.5, -8.316695> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 11.031570 }
      plane { x, 10.703309 inverse }
    }
    translate x*-11.031570
    scale <9.703114, 1, 1>
    translate x*-1.136910
    rotate y*180
    rotate z*8.935839
    rotate y*-128.579963
    translate <-6.042432, 13.5, -8.316695>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 10.76 translate <-8.025449, 14, -5.830830> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 10.699195 }
      plane { x, 10.371060 inverse }
    }
    translate x*-10.699195
    scale <9.366447, 1, 1>
    translate x*-1.142290
    rotate y*180
    rotate z*9.256214
    rotate y*-110.344734
    translate <-8.025449, 14, -5.830830>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 10.43 translate <-9.092100, 14.5, -2.954202> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 10.366628 }
      plane { x, 10.038633 inverse }
    }
    translate x*-10.366628
    scale <9.030126, 1, 1>
    translate x*-1.148005
    rotate y*180
    rotate z*9.600018
    rotate y*-92.091755
    translate <-9.092100, 14.5, -2.954202>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 10.1 translate <-9.2, 15, 0> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 10.033847 }
      plane { x, 9.706008 inverse }
    }
    translate x*-10.033847
    scale <8.694197, 1, 1>
    translate x*-1.154085
    rotate y*180
    rotate z*9.969862
    rotate y*-73.818862
    translate <-9.2, 15, 0>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 9.77 translate <-8.407340, 15.5, 2.731710> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 9.700824 }
      plane { x, 9.373161 inverse }
    }
    translate x*-9.700824
    scale <8.358707, 1, 1>
    translate x*-1.160565
    rotate y*180
    rotate z*10.368759
    rotate y*-55.523638
    translate <-8.407340, 15.5, 2.731710>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 9.44 translate <-6.860464, 16, 4.984419> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 9.367528 }
      plane { x, 9.040062 inverse }
    }
    translate x*-9.367528
    scale <8.023703, 1, 1>
    translate x*-1.167482
    rotate y*180
    rotate z*10.800200
    rotate y*-37.203272
    translate <-6.860464, 16, 4.984419>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 9.11 translate <-4.772816, 16.5, 6.569218> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 9.033923 }
      plane { x, 8.706679 inverse }
    }
    translate x*-9.033923
    scale <7.689255, 1, 1>
    translate x*-1.174876
    rotate y*180
    rotate z*11.268229
    rotate y*-18.854426
    translate <-4.772816, 16.5, 6.569218>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 8.78 translate <-2.397972, 17, 7.380199> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 8.699966 }
      plane { x, 8.372974 inverse }
    }
    translate x*-8.699966
    scale <7.355440, 1, 1>
    translate x*-1.182793
    rotate y*180
    rotate z*11.777573
    rotate y*-0.473103
    translate <-2.397972, 17, 7.380199>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 8.45 translate <0, 17.5, 7.4> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 8.365605 }
      plane { x, 8.038901 inverse }
    }
    translate x*-8.365605
    scale <7.022345, 1, 1>
    translate x*-1.191284
    rotate y*180
    rotate z*12.333789
    rotate y*17.945328
    translate <0, 17.5, 7.4>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 8.12 translate <2.175480, 18, 6.695438> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 8.030780 }
      plane { x, 7.704406 inverse }
    }
    translate x*-8.030780
    scale <6.690073, 1, 1>
    translate x*-1.200402
    rotate y*180
    rotate z*12.943441
    rotate y*36.406587
    translate <2.175480, 18, 6.695438>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 7.79 translate <3.926405, 18.5, 5.404234> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 7.695421 }
      plane { x, 7.369427 inverse }
    }
    translate x*-7.695421
    scale <6.358767, 1, 1>
    translate x*-1.210206
    rotate y*180
    rotate z*13.614295
    rotate y*54.917483
    translate <3.926405, 18.5, 5.404234>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 7.46 translate <5.112987, 19, 3.714803> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 7.359439 }
      plane { x, 7.033888 inverse }
    }
    translate x*-7.359439
    scale <6.028575, 1, 1>
    translate x*-1.220759
    rotate y*180
    rotate z*14.355670
    rotate y*73.486397
    translate <5.112987, 19, 3.714803>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 7.13 translate <5.668297, 19.5, 1.841741> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 7.022732 }
      plane { x, 6.697697 inverse }
    }
    translate x*-7.022732
    scale <5.699689, 1, 1>
    translate x*-1.232126
    rotate y*180
    rotate z*15.178751
    rotate y*92.123718
    translate <5.668297, 19.5, 1.841741>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 6.8 translate <5.6, 20, -0> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 6.685174 }
      plane { x, 6.360747 inverse }
    }
    translate x*-6.685174
    scale <5.372357, 1, 1>
    translate x*-1.244365
    rotate y*180
    rotate z*16.097039
    rotate y*110.842321
    translate <5.6, 20, -0>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 6.47 translate <4.983536, 20.5, -1.619249> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 6.346614 }
      plane { x, 6.022907 inverse }
    }
    translate x*-6.346614
    scale <5.046876, 1, 1>
    translate x*-1.257533
    rotate y*180
    rotate z*17.126987
    rotate y*129.658554
    translate <4.983536, 20.5, -1.619249>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 6.14 translate <3.948003, 21, -2.868392> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 6.006869 }
      plane { x, 5.684024 inverse }
    }
    translate x*-6.006869
    scale <4.723632, 1, 1>
    translate x*-1.271663
    rotate y*180
    rotate z*18.288684
    rotate y*148.593386
    translate <3.948003, 21, -2.868392>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 5.81 translate <2.656789, 21.5, -3.656757> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 5.665718 }
      plane { x, 5.343913 inverse }
    }
    translate x*-5.665718
    scale <4.403111, 1, 1>
    translate x*-1.286754
    rotate y*180
    rotate z*19.606835
    rotate y*167.674035
    translate <2.656789, 21.5, -3.656757>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 5.48 translate <1.285511, 22, -3.956395> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 5.322903 }
      plane { x, 5.002363 inverse }
    }
    translate x*-5.322903
    scale <4.085966, 1, 1>
    translate x*-1.302728
    rotate y*180
    rotate z*21.111749
    rotate y*-173.063496
    translate <1.285511, 22, -3.956395>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 5.15 translate <-0, 22.5, -3.8> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 4.978122 }
      plane { x, 4.659135 inverse }
    }
    translate x*-4.978122
    scale <3.773035, 1, 1>
    translate x*-1.319395
    rotate y*180
    rotate z*22.840766
    rotate y*-153.570633
    translate <-0, 22.5, -3.8>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 4.82 translate <-1.063018, 23, -3.271634> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 4.631047 }
      plane { x, 4.313984 inverse }
    }
    translate x*-4.631047
    scale <3.465471, 1, 1>
    translate x*-1.336340
    rotate y*180
    rotate z*24.839270
    rotate y*-133.780866
    translate <-1.063018, 23, -3.271634>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 4.49 translate <-1.810379, 23.5, -2.491772> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 4.281360 }
      plane { x, 3.966695 inverse }
    }
    translate x*-4.281360
    scale <3.164827, 1, 1>
    translate x*-1.352794
    rotate y*180
    rotate z*27.161540
    rotate y*-113.600358
    translate <-1.810379, 23.5, -2.491772>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 4.16 translate <-2.200526, 24, -1.598776> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 3.928854 }
      plane { x, 3.617190 inverse }
    }
    translate x*-3.928854
    scale <2.873290, 1, 1>
    translate x*-1.367371
    rotate y*180
    rotate z*29.869268
    rotate y*-92.894757
    translate <-2.200526, 24, -1.598776>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 3.83 translate <-2.244493, 24.5, -0.729280> }
  object { Connector_2 texture { SNAIL_BONE }           
    clipped_by {
      plane { x, 3.573633 }
      plane { x, 3.265723 inverse }
    }
    translate x*-3.573633
    scale <2.593922, 1, 1>
    translate x*-1.377695
    rotate y*180
    rotate z*33.025855
    rotate y*-71.466140
    translate <-2.244493, 24.5, -0.729280>
  }
  sphere { 0, 1 texture { SNAIL_SKIN } scale 3.5 translate <-2, 25, 0> }
  bounded_by { sphere { 0, 60.445726 translate <3.45, 4.25, -3.45> } }
}

// ------------------ THE END OF THE SEA SHELL ---------------------------

//------------- THE SLIMMY BOBY ATTACHED TO THE SHELL -----

#declare SLIME_BODY =
object {
  union {
    sphere { 0, 1 scale <19.75, 19.75, 19.75> }  
    difference {
      object {  Connector_2 }  
      plane { x, 18.974120 inverse }
      plane { x, 17.052691 }
      translate x*-18.974120
      scale <3.461575, 1, 1>
      translate x*-5.481355
      rotate y*180
      rotate z*-2.385944
    }
    sphere { 0, 1 scale <17.75, 17.75, 17.75> translate <7.2, -0.3, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 17.745302 inverse }
      plane { x, 17.495368 }
      translate x*-17.745302
      scale <43.454344, 1, 1>
      translate x*-0.408367
      rotate y*180
      rotate z*-6.340192
      translate <7.2, -0.3, 0>
    }
    sphere { 0, 1 scale <17.5, 17.5, 17.5> translate <18, -1.5, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 17.320524 inverse }
      plane { x, 15.835908 }
      translate x*-17.320524
      scale <6.928524, 1, 1>
      translate x*-2.499887
      rotate y*180
      rotate z*-0.545658
      translate <18, -1.5, 0>
    }
    sphere { 0, 1 scale <16, 16, 16> translate <28.5, -1.6, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 15.993736 inverse }
      plane { x, 15.493932 }
      translate x*-15.993736
      scale <35.727860, 1, 1>
      translate x*-0.447654
      rotate y*180
      rotate z*9.989407
      translate <28.5, -1.6, 0>
    }
    sphere { 0, 1 scale <15.5, 15.5, 15.5> translate <46.1, 1.5, 0> }  
    difference {
      object { Connector_2 }
      plane { x, 15.215923 inverse }
      plane { x, 12.565407 }
      translate x*-15.215923
      scale <5.151078, 1, 1>
      translate x*-2.953930
      rotate y*180
      rotate z*26.855115
      rotate <0, 4.537773, 0>
      translate <46.1, 1.5, 0>
    }
    sphere { 0, 1 scale <12.8, 12.8, 12.8> translate <58.7, 7.9, -1> }  
    difference {
      object { Connector_2 }
      plane { x, 12.656484 inverse }
      plane { x, 10.876666 }
      translate x*-12.656484
      scale <6.621607, 1, 1>
      translate x*-1.911392
      rotate y*180
      rotate z*42.219572
      rotate y*9.673355
      translate <58.7, 7.9, -1>
    }
    sphere { 0, 1 scale <11, 11, 11> translate <67.5, 16, -2.5> }  
    difference {
      object { Connector_2 }
      plane { x, 10.929158 inverse }
      plane { x, 9.438819 }
      translate x*-10.929158
      scale <8.768631, 1, 1>
      translate x*-1.246393
      rotate y*180
      rotate z*65.021660
      rotate y*26.565051
      translate <67.5, 16, -2.5>
    }
    sphere { 0, 1 scale <9.5, 9.5, 9.5> translate <72.5, 28, -5> }  
    difference {
      object { Connector_2 }
      plane { x, 10.467692 inverse }
      plane { x, 9.470769 }
      translate x*-9.470769
      scale <12.718097, 1, 1>
      translate x*0.744669
      rotate z*64.348141
      rotate y*84.805571
      translate <72.5, 28, -5>
    }
    sphere { 0, 1 scale <10.5, 10.5, 10.5> translate <73, 39.5, -10.5> }  
    difference {        
      object { Connector_2 }
      plane { x, 9.613702 inverse }
      plane { x, 6.180237 }
      translate x*-9.613702
      scale <2.276957, 1, 1>
      translate x*-4.222171
      rotate y*180
      rotate z*46.816209
      rotate y*54.566686
      translate <73, 39.5, -10.5>
    }
    sphere { 0, 1 scale <6.75, 6.75, 6.75> translate <76.7, 46.3, -15.7> }  
  }
  texture { SLIME scale <80, 10, 80> }
  texture { pigment { color Orange filter 0.9 } finish { phong 1.0 phong_size 20 } normal { bumps 0.6 frequency 20 } }
  bounded_by { sphere { 0, 73.257941 translate <31.875, 16.65, -1.35> } }
}
// ---------------------- END OF SLIMMY BODY ---------------

// ----------- MAKE SNAIL ANTLERS ---------------------------
#declare ANTLERS =
object {
  union {
    difference {
      object { UCone scale <3, 40, 3> }
      plane { y, -10 inverse }
    }
    sphere { 0, 3 translate y*-10 }
  }
  texture { SLIME scale <8, 1, 8> }
  texture { pigment { color Orange filter 0.9 } finish { phong 1.0 phong_size 20 } normal { bumps 0.6 frequency 20 } }
  translate y*40
}

#declare EYEB =
sphere { 0, 1
  scale <2, 1.5, 2>
  texture { pigment { color Black } finish { phong 1 } }
  translate y*32.2
}

// ----------------------COMPOSITE THE SNAIL-------------------------
#declare BODY =
union {
  object { SLIME_BODY rotate y*-90 }
  object { ANTLERS rotate z*35 rotate x*-35 translate <13.6, 45, 70> }
  object { ANTLERS rotate z*-45 rotate x*-25 translate <17, 45, 70> }
  object { EYEB rotate z*35 rotate x*-35 translate <13.6, 45, 70> }
  object { EYEB rotate z*-45 rotate x*-25 translate <17, 45, 70> }
}
 
#declare THESNAIL = 
union {
  object { BODY translate <26, 0, 3> }
  object { snail scale <1.12, 1.1, 1.1> }
}

// ----------- THE TOTAL SNAIN / I AM SNAIL-SEE ME CRAWL----
//object { THESNAIL }