//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
//#include "textures.inc"
#include "Shapes_CJF.inc"
#include "TheSnail_CJF.INC"
#include "Hallway_CJF.INC"
#include "Panther_CJF.INC"

camera {
  location <0, 250, -350>
  direction z
  up y
  right x*image_width/image_height
  look_at y*80
}

sphere { 0, 5000
  hollow on
  texture {
    pigment { color MidnightBlue }
    finish { ambient 0.7 diffuse 0 }
  }
}

light_source { <  600,  400, -1000> color White }
light_source { <-1100, 2000,  -200> color White }

#declare Glass = 
texture {
  pigment { color rgbf <1, 1, 1, 0.7> }
  finish { ambient 0 diffuse 0 reflection { 0.1 } } //transmit 0 }
}

// ------------------------ The Wet Spots ------------------------
#declare PUDDLE =
union {
  sphere { 0, 1 scale <88.5, 4, 39> }
  sphere { 0, 1 scale <41.3, 4, 12> translate <-74.8, 0, 43> }
  sphere { 0, 1 scale <10.5, 5, 6.3> translate <-119, 0, 27.8> }
  texture { Glass
    finish { reflection { 0.43 } phong 0.5 phong_size 50 }
    normal { ripples 0.5 frequency 0.05 }
  }
  interior { ior 1.5 }
  bounded_by { box { -1, 1 scale <114.5, 5, 57.25> translate <-20.5, 0, 1.2> } }
}

fog { color Black distance 1700 }

// ---------------- BUILD STAGE --------------------------------------------
object { THE_FLOOR scale <0.6, 0.8, 0.6> rotate x*90 translate <50, -14, 1720> }
object { THESNAIL scale <1.7, 1.8, 1.5> rotate y*-12 translate <-130, 14, -60> }
object { WALL translate <-310, 0, 200> }
object { WALL scale <1.1, 1.2, 1.1> translate <1050, 0, 1830> }
//object { PBODY scale <1.7, 1.7, 1.7> rotate y*-90 rotate z*-5 translate <270, -40, -85> }
object { PUDDLE scale <1.2, 1, 1.3> translate <170, -9, -95> }
object { PANTHER scale 8.2 translate <20, -9, 1000> }

// -----------------TEST FLOOR -----------------------
//plane { y, -14 pigment { color Gray } }

