//                PANTHER         M.Miller 11/18/91 - with help from Truman
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare PAN1 = 
texture {
  pigment { colour rgb <0.15, 0.1, 0.1> }
  finish { reflection { 0.4 } crand 0.05 phong 0.5 phong_size 30 }
  normal { bumps 0.1 frequency 200 }
}
/*
texture { 
  pigment { image_map { png "fract003.png" } }
  scale <40, 40, 4>
  rotate z*180 
  finish { ambient 0.4 diffuse 0.7 phong 0.8 phong_size 25 }
}
*/
// ------------------------------THE HEAD-------------------------------
#declare Dot = quadric { 1, 0, 0, -1 }

#declare Connector_1a = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2a = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

// ------------------THE NECK---------------------------------------------
#declare neck =
union {
  sphere { 0, 6 }
  sphere { 0, 6 translate < 7,   -1.5, 0> }
  sphere { 0, 7 translate <16.5, -5,   0> }
}

#declare C1 = 
intersection { 
  object {Connector_2a } 
  plane { x, 6.576779 }
  plane { x, 5.978890 inverse }
  translate x*-5.978890
  scale <11.889538, 1, 1>
  translate x*0.502870
  rotate z*-12.094757
}

#declare C2 =
intersection {         
  object {Connector_2a } 
  plane { x, 6.994534 }
  plane { x, 6.594847 inverse }
  translate x*-6.594847
  scale <25.290809, 1, 1>
  translate x*0.260761
  rotate z*-20.224859
  translate <7, -1.5, 0>
}

// ---------------------THE NOSE---------------------------------------
#declare Connector_1b = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane { x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2b = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare C3 =
intersection { 
  object { Connector_2b } 
  plane { x, 4.898979 }
  plane { x, 3.919184 inverse }
  translate x*-3.919184
  scale <4.898979, 1.01, 1.01>
  translate x*0.8
}

#declare nose = 
object {
  difference {
    union {
      sphere { 0, 1 scale <2.3, 4, 4> }
      sphere { 0, 1 scale <2.5, 3.98, 3.98> translate x*0.3 }
      object { C3 }
      sphere { 0, 1 scale <4, 5, 5> translate x*5 }
      // -------------Cleff Palette------------------------------------------
      sphere { 0, 1 scale <3, 2, 3> translate <1, 1.7, -2> }
      sphere { 0, 3 translate <1, 0.7, -2> }
    }
    sphere { 0, 1 scale <2.2, 1.7, 7> translate <-0.5, -0.5, 0> }
  }   // ----------MOUTH OPENING--------------
}   
            

// -------------------GUMS------------------------------
#declare GUM =
union {
  cylinder { 0, y, 1 scale <3, 0.7, 3.5> translate y*1.2 }
  cylinder { 0, y, 1 scale <3, 0.7, 3.5> translate y*-1 }
}

// -----------Poodle Chew - Poodle Bite-----------------------------------
#declare CHOPPERS =
object {
  union {
    cylinder { 0, y, 1 scale <2.8, 0.7, 3.3> translate y*0.9 }
    cylinder { 0, y, 1 scale <2.8, 0.7, 3.3> translate y*-0.7 }
    object { DCone scale <0.4, 1.5, 0.4> translate <-2, -0.2, -2> }
    object { DCone scale <0.4, 1.5, 0.4> translate <-2, -0.2, 2> }
  } 
}

// ----------------THE SKULL---------------------------------------------
#declare Connector_1c = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2c = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare skull = 
object {
  difference {
    union {
      sphere { 0, 1 scale <3.2, 6.2, 6.2> }
      sphere { 0, 1 scale <6.5, 6.5, 6.5> translate < 3, -0.1, 0> }
      // ------SOCKET MOUND-----------------------------------------
      sphere { 0, 2 translate <1, 3.2, -4> }
      //--------------JAW----------------------------------------------------
      sphere { 0, 1 scale <4, 4, 2> translate <2.3, -0.5, -4.7> }
    }
    // ----------------Eye Sockets------------------------------------------
    object { Cylinder_X scale <1, 1.3, 1.3> translate <0, 3.1, 3.9> }
    object { Cylinder_X scale <1, 1.3, 1.3> translate <0, 3.1, -3.9> }
  }
}
   
#declare C4 =
intersection {
  object { Connector_2c } 
  plane { x, 6.467455 }
  plane { x, 6.168957 inverse }
  translate x*-6.168957
  scale <9.955456, 1, 1>
  translate x*0.619656
  rotate z*-1.909152
}

#declare EYE = // ---------------EYE BALL----------------
sphere { 0, 1
  scale <1.2, 1, 1.2>
  rotate y*50
}

#declare EAR = //-----EAR------
difference {
  sphere { 0, 1 scale <1.75, 3.5, 1.75> }
  sphere { 0, 1 scale <1.25, 3.5, 1.25> translate <-0.7, -0.5, 0> }
  rotate y*-65
}

// ---------------------------A Matching set---------------------------------
#declare EARS = 
union {
  object { EAR rotate z*-30 rotate x*30 translate z*6 }
  object { EAR rotate z*-30 rotate x*-30 translate z*-6 }
}

#declare BRIDGE = // ----------NOSE & BRIDGE------
union {
  cylinder { 0, x, 1 scale <6.5, 1.2, 1.2> }
  sphere { 0, 1 scale <1, 1.5, 1.5> }
  sphere { 0, 1.3 translate x*0.2 }
}

#declare ED = 
object {
  union {
    object { nose scale <1, 1, 1.4> rotate z*7 translate <-42.5, 24.3, 0> }
    object { skull scale <1.2, 1, 1.2> rotate z*4 translate <-38, 26, 0> }
    object { neck scale <1, 1, 0.8> translate <-33, 26.5, 0> }
    object { C1 translate <-33, 26.5, 0> }
    object { C2 translate <-33, 26.5, 0> }
    object { C4 scale <1.2, 1, 1.2> rotate z*4 translate <-38, 26, 0> }
    object { EARS  translate <-33, 29, 0> }
    object { BRIDGE scale <1, 1, 3> rotate z*16 translate <-44, 27.4, 0> }
    object { GUM translate <-41, 23.2, 0> }
  }
  texture { PAN1 }
  bounded_by { box { -1, 1 scale <18, 11, 11> translate <-28.8, 24.2, 0> } }
}

#declare HEAD =
union {
  object { ED }
  object { EYE translate <-39, 28.3, -6.3> }
  object { EYE translate <-39, 28.3, 6.3> }
  object { CHOPPERS translate <-41, 23.2, 0> }
  bounded_by { box { -1, 1 scale <18, 11, 11> translate <-28.8, 24.2, 0> } }
}

// ---------------------------- LEG1 -------------------------------------
#declare Connector_1 =
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare LEG011 =
union {
  sphere { <1, 3, 0>, 6 texture { PAN1 } }
  object {
    Connector_1
    scale <3.162278, 6, 6>
    rotate <0, 0, -71.565051>
    rotate <0, -180, 0>
    translate <1, 3, 0>
    texture { PAN1 }
  }
  sphere { 0, 6 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 5.541289 }
      plane { x, 3.232419 inverse }
    }
    translate <-5.541289, 0, 0>
    scale <2.408319, 1, 1>
    translate <-2.300895, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -57.528808>
    rotate <0, -180, 0>
    texture { PAN1 }
  }
  sphere { <-3.5, -5.5, 0>, 3.5 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 3.481912 }
      plane { x, 2.984496 inverse }
    }
    translate <-3.481912, 0, 0>
    scale <9.797959, 1, 1>
    translate <-0.355371, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -23.962489>
    rotate <0, -180, 0>
    translate <-3.5, -5.5, 0>
    texture { PAN1 }
  }
  sphere { <-8, -7.5, 0>, 3 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 2.986864 }
      plane { x, 2.489053 inverse }
    }
    translate <-2.986864, 0, 0>
    scale <10.650822, 1, 1>
    translate <-0.280435, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -20.806791>
    rotate <0, -180, 0>
    translate <-8, -7.5, 0>
    texture { PAN1 }
  }
  sphere { <-13, -9.400000, 0>, 2.5 texture { PAN1 } }
  object {
    Connector_1
    scale <3.848376, 2.5, 2.5>
    rotate <0, 0, -24.567171>
    rotate <0, -180, 0>
    translate <-13, -9.400000, 0>
    texture { PAN1 }
  }
  sphere { <-16.5, -11, 0>, 2.5 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 3.357082 }
      plane { x, 2.397916 inverse }
    }
    translate <-2.397916, 0, 0>
    scale <3.391165, 1, 1>
    translate <0.707107, 0, 0>
    rotate <0, 0, -8.130102>
    rotate <0, -180, 0>
    translate <-16.5, -11, 0>
    texture { PAN1 }
  }
  sphere { <-20, -11.5, 0>, 3.5 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 3.300744 }
      plane { x, 2.357674 inverse }
    }
    translate <-3.300744, 0, 0>
    scale <2.835489, 1, 1>
    translate <-1.164083, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -3.814075>
    rotate <0, -180, 0>
    translate <-20, -11.5, 0>
    texture { PAN1 }
  }
  sphere { <-23, -11.7, 0>, 2.5 texture { PAN1 } }
  //-----------------------PLACE CLAWS------------------------------------
  bounded_by { sphere { <-9.250000, -3, 0>, 23.180070 } }
}

#declare LEG01 =
object {
  LEG011
  bounded_by { sphere { <-9.250000, -3, 0>, 23.180070 } }
}

// -----------------------------  LEG 2 ---------------------------------
#declare Connector_1 =
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare LEG02 =
union{
  sphere { z, 4.5 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 4.048809 }
      plane { x, 3.149074 inverse }
    }
    translate <-4.048809, 0, 0>
    scale <2.061553, 1, 1>
    translate <-1.963961, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -60.794068>
    rotate <0, 116.565051, 0>
    translate <0, 0, 1>
    texture { PAN1 }
  }
  sphere { <-0.5, -2, 0>, 3.5 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 3.299832 }
      plane { x, 2.357023 inverse }
    }
    translate <-3.299832, 0, 0>
    scale <2.828427, 1, 1>
    translate <-1.166667, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -90>
    translate <-0.5, -2, 0>
    texture { PAN1 }
  }
  sphere { <-0.5, -5, 0>, 2.5 texture { PAN1 } }
  object{
    Connector_2
    clipped_by {
      plane { x, 2.934174 }
      plane { x, 2.445145 inverse }
    }
    translate <-2.445145, 0, 0>
    scale <4.694678, 1, 1>
    translate <0.520833, 0, 0>
    rotate <0, 0, -90>
    translate <-0.5, -5, 0>
    texture { PAN1 }
  }
  sphere { <-0.5, -7.400000, 0>, 3 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 2.910213 }
      plane { x, 1.940142 inverse }
    }
    translate <-2.910213, 0, 0>
    scale <3.994997, 1, 1>
    translate <-0.728464, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -60.945396>
    rotate <0, -180, 0>
    translate <-0.5, -7.400000, 0>
    texture { PAN1 }
  }
  sphere { <-2.5, -11, 0>, 2 texture { PAN1 } }
  object{
    Connector_1
    scale <2.828427, 2, 2>
    rotate <0, 0, -45>
    rotate <0, -180, 0>
    translate <-2.5, -11, 0>
    texture { PAN1 }
  }
  sphere { <-4.5, -13, 0>, 2 texture { PAN1 } }
  object{
    Connector_2
    clipped_by {
      plane { x, 2.759599 }
      plane { x, 1.839732 inverse }
    }
    translate <-1.839732, 0, 0>
    scale <2.345208, 1, 1>
    translate <0.784465, 0, 0>
    rotate <0, 0, -11.309932>
    rotate <0, -180, 0>
    translate <-4.5, -13, 0>
    texture { PAN1 }
  }
  sphere { <-7, -13.5, 0>, 3 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 2.598076 }
      plane { x, 1.732051 inverse }
    }
    translate <-2.598076, 0, 0>
    scale <1.732051, 1, 1>
    translate <-1.5, 0, 0>
    rotate <0, 180, 0>
    rotate <0, -180, 0>
    translate <-7, -13.5, 0>
    texture { PAN1 }
  }
  sphere { <-9, -13.5, 0>, 2 texture { PAN1 } }
  bounded_by { sphere { <-3.250000, -6, 1>, 15.184881 } }
}

// ----------------------------TAIL--------------------------
#declare Connector_1 =
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare Panther_Tail =
union {
  sphere { 0, 2.6 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 2.596073 }
      plane { x, 2.396375 inverse }
    }
    translate <-2.596073, 0, 0>
    scale <18.172782, 1, 1>
    translate <-0.142855, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -15.945396>
    texture { PAN1 }
  }
  sphere { <3.5, -1, 0>, 2.4 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 2.396687 }
      plane { x, 2.196963 inverse }
    }
    translate <-2.396687, 0, 0>
    scale <19.013153, 1, 1>
    translate <-0.126054, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -23.198591>
    translate <3.5, -1, 0>
    texture { PAN1 }
  }
  sphere { <7, -2.5, 0>, 2.2 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 2.197113 }
      plane { x, 1.997375 inverse }
    }
    translate <-2.197113, 0, 0>
    scale <19.5, 1, 1>
    translate <-0.112672, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -39.805571>
    translate <7, -2.5, 0>
    texture { PAN1 }
  }
  sphere { <10, -5, 0>, 2 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.997375 }
      plane { x, 1.797638 inverse }
    }
    translate <-1.997375, 0, 0>
    scale <19.5, 1, 1>
    translate <-0.102430, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -50.194429>
    translate <10, -5, 0>
    texture { PAN1 }
  }
  sphere { <12.5, -8, 0>, 1.8 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.797783 }
      plane { x, 1.598030 inverse }
    }
    translate <-1.797783, 0, 0>
    scale <20.130822, 1, 1>
    translate <-0.089305, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -60.255119>
    translate <12.5, -8, 0>
    texture { PAN1 }
  }
  sphere { <14.5, -11.5, 0>, 1.6 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.599448 }
      plane { x, 1.499483 inverse }
    }
    translate <-1.599448, 0, 0>
    scale <38.065733, 1, 1>
    translate <-0.042018, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -66.801409>
    translate <14.5, -11.5, 0>
    texture { PAN1 }
  }
  sphere { <16, -15, 0>, 1.5 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.499367 }
      plane { x, 1.399410 inverse }
    }
    translate <-1.499367, 0, 0>
    scale <34.423829, 1, 1>
    translate <-0.043556, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -64.179008>
    translate <16, -15, 0>
    texture { PAN1 }
  }
  sphere { <17.5, -18.1, 0>, 1.4 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.399126 }
      plane { x, 1.299188 inverse }
    }
    translate <-1.399126, 0, 0>
    scale <28.284271, 1, 1>
    translate <-0.049467, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -57.994617>
    translate <17.5, -18.1, 0>
    texture { PAN1 }
  }
  sphere { <19, -20.5, 0>, 1.3 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.299235 }
      plane { x, 1.199294 inverse }
    }
    translate <-1.299235, 0, 0>
    scale <29.137605, 1, 1>
    translate <-0.044590, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -59.036243>
    translate <19, -20.5, 0>
    texture { PAN1 }
  }
  sphere { <20.5, -23, 0>, 1.2 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.199414 }
      plane { x, 1.099463 inverse }
    }
    translate <-1.199414, 0, 0>
    scale <32, 1, 1>
    translate <-0.037482, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -51.340192>
    translate <20.5, -23, 0>
    texture { PAN1 }
  }
  sphere { <22.5, -25.5, 0>, 1.1 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 1.099450 }
      plane { x, 0.999500 inverse }
    }
    translate <-1.099450, 0, 0>
    scale <31.606961, 1, 1>
    translate <-0.034785, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, -18.434949>
    translate <22.5, -25.5, 0>
    texture { PAN1 }
  }
  sphere { <25.5, -26.5, 0>, 1 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 0.997775 }
      plane { x, 0.798220 inverse }
    }
    translate <-0.997775, 0, 0>
    scale <14.966630, 1, 1>
    translate <-0.066667, 0, 0>
    rotate <0, 180, 0>
    translate <25.5, -26.5, 0>
    texture { PAN1 }
  }
  sphere { <28.5, -26.5, 0>, 0.8 texture { PAN1 } }
  object {
    Connector_2
    clipped_by {
      plane { x, 0.798115 }
      plane { x, 0.598587 inverse }
    }
    translate <-0.798115, 0, 0>
    scale <14.543040, 1, 1>
    translate <-0.054880, 0, 0>
    rotate <0, 180, 0>
    rotate <0, 0, 30.963757>
    translate <28.5, -26.5, 0>
    texture { PAN1 }
  }
  sphere { <31, -25, 0>, 0.6 texture { PAN1 } }
  object {
    Connector_1
    scale <2.236068, 0.6, 0.6>
    rotate <0, 0, 63.434949>
    translate <31, -25, 0>
    texture { PAN1 }
  }
  sphere { <32, -23, 0>, 0.6 texture { PAN1 } }
  bounded_by { sphere { <15, -12.450000, 0>, 25.633127 } }
}

// -------------------------THE BODY--------------------------------
#declare S0Z = object { Cylinder_Z scale <0.9, 0.2, 0.2> }

#declare X01 = //--The New & Improved Space Age Solution--}
object {
  difference {
    union {
      object { S0Z translate y*-0.8 }
      object { S0Z translate y*0.8 }
      object { S0Z rotate z*90 translate x*-0.8 }
      object { S0Z rotate z*90 translate x*0.8 }
    }
    plane { z, -1 }
    plane { z,  1 inverse }
  }
}

#declare X01X = object { X01 rotate y*90 }
#declare X01Y = object { X01 rotate x*90 }
#declare X01Z = object { X01 }

#declare HP07 = // ---------The Main Bod---------------------
object {
  union {
    sphere { 0, 1 scale <25.4, 9, 8.5> rotate z*10 translate <1.9, 20.6, 0> }
    sphere { 0, 1 scale <11, 8, 8> rotate z*10 translate <16.5, 22.9, 0> }
    sphere { 0, 1 scale <11, 6.5, 6.5> rotate z*15 translate <-15.5, 22, 0> }
    sphere { 0, 1 scale <6, 5.5, 4> translate <-11.5, 14.5, 4> }
    sphere { 0, 1 scale <6, 5.5, 4> translate <-16.5, 14.5, -4> }
    sphere { 0, 1 scale <14.2, 9.75, 8.5> translate <-7.2, 18.7, 0> }
    sphere { 0, 1 scale <14, 6.5, 6.5> translate <-18, 22.5, 0> }
    sphere { 0, 6 translate <-14.5, 23, -3.1> }
  }
  texture { PAN1 }
  bounded_by { box { -1, 1 scale <31, 20, 11> translate <-2, 15, 0> } }
}

#declare LP02 = // -----------BACK HIP--------------------------
object {
  union {
    sphere { 0, 1 scale <6.4, 8.7, 4.4> rotate z*-30 translate <14.6, 19.6, -6> }
    sphere { 0, 1 scale <6.4, 8.8, 4.4> rotate z*-40 translate <18, 20, -6> }
  }
  texture { PAN1 }
  bounded_by { box { -1, 1 scale <11, 15, 5> translate <11.7, 13.7, -6> } }
}

#declare LP03 = // -----------FRONT Back Leg-------------------
object {
  union {
    sphere { 0, 1 scale <4, 3, 3> translate <-3.7, 2, 6> }
    sphere { 0, 1 scale <3, 3, 2> translate <-6, 1.8, 6> }
    object {
      Y_Disk
      scale <2.5, 13, 2.5>
      translate y*-6.5
      rotate z*10
      translate <-3.1, 7.9, 6>
    }
  }
  texture { PAN1 }
  bounded_by { box { -1, 1 scale <5.5, 8, 4> translate <-3.5, 7, 6> } }
}

#declare LP04 = // -----------Back Stretched Leg----
object {
  union {
    sphere { 0, 1 scale <5.2,  9.5, 3.25> rotate z*61 translate <25.6, 16.5, 6> }
    sphere { 0, 1 scale <7.25, 7,   3.5> translate <22.2, 20.5, 6.5> }
    sphere { 0, 1 scale <4.5,  2.5, 2>   translate <35,   11,   6> }
    sphere { 0, 1 scale <4,    3.5, 4>   translate <40,    1,   6> }
    sphere { 0, 1 scale <2,    3,   2>   translate <37,    0.8, 6> }
    object {
      Y_Disk
      scale <1.8, 11.5, 2>
      translate y*-5.75
      rotate z*27
      translate <39.7, 5.7, 6>
    }
  }
  texture { PAN1 }
  bounded_by { box { -1, 1 scale <16, 15, 6> translate <30, 13.2, 6> } }
}

// --------------------PUT IT TOGETHER---------------------------------
#declare PANTHER =
union {
  object { HP07 }
  object { LP02 }
  object { LP03 }
  object { LP04 }
  object { Panther_Tail translate <20, 28, 0> }
  object { LEG01 translate <-17, 15,   -6> }
  object { LEG02 translate < 13, 15.5, -6> }
  object { HEAD }
}