//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "Lizard_CJF.INC"

/*---This dat is the top "head" half of snake------*/

/*------------------------------THE HEAD-------------------------------*/

#declare Dot = sphere { 0, 1 }

#declare Connector_1a = cylinder { -x, x, 1 }

#declare Connector_2a = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }


// ---------------------THE NOSE---------------------------------------
#declare Connector_1b = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
 }
}

#declare Connector_2b = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare C3 =
intersection { 
  object { Connector_2b } 
  plane { x, 4.898979 }
  plane { x, 3.919184 inverse }
  translate x*-3.919184
  scale <4.898979, 1.01, 1.01>
  translate x*0.8
}

#declare nose = 
object {
  difference {
    union {
      sphere { 0, 1 scale <2.3, 4, 4> }
      sphere { 0, 1 scale <2.5, 3.98, 3.98> translate x*0.3 }
      object { C3 }
      sphere { 0, 1 scale <4, 5, 5> translate x*5 }
      // -------------Cleff Palette------------------------------------------
      sphere { 0, 1 scale <3, 2, 3> translate <1, 1.7, -2> }
      sphere { 0, 3 translate <1, 0.7, -2> }
    }
    sphere { 0, 1 scale <2.2, 1.7, 7> translate <-0.5, -0.5, 0> }
  }   // ----------MOUTH OPENING--------------
}   
            

// -------------------GUMS------------------------------
#declare GUM =
union {
  cylinder { 0, y, 1 scale <3, 0.7, 3.5> translate <-1, 1.3, 0> }
  cylinder { 0, y, 1 scale <3, 0.7, 3.5> translate <-0.3, -1.2, 0> }
}

// -----------Poodle Chew - Poodle Bite-----------------------------------
#declare CHOPPERS =
object {
  union {
    cylinder { 0, y, 1 scale <2.8, 0.7, 3.3> translate <-1, 1.1, 0> }
    cylinder { 0, y, 1 scale <2.8, 0.7, 3.3> translate <-0.5, -0.95, 0> }
  } 
  texture { pigment { color Firebrick } finish { phong 1.0 } }
}

#declare fangs =
object {
  union {
    object { DCone scale <0.5, 1.9, 0.5> translate <-2.5, -0.5, -2.5> }
    object { DCone scale <0.5, 1.9, 0.5> translate <-2.5, -0.5, 2.5> }
  }
  texture { pigment { color White } finish { phong 1 } }
}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*----------------THE SKULL---------------------------------------------*/
#declare Connector_1c = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2c = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare skull = 
object {
  difference {
    union {
      sphere { 0, 1 scale <3.2, 6.2, 6.2> }
      sphere { 0, 1 scale <6.5, 6.5, 6.5> translate < 3, -0.1, 0> }
      // ------SOCKET MOUND-----------------------------------------
      sphere { 0, 2 translate <1, 3.2, -4> }
      //--------------JAW----------------------------------------------------
      //sphere { 0, 1 scale <4, 4, 2> translate <2.3, -0.5, -4.7> }
    }
    // ----------------Eye Sockets------------------------------------------
    object { Cylinder_X scale <1, 1.3, 1.3> translate <0, 3.1, 3.9> }
    object { Cylinder_X scale <1, 1.3, 1.3> translate <0, 3.1, -3.9> }
  }
}
   
#declare C4 =
intersection {
  object { Connector_2c } 
  plane { x, 6.467455 }
  plane { x, 6.168957 inverse }
  translate x*-6.168957
  scale <9.955456, 1, 1>
  translate x*0.619656
  rotate z*-1.909152
}


#declare EYE = // ---------------EYE BALL----------------
sphere { 0, 1.5
  pigment { color Black } finish { phong 1.0 }
}

#declare EAR = //-----EAR------
difference {
  sphere { 0, 1 scale <1.75, 3.5, 1.75> }
  sphere { 0, 1 scale <1.25, 3.5, 1.25> translate <-0.7, -0.5, 0> }
  rotate y*-65
}

// ---------------------------A Matching set---------------------------------
#declare EARS = 
union {
  object { EAR rotate z*-30 rotate x*30 translate z*6 }
  object { EAR rotate z*-30 rotate x*-30 translate z*-6 }
}

#declare BRIDGE = // ----------NOSE & BRIDGE------
union {
  cylinder { 0, x, 1 scale <6.5, 1.2, 1.2> }
  sphere { 0, 1 scale <1, 1.5, 1.5> }
  sphere { 0, 1.3 translate x*0.2 }
}

#declare ED = 
object {
  union {
    object { nose scale <1, 1, 1.4> rotate z*7 translate <-42.5, 24.3, 0> }
    object { skull scale <1.2, 1, 1.2> rotate z*4 translate <-38, 26, 0> }
    object { C4 scale <1.2, 1, 1.2> rotate z*4 translate <-38, 26, 0> }
    object { EARS  translate <-33, 29, 0> }
    object { BRIDGE scale <1, 1, 3> rotate z*16 translate <-44, 27.4, 0> }
    object { GUM translate <-41, 23.2, 0> }
  }
  texture { shead }
}

#declare HEAD =
union {
  object { ED }
  object { EYE translate <-39, 28.3, -6.3> }
  object { EYE translate <-39, 28.3, 6.3> }
  object { CHOPPERS translate <-41, 23.2, 0> }
  object { fangs translate <-41, 23.2, 0> }
  translate <38, -26, 0>
}

/*-----STRIPPED CTDS DATA / MOVED TEXTURE STATEMENT BEFORE SCALE/TRANS.--*/
#declare top =
union {
  sphere { 0, 9 translate x*23 texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.998481 }
      plane { x, 8.922304 inverse }
    }
    translate x*-8.998481
    scale <54.415615, 1, 1>
    translate x*-0.165366
    rotate y*180
    rotate z*7.920896
    rotate y*-99.646625
    translate x*23
  }
  sphere { 0, 8.923810 translate <22.311775, 0.571429, 4.048990> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.922261 }
      plane { x, 8.846083 inverse }
    }
    translate x*-8.922261
    scale <53.662584, 1, 1>
    translate x*-0.166266
    rotate y*180
    rotate z*8.032618
    rotate y*-109.996853
    translate <22.311775, 0.571429, 4.048990>
  }
  sphere { 0, 8.847619 translate <20.927078, 1.142857, 7.854064> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.846039 }
      plane { x, 8.769863 inverse }
    }
    translate x*8.846039
    scale <52.911216, 1, 1>
    translate x*-0.167186
    rotate y*180
    rotate z*8.147536
    rotate y*-120.348924
    translate <20.927078, 1.142857, 7.854064>
  }
  sphere { 0, 8.771429 translate <18.910401, 1.714286, 11.298438> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.769817 }
      plane { x, 8.693640 inverse }
    }
    translate x*-8.769817
    scale <52.158772, 1, 1>
    translate x*-0.168137
    rotate y*180
    rotate z*8.265722
    rotate y*-130.702976
    translate <18.910401, 1.714286, 11.298438>
  }
  sphere { 0, 8.695238 translate <16.345237, 2.285714, 14.280403> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.693593 }
      plane { x, 8.617418 inverse }
    }
    translate x*-8.693593
    scale <51.407990, 1, 1>
    translate x*-0.169110
    rotate y*180
    rotate z*8.387381
    rotate y*-141.059043
    translate <16.345237, 2.285714, 14.280403>
  }
  sphere { 0, 8.619048 translate <13.330806, 2.857143, 16.716302> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.617369 }
      plane { x, 8.541193 inverse }
    }
    translate x*-8.617369
    scale <50.656162, 1, 1>
    translate x*-0.170115
    rotate y*180
    rotate z*8.512606
    rotate y*-151.417270
    translate <13.330806, 2.857143, 16.716302>
  }
  sphere { 0, 8.542857 translate <9.978320, 3.428571, 18.542826> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.541143 }
      plane { x, 8.464968 inverse }
    }
    translate x*-8.541143
    scale <49.905998, 1, 1>
    translate x*-0.171145
    rotate y*180
    rotate z*8.641613
    rotate y*-161.777707
    translate <9.978320, 3.428571, 18.542826>
  }
  sphere { 0, 8.466667 translate <6.406952, 4, 19.718572> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.464915 }
      plane { x, 8.388740 inverse }
    }
    translate x*-8.464915
    scale <49.154855, 1, 1>
    translate x*-0.172209
    rotate y*180
    rotate z*8.774531
    rotate y*-172.140486
    translate <6.406952, 4, 19.718572>
  }
  sphere { 0, 8.390476 translate <2.739637, 4.571429, 20.224813> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.388686 }
      plane { x, 8.312512 inverse }
    }
    translate x*-8.388686
    scale <48.405368, 1, 1>
    translate x*-0.173301
    rotate y*180
    rotate z*8.911533
    rotate y*177.494280
    translate <2.739637, 4.571429, 20.224813>
  }
  sphere { 0, 8.314286 translate <-0.901142, 5.142857, 20.065489> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.312456 }
      plane { x, 8.236282 inverse }
    }
    translate x*-8.312456
    scale <47.654995, 1, 1>
    translate x*-0.174430
    rotate y*180
    rotate z*9.052858
    rotate y*167.126515
    translate <-0.901142, 5.142857, 20.065489>
  }
  sphere { 0, 8.238095 translate <-4.397438, 5.714286, 19.266433> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.236224 }
      plane { x, 8.160051 inverse }
    }
    translate x*-8.236224
    scale <46.906246, 1, 1>
    translate x*-0.175589
    rotate y*180
    rotate z*9.198650
    rotate y*156.756007
    translate <-4.397438, 5.714286, 19.266433>
  }
  sphere { 0, 8.161905 translate <-7.639658, 6.285714, 17.873868> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.159990 }
      plane { x, 8.083817 inverse }
    }
    translate x*-8.159990
    scale <46.156681, 1, 1>
    translate x*-0.176789
    rotate y*180
    rotate z*9.349184
    rotate y*146.382730
    translate <-7.639658, 6.285714, 17.873868>
  }
  sphere { 0, 8.085714 translate <-10.530002, 6.857143, 15.952272> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.083754 }
      plane { x, 8.007582 inverse }
    }
    translate x*-8.083754
    scale <45.408774, 1, 1>
    translate x*-0.178022
    rotate y*180
    rotate z*9.504621
    rotate y*136.006454
    translate <-10.530002, 6.857143, 15.952272>
  }
  sphere { 0, 8.009524 translate <-12.985396, 7.428571, 13.581660> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 8.007517 }
      plane { x, 7.931345 inverse }
    }
    translate x*-8.007517
    scale <44.660129, 1, 1>
    translate x*-0.179299
    rotate y*180
    rotate z*9.665273
    rotate y*125.627061
    translate <-12.985396, 7.428571, 13.581660>
  }
  sphere { 0, 7.933333 translate <-14.939847, 8, 10.854434> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.931277 }
      plane { x, 7.855107 inverse }
    }
    translate x*-7.931277
    scale <43.913108, 1, 1>
    translate x*-0.180613
    rotate y*180
    rotate z*9.831356
    rotate y*115.244396
    translate <-14.939847, 8, 10.854434>
  }
  sphere { 0, 7.857143 translate <-16.346149, 8.571429, 7.871891> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.855035 }
      plane { x, 7.778865 inverse }
    }
    translate x*-7.855035
    scale <43.165467, 1, 1>
    translate x*-0.181975
    rotate y*180
    rotate z*10.003133
    rotate y*104.858271
    translate <-16.346149, 8.571429, 7.871891>
  }
  sphere { 0, 7.780952 translate <-17.176900, 9.142857, 4.740523> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.778791 }
      plane { x, 7.702622 inverse }
    }
    translate x*-7.778791
    scale <42.419466, 1, 1>
    translate x*-0.183378
    rotate y*180
    rotate z*10.180965
    rotate y*94.468488
    translate <-17.176900, 9.142857, 4.740523>
  }
  sphere { 0, 7.704762 translate <-17.424807, 9.714286, 1.568261> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.702545 }
      plane { x, 7.626376 inverse }
    }
    translate x*-7.702545
    scale <41.672914, 1, 1>
    translate x*-0.184833
    rotate y*180
    rotate z*10.365089
    rotate y*84.074871
    translate <-17.424807, 9.714286, 1.568261>
  }
  sphere { 0, 7.628571 translate <-17.102301, 10.285714, -1.539235> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.626295 }
      plane { x, 7.550128 inverse }
    }
    translate x*-7.626295
    scale <40.928041, 1, 1>
    translate x*-0.186334
    rotate y*180
    rotate z*10.555919
    rotate y*73.677191
    translate <-17.102301, 10.285714, -1.539235>
  }
  sphere { 0, 7.552381 translate <-16.240479, 10.857143, -4.482087> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.550043 }
      plane { x, 7.473876 inverse }
    }
    translate x*-7.550043
    scale <40.182722, 1, 1>
    translate x*-0.187893
    rotate y*180
    rotate z*10.753739
    rotate y*63.275207
    translate <-16.240479, 10.857143, -4.482087>
  }
  sphere { 0, 7.476190 translate <-14.887438, 11.428571, -7.169412> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.473788 }
      plane { x, 7.397622 inverse }
    }
    translate x*-7.473788
    scale <39.439113, 1, 1>
    translate x*-0.189502
    rotate y*180
    rotate z*10.959016
    rotate y*52.868670
    translate <-14.887438, 11.428571, -7.169412>
  }
  sphere { 0, 7.400000 translate <-13.106075, 12, -9.522121> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.397530 }
      plane { x, 7.321366 inverse }
    }
    translate x*-7.397530
    scale <38.695660, 1, 1>
    translate x*-0.191172
    rotate y*180
    rotate z*11.172111
    rotate y*42.457327
    translate <-13.106075, 12, -9.522121>
  }
  sphere { 0, 7.323810 translate <-10.971442, 12.571429, -11.475229> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.321269 }
      plane { x, 7.245104 inverse }
    }
    translate x*-7.321269
    scale <37.952435, 1, 1>
    translate x*-0.192906
    rotate y*180
    rotate z*11.393472
    rotate y*32.040864
    translate <-10.971442, 12.571429, -11.475229>
  }
  sphere { 0, 7.247619 translate <-8.567760, 13.142857, -12.979601> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.245003 }
      plane { x, 7.168841 inverse }
    }
    translate x*-7.245003
    scale <37.211005, 1, 1>
    translate x*-0.194701
    rotate y*180
    rotate z*11.623633
    rotate y*21.618968
    translate <-8.567760, 13.142857, -12.979601>
  }
  sphere { 0, 7.171429 translate <-5.985210, 13.714286, -14.003094> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.168735 }
      plane { x, 7.092572 inverse }
    }
    translate x*-7.168735
    scale <36.469407, 1, 1>
    translate x*-0.196568
    rotate y*180
    rotate z*11.863040
    rotate y*11.191309
    translate <-5.985210, 13.714286, -14.003094>
  }
  sphere { 0, 7.095238 translate <-3.316622, 14.285714, -14.531068> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.092461 }
      plane { x, 7.016301 inverse }
    }
    translate x*-7.092461
    scale <35.729659, 1, 1>
    translate x*-0.198503
    rotate y*180
    rotate z*12.112328
    rotate y*0.757501
    translate <-3.316622, 14.285714, -14.531068>
  }
  sphere { 0, 7.019048 translate <-0.654172, 14.857143, -14.566270> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 7.016183 }
      plane { x, 6.940023 inverse }
    }
    translate x*-7.016183
    scale <34.989887, 1, 1>
    translate x*-0.200520
    rotate y*180
    rotate z*12.372027
    rotate y*-9.682860
    translate <-0.654172, 14.857143, -14.566270>
  }
  sphere { 0, 6.942857 translate <1.913783, 15.428571, -14.128112> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.939900 }
      plane { x, 6.863742 inverse }
    }
    translate x*-6.939900
    scale <34.252035, 1, 1>
    translate x*-0.202613
    rotate y*180
    rotate z*12.642869
    rotate y*-20.130219
    translate <1.913783, 15.428571, -14.128112>
  }
  sphere { 0, 6.866667 translate <4.305637, 16, -13.251387> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.863612 }
      plane { x, 6.787455 inverse }
    }
    translate x*-6.863612
    scale <33.514332, 1, 1>
    translate x*-0.204796
    rotate y*180
    rotate z*12.925501
    rotate y*-30.585037
    translate <4.305637, 16, -13.251387>
  }
  sphere { 0, 6.790476 translate <6.449127, 16.571429, -11.984486> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.787318 }
      plane { x, 6.711164 inverse }
    }
    translate x*-6.787318
    scale <32.778640, 1, 1>
    translate x*-0.207065
    rotate y*180
    rotate z*13.220685
    rotate y*-41.047890
    translate <6.449127, 16.571429, -11.984486>
  }
  sphere { 0, 6.714286 translate <8.283507, 17.142857, -10.387190> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.711019 }
      plane { x, 6.634865 inverse }
    }
    translate x*-6.711019
    scale <32.043317, 1, 1>
    translate x*-0.209436
    rotate y*180
    rotate z*13.529315
    rotate y*-51.519296
    translate <8.283507, 17.142857, -10.387190>
  }
  sphere { 0, 6.638095 translate <9.761241, 17.714286, -8.528139> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.634712 }
      plane { x, 6.558561 inverse }
    }
    translate x*-6.634712
    scale <31.310094, 1, 1>
    translate x*-0.211903
    rotate y*180
    rotate z*13.852225
    rotate y*-61.999939
    translate <9.761241, 17.714286, -8.528139>
  }
  sphere { 0, 6.561905 translate <10.849158, 18.285714, -6.482070> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.558399 }
      plane { x, 6.482248 inverse }
    }
    translate x*-6.558399
    scale <30.577453, 1, 1>
    translate x*-0.214485
    rotate y*180
    rotate z*14.190474
    rotate y*-72.490498
    translate <10.849158, 18.285714, -6.482070>
  }
  sphere { 0, 6.485714 translate <11.529064, 18.857143, -4.326930> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.482077 }
      plane { x, 6.405930 inverse }
    }
    translate x*-6.482077
    scale <29.847095, 1, 1>
    translate x*-0.217176
    rotate y*180
    rotate z*14.545049
    rotate y*-82.991754
    translate <11.529064, 18.857143, -4.326930>
  }
  sphere { 0, 6.409524 translate <11.797784, 19.428571, -2.140982> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.405747 }
      plane { x, 6.329601 inverse }
    }
    translate x*-6.405747
    scale <29.117551, 1, 1>
    translate x*-0.219996
    rotate y*180
    rotate z*14.917222
    rotate y*-93.504504
    translate <11.797784, 19.428571, -2.140982>
  }
  sphere { 0, 6.333333 translate <11.666667, 20, 0> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.329408 }
      plane { x, 6.253265 inverse }
    }
    translate x*-6.329408
    scale <28.390495, 1, 1>
    translate x*-0.222941
    rotate y*180
    rotate z*15.308197
    rotate y*-104.029793
    translate <11.666667, 20, 0>
  }
  sphere { 0, 6.257143 translate <11.160573, 20.571429, 2.025345> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.253059 }
      plane { x, 6.176918 inverse }
    }
    translate x*-6.253059
    scale <27.664556, 1, 1>
    translate x*-0.226031
    rotate y*180
    rotate z*15.719373
    rotate y*-114.568582
    translate <11.160573, 20.571429, 2.025345>
  }
  sphere { 0, 6.180952 translate <10.316417, 21.142857, 3.871816> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.176699 }
      plane { x, 6.100561 inverse }
    }
    translate x*-6.176699
    scale <26.941351, 1, 1>
    translate x*-0.229265
    rotate y*180
    rotate z*16.152378
    rotate y*-125.122112
    translate <10.316417, 21.142857, 3.871816>
  }
  sphere { 0, 6.104762 translate <9.181314, 21.714286, 5.485580> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.100327 }
      plane { x, 6.024191 inverse }
    }
    translate x*-6.100327
    scale <26.219599, 1, 1>
    translate x*-0.232663
    rotate y*180
    rotate z*16.608797
    rotate y*-135.691601
    translate <9.181314, 21.714286, 5.485580>
  }
  sphere { 0, 6.028571 translate <7.810427, 22.285714, 6.823765> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 6.023941 }
      plane { x, 5.947810 inverse }
    }
    translate x*-6.023941
    scale <25.500904, 1, 1>
    translate x*-0.236225
    rotate y*180
    rotate z*17.090593
    rotate y*-146.278622
    translate <7.810427, 22.285714, 6.823765>
  }
  sphere { 0, 5.952381 translate <6.264588, 22.857143, 7.855545> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.947542 }
      plane { x, 5.871413 inverse }
    }
    translate x*-5.947542
    scale <24.784093, 1, 1>
    translate x*-0.239974
    rotate y*180
    rotate z*17.599709
    rotate y*-156.884732
    translate <6.264588, 22.857143, 7.855545>
  }
  sphere { 0, 5.876190 translate <4.607809, 23.428571, 8.562743> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.871126 }
      plane { x, 5.795001 inverse }
    }
    translate x*-5.871126
    scale <24.070745, 1, 1>
    translate x*-0.243911
    rotate y*180
    rotate z*18.138508
    rotate y*-167.511829
    translate <4.607809, 23.428571, 8.562743>
  }
  sphere { 0, 5.800000 translate <2.904760, 24, 8.939931> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.794693 }
      plane { x, 5.718573 inverse }
    }
    translate x*-5.794693
    scale <23.360106, 1, 1>
    translate x*-0.248059
    rotate y*180
    rotate z*18.709416
    rotate y*-178.161997
    translate <2.904760, 24, 8.939931>
  }
  sphere { 0, 5.723810 translate <1.218327, 24.571429, 8.994049> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.718241 }
      plane { x, 5.642124 inverse }
    }
    translate x*-5.718241
    scale <22.652506, 1, 1>
    translate x*-0.252433
    rotate y*180
    rotate z*19.315181
    rotate y*171.162323
    translate <1.218327, 24.571429, 8.994049>
  }
  sphere { 0, 5.647619 translate <-0.392674, 25.142857, 8.743568> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.641767 }
      plane { x, 5.565656 inverse }
    }
    translate x*-5.641767
    scale <21.949166, 1, 1>
    translate x*-0.257038
    rotate y*180
    rotate z*19.958958
    rotate y*160.458477
    translate <-0.392674, 25.142857, 8.743568>
  }
  sphere { 0, 5.571429 translate <-1.875534, 25.714286, 8.217250> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.565270 }
      plane { x, 5.489163 inverse }
    }
    translate x*-5.565270
    scale <21.249248, 1, 1>
    translate x*-0.261904
    rotate y*180
    rotate z*20.644019
    rotate y*149.723245
    translate <-1.875534, 25.714286, 8.217250>
  }
  sphere { 0, 5.495238 translate <-3.185374, 26.285714, 7.452554> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.488746 }
      plane { x, 5.412646 inverse }
    }
    translate x*-5.488746
    scale <20.554350, 1, 1>
    translate x*-0.267036
    rotate y*180
    rotate z*21.374216
    rotate y*138.953142
    translate <-3.185374, 26.285714, 7.452554>
  }
  sphere { 0, 5.419048 translate <-4.286503, 26.857143, 6.493775> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.412194 }
      plane { x, 5.336099 inverse }
    }
    translate x*-5.412194
    scale <19.863787, 1, 1>
    translate x*-0.272465
    rotate y*180
    rotate z*22.153607
    rotate y*128.143951
    translate <-4.286503, 26.857143, 6.493775>
  }
  sphere { 0, 5.342857 translate <-5.153353, 27.428571, 5.389985> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.335609 }
      plane { x, 5.259523 inverse }
    }
    translate x*-5.335609
    scale <19.179191, 1, 1>
    translate x*-0.278198
    rotate y*180
    rotate z*22.986927
    rotate y*117.290809
    translate <-5.153353, 27.428571, 5.389985>
  }
  sphere { 0, 5.266667 translate <-5.770988, 28, 4.192868> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.258990 }
      plane { x, 5.182910 inverse }
    }
    translate x*-5.258990
    scale <18.500095, 1, 1>
    translate x*-0.284268
    rotate y*180
    rotate z*23.879214
    rotate y*106.388155
    translate <-5.770988, 28, 4.192868>
  }
  sphere { 0, 5.190476 translate <-6.135169, 28.571429, 2.954542> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.182330 }
      plane { x, 5.106260 inverse }
    }
    translate x*-5.182330
    scale <17.828219, 1, 1>
    translate x*-0.290681
    rotate y*180
    rotate z*24.836063
    rotate y*95.429317
    translate <-6.135169, 28.571429, 2.954542>
  }
  sphere { 0, 5.114286 translate <-6.251988, 29.142857, 1.725439> texture { bones } }
  object { Connector_2
    texture { skin }
    clipped_by {
      plane { x, 5.094784 }
      plane { x, 4.980934 inverse }
    }
    translate x*-5.094784
    scale <11.417999, 1, 1>
    translate x*-0.446206
    rotate y*180
    rotate z*25.863872
    rotate y*84.406457
    translate <-6.251988, 29.142857, 1.725439>
  }
  sphere { 0, 5 translate <-6.137099, 29.714286, 0.552349> texture { bones } }
}