//------- DECLARE TEXTURES FOR MULTI LAYERED MARBLES -----------
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//---------------LIGHT CREAM MOSS / GOOD FOR 1st LAYER TONE----------------
#declare MARBLE1 =
texture {
  pigment {
    marble
    turbulence 0.4
    color_map {
      [0.000 0.154 color red 0.690 green 0.612 blue 0.569 filter 0.000 color red 0.737 green 0.596 blue 0.522 filter 0.000]
      [0.154 0.368 color red 0.737 green 0.596 blue 0.522 filter 0.000 color red 0.776 green 0.702 blue 0.624 filter 0.000]
      [0.368 0.538 color red 0.776 green 0.702 blue 0.624 filter 0.000 color red 0.796 green 0.678 blue 0.643 filter 0.000]
      [0.538 0.846 color red 0.796 green 0.678 blue 0.643 filter 0.000 color red 0.690 green 0.612 blue 0.569 filter 0.000]
      [0.846 0.932 color red 0.690 green 0.612 blue 0.569 filter 0.000 color red 0.773 green 0.612 blue 0.569 filter 0.000]
      [0.932 1.001 color red 0.773 green 0.612 blue 0.569 filter 0.000 color red 0.690 green 0.612 blue 0.569 filter 0.000]
    }
  }
}

//-------------------DEEP THAN MARBLE1 With filter For SECOND LAYERS--------
#declare MARBLE2 =
texture {
  pigment {
    marble
    turbulence 0.5
    color_map {
      [0.000 0.291 color red 0.690 green 0.612 blue 0.569 filter 1.00  color red 0.737 green 0.596 blue 0.522 filter 0.500]
      [0.291 0.316 color red 0.737 green 0.596 blue 0.522 filter 0.500 color red 0.667 green 0.561 blue 0.514 filter 0.300]
      [0.316 0.436 color red 0.667 green 0.561 blue 0.514 filter 0.300 color red 0.788 green 0.667 blue 0.631 filter 0.500]
      [0.436 0.641 color red 0.788 green 0.667 blue 0.631 filter 0.500 color red 0.604 green 0.506 blue 0.455 filter 0.700]
      [0.641 0.692 color red 0.604 green 0.506 blue 0.455 filter 0.700 color red 0.773 green 0.612 blue 0.569 filter 0.400]
      [0.692 1.001 color red 0.773 green 0.612 blue 0.569 filter 0.400 color red 0.690 green 0.612 blue 0.569 filter 1.000]
    }
  }
}

//-------------------LIGHTER THAN MARBLE2 With filter For SECOND LAYERS--------
#declare MARBLE_light =
texture {
  pigment {
    marble
    turbulence 0.5
    color_map {
      [0.000 0.291 color red 0.690 green 0.612 blue 0.569 filter 0.6   color red 0.737 green 0.596 blue 0.522 filter 0.900]
      [0.291 0.316 color red 0.737 green 0.596 blue 0.522 filter 0.900 color red 0.667 green 0.561 blue 0.514 filter 0.700]
      [0.316 0.436 color red 0.667 green 0.561 blue 0.514 filter 0.700 color red 0.788 green 0.667 blue 0.631 filter 0.600]
      [0.436 0.641 color red 0.788 green 0.667 blue 0.631 filter 0.600 color red 0.604 green 0.506 blue 0.455 filter 0.700]
      [0.641 0.692 color red 0.604 green 0.506 blue 0.455 filter 0.700 color red 0.773 green 0.612 blue 0.569 filter 0.100]
      [0.692 1.001 color red 0.773 green 0.612 blue 0.569 filter 0.100 color red 0.690 green 0.612 blue 0.569 filter 1.000]
    }
  }
}

//--------------------Crack & OverTint /Green---------------------
#declare marble3 =
texture {
  pigment {
    marble
    turbulence 0.7
    color_map {
      [0.0  0.05  color Black   filter 0.6  color Black   filter 1.0]
      [0.05 0.90  color DimGray filter 0.85 color DimGray filter 0.90]
      [0.90 1.001 color Black   filter 0.9  color Black   filter 1.0]
    }
  }
  finish { diffuse 0.3 ambient 0.2 }
}

//--------------------Crack & OverTint /Red---------------------
#declare MARBLE4 =
texture {
  pigment {
    marble
    color_map {
      [0.0   0.05  color Black filter 0.60 color Black filter 1.0]
      [0.05  0.90  color Red   filter 0.95 color Red   filter 0.95]
      [0.90  1.001 color Black filter 0.70 color Black filter 1.0]
    }
    turbulence 0.7
  }
}

#declare pink = color red 1.0 green 0.5 blue 0.5;

/*--------------------Crack & OverTint /LIGHT Red---------------------*/
#declare marble7a =
texture {
  pigment {
    marble
    turbulence 0.7
    color_map {
      [0.0 0.05   color Black filter 0.6  color Black filter 1.0]
      [0.05 0.90  color pink  filter 0.90 color Red   filter 0.90]
      [0.90 1.001 color Black filter 0.7  color Black filter 1.0]
    }
  }
}

/*-----------Mostly Blacks W/thin Shades of D.Chroma----------------------*/
#declare MARBLE5 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.104 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.110 green 0.082 blue 0.071 filter 0.000]
      [0.104 0.252 color red 0.110 green 0.082 blue 0.071 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
      [0.252 0.383 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.000 green 0.000 blue 0.000 filter 0.000]
      [0.383 0.643 color red 0.000 green 0.000 blue 0.000 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
      [0.643 0.783 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.783 0.922 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.000 green 0.000 blue 0.000 filter 0.000]
      [0.922 0.983 color red 0.000 green 0.000 blue 0.000 filter 0.000 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.983 1.001 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
    }
    turbulence 5
  }
}

//-----------MOSTLY BLACY W/filter For SECOND LAYERS-----------------------
#declare marble6 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.035 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.110 green 0.082 blue 0.071 filter 0.800]
      [0.035 0.104 color red 0.110 green 0.082 blue 0.071 filter 0.800 color red 0.161 green 0.133 blue 0.118 filter 0.300]
      [0.104 0.357 color red 0.161 green 0.133 blue 0.118 filter 0.300 color red 0.000 green 0.000 blue 0.000 filter 0.700]
      [0.357 0.478 color red 0.000 green 0.000 blue 0.000 filter 0.700 color red 0.161 green 0.133 blue 0.118 filter 0.500]
      [0.478 0.539 color red 0.161 green 0.133 blue 0.118 filter 0.500 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.539 0.783 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.000 green 0.000 blue 0.000 filter 0.000]
      [0.783 0.983 color red 0.000 green 0.000 blue 0.000 filter 0.000 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.983 1.001 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
    }
    turbulence 0.4
  }
}

//--------------THIN WHITE VIENS------------------------------------------
#declare MARBLE7 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.078 color red 0.769 green 0.722 blue 0.690 filter 0.180 color red 0.745 green 0.690 blue 0.655 filter 1.000]
      [0.078 0.374 color red 0.745 green 0.690 blue 0.655 filter 1.000 color red 0.839 green 0.804 blue 0.780 filter 1.000]
      [0.374 0.461 color red 0.839 green 0.804 blue 0.780 filter 1.000 color red 0.839 green 0.804 blue 0.780 filter 0.263]
      [0.461 0.574 color red 0.839 green 0.804 blue 0.780 filter 0.263 color red 0.729 green 0.671 blue 0.631 filter 0.929]
      [0.574 0.643 color red 0.729 green 0.671 blue 0.631 filter 0.929 color red 0.839 green 0.804 blue 0.780 filter 1.000]
      [0.643 0.783 color red 0.839 green 0.804 blue 0.780 filter 1.000 color red 0.839 green 0.804 blue 0.780 filter 0.976]
      [0.783 0.948 color red 0.839 green 0.804 blue 0.780 filter 0.976 color red 0.839 green 0.804 blue 0.780 filter 0.278]
      [0.948 1.001 color red 0.839 green 0.804 blue 0.780 filter 0.278 color red 0.769 green 0.722 blue 0.690 filter 0.180]
    }
    turbulence 0.6
  }
}

//---------------CREAM MARBLE W/Gray Viens----------------------------
#declare MARBLE12 =
texture {
  //MARBLE1
  //MARBLE2
  MARBLE4
  scale 2
  finish { diffuse 0.8 }
}

//----------------DARKER CREAM MARBLE W/Gray Viens-------------------
#declare MARBLE13 =
texture {
  //MARBLE1
  //MARBLE2
  MARBLE4 scale 2
  finish { diffuse 0.6 }
}

//--------------EVEN DARKER CREAM MARBLE W/Gray Viens----------------
#declare MARBLE14 =
texture {
  //MARBLE1
  //MARBLE2
  MARBLE4
  scale 2
  finish { diffuse 0.4 }
}

//---------------BLACK MARBLE W/White Viens----------------------------
#declare MARBLE17 =
texture {
  //MARBLE5
  //MARBLE6
  MARBLE7
  scale 2
  finish { diffuse 0.5 }
}

#declare MARBLE51 =
texture {
  //MARBLE1 scale <10, 6, 4>
  //MARBLE2 scale <7, 6, 4> rotate z*40
  MARBLE4
  scale <3, 6, 4>
  rotate z*-40
}

#declare snk1 =
texture {
  pigment {
    marble turbulence 0.3
    color_map {
      [0.000 0.303 color red 0.000 green 0.239 blue 0.000 filter 0.000 color red 0.333 green 0.294 blue 0.000 filter 0.000]
      [0.303 0.588 color red 0.333 green 0.294 blue 0.000 filter 0.000 color red 0.000 green 0.239 blue 0.341 filter 0.000]
      [0.588 0.790 color red 0.000 green 0.239 blue 0.341 filter 0.000 color red 0.000 green 0.020 blue 0.000 filter 0.000]
      [0.790 1.001 color red 0.000 green 0.020 blue 0.000 filter 0.000 color red 0.000 green 0.239 blue 0.000 filter 0.000]
    }
  }
  normal { ripples 1.0 frequency 100 }
}

#declare snk2 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.303 color red 0.000 green 0.239 blue 0.000 filter 0.7 color red 0.333 green 0.294 blue 0.000 filter 0.7]
      [0.303 0.588 color red 0.333 green 0.294 blue 0.000 filter 0.7 color red 0.000 green 0.239 blue 0.341 filter 0.7]
      [0.588 0.790 color red 0.000 green 0.239 blue 0.341 filter 0.7 color red 0.000 green 0.020 blue 0.000 filter 0.7]
      [0.790 1.001 color red 0.000 green 0.020 blue 0.000 filter 0.7 color red 0.000 green 0.239 blue 0.000 filter 0.7]
    }
    turbulence 0.2
  }
  normal { ripples 0.75 frequency 50 }
  scale <1, 10, 1>
}

#declare snake_skin =
texture {
  snk1 scale <2, 5, 2> finish { ambient 0.6 phong 1 diffuse 1 }
  //snk2 scale <20, 40, 5> rotate z*90 finish { ambient 0.8 diffuse 0.8 phong 1 }
}

//------------Very Light White & Pinks-------------------------------
#declare M1 =
texture {
  pigment {
    marble
    turbulence 0.3
    color_map {
      [0.000 0.316 color red 0.910 green 0.788 blue 0.788 filter 0.000 color red 1.000 green 1.000 blue 1.000 filter 0.000]
      [0.316 0.453 color red 1.000 green 1.000 blue 1.000 filter 0.000 color red 0.965 green 1.000 blue 0.918 filter 0.000]
      [0.453 0.624 color red 0.965 green 1.000 blue 0.918 filter 0.000 color red 0.784 green 0.788 blue 0.788 filter 0.000]
      [0.624 0.726 color red 0.784 green 0.788 blue 0.788 filter 0.000 color red 0.965 green 1.000 blue 0.918 filter 0.000]
      [0.726 0.863 color red 0.965 green 1.000 blue 0.918 filter 0.000 color red 0.784 green 0.788 blue 0.788 filter 0.000]
      [0.863 1.001 color red 0.784 green 0.788 blue 0.788 filter 0.000 color red 0.910 green 0.788 blue 0.788 filter 0.000]
    }
  }
}

//---------------Slighty Darker & Grayer Than M1-------------------------
#declare M2 =
texture {
  pigment {
    marble
    turbulence 0.3
    color_map {
      [0.000 0.316 color red 0.910 green 0.788 blue 0.788 filter 0.000 color red 0.922 green 0.914 blue 0.871 filter 0.000]
      [0.316 0.453 color red 0.922 green 0.914 blue 0.871 filter 0.000 color red 0.894 green 0.867 blue 0.780 filter 0.000]
      [0.453 0.624 color red 0.894 green 0.867 blue 0.780 filter 0.000 color red 0.784 green 0.788 blue 0.788 filter 0.000]
      [0.624 0.726 color red 0.784 green 0.788 blue 0.788 filter 0.000 color red 0.851 green 0.812 blue 0.741 filter 0.000]
      [0.726 0.863 color red 0.851 green 0.812 blue 0.741 filter 0.000 color red 0.647 green 0.655 blue 0.655 filter 0.000]
      [0.863 1.001 color red 0.647 green 0.655 blue 0.655 filter 0.000 color red 0.910 green 0.788 blue 0.788 filter 0.000]
    }
  }
}

#declare M3 =
texture {
  pigment {
    marble
    turbulence 0.3
    color_map {
      [0.000 0.034 color red 0.027 green 0.012 blue 0.012 filter 0.000 color red 0.851 green 0.812 blue 0.741 filter 0.235]
      [0.034 0.342 color red 0.851 green 0.812 blue 0.741 filter 0.235 color red 0.792 green 0.694 blue 0.690 filter 0.839]
      [0.342 0.462 color red 0.792 green 0.694 blue 0.690 filter 0.839 color red 0.631 green 0.506 blue 0.471 filter 0.608]
      [0.462 0.632 color red 0.631 green 0.506 blue 0.471 filter 0.608 color red 0.851 green 0.812 blue 0.741 filter 0.922]
      [0.632 0.983 color red 0.851 green 0.812 blue 0.741 filter 0.922 color red 0.647 green 0.655 blue 0.655 filter 0.282]
      [0.983 1.001 color red 0.647 green 0.655 blue 0.655 filter 0.282 color red 0.027 green 0.012 blue 0.012 filter 0.000]
    }
  }
}

#declare M4 =
texture {
  pigment {
    marble
    turbulence 0.4
    color_map {
      [0.000 0.128 color red 0.820 green 0.580 blue 0.580 filter 0.000 color red 0.851 green 0.812 blue 0.741 filter 0.235]
      [0.128 0.282 color red 0.851 green 0.812 blue 0.741 filter 0.235 color red 0.792 green 0.694 blue 0.690 filter 0.282]
      [0.282 0.393 color red 0.792 green 0.694 blue 0.690 filter 0.282 color red 0.647 green 0.655 blue 0.655 filter 0.133]
      [0.393 0.590 color red 0.647 green 0.655 blue 0.655 filter 0.133 color red 0.851 green 0.812 blue 0.741 filter 0.333]
      [0.590 0.983 color red 0.851 green 0.812 blue 0.741 filter 0.333 color red 0.647 green 0.655 blue 0.655 filter 0.282]
      [0.983 1.001 color red 0.647 green 0.655 blue 0.655 filter 0.282 color red 0.820 green 0.580 blue 0.580 filter 0.000]
    }
  }
}

//--------------------Crack & OverTint /Green---------------------
#declare M5 =
texture {
  pigment {
    marble
    color_map {
      [0.0 0.05   color Black   filter 0.6 color Black   filter 1.0]
      [0.05 0.90  color DimGray filter 1.0 color DimGray filter 1.0]
      [0.90 1.001 color Black   filter 0.6 color Black   filter 1.0]
    }
    turbulence 0.7
  }
}

//---------------LIGHT CREAM MOSS / GOOD FOR 1st LAYER TONE----------------
#declare M6 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.154 color red 0.690 green 0.612 blue 0.569 filter 0.000 color red 0.737 green 0.596 blue 0.522 filter 0.000]
      [0.154 0.368 color red 0.737 green 0.596 blue 0.522 filter 0.000 color red 0.776 green 0.702 blue 0.624 filter 0.000]
      [0.368 0.538 color red 0.776 green 0.702 blue 0.624 filter 0.000 color red 0.796 green 0.678 blue 0.643 filter 0.000]
      [0.538 0.846 color red 0.796 green 0.678 blue 0.643 filter 0.000 color red 0.690 green 0.612 blue 0.569 filter 0.000]
      [0.846 0.932 color red 0.690 green 0.612 blue 0.569 filter 0.000 color red 0.773 green 0.612 blue 0.569 filter 0.000]
      [0.932 1.001 color red 0.773 green 0.612 blue 0.569 filter 0.000 color red 0.690 green 0.612 blue 0.569 filter 0.000]
    }
    turbulence 0.5
  }
}

//-------------------DEEP THAN MARBLE1 With filter For SECOND LAYERS--------
#declare M7 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.291 color red 0.690 green 0.612 blue 0.569 filter 1.00  color red 0.737 green 0.596 blue 0.522 filter 0.500]
      [0.291 0.316 color red 0.737 green 0.596 blue 0.522 filter 0.500 color red 0.667 green 0.561 blue 0.514 filter 0.300]
      [0.316 0.436 color red 0.667 green 0.561 blue 0.514 filter 0.300 color red 0.788 green 0.667 blue 0.631 filter 0.500]
      [0.436 0.641 color red 0.788 green 0.667 blue 0.631 filter 0.500 color red 0.604 green 0.506 blue 0.455 filter 0.700]
      [0.641 0.692 color red 0.604 green 0.506 blue 0.455 filter 0.700 color red 0.773 green 0.612 blue 0.569 filter 0.400]
      [0.692 1.001 color red 0.773 green 0.612 blue 0.569 filter 0.400 color red 0.690 green 0.612 blue 0.569 filter 1.000]
    }
    turbulence 0.5
  }
}

//-------------------LIGHTER THAN MARBLE2 With filter For SECOND LAYERS--------
#declare M8 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.291 color red 0.690 green 0.612 blue 0.569 filter 0.6 color red 0.737 green 0.596 blue 0.522 filter 0.900]
      [0.291 0.316 color red 0.737 green 0.596 blue 0.522 filter 0.900 color red 0.667 green 0.561 blue 0.514 filter 0.700]
      [0.316 0.436 color red 0.667 green 0.561 blue 0.514 filter 0.700 color red 0.788 green 0.667 blue 0.631 filter 0.600]
      [0.436 0.641 color red 0.788 green 0.667 blue 0.631 filter 0.600 color red 0.604 green 0.506 blue 0.455 filter 0.700]
      [0.641 0.692 color red 0.604 green 0.506 blue 0.455 filter 0.700 color red 0.773 green 0.612 blue 0.569 filter 0.100]
      [0.692 1.001 color red 0.773 green 0.612 blue 0.569 filter 0.100 color red 0.690 green 0.612 blue 0.569 filter 1.000]
    }
    turbulence 0.01
  }
}

//--------------------Crack & OverTinting ---------------------
#declare M9 =
texture {
  pigment {
    marble
    color_map {
      [0.0 0.05   color Black   filter 0.6  color Black  filter 1.0]
      [0.05 0.90  color DimGray filter 0.75 color Salmon filter 0.70]
      [0.90 1.001 color Black   filter 0.9  color Black  filter 1.0]
    }
    turbulence 0.7
  }
  finish { diffuse 0.3 ambient 0.2 }
}

//--------------------Crack & OverTinting ---------------------
#declare M19 =
texture {
  pigment {
    marble
    turbulence 0.6
    color_map {
      [0.0 0.05   color Black    filter 0.6  color Black  filter 1.0]
      [0.05 0.90  color SeaGreen filter 0.85 color Salmon filter 0.60]
      [0.90 1.001 color Black    filter 0.9  color Black  filter 1.0]
    }
  }
  finish { diffuse 0.3 ambient 0.2 }
}

//--------------------Crack & OverTint /Red---------------------
#declare M10 =
texture {
  pigment {
    marble
    color_map {
      [0.0 0.05   color Black filter 0.6  color Black filter 1.0]
      [0.05 0.90  color Red   filter 0.95 color Red   filter 0.95]
      [0.90 1.001 color Black filter 0.7  color Black filter 1.0]
    }
    turbulence 0.7
  }
}

//--------------------Crack & OverTint /LIGHT Red---------------------
#declare M11 =
texture {
  pigment {
    marble
    color_map {
      [0.0 0.05   color Black filter 0.6  color Black filter 1.0]
      [0.05 0.90  color pink  filter 0.90 color Red   filter 0.90]
      [0.90 1.001 color Black filter 0.7  color Black filter 1.0]
    }
    turbulence 0.7
  }
}

//-----------Mostly Blacks W/thin Shades of D.Chroma----------------------
#declare M12 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.104 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.110 green 0.082 blue 0.071 filter 0.000]
      [0.104 0.252 color red 0.110 green 0.082 blue 0.071 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
      [0.252 0.383 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.000 green 0.000 blue 0.000 filter 0.000]
      [0.383 0.643 color red 0.000 green 0.000 blue 0.000 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
      [0.643 0.783 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.783 0.922 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.000 green 0.000 blue 0.000 filter 0.000]
      [0.922 0.983 color red 0.000 green 0.000 blue 0.000 filter 0.000 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.983 1.001 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
    }
    turbulence 5.0
  }
}

//-----------MOSTLY BLACY W/filter For SECOND LAYERS-----------------------
#declare M13 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.035 color red 0.161 green 0.133 blue 0.118 filter 0.000 color red 0.110 green 0.082 blue 0.071 filter 0.800]
      [0.035 0.104 color red 0.110 green 0.082 blue 0.071 filter 0.800 color red 0.161 green 0.133 blue 0.118 filter 0.300]
      [0.104 0.357 color red 0.161 green 0.133 blue 0.118 filter 0.300 color red 0.000 green 0.000 blue 0.000 filter 0.700]
      [0.357 0.478 color red 0.000 green 0.000 blue 0.000 filter 0.700 color red 0.161 green 0.133 blue 0.118 filter 0.500]
      [0.478 0.539 color red 0.161 green 0.133 blue 0.118 filter 0.500 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.539 0.783 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.000 green 0.000 blue 0.000 filter 0.000]
      [0.783 0.983 color red 0.000 green 0.000 blue 0.000 filter 0.000 color red 0.220 green 0.149 blue 0.137 filter 0.000]
      [0.983 1.001 color red 0.220 green 0.149 blue 0.137 filter 0.000 color red 0.161 green 0.133 blue 0.118 filter 0.000]
    }
    turbulence 0.4
  }
}

//--------------THIN WHITE VIENS------------------------------------------
#declare M14 =
texture {
  pigment {
    marble
    color_map {
      [0.000 0.078 color red 0.769 green 0.722 blue 0.690 filter 0.180 color red 0.745 green 0.690 blue 0.655 filter 1.000]
      [0.078 0.374 color red 0.745 green 0.690 blue 0.655 filter 1.000 color red 0.839 green 0.804 blue 0.780 filter 1.000]
      [0.374 0.461 color red 0.839 green 0.804 blue 0.780 filter 1.000 color red 0.839 green 0.804 blue 0.780 filter 0.263]
      [0.461 0.574 color red 0.839 green 0.804 blue 0.780 filter 0.263 color red 0.729 green 0.671 blue 0.631 filter 0.929]
      [0.574 0.643 color red 0.729 green 0.671 blue 0.631 filter 0.929 color red 0.839 green 0.804 blue 0.780 filter 1.000]
      [0.643 0.783 color red 0.839 green 0.804 blue 0.780 filter 1.000 color red 0.839 green 0.804 blue 0.780 filter 0.976]
      [0.783 0.948 color red 0.839 green 0.804 blue 0.780 filter 0.976 color red 0.839 green 0.804 blue 0.780 filter 0.278]
      [0.948 1.001 color red 0.839 green 0.804 blue 0.780 filter 0.278 color red 0.769 green 0.722 blue 0.690 filter 0.180]
    }
    turbulence 0.6
  }
}

#declare M21 =
texture {
  pigment {
    marble
    turbulence 0.5
    color_map {
      [0.000 0.479 color red 0.714 green 0.690 blue 0.706 filter 0.000 color red 0.663 green 0.596 blue 0.624 filter 0.000]
      [0.479 0.723 color red 0.663 green 0.596 blue 0.624 filter 0.000 color red 0.655 green 0.690 blue 0.706 filter 0.000]
      [0.723 0.866 color red 0.655 green 0.690 blue 0.706 filter 0.000 color red 0.784 green 0.808 blue 0.737 filter 0.000]
      [0.866 1.001 color red 0.784 green 0.808 blue 0.737 filter 0.000 color red 0.714 green 0.690 blue 0.706 filter 0.000]
    }
  }
}