//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
global_settings {
  //assumed_gamma 1
  //ambient_light 0.35
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "stones.inc"
#include "Shapes_CJF.inc"
#include "Marble_CJF.inc"
#include "B-Snake_CJF.inc"
#include "Turn_CJF.inc"
#include "Panther_CJF.INC"
#include "S-Head3_CJF.inc"
#include "WorldCJF.INC" // Taken from Mike Millers Station.POV

/* original camera */
camera {
  location <-50, 80, -220>
  direction z*1.5
  up y
  right x*image_width/image_height
}

// Optional stereo views:
/* camera for left eye, render at 768 x 480 or similar aspect ratio */
/*
camera {
  location <-61, 80, -220>
  direction z*1.4
  up y
  right x*1.6
}
*/

/* camera for right eye, render at 768 x 480 or similar aspect ratio */
/*
camera {
  location <-39, 80, -220>
  direction z*1.4
  up y
  right x*1.6
}
*/

/*-------------- WORLD WALLS ---------------------------------*/
/*
sphere {
  0, 50000
  hollow on
  texture {
    pigment { MidnightBlue }
    finish { ambient 1 diffuse 0 }
  }
}
*/
/*---------------LIGHT #1------------------------------------*/
light_source { <700, 150, -500> colour White }

/*--------------LIGHT #2-------------------------------------*/
light_source { <-4000, 100, -1000> colour White }

/*-----------BASE OF COLUMN A / TOP FLOOR-------------------*/

#declare base_a =
union {
  sphere { 0, 1 scale <13, 5.5, 13> }
  sphere { 0, 1 scale <11, 3, 11> translate 4*y  }
  cylinder { 0, y, 1 scale <10, 4, 10> translate 5*y }

  //texture { MARBLE4 scale <7, 12, 9> rotate z*-40 finish { diffuse 1 phong 0.6 phong_size 50 } }
  //texture { MARBLE1 scale <9, 6, 4> finish { ambient 0.5 diffuse 1 } }

  texture { T_Stone1 scale 8 }
  rotate 40*y
}

/*-----------MOTIF TILE WORK--------------------*/
#declare motif1 =
cylinder {
  0, y, 1
  scale <9.5, 7, 9.5>
  texture {
    pigment { image_map { png "congo4.png" } scale <19, 7, 1>  translate <-9.5, 0, -1> }
    finish { ambient 0.3 diffuse 0.9 phong 0.6 }
  }
}

/*----------- COLUMN A -------------------------------------------------*/
#declare column_a =
cylinder {
  0, y, 1
  scale <9.3, 50, 9.3>

  //texture { MARBLE1 finish { crand 0.01 ambient 0.2 diffuse 0.8 } scale <16, 4, 4> }
  //texture { MARBLE2 scale <10, 6, 5> rotate -30*z finish { diffuse 1 } }
  //texture { MARBLE4 finish { phong 0.6 phong_size 45 } scale <8, 15, 5> rotate z*50 }

  texture { T_Stone5 scale 10 }
  rotate 10*y
}

/*-----------COMBINE COLUMN & BASE --------------------------------*/
#declare top_column =
union {
  object { base_a }
  object { motif1 translate 9*y }
  object { column_a translate 12*y }
}

/*--------------------TOP  FLOOR---------------------------------------*/
#declare gfloor =
box { -1, 1
  scale <100, 1, 50>

  texture {
    pigment { Salmon }
    finish { ambient 0.2 diffuse 0.5 phong 1 phong_size 10 }
  }
}

/*----------- ROUND CORNER ----------------------------*/
#declare sp1 = sphere { 0, 2 }

#declare round_cap =
object {
  union {
    object { sp1 translate <-100, 0, -50> }
    object { sp1 translate <-100, 0,  50> }
    object { sp1 translate < 100, 0, -50> }
    object { sp1 translate < 100, 0,  50>  }
    cylinder { 0, x, 1 scale <200, 2, 2>   translate <-100, 0, -50> }
    cylinder { 0, z, 1 scale <  2, 2, 100> translate <-100, 0, -50> }
  }

  //texture { MARBLE1 scale <50, 10, 40> finish { ambient 0.4 diffuse 0.9 } }
  //texture { MARBLE2 scale <40, 5, 20> rotate z*40 }
  //texture { MARBLE4 scale <20, 20, 20> rotate z*-40 finish { phong 0.6 phong_size 20 } }

  texture { T_Stone5 scale 10 }
}

/*--------------- ONE DENTILE ----------------------------------*/
#declare d1 = box { -1, 1 scale <1, 1.5, 2> }

#declare cornice =
union {
  box { -1, 1 scale <103, 0.5, 53> translate y*2.5 }
  box { -1, 1 scale <103, 1, 53> translate y*-2  }
  box { -1, 1 scale <101, 2, 51> translate 0 }

  //texture { MARBLE1 scale <10, 6, 4> finish { ambient 0.4 diffuse 1 } }
  //texture { MARBLE2 scale <7, 6, 4> rotate z*40 }
  //texture { MARBLE4 scale <3, 6, 5> rotate z*-40 finish { phong 0.6 phong_size 20 } }

  texture { T_Stone5 scale 10 }
}

/*-------------------- ROW OF DENTILES ---------------*/
#declare dentile_a =
union {
  object { d1 translate -50*x }
  object { d1 translate -45*x }
  object { d1 translate -40*x }
  object { d1 translate -35*x }
  object { d1 translate -30*x }
  object { d1 translate -25*x }
  object { d1 translate -20*x }
  object { d1 translate -15*x }
  object { d1 translate -10*x }
  object { d1 translate  -5*x }
  object { d1 }
  object { d1 translate  50*x }
  object { d1 translate  45*x }
  object { d1 translate  40*x }
  object { d1 translate  35*x }
  object { d1 translate  30*x }
  object { d1 translate  25*x }
  object { d1 translate  20*x }
  object { d1 translate  15*x }
  object { d1 translate  10*x }
  object { d1 translate  5*x }

  //texture { MARBLE1 scale <10, 6, 4> finish { ambient 0.4 diffuse 0.9 } 
  //texture { MARBLE2 scale <7, 6, 4> rotate z*40 }
  //texture { MARBLE4 scale <3, 6, 4> rotate z*-40 finish { phong 0.6 phong_size 20 } }

  texture { T_Stone5 scale 10 }
}

/*--------------  COMBINE CORNICE, FLOOR, CAP & DENTILES -----------*/
#declare top_floor =
union {
  object { gfloor translate y*9 }
  object { round_cap translate y*7 }
  object { cornice translate y*3 }
  object { dentile_a translate <-50, 4, -52> }
  object { dentile_a translate <50, 4, -52> }
}

/*------------------MAKE AN IONIC CAPIAL---------------------------*/
#declare turn = object { s1 rotate -90*x }

/*--------------- 1/2 SECTION OF CAP ------------------------------*/
#declare cap_a =
union {
  sphere { 0, 1 scale <7, 2, 7> translate y }
  cylinder { 0, y, 1 scale <6, 5, 6> translate y*2  }
  sphere { 0, 1 scale <8, 3, 8> translate y*8 }
  cylinder { 0, y, 1 scale <8, 2, 8> translate y*8 }

  //texture { MARBLE1 finish { ambient 0.4 diffuse 1 } scale <5, 13, 4> }
  //texture { MARBLE4 finish { diffuse 1 phong 0.6 phong_size 20 } scale <5, 7, 3> rotate z*50 }

  texture { T_Stone1 scale 10 }
}

/*-------------- THE OTHER 1/2-----------------------------*/
#declare cap_b =
union {
  cylinder { 0, y, 1 scale <1.2, 8, 1.2> translate < 1, 0, -4>  }
  cylinder { 0, y, 1 scale <1.2, 8, 1.2> translate <-1, 0, -4> }

  cylinder { 0, y, 1 scale <1.2, 4, 1.2> translate <-2, 0, -4> }
  cylinder { 0, y, 1 scale <1.2, 4, 1.2> translate < 2, 0, -4>  }

  box { -1, 1 scale <10, 2, 8> translate <0, 10, 2> }
  box { -1, 1 scale <7, 4, 4> translate y*4 }
  cylinder { 0, z, 1 scale <4.5, 4.5, 8> translate <-6, 4, -4> }
  cylinder { 0, z, 1 scale <4.5, 4.5, 8> translate < 6, 4, -4>  }

  //texture { MARBLE1 finish { ambient 0.4 diffuse 1 } scale <5, 13, 4> }
  //texture { MARBLE4 finish { diffuse 1 phong 0.6 phong_size 20 } scale <5, 7, 3> rotate 50*z }

  texture { T_Stone1 scale 10 }
}

/*-----------2 HALFS & 2 TURNS MAKE A WHOLE ------------------------*/
#declare capital =
union {
  object { cap_a }
  object { cap_b translate y*10 }
  object { turn translate <-6, 14, -4> }
  object { turn rotate y*180 translate <6, 14, -4> }
}

/*--------------MAKE COLUMN-------------------*/

/*-----------MOTIF TILE WORK--------------------*/
#declare motif2 =
cylinder { 0, y, 1
  scale <6.5, 8, 6.5>

  texture {
    pigment { image_map { png "congo4.png" } scale <13, 8, 1> translate <-6.5, 0, -1> }
    finish { ambient 0.3 diffuse 0.9 phong 1 }
  }
}

#declare column_b =
cylinder { 0, y, 1 scale <6, 54, 6>

  //texture { MARBLE1 finish { ambient 0.4 diffuse 0.8 crand 0.1 } scale <9, 30, 18> }
  //texture { MARBLE2 scale <10, 18, 5> rotate <0, 0, -30> finish { diffuse 1 } }
  //texture { MARBLE4 finish { diffuse 0.9 phong 0.8 phong_size 45 } scale <4, 15, 5> rotate 50*z }

  texture { T_Stone5 scale 10 }
}

/*-----------THE COMPLETE BOTTOM COLUMN---------------------------------*/
#declare bottom_column =
union {
  object { capital translate y*58 }
  object { motif2 translate y*50 }
  object { column_b }
}

/*---------------------START LOWER WALLS-----------------------------*/

/*----------- ABOVE DOOR SECTION OF WALL -----------------------------*/
#declare brick_wall = 
box { -1, 1 scale <30, 6, 3>

  //texture { MARBLE1 finish { ambient 0.2 diffuse 0.9 } scale <20, 30, 4> }
  //texture { MARBLE2 scale <20, 9, 5> finish { diffuse 1 } rotate -30*z }
  //texture { MARBLE4 finish { phong 0.6 phong_size 25 } scale <18, 18, 3> rotate 50*z }

  texture { T_Stone5 scale 10 }
}

/*-------------- ARCH SECTION OF WALL --------------------------------*/
#declare top_wall =
object {
  difference {
    box { -1, 1 scale <30, 10, 3> translate z }
    object { Cylinder_Z scale <13, 13, 1> translate y*-10 }
  }

  //texture { MARBLE1 finish { ambient 0.2 diffuse 0.9 } scale <30, 20, 4> }
  //texture { MARBLE2 scale <26, 16, 5> finish { diffuse 1 } rotate -30*z }
  //texture { MARBLE4 finish { phong 0.6 phong_size 25 } scale <15, 27, 2> rotate 50*z }

  texture { T_Stone5 scale 10 }
  
}

/*------------------ TRIM ---------------------------------------------*/
#declare molding_2 =
union {
  difference {
    cylinder { 0, z, 1 scale <16, 16, 12> translate z*-6 }
    object { Cylinder_Z scale <13, 13, 1> }
    plane { y*16, 0 } // ooops!!
  }
  box { -1, 1 scale <10, 2, 6> translate <-21, -2, 0> }
  box { -1, 1 scale <10, 2, 6> translate < 21, -2, 0> }
  box { -1, 1 scale <31, 1, 6> translate y*17 }

  //texture { MARBLE1 finish { ambient 0.5 diffuse 1 } scale <15, 3, 4> }
  //texture { MARBLE4 finish { phong 0.8 phong_size 15 ambient 0.6 } scale <15, 7, 6> rotate 50*z }

  texture { T_Stone1 scale 10 }
}

#declare motif3 =
box { -1, 1
  scale <9.5, 5, 3.1>

  texture {
    pigment { image_map { png "congo4.png" } scale <19, 10, 1> translate <-9.5, -5, -1> }
    finish { ambient 0.3 diffuse 0.9 phong 1 }
  }
}

/*----------WALLS FLANKING DOOR WAY -----------------------------------*/
#declare low_wall =
box { -1, 1
  scale <9, 22, 3>

  //texture { MARBLE1 finish { ambient 0.2 diffuse 0.9 } scale <30, 20, 4> }
  //texture { MARBLE2 scale <26, 16, 5> finish { diffuse 1 } rotate -30*z }
  //texture { MARBLE4 finish { phong 0.6 phong_size 25 } scale <15, 27, 2> rotate 50*z }

  texture { T_Stone5 scale 10 }
}

/*----------COMPOSITE THE WALL------------------------------*/
#declare wall =
union {
  object { low_wall translate <-21, 22, 0> }
  object { low_wall translate < 21, 22, 0> }
  object { motif3 translate <-21, 42, 0> }
  object { motif3 translate < 21, 42, 0> }
  object { molding_2 translate y*50 }
  object { top_wall translate y*60 }
  object { brick_wall translate y*74 }
}


/*--------CREATE INSIDE BACK WALL-----------------------*/
box { -1, 1
  scale <95, 55, 1>

  //texture { MARBLE1 finish { ambient 0.2 diffuse 0.9 } scale <30, 20, 4> }
  //texture { MARBLE2 scale <26, 16, 5> finish { diffuse 1 } rotate -30*z }
  //texture { MARBLE4 finish { phong 0.6 phong_size 25 } scale <15, 27, 2> rotate 50*z }

  texture { T_Stone5 scale 10 }
  translate <0, 15, 10>
}

/*----------*** PUT UP THE WALLS ****--------------------*/
object { top_column rotate 10*y  scale 1.9 translate <-30, 94, -25> }
object { top_floor translate <-10, 80, 0> }
object { bottom_column scale <1.3, 1, 1.3> translate <-100, 0, -40>  }
object { bottom_column scale <1.3, 1, 1.3> translate < -30, 0, -40>  }
object { bottom_column scale <1.3, 1, 1.3> translate <  40, 0, -40>  }
object { wall translate <  5, 0, -32>  }
object { wall translate <-65, 0, -32>  }


/*---------------------BACKDROP---------------------------------*/
/*
box { -1, 1
  scale <2000, 1500, 1>

  texture {
    pigment { Maroon }
    finish { ambient 0.2 diffuse 0.6 }
  }
  texture {
    pigment {
      gradient y
      colour_map {
        [0 0.3 colour Salmon                colour BlueViolet filter 0.3]
        [0.3 1 colour BlueViolet filter 0.3 colour Black      filter 0.2]
      }
      scale <4000, 3000, 1>
      translate y*-1500
    }
    finish { ambient 1 diffuse 0 }
  }
  scale 1
  translate z*2000
}
*/
object { TheWorld scale 1000 hollow } // Taken from Mike Millers Station.POV

/*------------------- CREATURE & MOTHER-IN-LAW -------------------------*/
object { PANTHER rotate -20*y scale 1.2 translate <-70, 89.5, -10> }
object { lizard scale <1, 0.9, 1> rotate -10*z translate <-33, 16, -20> }

#declare snake = union {
  object { top }
  object { HEAD scale <1.9, 1.6, 1.6> rotate <0, -90, -90> translate <23, 0, -13> }
  rotate <-90, -180, -90>
}

object { snake  translate <-4, 87, -68> }
// end-of-file