// Persistence of Vision Raytracer
//                POV Data - Mantel Clock               M.Miller 11/1/91
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//#include "colors.inc"
#include "shapes.inc"
//#include "shapes.old"
//#include "textures.inc"
#include "shapesq.inc"

camera {
  location <0, 60, -220>
  direction z
  up y
  right x*image_width/image_height
}

#declare DCone = /*--------CONE POINT DOWN /POINT at 000--------*/
intersection {
  object { QCone_Y scale 1 }
  plane { -y, 0 }
  plane {  y, 1 }
}

#declare UCone = /*--------CONE POINT UP /POINT at 000--------*/
intersection {
  object { QCone_Y scale 1 }
  plane { y,  0 }
  plane { y, -1 inverse }
}

#declare gold =
texture {  /*------Bright Reflective Gold---------------*/
  finish {
    crand 0.02
    ambient 0.3
    diffuse 0.5
    reflection { 0.6 }
    brilliance 8.0
    specular 0.5
  }
  pigment { colour rgb <0.64, 0.55, 0> }
}

/*----------LIGHT Source1------------------------------*/
light_source { < 250, 300, -500> color rgb 1 /*no_shadow*/ }

/*----------LIGHT Source2------------------------------*/
light_source { <-100, 200, -100> color rgb 1 /*no_shadow*/ }	


#declare a01 =
/*--------------CLOCK BASE------------*/
difference {
  union {
    object { Ellipsoid scale <62, 15, 62> }
    object { Ellipsoid scale <55, 5, 55> translate y*10 }
    object { Disk_Y scale <50, 3, 50> translate y*12 }
    object { Disk_Y scale <43, 1, 43> translate y*15 }
  }
  plane { y, 0 }
  texture { gold }
}

#declare a02 = 
object { /*------------RING--------------*/
  Disk_Y scale <7, 2, 7> }

#declare a03_1 = 
object { /*--Squash Disk to make rib----*/
  Disk_Y scale <1, 56, 4> }

#declare a03 =
union {    /*----------MAKE Rib Colum------------*/
  object { a03_1 }
  object { a03_1 rotate y*30 }
  object { a03_1 rotate y*60 }
  object { a03_1 rotate y*90 }
  object { a03_1 rotate y*120 }
  object { a03_1 rotate y*150 }
}

#declare a04 =
union {   /*----------------Colum Caps------------*/
  object { Disk_Y scale 5 }
  object { Ellipsoid scale <4, 2, 4> translate y*5 }
  object { Ellipsoid scale 1.5 translate y*8 }
  object { Ellipsoid scale <3, 2, 3> translate y*10 }
}

#declare a06 =
union {
  object { Disk_Y scale <6, 2, 6> translate < 27, -1, 0> }
  object { Disk_Y scale <6, 2, 6> translate <-27, -1, 0> }
  object { Cube scale <17, 1, 8.5> translate z*10.5 }
  object { Cube scale <6, 1, 11.5> translate z*11.5 rotate y*45 translate x*-27 }
  object { Cube scale <6, 1, 11.5> translate z*11.5 rotate y*-45 translate x*27 }
  texture { gold }
  bounded_by { object { Cube scale <35, 2, 14> translate z*4 } }
}


#declare a07 =
/*----Bracket for Pivit Rod of Counter Balls--*/
difference {
  union {
    object { Cube scale <17, 8, 0.5> }
    object { Cube scale <9, 0.5, 6.5> translate <0, -7.5, 7> }
  }
  object { Cylinder_Z scale 8 translate <-17, -8, 0> }
  object { Cylinder_Z scale 8 translate < 17, -8, 0> }
  texture { gold }
  bounded_by { object { Cube scale <18, 9, 8> translate z*6.5 } }
}


#declare ass1 =
object {  /*------The Column Assembly--------------------*/
  union {
    object { a02 }
    object { a03 translate y*2 }
    object { a04 translate y*56 }
  }
  texture { gold }
  bounded_by { object { Disk_Y scale <7.2, 71, 7.2> translate y*-0.5 } }
}

#declare b01 =
/*--------Ball Brace----------*/
difference {
  union {
    object { Cube scale <1,  10, 0.6> translate < 1, 18, 0> }
    object { Cube scale <5,   3, 0.6> translate < 2, 25, 0> }
    object { Cube scale <6,   1, 0.6> translate <14,  1, 0> }
    object { Cube scale <5.8, 1, 0.6> rotate z*-45 translate <4.5, 4.5, 0> }
  }
  object { Cylinder_Z scale 8 translate <10, 22, 0> }
}

#declare b02 =
union {  /*------------Brass Balls------------------*/
  object { Ellipsoid scale 9 }
  object { Ellipsoid scale <3, 2, 3> translate y*12 }
  object { Disk_Y scale <3, 2, 3> translate y*8 }
}

#declare b03 =
object { /*------Combined Ball & Support----------------*/
  union {
    object { b01 }
    object { b02 translate <13, 11, 0> }
  }
  texture { gold }
  bounded_by { object { Cube scale <14, 15, 9> translate <10, 14, 0> } }
}

#declare b04 =
/*----------Pivot Support for B03----------*/
union {
  object { DCone  scale < 3,  4,    3> }
  object { Disk_Y scale < 3, 20,    3> translate  y*4 }
  object { Disk_Y scale < 2, 10,    2> translate y*24 }
  object { Disk_Y scale < 7,  2,    7> translate y*28 }
  object { Disk_Y scale < 1, 13,    1> translate y*35 }
  object { Disk_Y scale <11,  1,   11> translate y*34 }
  object { Cube   scale <14,  0.5,  2> translate  y*7 }
  object { Cube   scale < 2,  0.5, 14> translate  y*7 }
  texture { gold }
  bounded_by { object { Disk_Y scale <12, 50, 12> translate -y } }
}

#declare ass2 = 
union {   /*------Pivot Support w/balls ----*/
  object { b04 }
  object { b03 translate <8, 4, 0> }
  object { b03 translate <8, 4, 0>  rotate y*90 }
  object { b03 translate <8, 4, 0> rotate y*180 }
  object { b03 translate <8, 4, 0> rotate y*270 }
  bounded_by { object { Disk_Y scale <32, 50, 32> translate -y } }
}

#declare c01 = object { Disk_Z scale <2, 2, 20> }

#declare c02 =
/*----------GEAR BOX----------------------*/
union {
  object { Cube scale <17, 26, 1> texture { gold }}
  object { Cube scale <17, 26, 1> translate z*17 texture { gold } }
  object { c01 translate <-14, -23, -1.5> texture { gold } }
  object { c01 translate < 14, -23, -1.5> texture { gold } }
  object { c01 translate <-14,  23, -1.5> texture { gold } }
  object { c01 translate < 14,  23, -1.5> texture { gold } }
  //texture { gold }
  clipped_by { object { Cube scale <18, 27, 11> translate z*9 } }
  bounded_by { object { Cube scale <18, 27, 11> translate z*9 } }
}

#declare g01 =
object {    /*------------TOOTH of GEAR--------*/
  Cube scale <1, 0.5, 0.5> translate x*12 }

#declare g02 =
/*--------------GEAR RING------------*/
difference {
  object { Disk_Z scale <12, 12, 1> }
  object { Cylinder_Z scale 10 }
}

#declare g03 =
union {    /*----------GEAR SPOKE----------------------*/
  object { Cube scale <1.5, 11, 0.5> }
  object { Cube scale <11, 1.5, 0.5> }
}

#declare g04 =
/*-------- ASSEMBLE THE GEAR PARTS --------*/
union {
  object { g02 translate z*-0.5 }
  object { g03 }
  object { g01 }
  object { g01 rotate z*10 }
  object { g01 rotate z*20 }
  object { g01 rotate z*30 }
  object { g01 rotate z*40 }
  object { g01 rotate z*50 }
  object { g01 rotate z*60 }
  object { g01 rotate z*70 }
  object { g01 rotate z*80 }
  object { g01 rotate z*90 }
  object { g01 rotate z*100 }
  object { g01 rotate z*110 }
  object { g01 rotate z*120 }
  object { g01 rotate z*130 }
  object { g01 rotate z*140 }
  object { g01 rotate z*150 }
  object { g01 rotate z*160 }
  object { g01 rotate z*170 }
  object { g01 rotate z*180 }
  object { g01 rotate z*190 }
  object { g01 rotate z*200 }
  object { g01 rotate z*210 }
  object { g01 rotate z*220 }
  object { g01 rotate z*230 }
  object { g01 rotate z*240 }
  object { g01 rotate z*250 }
  object { g01 rotate z*260 }
  object { g01 rotate z*270 }
  object { g01 rotate z*280 }
  object { g01 rotate z*290 }
  object { g01 rotate z*300 }
  object { g01 rotate z*310 }
  object { g01 rotate z*320 }
  object { g01 rotate z*330 }
  object { g01 rotate z*340 }
  object { g01 rotate z*350 }
  texture { gold }
  bounded_by { object { Disk_Z scale <14, 14, 2> translate -z } }
}

#declare d01 =
/*------------CROWN PLATE ----------------*/
difference {
  union {
    object { Cube scale <24, 17, 1> }
    object { Cube scale < 4, 21, 1> }
  }
  object { Cylinder_Z scale 6 translate <-10, 17, 0> }
  object { Cylinder_Z scale 6 translate < 10, 17, 0> }
  texture { gold }
  bounded_by { object { Cube scale <25, 22, 2> translate -z } }
}

#declare d02 = 
/*--------------CROWN CAPS ----------------*/
union {
  object { UCone     scale <2,  14, 2> translate y*14 }
  object { Ellipsoid scale <4,   1, 4>   translate  y*3 }
  object { Ellipsoid scale <0.7, 1, 0.7> translate y*14 }
  texture { gold }
  bounded_by { object { Disk_Y scale <4.5, 16, 4.5> translate y*-0.5 } }
}

#declare ass3 = 
union { /*GEAR BOX & CROWN ASSEMBLY*/
  object { c02 }
  object { d01 translate <  0, 23, 2> }
  object { d02 translate < 20, 40, 2> }
  object { d02 translate <  0, 44, 2> }
  object { d02 translate <-20, 40, 2> }
  bounded_by { object { Cube scale <25, 45, 11> translate <0, 15, 8> } }
}

#declare f01 =
object {    /*------------ CLOCK FACE RIM ------*/
  Ellipsoid scale <33, 33, 6>
  texture {  gold }
}

#declare f02 =
object {    /*------------ CLOCK FACE  --------*/
  Ellipsoid scale <28, 28, 4>
  texture { 
    pigment { image_map { gif "cface.gif" } }
    scale <56, 56, 4>
    translate <-28, -28, -4>
    finish { ambient 0.3 diffuse 0.6 reflection 0.1 }
  }
}

#declare tip =
object {
  difference {
    object { Cube scale <5, 5, 1> }
    object { Cube scale <3, 3, 2> }
  }
  rotate z*45
  scale <1, 2, 1> 
}

#declare hand =
union {
  object { tip translate y*55 }
  object { Cube scale <1, 22, 1> translate y*22 }
  texture { pigment { color rgb 0 } finish { phong 1 } }
  bounded_by { object { Cube scale <6, 35, 2> translate y*34 } }
}

#declare h01 =
object { /*----LARGE HAND----*/
  hand scale <0.36, 0.36, 0.3> rotate z*160 }

#declare h02 =
object { /*----SMALL HAND----*/
  hand scale <0.3, 0.3, 0.2> rotate z*220 }

#declare h03 =
object {    /*----Post Tip for Hands-------*/
  Ellipsoid scale <3, 3, 2>
  texture { gold }
}

#declare mm_clock =
union { /*----SOME ASSEMBLY REQUIRED----*/
  object { a01 }  /*base*/
  object { ass1 translate < 27, 16, -19> }            /*r.colum*/
  object { ass1 translate <-27, 16, -19> }            /*l.colum*/
  
  object { a06  translate <0, 77, -19> }               /*support*/

  object { a07  translate <0, 70, 0.5> }               /*pivot sup*/

  object { ass2 translate <0, 16, 9> }                /*balls*/

  object { ass3 translate <0, 104, -17> }             /*crown/box*/
  object { g04  translate <-18, 120, -3> }             /*t.gear*/
  object { g04  rotate z*15 translate <-22, 100, -5> } /*b.gear*/  
  
  object { f01  translate <0, 110, -21> }              /*face rim*/
  object { f02  translate <0, 110, -24> }              /*face*/
  
  object { h01  translate <0, 110, -30> }              /*lhand*/
  object { h02  translate <0, 110, -30> }              /*shand*/
  object { h03  translate <0, 110, -30> }              /*post*/
  bounded_by { object { Disk_Y scale <64, 170, 64> translate -y } }
}

/*-------------------------------PLACE CLOCK----------------------------------------------------*/
object { mm_clock rotate y*-30 }

/*----------------FLOOR PLANE--------------------------------------*/
plane { y, -3
  texture {
    pigment { color rgb 0 }
    finish { ambient 0.8 reflection 0.3 phong 0.5 }
  }
}

/*----------Dan Farmers NICE WILD SKY!!---------*/
#declare Zenith = colour rgb <0, 0, 0.83>;
#declare MidSky = colour rgb <0.65, 0.65, 1>;             
#declare HighHorizon = colour rgb <0.83, 0.83, 0.98>;        
#declare GroundColor = colour red 0.137255 green 0.556863 blue 0.137255;
#declare Rose = colour rgb <0.96, 0.59, 0.66>;
#declare LowHorizon = colour red 0.52 green 0.39 blue 0.39;
#declare Clouds1 =
texture {        
  pigment {
    bozo
    turbulence 0.8
    colour_map {
      [0.0 0.6   colour rgbf 1 colour rgbf 1]        /* transparent to transparent */
      [0.6 0.8   colour Rose filter 1.0 colour Rose] /* transparent to rose */
      [0.8 1.001 colour Rose colour rgb 0.329412 ]   /* rose to gray */
    }
  }
  scale <1, 0.5, 1>
}

/* -----------------Sky sphere------------------------------------- */
object {
  Ellipsoid scale <800000, 150000, 800000>
  texture {
    pigment {
      gradient y
      color_map {
        [0.00 0.10 color LowHorizon color HighHorizon]
        [0.10 0.15 color HighHorizon color HighHorizon]
        [0.15 0.70 color HighHorizon color MidSky]
        [0.70 0.95 color MidSky color Zenith]
        [0.95 1.01 color Zenith color LowHorizon]
      }
    }
    finish { ambient 0.0 }
    scale <800000, 150000, 800000>
  }
  texture { Clouds1 scale <50000, 20000, 70000> }
  }
/*---THANKS DAN--*/

/*
//-----------------------------BACK DROP----------------------------
object {
  Cube scale <1000, 500, 5>
  texture {
    pigment { image_map { gif "st.gif" } }
    scale <2000, 2000, 5>
    translate <-1000, -1000, -5>
    finish { ambient 0.4 diffuse 0.0 }
  }
  translate <0, 400, 1200> 
 }

//-----------------------------Front DROP----------------------------
object {
  Cube scale <1000, 500, 5>
  texture {
    pigment { image_map { gif "f1.gif" } }
    scale <2000, 2000, 5>
    translate <-1000, -1000, -5>
    finish { ambient 0.4 diffuse 0.0 }
  }
  translate <0, 450, -500> 
}

object { 
  Ellipsoid scale 100
  texture {
    pigment { image_map { gif "f1.gif" } }
    scale <200, 200, 1>
    translate <-100, -100, -1>
    finish { phong 1.0 ambient 0.4 }
  }
  translate <-220, 100, 600>
}
*/