// Persistence of Vision Raytracer
/*                POV Data - Mantel Clock               M.Miller 11/1/91*/

#include "colors.inc"
#include "shapes.inc"
#include "shapes.old"
#include "textures.inc"
#include "shapesq.inc"


camera {
location < 0 60 -220 > direction < 0 0 1 > up < 0 1 0 > right < 1.333 0 0 >
 }


#declare DCone = /*--------CONE POINT DOWN /POINT at 000--------*/
intersection {
quadric { QCone_Y scale < 1 1 1 >  }
plane { < 0 -1 0 > 0  }
plane { < 0 1 0 > 1   }
 }

#declare UCone = /*--------CONE POINT UP /POINT at 000--------*/
intersection {
quadric { QCone_Y scale < 1 1 1 >  }
plane { < 0 1 0 > 0    }
plane { < 0 1 0 > -1 inverse  }
 }


#declare gold = texture {  /*------Bright Reflective Gold---------------*/
        0.02 ambient 0.3 diffuse 0.5
        colour red 0.64 green 0.55 blue 0.0 reflection 0.6 brilliance 8.0
        specular 0.5
     }



/*----------LIGHT Source1------------------------------*/
object
{
	union
	{
		sphere
		{
			< 250 300 -500 > 1
			texture
		 	{
				color White
			}
		}
		light_source
		{
			<250 300 -500>
			color White
		}
	}
	no_shadow
}


/*----------LIGHT Source2------------------------------*/
object
{
	union
	{
		sphere
		{
			<-100 200 -100> 1
			texture
			{
				color White
			}
		}
		light_source
		{
			<-100 200 -100>
			color White
		}
	}
	no_shadow
}	


#declare a01 = object { /*--------------CLOCK BASE------------*/
difference {
union {
quadric { Ellipsoid scale < 62 15 62 >  }
quadric { Ellipsoid scale < 55 5 55 > translate < 0 10 0 >  }
intersection { Y_Disk scale < 50 3 50 > translate < 0 12 0 >  }
intersection { Y_Disk scale < 43 1 43 > translate < 0 15 0 >  }
 }
plane { < 0 1 0 > 0  }
 }
texture { gold  }
 }


#declare a02 = intersection { /*------------RING--------------*/
Y_Disk scale < 7 2 7 >  }

#declare a03_1 = intersection { /*--Squash Disk to make rib----*/
Y_Disk scale < 1 56 4 >  }


#declare a03 = union {    /*----------MAKE Rib Colum------------*/
intersection { a03_1 rotate < 0 0 0 >  }
intersection { a03_1 rotate < 0 30 0 >  }
intersection { a03_1 rotate < 0 60 0 >  }
intersection { a03_1 rotate < 0 90 0 >  }
intersection { a03_1 rotate < 0 120 0 >  }
intersection { a03_1 rotate < 0 150 0 >  }
 }


#declare a04 = union {   /*----------------Colum Caps------------*/
intersection { Y_Disk scale < 5 5 5 >  }
quadric { Ellipsoid scale < 4 2 4 > translate < 0 5 0 >  }
quadric { Ellipsoid scale < 1.5 1.5 1.5 > translate < 0 8 0 >  }
quadric { Ellipsoid scale < 3 2 3 > translate < 0 10 0 >  }
 }

#declare a06 = object {   /*------Cross Support for Gear Box --------*/
union {
intersection { Y_Disk scale < 6 2 6 > translate < 27 -1 0 >  }
intersection { Y_Disk scale < 6 2 6 > translate < -27 -1 0 >  }
intersection { Cube scale < 17 1 8.5 > translate < 0 0 10.5 >  }
intersection { Cube scale < 6 1 11.5 > translate < 0 0 11.5 > 
	rotate < 0 45 0 > translate < -27 0 0 >  }
intersection { Cube scale < 6 1 11.5 > translate < 0 0 11.5 > 
	rotate < 0 -45 0 > translate < 27 0 0 >  }
 }
texture { gold  }
bounded_by { intersection { Cube scale < 35 2 14 > translate < 0 0 4 >
 }  }
 }


#declare a07 = object {    /*----Bracket for Pivit Rod of Counter Balls--*/
difference {
union {
intersection { Cube scale < 17 8 0.5 >  }
intersection { Cube scale < 9 0.5 6.5 > translate < 0 -7.5 7 >  }
 }
quadric { Cylinder_Z scale < 8 8 8 > translate < -17 -8 0 >  }
quadric { Cylinder_Z scale < 8 8 8 > translate < 17 -8 0 >  }
 }
texture { gold  }
bounded_by {
intersection { Cube scale < 18 9 8 > translate < 0 0 6.5 >  }
 }
 }


#declare ass1 = object {  /*------The Column Assembly--------------------*/
union {
intersection { a02  }
union { a03 translate < 0 2 0 >  }
intersection { a04 translate < 0 56 0 >  }
 }
texture { gold  }
bounded_by { intersection { Y_Disk scale < 7.2 71 7.2 >
translate < 0 -0.5 0 >  }  }
 }


#declare b01 = intersection {  /*--------Ball Brace----------*/
difference {
union {
intersection { Cube scale < 1 10 0.6 > translate < 1 18 0 >  }
intersection { Cube scale < 5 3 0.6 > translate < 2 25 0 >  }
intersection { Cube scale < 6 1 0.6 > translate < 14 1 0 >  }
intersection { Cube scale < 5.8 1 0.6 > rotate < 0 0 -45 >
translate < 4.5 4.5 0 >  }
 }
quadric { Cylinder_Z scale < 8 8 8 > translate < 10 22 0 >  }
 }
 }


#declare b02 = union {  /*------------Brass Balls------------------*/
quadric { Ellipsoid scale < 9 9 9 >  }
quadric { Ellipsoid scale < 3 2 3 > translate < 0 12 0 >  }
intersection { Y_Disk scale < 3 2 3 > translate < 0 8 0 >  }
 }

#declare b03 = object { /*------Combined Ball & Support----------------*/
union {
intersection { b01  }
union { b02 translate < 13 11 0 >  }
 }
texture { gold  }
bounded_by { intersection { Cube scale < 14 15 9 >
translate < 10 14 0 >  }  }
 }

#declare b04 = object {   /*----------Pivot Support for B03----------*/
union {
intersection { DCone scale < 3 4 3 >  }
intersection { Y_Disk scale < 3 20 3 > translate < 0 4 0 >  }
intersection { Y_Disk scale < 2 10 2 > translate < 0 24 0 >  }
intersection { Y_Disk scale < 7 2 7 > translate < 0 28 0 >  }
intersection { Y_Disk scale < 1 13 1 > translate < 0 35 0 >  }
intersection { Y_Disk scale < 11 1 11 > translate < 0 34 0 >  }
intersection { Cube scale < 14 0.5 2 > translate < 0 7 0 >  }
intersection { Cube scale < 2 0.5 14 > translate < 0 7 0 >  }
 }
texture { gold  }
bounded_by { intersection { Y_Disk scale < 12 50 12 >
translate < 0 -1 0 >  }  }
 }

#declare ass2 = composite {   /*------Pivot Support w/balls ----*/
object { b04  }
object { b03 translate < 8 4 0 > rotate < 0 0 0 >  }
object { b03 translate < 8 4 0 > rotate < 0 90 0 >  }
object { b03 translate < 8 4 0 > rotate < 0 180 0 >  }
object { b03 translate < 8 4 0 > rotate < 0 270 0 >  }
bounded_by { intersection { Y_Disk scale < 32 50 32 >
translate < 0 -1 0 >  }  }
 }


#declare c01 = intersection { Z_Disk scale < 2 2 20 >  }

#declare c02 = object {  /*----------GEAR BOX----------------------*/
union {
intersection { Cube scale < 17 26 1 >  }
intersection { Cube scale < 17 26 1 > translate < 0 0 17 >  }
intersection { c01 translate < -14 -23 -1.5 >  }
intersection { c01 translate < 14 -23 -1.5 >  }
intersection { c01 translate < -14 23 -1.5 >  }
intersection { c01 translate < 14 23 -1.5 >  }
 }
texture { gold  }
bounded_by { intersection { Cube scale < 18 27 11 >
translate < 0 0 9 >  }  }
 }

#declare g01 = intersection {    /*------------TOOTH of GEAR--------*/
Cube scale < 1 0.5 0.5 > translate < 12 0 0 >  }

#declare g02 = intersection {   /*--------------GEAR RING------------*/
difference {
intersection { Z_Disk scale < 12 12 1 >  }
quadric { Cylinder_Z scale < 10 10 10 >  }
 }
 }

#declare g03 = union {    /*----------GEAR SPOKE----------------------*/
intersection { Cube scale < 1.5 11 0.5 >  }
intersection { Cube scale < 11 1.5 0.5 >  }
 }

#declare g04 = object {    /*-------- ASSEMBLE THE GEAR PARTS --------*/
union {
intersection { g02 translate < 0 0 -0.5 >  }
union { g03  }
intersection { g01 rotate < 0 0 0 >  }
intersection { g01 rotate < 0 0 10 >  }
intersection { g01 rotate < 0 0 20 >  }
intersection { g01 rotate < 0 0 30 >  }
intersection { g01 rotate < 0 0 40 >  }
intersection { g01 rotate < 0 0 50 >  }
intersection { g01 rotate < 0 0 60 >  }
intersection { g01 rotate < 0 0 70 >  }
intersection { g01 rotate < 0 0 80 >  }
intersection { g01 rotate < 0 0 90 >  }
intersection { g01 rotate < 0 0 100 >  }
intersection { g01 rotate < 0 0 110 >  }
intersection { g01 rotate < 0 0 120 >  }
intersection { g01 rotate < 0 0 130 >  }
intersection { g01 rotate < 0 0 140 >  }
intersection { g01 rotate < 0 0 150 >  }
intersection { g01 rotate < 0 0 160 >  }
intersection { g01 rotate < 0 0 170 >  }
intersection { g01 rotate < 0 0 180 >  }
intersection { g01 rotate < 0 0 190 >  }
intersection { g01 rotate < 0 0 200 >  }
intersection { g01 rotate < 0 0 210 >  }
intersection { g01 rotate < 0 0 220 >  }
intersection { g01 rotate < 0 0 230 >  }
intersection { g01 rotate < 0 0 240 >  }
intersection { g01 rotate < 0 0 250 >  }
intersection { g01 rotate < 0 0 260 >  }
intersection { g01 rotate < 0 0 270 >  }
intersection { g01 rotate < 0 0 280 >  }
intersection { g01 rotate < 0 0 290 >  }
intersection { g01 rotate < 0 0 300 >  }
intersection { g01 rotate < 0 0 310 >  }
intersection { g01 rotate < 0 0 320 >  }
intersection { g01 rotate < 0 0 330 >  }
intersection { g01 rotate < 0 0 340 >  }
intersection { g01 rotate < 0 0 350 >  }
 }
texture { gold  }
bounded_by { intersection { Z_Disk scale < 14 14 2 >
translate < 0 0 -1 >  }  }
 }

#declare d01 = object {   /*------------CROWN PLATE ----------------*/
difference {
union {
intersection { Cube scale < 24 17 1 >  }
intersection { Cube scale < 4 21 1 >  }
 }
quadric { Cylinder_Z scale < 6 6 6 > translate < -10 17 0 >  }
quadric { Cylinder_Z scale < 6 6 6 > translate < 10 17 0 >  }
 }
texture { gold  }
bounded_by { intersection { Cube scale < 25 22 2 >
translate < 0 0 -1 >  }  }
 }

#declare d02 = object {  /*--------------CROWN CAPS ----------------*/
union {
intersection { UCone scale < 2 14 2 > translate < 0 14 0 >  }
quadric { Ellipsoid scale < 4 1 4 > translate < 0 3 0 >  }
quadric { Ellipsoid scale < 0.7 1 0.7 > translate < 0 14 0 >  }
 }
texture { gold  }
bounded_by { intersection { Y_Disk scale < 4.5 16 4.5 >
	translate < 0 -0.5 0 >  }
 }
 }

#declare ass3 = composite { /*GEAR BOX & CROWN ASSEMBLY*/
object { c02  }
object { d01 translate < 0 23 2 >  }
object { d02 translate < 20 40 2 >  }
object { d02 translate < 0 44 2 >  }
object { d02 translate < -20 40 2 >  }

bounded_by { intersection { Cube scale < 25 45 11 >
	translate < 0 15 8 >  }
 }
 }

#declare f01 = object {    /*------------ CLOCK FACE RIM ------*/
quadric { Ellipsoid scale < 33 33 6 >  }
texture {  gold  }
 }

#declare f02 = object {    /*------------ CLOCK FACE  --------*/
quadric { Ellipsoid scale < 28 28 4 >  }
texture { 
image_map { < 1.0 -1.0 0 > gif "cface.gif"  }
scale < 56 56 4 > translate < -28 -28 -4 > ambient 0.3  diffuse 0.6
reflection 0.1
 }
 }

#declare tip = intersection {
difference {
intersection { Cube scale <5 5 1>  }
intersection { Cube scale <3 3 2>  }
 }
rotate <0 0 45> scale <1 2 1> 
 }

#declare hand = object {
union {
intersection { tip translate <0 55 0>  }
intersection { Cube scale <1 22 1> translate <0 22 0>  }
 } 
texture { color Black phong 1.0  }
bounded_by { 
intersection { Cube scale <6 35 2> translate <0 34 0>  }
 }
 }

#declare h01 = object { /*----LARGE HAND----*/
hand scale <0.36 0.36 0.3> rotate <0 0 160 >  }

#declare h02 = object { /*----SMALL HAND----*/
hand scale <0.3 0.3 0.2> rotate <0 0 220 >  }

#declare h03 = object {    /*----Post Tip for Hands-------*/
quadric { Ellipsoid scale <3 3 2>  }
texture { gold  }  }

#declare clock = composite { /*----SOME ASSEMBLY REQUIRED----*/
/*base*/		object { a01  }
/*r.colum*/	object { ass1 translate < 27 16 -19 >  }
/*l.colum*/	object { ass1 translate < -27 16 -19 >  }
/*support*/	object { a06 translate < 0 77 -19 >  }
/*pivot sup*/	object { a07 translate < 0 70 0.5 >  }
/*balls*/		composite { ass2 translate < 0 16 9 >  }
/*crown/box*/	composite { ass3 translate < 0 104 -17 >  }
/*t.gear*/	object { g04 translate < -18 120 -3 >  }
/*b.gear*/	object { g04 rotate <0 0 15> translate < -22 100 -5 >  }
/*face rim*/	object { f01 translate < 0 110 -21 >  }
/*face*/		object { f02 translate < 0 110 -24 >  }
/*lhand*/		object { h01 translate <0 110 -30>  }
/*shand*/		object { h02 translate <0 110 -30>  }
/*post*/		object { h03 translate <0 110 -30>  }


bounded_by { 
intersection { Y_Disk scale < 64 170 64 > translate < 0 -1 0 >  }
 }
 }

/*-------------------------------PLACE CLOCK----------------------------------------------------*/
composite { clock rotate < 0 -30 0 >  }

/*----------------FLOOR PLANE--------------------------------------*/
object { plane { < 0 1 0 > -3  }
texture { color Black ambient 0.8 reflection 0.3 phong 0.5  }
 }


/*----------Dan Farmers NICE WILD SKY!!---------*/

#declare Zenith = colour red 0.00 green 0.00 blue 0.83             
#declare MidSky = colour red 0.65 green 0.65 blue 1.00             
#declare HighHorizon = colour red 0.83 green 0.83 blue 0.98        
#declare GroundColor = colour ForestGreen
#declare Rose = colour red 0.96 green 0.59 blue 0.66
#declare LowHorizon = colour Rose
#declare Clouds1 = texture {        
      turbulence 0.8
      bozo
      colour_map {
          /* transparent to transparent */
          [0.0 0.6   colour red 1.0 green 1.0 blue 1.0 alpha 1.0
                     colour red 1.0 green 1.0 blue 1.0 alpha 1.0]
          /* transparent to rose */
          [0.6 0.8   colour Rose alpha 1.0 colour Rose]
          /* rose to gray */
          [0.8 1.001 colour Rose colour DimGray ]
       }
      scale <1  0.5  1>
 }


/* -----------------Sky sphere------------------------------------- */
object {
    quadric { Ellipsoid scale <800000.0  150000.0 800000.0>  }
        texture {
        gradient <0 1 0>
        color_map {
            [0.0 0.10 color LowHorizon color HighHorizon]
            [0.10 0.15 color HighHorizon color HighHorizon]
            [0.15 0.70 color HighHorizon color MidSky]
            [0.70 0.95 color MidSky color Zenith]
            [0.95 1.01 color Zenith color LowHorizon]
            
                     }
        ambient 0.0
        scale <800000 150000 800000>
     }
    texture { Clouds1 scale <50000.0 20000.0 70000.0>  }
 }
/*---THANKS DAN--*/

/*-----------------------------BACK DROP----------------------------*/
object {
intersection { Cube scale <1000 500 5>  }
texture {
	image_map { <1.0 -1.0 0> gif "st.gif"
	 } scale <2000 2000 5> translate <-1000 -1000 -5>
ambient 0.4 diffuse 0.0
 }
rotate <0 0 0> translate <0 400 1200> 
 }

/*-----------------------------Front DROP----------------------------*/
object {
intersection { Cube scale <1000 500 5>  }
texture {
	image_map { <1.0 -1.0 0> gif "f1.gif"
	 } scale <2000 2000 5> translate <-1000 -1000 -5>
ambient 0.4 diffuse 0.0
 }
rotate <0 0 0> translate <0 450 -500> 
 }




object { 
quadric { Ellipsoid scale <100 100 100>  }
texture {
image_map { <1.0 -1.0 0> gif "f1.gif"  }
scale <200 200 1> translate <-100 -100 -1>
phong 1.0 
ambient 0.4
 }
rotate <0 0 0>
rotate <0 0 0> 
translate <-220 100 600>
 }







