//------ Back Sky
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Zenith = colour MidnightBlue;
#declare MidSky = color Black;    
#declare HighHorizon = colour rgb <0.83, 0.83, 0.98>;
#declare GroundColor = colour ForestGreen;
#declare Rose = colour rgb <0.96, 0.59, 0.66>;
#declare LowHorizon = colour Rose;

#declare Clouds1 =
texture {
  pigment {
    turbulence 0.8
    //bozo
    colour_map {
      [0.0 0.6   colour rgbf 1        colour rgbf 1]
      [0.6 0.8   colour Rose filter 1 colour Rose]
      [0.8 1.001 colour Rose          colour DimGray ]
    }
    scale <1, 0.5, 1>
  }
}

/* -----------------Sky sphere------------------------------------- */
#declare W77 =
sphere { 0, 1
  texture {
    pigment {
      gradient y
      color_map {
        [0.0  0.1  colour LowHorizon  colour HighHorizon]
        [0.1  0.15 colour HighHorizon colour HighHorizon]
        [0.15 0.7  colour HighHorizon colour MidSky]
        [0.7  0.95 colour MidSky      colour Zenith]
        [0.95 1.01 colour Zenith      colour LowHorizon]
      }
    }
    finish {ambient 1 diffuse 0 } 
    scale <1, 0.5, 1>
  }
  texture { Clouds1 scale 0.001}
  scale <1950, 995, 5000>
  translate z*200
}