// Persistence of Vision Raytracer Version 1.0
//-------------- planet 22             .....miller 3/24/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare gold2 = 
texture {  
  pigment { colour rgb <0.64, 0.51, 0.05> }
  finish { crand 0.02 ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8 specular 0.5 }
}


//----------- light blue to midnight blue
#declare n1 =
texture {
  pigment {
    gradient y
    colour_map {
      [0.000 0.308 colour rgbf <0.722, 0.722, 0.992, 0> colour rgbf <0.333, 0.333, 0.584, 0>]
      [0.308 0.992 colour rgbf <0.333, 0.333, 0.584, 0> colour rgbf <0.016, 0.016, 0.231, 0>]
      [0.992 1.001 colour rgbf <0.016, 0.016, 0.231, 0> colour rgbf <0.722, 0.722, 0.992, 0>]
    }
  }
}

//-------------- clear - light blue - white
#declare n2 =
texture {
  pigment { 
    bozo
    turbulence 0.8
    colour_map {
      [0.000 0.252 colour rgbf <0.722, 0.722, 0.992, 0.89>  colour rgbf <0.333, 0.333, 0.584, 0.859>]
      [0.252 0.798 colour rgbf <0.333, 0.333, 0.584, 0.859> colour rgbf <0.918, 0.922, 0.929, 0>]
      [0.798 0.992 colour rgbf <0.918, 0.922, 0.929, 0>     colour rgbf <0.529, 0.522, 0.733, 0.243>]
      [0.992 1.001 colour rgbf <0.529, 0.522, 0.733, 0.243> colour rgbf <0.722, 0.722, 0.992, 0.89>]
    }
  }
}
//-------------- clear - light blue - white
#declare n2x =
texture {
  pigment {
    bozo
    turbulence 0.8
    colour_map {
      [0.000 0.252 colour rgbf <0.722, 0.722, 0.992, 0.89>  colour rgbf <0.333, 0.333, 0.584, 0.859>]
      [0.252 0.798 colour rgbf <0.333, 0.333, 0.584, 0.859> colour rgbf <0.918, 0.922, 0.929, 0.22>]
      [0.798 0.992 colour rgbf <0.918, 0.922, 0.929, 0.229> colour rgbf <0.529, 0.522, 0.733, 0.243>]
      [0.992 1.001 colour rgbf <0.529, 0.522, 0.733, 0.243> colour rgbf <0.722, 0.722, 0.992, 0.89>]
    }
  }
}

//----------light blues & light clears alternating
#declare n3 =
texture {
  pigment {
    gradient y
    colour_map {
      [0.000 0.155   colour rgbf <0.996, 0.980, 0.761, 0.58>  colour rgbf <0.722, 0.722, 0.992, 0.635>]
      [0.155 0.517   colour rgbf <0.722, 0.722, 0.992, 0.635> colour rgbf <0.996, 0.980, 0.761, 0.675>]
      [0.517 0.638   colour rgbf <0.996, 0.980, 0.761, 0.675> colour rgbf <0.875, 0.875, 1.000, 0.659>]
      [0.638 0.750   colour rgbf <0.875, 0.875, 1.000, 0.659> colour rgbf <0.722, 0.722, 0.992, 0.702>]
      [0.750 0.871   colour rgbf <0.722, 0.722, 0.992, 0.702> colour rgbf <0.357, 0.357, 0.702, 0.647>]
      [0.871 0.983   colour rgbf <0.357, 0.357, 0.702, 0.647> colour rgbf <0.345, 0.345, 0.537, 0.675>]
      [0.983 1.001   colour rgbf <0.345, 0.345, 0.537, 0.675> colour rgbf <0.996, 0.980, 0.761, 0.58>]
    }
  }
}

#declare n11 =
texture {
  pigment {
    gradient y
    color_map {
      [0.0 0.3 color Black color Violet]
      [0.3 0.5 color Violet color Violet filter 0.4]
      [0.5 1.01 color Violet filter 0.4 color Violet filter 1]
    }
  }
}

#declare nimrod = 
texture { n1 finish  { ambient 1 diffuse 0 } scale <1, 2, 1> rotate z*180 }
texture { n2x finish { ambient 1 diffuse 0 } translate 1 }
texture { n11 finish { ambient 1 diffuse 0 } scale <1, 2, 1> translate y*1.6 }
texture { n2 finish  { ambient 1 diffuse 0 } scale <2, 0.5, 1> translate y*-1 }

/*-------The World in Front-----------*/
#declare W22 =
sphere { 0, 1 inverse
  texture { nimrod }
  scale <2000, 1000, 5000>
}

/*-------- The World in Back ---------*/
#declare W44 =
sphere { 0, 1 inverse
  texture { 
    pigment {
      gradient y
      color_map {
        [0.0 0.3 color Scarlet color Scarlet]
        [0.3 0.5 color Scarlet color Violet ]
        [0.5 0.7 color Violet color MidnightBlue]
        [0.7 0.8 color MidnightBlue color Black]
        [0.8 1.0 color Black color Black ]
      }
    }
    finish { ambient 1 diffuse 0 }
    scale <1, 2, 1>
    translate -y
  }
  scale <2000, 1000, 5000>
  translate z*100
}

//----------- liquid love lake
#declare LAKE =
plane { y, 0
  texture { 
    pigment { color rgb <0, 0.07, 0> }
    finish { reflection { 0.85 } ambient 0.15 diffuse 0.6 phong 1.0 phong_size 80 }
    normal { ripples 0.1 frequency 0.08 }
  }
}