//------- PipeWorks                     6/9/92 Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//------- Pipe Textures
#declare TEX1 =
texture {
  pigment { color CadetBlue }
  finish { ambient 0.25 diffuse 0.7 phong 1 phong_size 100 crand 0.02 }
}

#declare TEX2 = texture { gold2 }

//------- Torus Shapes
//--------Torus - outer17 inner11
#declare T_17_11 =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -410, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 374, 0, 0, 0, 0, 1, 0, -410, 0, 34969> }

//----- Torus outer 7 inner 5
#declare T_7_5 =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 70, 0, 0, 0, 0, 1, 0, -74, 0, 1225> }

//-----Torus outer8.5 inner 3.5
#declare T_3_8 =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -84.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 59.5, 0, 0, 0, 0, 1, 0, -84.5, 0, 885.0625> }

//--------- Pipe Parts
//----- 2.5 radius Flange
#declare F1 = object { Disk_X scale <0.7, 2.5, 2.5> }

//----- Small Spoke
#declare S1 = object { Disk_Z scale <0.7, 0.7, 6> }

//----- 1.5 radius Pipe
#declare P1 = 
object {
  intersection {
    object { Cylinder_X scale <1, 1.5, 1.5> }
    plane { x, 0 } 
  }
  texture { TEX1 }
}

//----- 6 radius X Pipe
#declare P2 =
object {
  intersection {
    object { Cylinder_X scale <1, 6, 6> }
    plane { x, 0 } 
  }
  texture { TEX1 }
}

//----- 1.5 radius Z Pipe
#declare P3 =
object {
  intersection {
    object { Cylinder_Z scale <1.5, 1.5, 1> }
    plane { z, 0 inverse }
  }
  texture { TEX1 }
}

//----- 1.5 Connector
#declare CONNECTOR_1 =
object {
  union {
    object { Disk_X scale <4, 2.5, 2.5> }
    object { Disk_Z scale <2.5, 2.5, 4> }
  }
  texture { TEX1 }
  bounded_by { sphere { 0, 7 } }
}

//------ Small Elbo
#declare ELBO_1 =
object {
  intersection {
    object { T_3_8 }
    plane { z, 0 }
    plane { x, 0 inverse }
  }
  texture { TEX1}
  bounded_by { sphere { <4, 0, -4>, 10 } }
}

//------ 1.5 radius Y Pipe
#declare P4 =
object {
  intersection {
    object { Cylinder_Y scale <1.5, 1, 1.5> }
    plane { y, 0 }
  }
  texture { TEX1 }
}

//------ Large Collar
#declare COLLAR_1 =
object {
  union {
    object { Disk_Y scale <16, 10, 16> }
    object { Disk_X scale <5, 8, 8> translate x*-15 }
    object { Disk_Z scale 5 translate z*-15 }
    object { Disk_Z scale <3, 3, 5> translate z*-18 }
  }
  texture { TEX1 }
  bounded_by { sphere { 0, 25 } }
}

#declare CUTTER =
difference {
  union {
    object { Disk_Y scale <15, 2, 15> }
    object { Disk_Y scale <17, 1, 17> }
  }
  object { Cylinder_Y scale <14, 1, 14> }
}

//------ Main Fat Vertical Stack
#declare MAIN_DRAIN = 
object {
  difference {
    union {
      //object { Disk_Y scale <15, 2, 15> translate y*38 }
      //object { Disk_Y scale <17, 1, 17> translate y*38 }
      object { CUTTER translate y*38 }
      object { T_17_11 translate y*33 }
      object { Disk_Y scale <14, 15, 14> translate y*15 }
      object { Disk_Y scale <15, 0.5, 15> translate y*20.5 }
      object { Disk_Y scale <15, 0.5, 15> translate y*16.5 }
      object { Disk_Y scale <15, 0.5, 15> translate y*12.5 }
    }
    object { Disk_Y scale <13, 15, 13> translate y*15 }
  }
  texture { TEX1 }
  bounded_by { box { <-20, -1, -20>, <20, 42, 20> } }
}


//------ Small Shut-Off
#declare SHUT_OFF_1 = 
object {
  union {
    object { F1 translate x*9 }
    object { F1 translate x*6 }
    object { F1 translate x*-9 }
    object { F1 translate x*-6 }
    object { Disk_X scale <9, 1.6, 1.6> }
    sphere { 0, 1 scale <5, 3.5, 3.5> }
    object { Disk_Y scale <1, 2.5, 1> translate y*5 }
    object { S1 translate y*7.5 }
    object { S1 rotate y*60 translate y*7.5 }
    object { S1 rotate y*120 translate y*7.5 }
    object { T_7_5 translate y*7.5 }
  }
  texture { TEX2 }
  bounded_by { sphere { 0, 14 } }
}

//---------------- ASSEMBLE PIPES
#declare PIPES  =
union {
  object { MAIN_DRAIN translate y*-40 }
  object { SHUT_OFF_1 translate <-35, -15.5, 0> }
  object { SHUT_OFF_1 rotate <-90, 0, 0> translate <-90, -31.5, 0> }
  object { SHUT_OFF_1 translate <-75, -15.5, -36> }
  object { SHUT_OFF_1 rotate y*90 rotate x*-90  translate <-75, -49, -21> }
  object { P1 translate y*-15.5 }
  object { P1 translate y*-31.5 }
  object { P2 translate y*-50 }
  object { CONNECTOR_1 translate <-55, -15.5, 0> }
  object { CONNECTOR_1 translate <-55, -31.5, 0> }
  object { CONNECTOR_1 translate <-75, -31.5, 0> }
  object { P3 translate <-55, -15.5, -30> }
  object { P3 translate <-55, -31.5, -35> }
  object { P3 translate <-75, -31.5, -15> }
  object { COLLAR_1 translate <0, -50, 0> }
  object { ELBO_1 translate <-61, -15.5, -30> }
  object { P1 translate <-61, -15.5, -36> }
  object { ELBO_1 rotate z*90 translate <-55, -37.5, -35> }
  object { ELBO_1 rotate z*90 translate <-75, -37.5, -15> }
  object { P4 translate <-55, -37.5, -41> }
  object { P4 translate <-75, -37.5, -21> }
  object { P4 scale 9 translate y*-50 }
}